/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.ide.ui.internal.editor.ApprovalsTab;
import com.ibm.team.workitem.ide.ui.internal.editor.CustomAttributesTab;
import com.ibm.team.workitem.ide.ui.internal.editor.HTab;
import com.ibm.team.workitem.ide.ui.internal.editor.HistoryTab;
import com.ibm.team.workitem.ide.ui.internal.editor.LinksTab;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.OverviewTab;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemEditorTabs {
    public static final String OVERVIEW = "com.ibm.team.workitem.ide.ui.editor.page.overview";
    public static final String LINKS = "com.ibm.team.workitem.ide.ui.editor.page.links";
    public static final String APPROVALS = "com.ibm.team.workitem.ide.ui.editor.page.approvals";
    public static final String CUSTOM_ATTRIBUTES = "com.ibm.team.workitem.ide.ui.editor.page.customAttributes";
    public static final String HISTORY = "com.ibm.team.workitem.ide.ui.editor.page.history";
    public static final String H = "com.ibm.team.workitem.ide.ui.editor.tab.h";
    private static Map<String, Class<? extends TeamFormPage>> fgTabs = new HashMap<String, Class<? extends TeamFormPage>>();
    public static List<String> SMALL_SLOTS;
    private static Map<String, Class<? extends TeamFormPage>> fgTabLayouts;
    private static Map<String, Set<String>> fgLayoutSlots;
    private static Map<String, String> fgLayoutNames;
    private static Map<String, String> fgSlotNames;

    static {
        fgTabs.put(OVERVIEW, OverviewTab.class);
        fgTabs.put(LINKS, LinksTab.class);
        fgTabs.put(APPROVALS, ApprovalsTab.class);
        fgTabs.put(CUSTOM_ATTRIBUTES, CustomAttributesTab.class);
        fgTabs.put(HISTORY, HistoryTab.class);
        fgTabs.put(H, HTab.class);
        SMALL_SLOTS = new ArrayList<String>();
        fgTabLayouts = new HashMap<String, Class<? extends TeamFormPage>>();
        fgLayoutSlots = new HashMap<String, Set<String>>();
        fgLayoutNames = new HashMap<String, String>();
        fgSlotNames = new HashMap<String, String>();
        fgTabLayouts.put("builtInOverviewLayout", OverviewTab.class);
        fgTabLayouts.put("builtInLinksLayout", LinksTab.class);
        fgTabLayouts.put("builtInApprovalsLayout", ApprovalsTab.class);
        fgTabLayouts.put("builtInCustomAttributesLayout", CustomAttributesTab.class);
        fgTabLayouts.put("builtInHistoryLayout", HistoryTab.class);
        fgTabLayouts.put("builtInHLayout", HTab.class);
        fgLayoutSlots.put("builtInOverviewLayout", OverviewTab.SLOTS.keySet());
        fgLayoutSlots.put("builtInLinksLayout", LinksTab.SLOTS.keySet());
        fgLayoutSlots.put("builtInApprovalsLayout", ApprovalsTab.SLOTS.keySet());
        fgLayoutSlots.put("builtInCustomAttributesLayout", CustomAttributesTab.SLOTS.keySet());
        fgLayoutSlots.put("builtInHistoryLayout", HistoryTab.SLOTS.keySet());
        fgLayoutSlots.put("builtInHLayout", HTab.SLOTS.keySet());
        fgSlotNames.putAll(OverviewTab.SLOTS);
        fgSlotNames.putAll(LinksTab.SLOTS);
        fgSlotNames.putAll(ApprovalsTab.SLOTS);
        fgSlotNames.putAll(CustomAttributesTab.SLOTS);
        fgSlotNames.putAll(HistoryTab.SLOTS);
        fgSlotNames.putAll(HTab.SLOTS);
        fgLayoutNames.put("builtInOverviewLayout", Messages.WorkItemEditorTabs_OVERVIEW_LAYOUT);
        fgLayoutNames.put("builtInLinksLayout", Messages.WorkItemEditorTabs_LINKS_LAYOUT);
        fgLayoutNames.put("builtInApprovalsLayout", Messages.WorkItemEditorTabs_APPROVALS_LAYOUT);
        fgLayoutNames.put("builtInCustomAttributesLayout", Messages.WorkItemEditorTabs_CUSTOMATTRIBUTES_LAYOUT);
        fgLayoutNames.put("builtInHistoryLayout", Messages.WorkItemEditorTabs_HISTORY_LAYOUT);
        fgLayoutNames.put("builtInHLayout", Messages.WorkItemEditorTabs_H_LAYOUT);
        SMALL_SLOTS.addAll(OverviewTab.SMALL_SLOTS);
        SMALL_SLOTS.addAll(LinksTab.SMALL_SLOTS);
        SMALL_SLOTS.addAll(ApprovalsTab.SMALL_SLOTS);
        SMALL_SLOTS.addAll(CustomAttributesTab.SMALL_SLOTS);
        SMALL_SLOTS.addAll(HistoryTab.SMALL_SLOTS);
        SMALL_SLOTS.addAll(HTab.SMALL_SLOTS);
    }

    public static Set<String> getTabLayouts() {
        return fgTabLayouts.keySet();
    }

    public static Set<String> getLayoutSlots(String layout) {
        if (fgLayoutSlots.get(layout) == null) {
            return Collections.emptySet();
        }
        return fgLayoutSlots.get(layout);
    }

    public static String getLayoutDisplayName(String layoutId) {
        String name = fgLayoutNames.get(layoutId);
        if (name == null) {
            return layoutId;
        }
        return name;
    }

    public static String getSlotName(String slotId) {
        String name = fgSlotNames.get(slotId);
        if (name == null) {
            return slotId;
        }
        return name;
    }

    public static TeamFormPage createPage(String id) {
        Class<? extends TeamFormPage> clazz = fgTabs.get(id);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException x) {
            throw new RuntimeException(x);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
    }

    public static TeamFormPage createTab(WorkItemEditorInput editorInput, Map<String, List<AbstractPresentationDescriptor>> presentations, TabDescriptor desc) {
        Class<? extends TeamFormPage> c;
        Class<? extends TeamFormPage> clazz = null;
        String tabLayout = (String)editorInput.getEditorPresentation().getTabLayouts().get(desc.getElementId());
        if (tabLayout != null && (c = fgTabLayouts.get(tabLayout)) != null && TeamFormPage.class.isAssignableFrom(c)) {
            TeamFormPage page;
            block18: {
                clazz = c;
                Constructor<? extends TeamFormPage> constr = null;
                try {
                    constr = clazz.getConstructor(String.class, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                page = constr == null ? clazz.newInstance() : constr.newInstance(desc.getElementId(), desc.getTitle());
                if (!(page instanceof PresentationTab)) break block18;
                ((PresentationTab)page).initialize(editorInput.getWorkingCopy(), presentations, desc);
                if (desc.getProperties() == null || !"true".equalsIgnoreCase((String)desc.getProperties().get("hideIfEmpty")) || !((PresentationTab)page).isEmpty(editorInput)) break block18;
                return null;
            }
            try {
                return page;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
        }
        if (clazz == null && (c = fgTabs.get(desc.getElementId())) != null && TeamFormPage.class.isAssignableFrom(c)) {
            TeamFormPage page;
            block19: {
                clazz = c;
                page = clazz.newInstance();
                if (!(page instanceof PresentationTab)) break block19;
                ((PresentationTab)page).initialize(editorInput.getWorkingCopy(), presentations, desc);
                if (desc.getProperties() == null || !"true".equalsIgnoreCase((String)desc.getProperties().get("hideIfEmpty")) || !((PresentationTab)page).isEmpty(editorInput)) break block19;
                return null;
            }
            try {
                return page;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(NLS.bind((String)Messages.WorkItemEditorTabs_CANNOT_CREATE_TAB, (Object)desc.getElementId(), (Object[])new Object[0]), e);
            }
        }
        if (clazz == null) {
            return null;
        }
        return null;
    }

    public static List<String> getDefaultPages() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(OVERVIEW);
        result.add(LINKS);
        result.add(APPROVALS);
        result.add(CUSTOM_ATTRIBUTES);
        result.add(HISTORY);
        return result;
    }
}

