/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.editor.AbstractWorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemEditorInputFuture
extends AbstractWorkItemEditorInput {
    private List<WorkItemEditor> fWaitingEditors = new ArrayList<WorkItemEditor>(1);
    private Object fMutex = new Object();
    private boolean fIsLoading = false;
    private boolean fIsDone = false;
    private WorkItemEditorInput fEditorInput;

    public WorkItemEditorInputFuture(WorkItemEditorInput input) {
        super(input.getWorkItemHandle());
        this.fEditorInput = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingEditor(WorkItemEditor editor) {
        ArrayList<WorkItemEditor> editors = null;
        Object object = this.fMutex;
        synchronized (object) {
            this.fWaitingEditors.add(editor);
            if (!this.fIsLoading && !this.fIsDone) {
                this.fIsLoading = true;
                this.startLoadingThread();
            } else if (this.fIsDone) {
                editors = new ArrayList<WorkItemEditor>(this.fWaitingEditors);
                this.fWaitingEditors.clear();
            }
        }
        if (editors != null) {
            this.notifyEditors(this.fEditorInput, editors);
        }
    }

    private void startLoadingThread() {
        Job.getJobManager().cancel((Object)this.fWorkItemHandle);
        ITeamRepository teamRepository = (ITeamRepository)this.fWorkItemHandle.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        final IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        final boolean connected = workingCopyManager.connectLocal(this.fWorkItemHandle, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Collections.emptyList()));
        String jobName = Messages.WorkItemEditorInputFuture_LOADING_WORKITEM;
        FoundationJob job = new FoundationJob(jobName){

            public boolean belongsTo(Object family) {
                if (family instanceof IItemHandle) {
                    return WorkItemEditorInputFuture.this.fWorkItemHandle.sameItemId((IItemHandle)family);
                }
                return false;
            }

            public IStatus runProtected(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.WorkItemEditorInputFuture_FETCHING_DATA, -1);
                    WorkItemEditorInputFuture.this.fEditorInput.getWorkingCopy(monitor);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    if (connected) {
                        workingCopyManager.disconnect(WorkItemEditorInputFuture.this.fWorkItemHandle);
                    }
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = WorkItemEditorInputFuture.this.fMutex;
                synchronized (object) {
                    WorkItemEditorInputFuture.this.fIsLoading = false;
                    WorkItemEditorInputFuture.this.fIsDone = true;
                }
                WorkItemEditorInputFuture.this.notifyWaitingEditors(WorkItemEditorInputFuture.this.fEditorInput);
            }
        });
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingEditors(WorkItemEditorInput input) {
        ArrayList<WorkItemEditor> editors = null;
        Object object = this.fMutex;
        synchronized (object) {
            editors = new ArrayList<WorkItemEditor>(this.fWaitingEditors);
            this.fWaitingEditors.clear();
        }
        this.notifyEditors(input, editors);
    }

    private void notifyEditors(WorkItemEditorInput input, ArrayList<WorkItemEditor> editors) {
        for (WorkItemEditor editor : editors) {
            editor.completeEditorInputAvailable(input);
        }
    }
}

