/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.TextOperationAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.QueryExpiredException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormEditor;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.UnmergableChangesException;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.CommentsChangeDetails;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.common.model.PendingItemChangesException;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.editor.FormEditorPage;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.AbstractWorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.ChangeDecorator;
import com.ibm.team.workitem.ide.ui.internal.editor.FindReplaceTarget;
import com.ibm.team.workitem.ide.ui.internal.editor.FormEditorPagesRegistry;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInputFuture;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorTabs;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormPartContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.RemoteChangesTooltipSupport;
import com.ibm.team.workitem.ide.ui.internal.editor.part.TitlePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationContext;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.ide.ui.internal.preview.RestWorkItemHTMLGenerator;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.ItemSelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.PendingNotificationsDecorator;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorExtension2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemEditor
extends TeamFormEditor
implements ITextEditorExtension2,
IReusableEditor,
ISaveablePart2 {
    private static final String PROGRESS_PAGE_ID = "com.ibm.magnolia.workItemEditor.progress";
    private UIWorkItemWorkingCopyListener fWorkingCopyListener = new UIWorkItemWorkingCopyListener((IWorkingCopyListener)new WorkingCopyListener());
    private UIWorkItemListener fWorkItemListener = new WorkItemListener(new InternalWorkItemListener());
    private WorkItemWorkingCopy fCachedWorkingCopy;
    private IWorkItem fPartialWorkItem;
    private Map<String, IHandlerActivation> fHandlerActivations = new HashMap<String, IHandlerActivation>();
    private FindReplaceTarget fFindReplaceTarget;
    private SourceViewerPane fSourceViewerPane = new SourceViewerPane((IWorkbenchPart)this);
    private ViewerPane fViewerPane = new ViewerPane();
    private ContextProvider fContextProvider = new ContextProvider(null){

        public URIReference getContext() {
            if (WorkItemEditor.this.getEditorInput() instanceof WorkItemEditorInput) {
                return ((WorkItemEditorInput)WorkItemEditor.this.getEditorInput()).getReference();
            }
            return null;
        }

        public Object getUIContext() {
            return WorkItemEditor.this.getSite().getPage();
        }
    };
    private InternalChangeDecorator fChangeDecorator = new InternalChangeDecorator();
    private ILabelProvider fLabelProvider = new DecoratingLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkItemLabelProvider(), (ILabelDecorator)new PendingNotificationsDecorator()), (ILabelDecorator)this.fChangeDecorator);
    private ILabelProviderListener fLabelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            AbstractWorkItemEditorInput editorInput;
            IEditorInput input = WorkItemEditor.this.getEditorInput();
            if (input instanceof AbstractWorkItemEditorInput && this.isAffected((editorInput = (AbstractWorkItemEditorInput)input).getWorkItemHandle(), event.getElements())) {
                WorkItemEditor.this.updateEditorTab();
            }
        }

        private boolean isAffected(IWorkItemHandle workItem, Object[] objects) {
            if (objects == null) {
                return true;
            }
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IItemHandle && workItem.sameItemId((IItemHandle)objects[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    };
    private static final long ATTACHMENTS_WARN_SIZE = 0xA00000L;
    private PresentationHandlerManager fPresentationHandlerManager = new PresentationHandlerManager(new IPresentationContext(){

        public WorkItemWorkingCopy getWorkingCopy() {
            return WorkItemEditor.this.fCachedWorkingCopy;
        }

        public IWorkbenchWindow getWorkbench() {
            return WorkItemEditor.this.getSite().getWorkbenchWindow();
        }
    });
    private InternalRefreshJob fRefreshJob;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private TitlePart fTitlePart;
    private ActiveControlTracker fActiveControlTracker;
    private TeamFormSectionContainer fHeaderSection;
    private String fCurrentLayoutId;
    private String fCurrentDisplayedType;

    public WorkItemEditor() {
        this.fLabelProvider.addListener(this.fLabelProviderListener);
    }

    private void handleDirtyStateChanged(boolean isDirty) {
        this.firePropertyChange(257);
        this.updatePrintEnablement();
    }

    private void handleStaleStateChanged(boolean isStale) {
        this.fChangeDecorator.setShowChangeDecoration(isStale);
    }

    private void handleRemoteChange(WorkItemChangeEvent event) {
        if (this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        if (event.getAttributeChangeType(IWorkItem.COMMENTS_PROPERTY) == 2) {
            ITeamRepository teamRepository = (ITeamRepository)event.getWorkItem().getOrigin();
            CommentsChangeDetails details = (CommentsChangeDetails)event.getAttributeChangeDetails(IWorkItem.COMMENTS_PROPERTY, CommentsChangeDetails.class);
            IContributor user = teamRepository.loggedInContributor();
            if (details == null || user == null || !user.sameItemId((IItemHandle)details.getComment().getCreator())) {
                this.fChangeDecorator.setShowChangeDecoration(true);
            }
        }
    }

    public void setFocus() {
        this.fChangeDecorator.setShowChangeDecoration(this.fCachedWorkingCopy != null && this.fCachedWorkingCopy.isStale());
        super.setFocus();
    }

    public void synchronizeWorkItem() {
        new UIUpdaterJob(Messages.WorkItemEditor_SYNCHRONIZE_EDITOR){
            private String fNewEditorId;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    IEditorInput input;
                    if (WorkItemEditor.this.isDirty()) {
                        IWorkItem workItem = WorkItemEditor.this.fCachedWorkingCopy.getWorkItem();
                        IWorkItemClient workItemClient = (IWorkItemClient)((ITeamRepository)workItem.getOrigin()).getClientLibrary(IWorkItemClient.class);
                        IWorkItemType oldT = null;
                        IWorkItemType newT = workItemClient.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor);
                        if (WorkItemEditor.this.fCurrentDisplayedType != null) {
                            oldT = workItemClient.findWorkItemType(workItem.getProjectArea(), WorkItemEditor.this.fCurrentDisplayedType, monitor);
                        }
                        if (newT != null) {
                            final WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)WorkItemEditor.this.fCachedWorkingCopy.getAdapter(WorkItemUIWorkingCopy.class);
                            IWorkItemListener uiListener = new IWorkItemListener(){

                                public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
                                }

                                public void workItemAttributeChanged(WorkItemChangeEvent event) {
                                    if (!event.affects(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY)) {
                                        return;
                                    }
                                    uiCopy.getUIWorkItemListener().removeListener((IWorkItemListener)this);
                                    new UIUpdaterJob(Messages.WorkItemEditor_SYNCHRONIZE_EDITOR){

                                        public IStatus runInBackground(IProgressMonitor monitor) {
                                            IEditorInput input = WorkItemEditor.this.getEditorInput();
                                            if (input instanceof WorkItemEditorInput) {
                                                try {
                                                    ((WorkItemEditorInput)input).updateEditorPresentation(monitor);
                                                    fNewEditorId = ((WorkItemEditorInput)input).getEditorPresentation().getEditorLayout();
                                                }
                                                catch (TeamRepositoryException e) {
                                                    return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.WorkItemEditor_ERROR_SYNCHRONIZING_EDITOR, (Throwable)e);
                                                }
                                            }
                                            return super.runInBackground(monitor);
                                        }

                                        public IStatus runInUI(IProgressMonitor monitor) {
                                            WorkItemEditor.this.updateEditorLayout();
                                            return Status.OK_STATUS;
                                        }
                                    }.schedule();
                                }
                            };
                            uiCopy.getUIWorkItemListener().addListener(uiListener);
                            boolean changed = false;
                            try {
                                workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                                changed = workItemClient.updateWorkItemType(workItem, newT, oldT, monitor);
                            }
                            finally {
                                workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)workItem);
                            }
                            if (changed) {
                                return Status.CANCEL_STATUS;
                            }
                            uiCopy.getUIWorkItemListener().removeListener(uiListener);
                        }
                    }
                    if ((input = WorkItemEditor.this.getEditorInput()) instanceof WorkItemEditorInput) {
                        ((WorkItemEditorInput)input).updateEditorPresentation(monitor);
                        this.fNewEditorId = ((WorkItemEditorInput)input).getEditorPresentation().getEditorLayout();
                    }
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.WorkItemEditor_ERROR_SYNCHRONIZING_EDITOR, (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (WorkItemEditor.this.isDirty() || this.fNewEditorId != null && !this.fNewEditorId.equals(WorkItemEditor.this.fCurrentLayoutId)) {
                    WorkItemEditor.this.updateEditorLayout();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void updateEditorLayout() {
        this.removePages();
        this.removeHeader();
        this.createHeader(this.getHeaderForm());
        this.createPages();
    }

    private void removeHeader() {
        if (this.fHeaderSection != null && this.getHeaderForm() != null) {
            this.getHeaderForm().removePart((IFormPart)this.fHeaderSection.getFormPart());
            this.fHeaderSection.getFormPart().dispose();
        }
    }

    public List getPages() {
        return this.pages;
    }

    public void activatePart(String partId) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)input;
            String layoutId = workItemEditorInput.getEditorPresentation().getEditorLayout();
            Map presentations = workItemEditorInput.getEditorPresentation().getPresentationsMap();
            String tabId = null;
            List tabs = (List)presentations.get(layoutId);
            for (AbstractPresentationDescriptor tab : tabs) {
                if (!(tab instanceof TabDescriptor) || presentations.get(tab.getElementId()) == null) continue;
                for (AbstractPresentationDescriptor section : (List)presentations.get(tab.getElementId())) {
                    if (!(section instanceof SectionDescriptor) || presentations.get(section.getElementId()) == null) continue;
                    for (AbstractPresentationDescriptor part : (List)presentations.get(section.getElementId())) {
                        if (!(part instanceof PresentationDescriptor) || !part.getElementId().equals(partId)) continue;
                        tabId = tab.getElementId();
                        break;
                    }
                    if (tabId != null) break;
                }
                if (tabId != null) break;
            }
            if (tabId == null) {
                return;
            }
            for (Object o : this.getPages()) {
                if (!(o instanceof TeamFormPage) || !((TeamFormPage)o).getId().equals(tabId)) continue;
                this.setActiveEditor((IEditorPart)((TeamFormPage)o));
                IFormPart[] formParts = ((TeamFormPage)o).getManagedForm().getParts();
                int i = 0;
                while (i < formParts.length) {
                    IFormPart section = formParts[i];
                    if (section instanceof WorkItemTeamFormSectionPart) {
                        if (((WorkItemTeamFormSectionPart)section).getPart(partId) != null) {
                            ((WorkItemTeamFormSectionPart)section).setFocus();
                            ((WorkItemTeamFormSectionPart)section).getPart(partId).setFocus();
                            return;
                        }
                    } else if (section instanceof WorkItemTeamFormPartContainer && ((WorkItemTeamFormPartContainer)section).getPart(partId) != null) {
                        ((WorkItemTeamFormPartContainer)section).setFocus();
                        ((WorkItemTeamFormPartContainer)section).getPart(partId).setFocus();
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    protected IEditorPart getEditor(int pageIndex) {
        if (this.getPageCount() != this.pages.size()) {
            return super.getEditor(pageIndex);
        }
        if (pageIndex >= 0 && pageIndex < this.pages.size() && this.pages.get(pageIndex) instanceof IEditorPart) {
            return (IEditorPart)this.pages.get(pageIndex);
        }
        return super.getEditor(pageIndex);
    }

    protected void addPages() {
        if (this.getContainer() == null) {
            return;
        }
        this.getToolkit().setBorderStyle(0);
        IEditorInput input = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            Map presentations;
            String layoutId;
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)input;
            this.fCurrentLayoutId = layoutId = workItemEditorInput.getEditorPresentation().getEditorLayout();
            if (this.fCachedWorkingCopy != null) {
                this.fCurrentDisplayedType = this.fCachedWorkingCopy.getWorkItem().getWorkItemType();
            }
            if ((presentations = workItemEditorInput.getEditorPresentation().getPresentationsMap()).get(layoutId) == null) {
                String message = NLS.bind((String)Messages.WorkItemEditor_NOE_EDITORLAYOUT_DEFINED, (Object)"com.ibm.team.workitem.editor.default", (Object[])new Object[0]);
                if (!layoutId.equals("com.ibm.team.workitem.editor.default")) {
                    message = NLS.bind((String)Messages.WorkItemEditor_BOUND_EDITORLAYOUT_NOT_DEFINED, (Object)workItemEditorInput.getWorkItem().getWorkItemType(), (Object[])new Object[]{layoutId});
                }
                DetailedStatus status = new DetailedStatus(4, "com.ibm.team.workitem.ide.ui", 4, message, null);
                this.setInput(new WorkItemEditorInputError(workItemEditorInput.getWorkItemHandle(), (IDetailedStatus)status, true));
                return;
            }
            for (AbstractPresentationDescriptor descriptor : (List)presentations.get(layoutId)) {
                TeamFormPage tab;
                if (!(descriptor instanceof TabDescriptor) || (tab = WorkItemEditorTabs.createTab(workItemEditorInput, presentations, (TabDescriptor)descriptor)) == null) continue;
                tab.initialize((FormEditor)this);
                try {
                    this.addPage((IFormPage)tab);
                }
                catch (PartInitException x) {
                    WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.WorkItemEditor_ERROR_CREATING_PAGE, (Object)((TabDescriptor)descriptor).getTitle(), (Object[])new Object[0]), x);
                }
            }
            this.addContributedPages();
            if (this.getPageCount() == 0) {
                DetailedStatus status = new DetailedStatus(4, "com.ibm.team.workitem.ide.ui", 4, Messages.WorkItemEditor_EDITOR_NO_VALID_PAGES, null);
                this.setInput(new WorkItemEditorInputError(workItemEditorInput.getWorkItemHandle(), (IDetailedStatus)status, true));
            }
        } else if (input instanceof WorkItemEditorInput && !((WorkItemEditorInput)input).isResolved()) {
            try {
                this.addPage((IEditorPart)new TeamFormPage((FormEditor)this, PROGRESS_PAGE_ID, Messages.WorkItemEditor_LOADING), input);
            }
            catch (PartInitException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemEditor_ERROR_ADDING_PAGE, x);
            }
        } else {
            try {
                this.addPage((IEditorPart)new TeamFormPage((FormEditor)this, PROGRESS_PAGE_ID, Messages.WorkItemEditor_FAILED_PAGE_TITLE), input);
            }
            catch (PartInitException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemEditor_ERROR_ADDING_PAGE, x);
            }
        }
    }

    private void addContributedPages() {
        FormEditorPagesRegistry registry = FormEditorPagesRegistry.getInstance();
        for (FormEditorPagesRegistry.FormEditorPageDescription curDesc : registry.getEditorPages()) {
            try {
                FormEditorPage curPage = curDesc.createPage((FormEditor)this);
                if (curPage == null) continue;
                this.addPage(curPage.getFormPage());
            }
            catch (PartInitException ex) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.WorkItemEditor_ERROR_CREATING_PAGE, (Object)curDesc.getTitle(), (Object[])new Object[0]), ex);
            }
        }
    }

    public void completeEditorInputAvailable(final WorkItemEditorInput input) {
        if (this.isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (WorkItemEditor.this.isDisposed()) {
                    return;
                }
                TeamRepositoryException exception = input.getException();
                if (exception != null) {
                    String repositoryURI = Messages.WorkItemEditor_UNKNOWN_REPO;
                    if (exception.getOrigin() instanceof ITeamRepository) {
                        repositoryURI = ((ITeamRepository)exception.getOrigin()).getRepositoryURI().toString();
                    }
                    DetailedStatus status = new DetailedStatus(4, "com.ibm.team.workitem.ide.ui", 4, NLS.bind((String)Messages.WorkItemEditor_ERROR_LOADING_WORKITEM_FROM_REPO, (Object)repositoryURI, (Object[])new Object[0]), (Throwable)exception);
                    WorkItemEditor.this.setInput(new WorkItemEditorInputError(input.getWorkItemHandle(), (IDetailedStatus)status, false));
                    return;
                }
                try {
                    input.acquire();
                    WorkItemEditor.this.setInput(input);
                    IWorkItem workItem = input.getWorkItem();
                    if (workItem.getId() != -1) {
                        ClientModel.getHistoryManager().addToHistory((IWorkItemHandle)workItem, WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem));
                    }
                }
                finally {
                    input.release();
                }
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        String newLayoutId;
        IReadStateTracker tracker;
        boolean isCreation;
        if (!this.performConnectionValidation()) {
            if (monitor != null) {
                monitor.setCanceled(true);
                return;
            }
            throw new OperationCanceledException();
        }
        try {
            super.doSave(monitor);
        }
        catch (RuntimeException x) {
            if (x instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)x);
            }
            DetailedStatus status = new DetailedStatus(4, "com.ibm.team.workitem.ide.ui", 4, Messages.WorkItemEditor_SAVE_PROBLEM, (Throwable)x);
            WorkItemIDEUIPlugin.getDefault().log((IStatus)status);
            this.setStatus(Messages.WorkItemEditor_SAVING_WORKITEM, (IDetailedStatus)status);
            if (monitor != null) {
                monitor.setCanceled(true);
                return;
            }
            throw new OperationCanceledException();
        }
        if (monitor.isCanceled()) {
            return;
        }
        boolean bl = isCreation = this.fCachedWorkingCopy.getWorkItem().getId() == -1;
        if (!this.validateStringLengths()) {
            if (monitor != null) {
                monitor.setCanceled(true);
                return;
            }
            throw new OperationCanceledException();
        }
        if (!this.performTagValidation()) {
            if (monitor != null) {
                monitor.setCanceled(true);
                return;
            }
            throw new OperationCanceledException();
        }
        this.handleEmptyCategory();
        this.handleAttachments();
        String layoutId = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            layoutId = ((WorkItemEditorInput)input).getEditorPresentation().getEditorLayout();
        }
        this.clearStatus();
        IDetailedStatus status = this.performSave(monitor);
        boolean done = false;
        block5: while (!done) {
            done = true;
            switch (status.getSeverity()) {
                case 4: 
                case 8: {
                    List itemHandles;
                    boolean error = true;
                    Throwable x = status.getException();
                    if (x instanceof MultiStaleDataException) {
                        itemHandles = new ArrayList();
                        IReconcileReport[] iReconcileReportArray = ((MultiStaleDataException)x).getReconcileReports();
                        int n = iReconcileReportArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IReconcileReport report = iReconcileReportArray[n2];
                            itemHandles.add((IAuditableHandle)report.getOutgoing());
                            ++n2;
                        }
                        String[] labels = new String[]{Messages.WorkItemEditor_MERGE, Messages.WorkItemEditor_DISCARD, Messages.WorkItemEditor_CANCEL};
                        int result = this.openUpdateConflictDialog(labels, itemHandles);
                        if (result == 0) {
                            this.performRefresh(new ArrayList<IAuditableHandle>(itemHandles), monitor);
                            error = false;
                        } else if (result == 1) {
                            this.performRevert(new ArrayList<IAuditableHandle>(itemHandles), monitor);
                            error = false;
                        }
                    } else if (x instanceof PendingItemChangesException) {
                        itemHandles = ((PendingItemChangesException)x).getItemHandles();
                        if (this.openAdditionalChangesDialog(itemHandles)) {
                            status = this.performMultiSave(new ArrayList<IAuditableHandle>(itemHandles), monitor);
                            done = false;
                        }
                        this.clearStatus();
                    } else {
                        this.setStatus(Messages.WorkItemEditor_SAVING_WORKITEM, status);
                    }
                    if (!done || !error) continue block5;
                    if (monitor != null) {
                        monitor.setCanceled(true);
                        break;
                    }
                    throw new OperationCanceledException();
                }
                default: {
                    if (status.isOK()) continue block5;
                    this.setStatus(Messages.WorkItemEditor_SAVING_WORKITEM, status);
                }
            }
        }
        IAuditableClient auditableClient = (IAuditableClient)this.fCachedWorkingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
        IWorkItem workItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)this.fCachedWorkingCopy.getWorkItem(), IWorkItem.FULL_PROFILE);
        if (workItem != null && (tracker = this.getReadStateTracker(workItem)) != null && !tracker.isMarkedRead()) {
            tracker.markRead();
        }
        IWorkItem copy = this.fCachedWorkingCopy.getWorkItem();
        if (isCreation && copy.getId() != -1 && !monitor.isCanceled()) {
            ClientModel.getHistoryManager().addToHistory((IWorkItemHandle)copy, WorkItemTextUtilities.getWorkItemText((IWorkItem)copy));
        }
        this.updateEditorTab();
        input = this.getEditorInput();
        if (status.isOK() && layoutId != null && input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved() && !layoutId.equals(newLayoutId = ((WorkItemEditorInput)input).getEditorPresentation().getEditorLayout())) {
            this.updateEditorLayout();
        }
    }

    private IDetailedStatus getStatus() {
        if (this.fTitlePart != null) {
            return this.fTitlePart.getStatus();
        }
        return null;
    }

    private void setStatus(String operationName, IDetailedStatus status) {
        if (this.fTitlePart != null) {
            this.fTitlePart.setStatus(operationName, status);
        }
    }

    private void clearStatus() {
        if (this.fTitlePart != null) {
            this.fTitlePart.clearStatus();
        }
    }

    private void clearOldStatus(IDetailedStatus oldStatus) {
        if (this.getStatus() == oldStatus) {
            this.clearStatus();
        }
    }

    private void handleEmptyCategory() {
        final ICategory[] guessedCategory = new ICategory[1];
        final IDetailedStatus[] status = new IDetailedStatus[1];
        final String[] hierarchicalName = new String[1];
        final boolean[] alreadyLogged = new boolean[1];
        InternalSafeRunner.run(new ISafeRunnable(){

            public void run() throws Exception {
                WorkItemEditor.this.runLongOperation(new IRunnableWithProgress(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) {
                        IWorkItemClient workitemClient = (IWorkItemClient)WorkItemEditor.this.fCachedWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                        try {
                            if (!workitemClient.findRequiredProperties(WorkItemEditor.this.fCachedWorkingCopy.getWorkItem(), monitor).contains(IWorkItem.CATEGORY_PROPERTY)) {
                                return;
                            }
                            WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)WorkItemEditor.this.fCachedWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                            ICategory category = (ICategory)uiWorkingCopy.getResolvedWorkItem().getValue(IWorkItem.CATEGORY_PROPERTY);
                            if (!category.isUnassigned()) {
                                return;
                            }
                            monitor.beginTask(Messages.WorkItemEditor_GUESSING_CATEGORY, 1);
                            ICategoryHandle guessedCategoryHandle = workitemClient.guessCategory(WorkItemEditor.this.fCachedWorkingCopy.getWorkItem(), monitor);
                            if (guessedCategoryHandle == null) return;
                            IAuditableClient auditableClient = (IAuditableClient)WorkItemEditor.this.fCachedWorkingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
                            guessedCategory[0] = (ICategory)auditableClient.resolveAuditable((IAuditableHandle)guessedCategoryHandle, ICategory.FULL_PROFILE, monitor);
                            hierarchicalName[0] = workitemClient.resolveHierarchicalName(guessedCategoryHandle, monitor);
                            return;
                        }
                        catch (TeamRepositoryException e) {
                            guessedCategory[0] = null;
                            status[0] = DetailedStatus.createFromException((String)Messages.WorkItemEditor_ERROR_GUESSING_CATEGORY, (Throwable)e);
                            return;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }

            public void handleException(Throwable x) {
                status[0] = DetailedStatus.createFromException((String)Messages.WorkItemEditor_ERROR_GUESSING_CATEGORY, (Throwable)x);
                alreadyLogged[0] = true;
            }
        });
        if (!alreadyLogged[0] && status[0] != null && status[0].getSeverity() == 4 && this.shouldLog(status[0].getException())) {
            WorkItemIDEUIPlugin.getDefault().log((IStatus)status[0]);
        }
        if (guessedCategory[0] != null) {
            String message = NLS.bind((String)Messages.WorkItemEditor_WANT_TO_GUESS_CATEGORY, (Object)hierarchicalName[0], (Object[])new Object[0]);
            MessageDialog md = new MessageDialog(this.getSite().getShell(), Messages.WorkItemEditor_UNASSINGED_FILED_AGAINST, null, message, 3, new String[]{Messages.WorkItemEditor_CHOOSE_CATEGORY, IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1){

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
                    ((GridData)this.getButton((int)1).getLayoutData()).horizontalAlignment = 0x1000008;
                    ((GridData)this.getButton((int)1).getLayoutData()).horizontalIndent = 20;
                }
            };
            int res = md.open();
            switch (res) {
                case 0: {
                    ICategory category = ItemSelectionDialog.getCategory((Shell)this.getSite().getShell(), (IProjectAreaHandle)this.fCachedWorkingCopy.getWorkItem().getProjectArea(), (IWorkItem)this.fCachedWorkingCopy.getWorkItem(), (ICategory)guessedCategory[0], (boolean)false);
                    if (category == null) break;
                    this.fCachedWorkingCopy.getWorkItem().setCategory((ICategoryHandle)category);
                    break;
                }
                case 1: {
                    this.fCachedWorkingCopy.getWorkItem().setCategory((ICategoryHandle)guessedCategory[0]);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new OperationCanceledException();
                }
            }
        }
    }

    private void handleAttachments() {
        long maxSize = -1L;
        WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)this.fCachedWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        for (ArtifactLink link : uiWorkingCopy.getArtifactLinks()) {
            if (!link.needsUpload()) continue;
            if (maxSize == -1L) {
                maxSize = this.fetchMaxAttachmentSize();
            }
            if (link.getContentLength() <= maxSize) continue;
            String title = Messages.WorkItemEditor_ATTACHMENT_TOO_LARGE;
            String message = NLS.bind((String)Messages.WorkItemEditor_ATTACHMENT_TOO_LARGE_MAX_SIZE_IS, (Object)link.getName(), (Object[])new Object[]{link.getContentLength() / 1024L / 1024L, maxSize / 1024L / 1024L});
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
            throw new OperationCanceledException();
        }
        long size = 0L;
        for (ArtifactLink link : uiWorkingCopy.getArtifactLinks()) {
            if (!link.needsUpload()) continue;
            size += link.getContentLength();
        }
        if (size > 0xA00000L) {
            String title = Messages.WorkItemEditor_UPLOADING_LARGE_ATTACHMENTS;
            String message = NLS.bind((String)Messages.WorkItemEditor_ATTACHMENTS_ARE_LARGE, (Object)(size / 1024L / 1024L), (Object[])new Object[0]);
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            if (dialog.open() != 0) {
                throw new OperationCanceledException();
            }
        }
    }

    private long fetchMaxAttachmentSize() {
        final long[] maxSize = new long[1];
        this.runLongOperationWithExceptionHandling(Messages.WorkItemEditor_DETERMINING_MAX_SIZE, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(Messages.WorkItemEditor_DETERMINING_MAX_SIZE, 1);
                        ITeamRepository teamRepository = WorkItemEditor.this.fCachedWorkingCopy.getTeamRepository();
                        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                        maxSize[0] = workItemClient.fetchMaxAttachmentSize(monitor);
                    }
                    catch (TeamRepositoryException x) {
                        throw new InvocationTargetException(x);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        return maxSize[0];
    }

    private IDetailedStatus performSave(IProgressMonitor monitor) {
        return this.performMultiSave(Collections.<IWorkItemHandle>emptyList(), monitor);
    }

    private IDetailedStatus performMultiSave(final List<IWorkItemHandle> additionalItems, IProgressMonitor monitor) {
        final boolean[] alreadyLogged = new boolean[1];
        final IDetailedStatus[] result = new IDetailedStatus[1];
        SafeRunnable safeRunnable = new SafeRunnable(){

            public void run() throws Exception {
                WorkItemEditor.this.runLongOperation(new IRunnableWithProgress(){

                    /*
                     * Unable to fully structure code
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(Messages.WorkItemEditor_SAVING_WORKITEM, 1);
                            try {
                                if (LinkHelper.canModifyCalmLinks(WorkItemEditor.access$1(9.access$0(this)))) {
                                    WorkItemEditor.access$1(9.access$0(this)).getAdditionalSaveParameters().add("com.ibm.team.workitem.common.internal.util.updateBacklinks");
                                }
                                workingCopyManager = ((WorkItemEditorInput)9.access$0(this).getEditorInput()).getWorkingCopyManager();
                                additionalCopies = new ArrayList<WorkItemWorkingCopy>();
                                try {
                                    for (IWorkItemHandle workItemHandle : additionalItems) {
                                        if (!workingCopyManager.connectLocal(workItemHandle, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[0]))) continue;
                                        additionalCopies.add(workingCopyManager.getWorkingCopy(workItemHandle));
                                    }
                                    allCopies = new ArrayList<WorkItemWorkingCopy>();
                                    allCopies.add(WorkItemEditor.access$1(9.access$0(this)));
                                    allCopies.addAll(additionalCopies);
                                    result[0] = workingCopyManager.save(allCopies.toArray(new WorkItemWorkingCopy[allCopies.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    input = 9.access$0(this).getEditorInput();
                                    if (!(input instanceof WorkItemEditorInput)) ** break block13
                                    if (((WorkItemEditorInput)input).isResolved()) {
                                        ((WorkItemEditorInput)input).updateEditorPresentation(monitor);
                                    }
                                    break block14;
                                }
                                finally {
                                    var8_9 = additionalCopies.iterator();
                                    if (true) ** GOTO lbl37
                                }
                                {
                                    block14: {
                                    }
                                }
                                do {
                                    copy = (WorkItemWorkingCopy)var8_9.next();
                                    workingCopyManager.disconnect((IWorkItemHandle)copy.getWorkItem());
lbl37:
                                    // 2 sources

                                } while (var8_9.hasNext());
                            }
                            catch (TeamRepositoryException x) {
                                result[0] = DetailedStatus.createFromException((String)Messages.WorkItemEditor_EXCEPTION_SAVING_WORKITEM, (Throwable)x);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }

            public void handleException(Throwable x) {
                alreadyLogged[0] = true;
                result[0] = DetailedStatus.createFromException((String)Messages.WorkItemEditor_EXCEPTION_SAVING_WORKITEM, (Throwable)x);
            }

            static /* synthetic */ WorkItemEditor access$0(9 var0) {
                return var0.WorkItemEditor.this;
            }
        };
        InternalSafeRunner.run((ISafeRunnable)safeRunnable);
        if (!alreadyLogged[0] && result[0].getSeverity() == 4 && this.shouldLog(result[0].getException())) {
            WorkItemIDEUIPlugin.getDefault().log((IStatus)result[0]);
        }
        return result[0];
    }

    private boolean shouldLog(Throwable x) {
        return !(x instanceof TeamOperationCanceledException) && !(x instanceof StaleDataException) && !(x instanceof MultiStaleDataException) && !(x instanceof PendingItemChangesException);
    }

    private boolean performTagValidation() {
        if (this.fCachedWorkingCopy.getWorkItem().getTags2().isEmpty()) {
            return true;
        }
        IWorkItem baseState = ((WorkItemWorkingCopyImpl)this.fCachedWorkingCopy).getBaseState();
        if (baseState != null && this.fCachedWorkingCopy.getWorkItem().getTags().equals(baseState.getTags())) {
            return true;
        }
        final Object[] result = new Object[1];
        this.runLongOperationWithExceptionHandling(Messages.WorkItemEditor_VALIDATING_TAGS, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.WorkItemEditor_VALIDATING_TAGS, 1);
                try {
                    IClientLibraryContext context = (IClientLibraryContext)WorkItemEditor.this.fCachedWorkingCopy.getTeamRepository();
                    result[0] = context.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                        public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                            return WorkItemEditor.this.getUndefinedTags(WorkItemEditor.this.fCachedWorkingCopy.getWorkItem().getTags2(), monitor);
                        }
                    }, monitor);
                }
                catch (TeamRepositoryException x) {
                    throw new InvocationTargetException(x);
                }
            }
        });
        if (result[0] == null || !(result[0] instanceof List)) {
            return true;
        }
        List newTags = (List)result[0];
        if (newTags.size() > 0) {
            String tags = "";
            for (String tag : newTags) {
                tags = String.valueOf(tags) + NLS.bind((String)", ''{0}''", (Object)tag, (Object[])new Object[0]);
            }
            if (tags.length() > 1) {
                tags = tags.substring(2);
            }
            String message = newTags.size() == 1 ? NLS.bind((String)Messages.WorkItemEditor_SAVING_CREATES_TAG, (Object)tags, (Object[])new Object[0]) : NLS.bind((String)Messages.WorkItemEditor_SAVING_CREATES_TAGS, (Object)tags, (Object[])new Object[0]);
            MessageDialog md = new MessageDialog(this.getSite().getShell(), Messages.WorkItemEditor_DEFINING_NEW_TAGS, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            return md.open() == 0;
        }
        return true;
    }

    private List<String> getUndefinedTags(List<String> tags, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = this.fCachedWorkingCopy.getTeamRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        ArrayList<String> results = new ArrayList<String>();
        try {
            List allTags = workItemClient.findTags(this.fCachedWorkingCopy.getWorkItem().getProjectArea(), monitor);
            for (String candidate : tags) {
                if (allTags.contains(candidate)) continue;
                results.add(candidate);
            }
        }
        catch (QueryExpiredException q) {
            WorkItemIDEUIPlugin.getDefault().log(q.getLocalizedMessage(), q);
        }
        return results;
    }

    private boolean validateStringLengths() {
        IWorkItemUIWorkingCopy uiWorkingCopy = (IWorkItemUIWorkingCopy)this.fCachedWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        boolean valid = true;
        valid &= this.validateStringLength((IType)IWorkItem.ITEM_TYPE, IWorkItem.SUMMARY_PROPERTY, uiWorkingCopy.getSummary(), Messages.WorkItemEditor_SUMMARY, Messages.WorkItemEditor_SUMMARY_EXCEEDS_MAX_LENGTH, null);
        String attachmentName = Messages.WorkItemEditor_DESCRIPTION_ATTACHMENT_NAME;
        if (attachmentName.length() < 3) {
            attachmentName = NLS.bind((String)"{0}-0", (Object)attachmentName, (Object[])new Object[0]);
        }
        valid &= this.validateStringLength((IType)IWorkItem.ITEM_TYPE, IWorkItem.DESCRIPTION_PROPERTY, ((WorkItemUIWorkingCopy)uiWorkingCopy).getDescription(), Messages.WorkItemEditor_DESCRIPTION, Messages.WorkItemEditor_DESCRIPTION_EXCEEDS_MAX_LENGTH, attachmentName);
        attachmentName = NLS.bind((String)"{0}-{1}", (Object)Messages.WorkItemEditor_COMMENT_ATTACHMENT_NAME, (Object[])new Object[]{this.fCachedWorkingCopy.getWorkItem().getComments().getContents().length + 1});
        valid &= this.validateStringLength((IType)IComment.HELPER_TYPE, IComment.CONTENT_PROPERTY, uiWorkingCopy.getNewComment(), Messages.WorkItemEditor_NEW_COMMENT, Messages.WorkItemEditor_COMMENTS_EXCEEDS_MAX_LENGTH, attachmentName);
        String newTags = this.validateStringLength((IType)IWorkItem.ITEM_TYPE, IWorkItem.TAGS_PROPERTY, this.fCachedWorkingCopy.getWorkItem().getTags(), Messages.WorkItemEditor_TAGS, Messages.WorkItemEditor_TAG_EXCEEDS_MAX_LENGTH);
        if (newTags != null) {
            this.fCachedWorkingCopy.getWorkItem().setTags(newTags);
            valid = false;
        }
        return valid;
    }

    private boolean validateStringLength(IType type, String property, IStyledDocument value, String name, String question, String attachmentName) {
        boolean offerAttachment;
        boolean shorten;
        boolean tooLong = Utils.isTooLong((IType)type, (String)property, (String)value.getHTML().getXMLText());
        if (tooLong && (shorten = this.openShortenQuestionDialog(name, question, offerAttachment = attachmentName != null))) {
            try {
                if (offerAttachment) {
                    this.createAttachment(attachmentName, value);
                }
                Util.shorten(type, property, value, offerAttachment);
            }
            catch (IOException x) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.WorkItemEditor_EXCEPTION_UPLOADING_ATTACHMENT, (Object)name, (Object[])new Object[0]), x);
            }
        }
        return !tooLong;
    }

    private void createAttachment(String name, IStyledDocument content) throws IOException {
        String suffix = ".html";
        File file = File.createTempFile(name, suffix);
        file.deleteOnExit();
        FileOutputStream stream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        writer.write("<html><head></head><body>");
        writer.write(content.getHTML().getXMLText());
        writer.write("</body>");
        ((Writer)writer).close();
        ((OutputStream)stream).close();
        IURIReference reference = IReferenceFactory.INSTANCE.createReferenceFromURI(file.toURI(), String.valueOf(name) + suffix);
        if (reference != null) {
            this.fCachedWorkingCopy.getReferences().add(WorkItemEndPoints.ATTACHMENT, (IReference)reference);
        }
    }

    private String validateStringLength(IType type, String property, String string, String name, String question) {
        if (Utils.isTooLong((IType)type, (String)property, (String)string)) {
            if (this.openShortenQuestionDialog(name, question, false)) {
                return Utils.shorten((IType)type, (String)property, (String)string);
            }
            return string;
        }
        return null;
    }

    private boolean openShortenQuestionDialog(String name, String question, boolean offerAttachment) {
        String title = NLS.bind((String)Messages.WorkItemEditor_TOO_LONG, (Object)name, (Object[])new Object[0]);
        String shorten = offerAttachment ? Messages.WorkItemEditor_CREATE_ATTACHMENT_AND_SHORTEN : Messages.WorkItemEditor_SHORTEN;
        String message = NLS.bind((String)Messages.WorkItemEditor_SHORTEN_STATEMENT_FOLLOWED_BY_SHORTEN_QUESTION, (Object)question, (Object[])new Object[]{shorten});
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)title, (String)message);
    }

    private void runLongOperationWithExceptionHandling(String operationName, IRunnableWithProgress runnable) {
        try {
            this.getSite().getWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause() != null ? x.getCause() : x;
            FoundationLog log = FoundationLog.getLog((String)"com.ibm.team.workitem.ide.ui");
            log.error(cause.getMessage(), cause);
            this.setStatus(operationName, DetailedStatus.createFromException((String)Messages.WorkItemEditor_EXCEPTION_RUNNING_OPERATION, (Throwable)cause));
            throw new OperationCanceledException(cause.getMessage());
        }
        catch (InterruptedException x) {
            throw new OperationCanceledException(x.getMessage());
        }
    }

    private void runLongOperation(IRunnableWithProgress runnable) {
        try {
            this.getSite().getWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException x) {
            if (x.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)x.getTargetException();
            }
            if (x.getTargetException() instanceof Error) {
                throw (Error)x.getTargetException();
            }
            throw new UndeclaredThrowableException(x.getTargetException() != null ? x.getTargetException() : x);
        }
        catch (InterruptedException x) {
            throw new OperationCanceledException(x.getMessage());
        }
    }

    private int openUpdateConflictDialog(String[] labels, List<IAuditableHandle> itemHandles) {
        String title = Messages.WorkItemEditor_UPDATE_CONFLICT;
        String message = Messages.WorkItemEditor_FOLLOWING_WORKITEMS_CHANGED;
        ItemConfirmationDialog dialog = new ItemConfirmationDialog(this.getSite().getShell(), title, message, 4, labels, itemHandles){

            protected void createTooltipSupport(Control control) {
                new RemoteChangesTooltipSupport(control);
            }
        };
        return dialog.open();
    }

    private boolean openAdditionalChangesDialog(List<IAuditableHandle> itemHandles) {
        String title = Messages.WorkItemEditor_SAVE_ADDITIONAL_CHANGES;
        String message = Messages.WorkItemEditor_FOLLOWING_ADDITIONAL_WORKITEMS_NEED_SAVING;
        ItemConfirmationDialog dialog = new ItemConfirmationDialog(this.getSite().getShell(), title, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, itemHandles);
        return dialog.open() == 0;
    }

    public int promptToSaveOnClose() {
        String choice;
        if (this.fCachedWorkingCopy == null || !((WorkItemWorkingCopyImpl)this.fCachedWorkingCopy).hasOtherWriteConnection(((WorkItemEditorInput)this.getEditorInput()).getWorkingCopyManager())) {
            return 3;
        }
        String[] choices = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, Messages.WorkItemEditor_DISCARD, IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.WorkItemEditor_SAVE_WORKITEM, null, NLS.bind((String)Messages.WorkItemEditor_MODIFIED_OPEN_IN_ANOTHER_EDITOR, (Object)this.getEditorInput().getName(), (Object[])new Object[0]), 3, choices, 0);
        int result = dialog.open();
        String string = choice = result >= 0 && result < choices.length ? choices[result] : IDialogConstants.CANCEL_LABEL;
        if (IDialogConstants.YES_LABEL.equals(choice)) {
            return 0;
        }
        if (IDialogConstants.NO_LABEL.equals(choice)) {
            return 1;
        }
        if (IDialogConstants.CANCEL_LABEL.equals(choice)) {
            return 2;
        }
        ((WorkItemEditorInput)this.getEditorInput()).getWorkingCopyManager().refresh((IWorkItemHandle)this.fCachedWorkingCopy.getWorkItem());
        return 1;
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.fCachedWorkingCopy != null && this.fCachedWorkingCopy.isDirty() || super.isDirty();
    }

    public void setInput(IEditorInput input) {
        IReadStateTracker tracker;
        IEditorInput oldInput = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).needsLoading()) {
            WorkItemEditorInput futureInput = new WorkItemEditorInput(((WorkItemEditorInput)input).getWorkItemHandle());
            WorkItemEditorInputFuture future = new WorkItemEditorInputFuture(futureInput);
            future.addWaitingEditor(this);
        }
        this.removePages();
        this.fCachedWorkingCopy = null;
        this.fPartialWorkItem = null;
        if (this.fTitlePart != null) {
            this.fTitlePart.clearStatus();
        }
        this.fChangeDecorator.setShowChangeDecoration(false);
        super.setInput(input);
        if (this.fTitlePart != null) {
            this.fTitlePart.setInput(input);
        }
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput editorInput = (WorkItemEditorInput)input;
            this.fCachedWorkingCopy = editorInput.getWorkingCopy();
            this.acquireEditorInput(editorInput);
            this.fChangeDecorator.setShowChangeDecoration(this.fCachedWorkingCopy.isStale());
            if (this.fCachedWorkingCopy.isDirty()) {
                this.firePropertyChange(257);
            }
            if (this.fRefreshJob == null) {
                this.fRefreshJob = new InternalRefreshJob();
            }
            this.fRefreshJob.scheduleDelayed();
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fCachedWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            IProjectArea area = (IProjectArea)workItem.getValue(WorkItemAttributes.getAttributeId((Identifier)WorkItemAttributes.PROJECT_AREA));
            if (area != null && area.isArchived()) {
                this.setStatus("", (IDetailedStatus)new DetailedStatus(2, "com.ibm.team.workitem.ide.ui", 70003, Messages.WorkItemEditor_PROJECT_AREA_ARCHIVED, null));
            }
        } else if (input instanceof AbstractWorkItemEditorInput) {
            IWorkItemHandle handle = ((AbstractWorkItemEditorInput)input).getWorkItemHandle();
            IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)handle.getOrigin()).getClientLibrary(IAuditableClient.class);
            this.fPartialWorkItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE);
            if (input instanceof WorkItemEditorInputError && this.fTitlePart != null) {
                IDetailedStatus status = ((WorkItemEditorInputError)input).getStatus();
                this.fTitlePart.setStatus(Messages.WorkItemEditor_LOADING_WORKITEM_STATUS, status);
            }
        }
        if (this.getHeaderForm() != null && input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            this.removeHeader();
            this.createHeader(this.getHeaderForm());
        }
        if (this.getToolkit() != null && this.getContainer() != null) {
            this.createPages();
        }
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved() && (tracker = this.getReadStateTracker(((WorkItemEditorInput)input).getWorkItem())) != null && !tracker.isMarkedRead()) {
            tracker.markRead();
        }
        this.releaseEditorInput(oldInput);
        this.updatePrintEnablement();
        this.updateEditorTab();
        if (oldInput == null || input == null || !oldInput.equals(input)) {
            this.firePropertyChange(258);
        }
    }

    private IReadStateTracker getReadStateTracker(IWorkItem workItem) {
        if (workItem instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)workItem;
            return (IReadStateTracker)adaptable.getAdapter(IReadStateTracker.class);
        }
        IAdapterManager manager = Platform.getAdapterManager();
        return (IReadStateTracker)manager.getAdapter((Object)workItem, IReadStateTracker.class);
    }

    private void updateEditorTab() {
        if (this.getEditorInput() != null) {
            this.setPartName(this.getEditorInput().getName());
            if (this.fCachedWorkingCopy != null) {
                this.setTitleImage(this.fLabelProvider.getImage((Object)this.fCachedWorkingCopy.getWorkItem()));
            } else if (this.fPartialWorkItem != null) {
                this.setTitleImage(this.fLabelProvider.getImage((Object)this.fPartialWorkItem));
            }
        } else {
            this.setPartName(Messages.WorkItemEditor_LOADING_WORKITEM);
            this.setTitleImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.WORKITEM_TITLE));
        }
        this.firePropertyChange(1);
    }

    public void dispose() {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.removeListener(this.fLabelProviderListener);
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        if (this.fHandlerActivations != null) {
            IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
            for (IHandlerActivation activation : this.fHandlerActivations.values()) {
                handlerService.deactivateHandler(activation);
            }
            this.fHandlerActivations = null;
        }
        super.dispose();
        if (this.fSourceViewerPane != null) {
            this.fSourceViewerPane.dispose();
            this.fSourceViewerPane = null;
        }
        if (this.fViewerPane != null) {
            this.fViewerPane.dispose();
            this.fViewerPane = null;
        }
        this.fCachedWorkingCopy = null;
        this.fPartialWorkItem = null;
        this.fActiveControlTracker = null;
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        if (this.fTitlePart != null) {
            this.fTitlePart.dispose();
            this.fTitlePart = null;
        }
        if (this.fRefreshJob != null) {
            this.fRefreshJob.dispose();
            this.fRefreshJob = null;
        }
        this.releaseEditorInput(this.getEditorInput());
    }

    private boolean isDisposed() {
        return this.fViewerPane == null;
    }

    private void acquireEditorInput(IEditorInput input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput editorInput = (WorkItemEditorInput)input;
            editorInput.acquire();
            WorkItemWorkingCopy workingCopy = editorInput.getWorkingCopy();
            workingCopy.addWorkingCopyListener((IWorkingCopyListener)this.fWorkingCopyListener);
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            uiCopy.getUIWorkItemListener().addListener((IWorkItemListener)this.fWorkItemListener);
        }
    }

    private void releaseEditorInput(IEditorInput input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput editorInput = (WorkItemEditorInput)input;
            WorkItemWorkingCopy workingCopy = editorInput.getWorkingCopy();
            workingCopy.removeWorkingCopyListener((IWorkingCopyListener)this.fWorkingCopyListener);
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            uiCopy.getUIWorkItemListener().removeListener((IWorkItemListener)this.fWorkItemListener);
            editorInput.release();
        }
    }

    protected Composite createPageContainer(Composite parent) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("com.ibm.magnolia.styledEditingScope");
        this.createActions();
        this.fActiveControlTracker = new ActiveControlTracker(parent);
        return super.createPageContainer(parent);
    }

    public Object getAdapter(Class adapter) {
        if (IFindReplaceTarget.class.equals((Object)adapter)) {
            if (this.fFindReplaceTarget == null) {
                this.fFindReplaceTarget = new FindReplaceTarget(this, this.fSourceViewerPane);
            }
            return this.fFindReplaceTarget;
        }
        if (SourceViewerPane.class.equals((Object)adapter)) {
            return this.fSourceViewerPane;
        }
        if (ViewerPane.class.equals((Object)adapter)) {
            return this.fViewerPane;
        }
        if (ContextProvider.class.equals((Object)adapter)) {
            return this.fContextProvider;
        }
        if (UIWorkItemWorkingCopyListener.class.equals((Object)adapter)) {
            return this.fWorkingCopyListener;
        }
        if (UIWorkItemListener.class.equals((Object)adapter)) {
            return this.fWorkItemListener;
        }
        if (PresentationHandlerManager.class.equals((Object)adapter)) {
            return this.fPresentationHandlerManager;
        }
        if (EditorPresentation.class.equals((Object)adapter) && this.getEditorInput() instanceof WorkItemEditorInput && ((WorkItemEditorInput)this.getEditorInput()).isResolved()) {
            return ((WorkItemEditorInput)this.getEditorInput()).getEditorPresentation();
        }
        if (IProgressService.class.equals((Object)adapter)) {
            return this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        }
        if (IWorkbenchWindow.class.equals((Object)adapter)) {
            return this.getSite().getWorkbenchWindow();
        }
        if (ActiveControlTracker.class.equals((Object)adapter)) {
            return this.fActiveControlTracker;
        }
        if (IServiceLocator.class.equals((Object)adapter)) {
            return this.getSite();
        }
        if (InternalRefreshJob.class.equals((Object)adapter)) {
            return this.fRefreshJob;
        }
        if (ICollaborationContextProvider.class.equals((Object)adapter)) {
            return new ICollaborationContextProvider(){

                public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor monitor) {
                    IEditorInput input = WorkItemEditor.this.getEditorInput();
                    if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
                        WorkItemEditorInput extended = (WorkItemEditorInput)input;
                        IWorkItem item = extended.getWorkItem();
                        URIReference topic = null;
                        if (item != null) {
                            if (item.isNewItem()) {
                                topic = Hyperlinks.create((Object)item, (IProgressMonitor)monitor);
                            } else {
                                Location location = Location.namedLocation((IItem)item, (String)((ITeamRepository)item.getOrigin()).getRepositoryURI());
                                String text = WorkItemTextUtilities.getWorkItemText((IWorkItem)item);
                                topic = new URIReference(text, text, location.toAbsoluteUri());
                            }
                        }
                        if (topic != null) {
                            return Collections.singleton(topic);
                        }
                    }
                    return Collections.emptySet();
                }

                public CollaborationData getContext(Collection<CollaborationUser> user, IProgressMonitor monitor) {
                    return null;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private void createActions() {
        ListResourceBundle findReplaceBundle = new ListResourceBundle(){
            private final Object[][] CONTENTS = new Object[][]{{"Editor.FindReplace.label", Messages.WorkItemEditor_FIND_REPLACE_LABEL}, {"Editor.FindReplace.tooltip", Messages.WorkItemEditor_FIND_REPLACE_TOOLTIP}, {"Editor.FindReplace.image", ""}, {"Editor.FindReplace.description", Messages.WorkItemEditor_FIND_REPLACE_DESCRIPTION}};

            protected Object[][] getContents() {
                return this.CONTENTS;
            }
        };
        FindReplaceAction action = new FindReplaceAction((ResourceBundle)findReplaceBundle, "Editor.FindReplace.", (IWorkbenchPart)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        action.setEnabled(true);
        this.activateAction((IAction)action);
        TextOperationAction quickAssist = new TextOperationAction(Messages.WorkItemEditor_QUICK_ASSIST, "Editor.QuickAssist.", null, (IWorkbenchPart)this, 22){

            public void update() {
                this.setEnabled(true);
            }
        };
        quickAssist.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.activateAction((IAction)quickAssist);
    }

    void updatePrintEnablement() {
        IAction handler;
        IActionBars actionBars;
        IWorkbenchPage page;
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (page = site.getPage()) != null && page.getActiveEditor() == this && (actionBars = ((IEditorSite)site).getActionBars()) != null && (handler = actionBars.getGlobalActionHandler(ActionFactory.PRINT.getId())) != null) {
            boolean disabled = this.fCachedWorkingCopy == null || this.fCachedWorkingCopy.getWorkItem() == null || this.fCachedWorkingCopy.getWorkItem().isNewItem() || this.fCachedWorkingCopy.isDirty();
            handler.setEnabled(!disabled);
        }
    }

    void doPrint() {
        if (this.fCachedWorkingCopy == null || this.fCachedWorkingCopy.getWorkItem() == null || this.fCachedWorkingCopy.getWorkItem().isNewItem()) {
            return;
        }
        Job printJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                if (WorkItemEditor.this.fCachedWorkingCopy == null || WorkItemEditor.this.fCachedWorkingCopy.getWorkItem() == null) {
                    return Status.OK_STATUS;
                }
                try {
                    try {
                        RestWorkItemHTMLGenerator generator = new RestWorkItemHTMLGenerator(true);
                        StringBuffer htmlBuf = new StringBuffer();
                        generator.generate(WorkItemEditor.this.fCachedWorkingCopy.getWorkItem(), new HashMap(), htmlBuf, null, monitor);
                        File tmpFile = File.createTempFile("workitem", ".html");
                        tmpFile.deleteOnExit();
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Charset.forName("UTF-8")));
                        writer.write(htmlBuf.toString());
                        writer.flush();
                        writer.close();
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
                        browser.openURL(tmpFile.toURL());
                    }
                    catch (IOException e) {
                        WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    catch (PartInitException e) {
                        WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        printJob.setUser(true);
        printJob.schedule();
    }

    private void activateAction(IAction action) {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        String actionDefinitionId = action.getActionDefinitionId();
        IHandlerActivation activation = handlerService.activateHandler(actionDefinitionId, (IHandler)new ActionHandler(action));
        this.fHandlerActivations.put(actionDefinitionId, activation);
    }

    public IAction getAction(String actionDefinitionId) {
        IHandlerActivation activation = this.fHandlerActivations.get(actionDefinitionId);
        if (activation == null || !(activation.getHandler() instanceof ActionHandler)) {
            return null;
        }
        return ((ActionHandler)activation.getHandler()).getAction();
    }

    public boolean isEditorInputModifiable() {
        IEditorInput input = this.getEditorInput();
        return input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved();
    }

    public boolean validateEditorInputState() {
        IEditorInput input = this.getEditorInput();
        return input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved();
    }

    public void doRevert(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            boolean confirmed;
            if (this.fCachedWorkingCopy != null && this.fCachedWorkingCopy.isDirty() && !(confirmed = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.WorkItemEditor_DISCARD_LOCAL_CHANGES, (String)Messages.WorkItemEditor_SURE_TO_DISCARD))) {
                return;
            }
            IWorkItemHandle handle = ((WorkItemEditorInput)input).getWorkItemHandle();
            this.performRevert(Collections.singletonList(handle), monitor);
        } else if (input instanceof WorkItemEditorInputError) {
            this.setInput(new WorkItemEditorInput(((WorkItemEditorInputError)input).getWorkItemHandle()));
        }
    }

    private void performRevert(final List<IWorkItemHandle> handles, IProgressMonitor monitor) {
        IDetailedStatus oldStatus = this.getStatus();
        this.runLongOperationWithExceptionHandling(Messages.WorkItemEditor_REVERTING_WORKITEM, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(Messages.WorkItemEditor_REVERTING_WORKITEM, 1);
                        IWorkItemWorkingCopyManager workingCopyManager = ((WorkItemEditorInput)WorkItemEditor.this.getEditorInput()).getWorkingCopyManager();
                        for (IWorkItemHandle handle : handles) {
                            if (!WorkItemEditor.this.fCachedWorkingCopy.getWorkItem().sameItemId((IItemHandle)handle) && !workingCopyManager.connectLocal(handle, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[0]))) continue;
                            try {
                                workingCopyManager.refreshWithCurrent(handle, monitor);
                            }
                            finally {
                                if (!WorkItemEditor.this.fCachedWorkingCopy.getWorkItem().sameItemId((IItemHandle)handle)) {
                                    workingCopyManager.disconnect(handle);
                                }
                            }
                        }
                    }
                    catch (TeamRepositoryException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemEditor_ERROR_REVERTING_WORKING_COPY, x);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        this.clearOldStatus(oldStatus);
    }

    public void doRefresh(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            IWorkItemHandle handle = ((WorkItemEditorInput)input).getWorkItemHandle();
            this.performRefresh(Collections.singletonList(handle), monitor);
            this.refreshProgress((WorkItemEditorInput)input);
        } else if (input instanceof WorkItemEditorInputError) {
            this.setInput(new WorkItemEditorInput(((WorkItemEditorInputError)input).getWorkItemHandle()));
        }
    }

    private void refreshProgress(WorkItemEditorInput input) {
        String progressPresentationPart = "com.ibm.team.apt.internal.ide.ui.resource.parts.WorkItemProgressPresentationPart";
        List pages = this.getPages();
        if (pages != null) {
            for (Object o : pages) {
                if (!(o instanceof TeamFormPage) || ((TeamFormPage)o).getManagedForm() == null) continue;
                IFormPart[] formParts = ((TeamFormPage)o).getManagedForm().getParts();
                int i = 0;
                while (i < formParts.length) {
                    TeamFormPart part;
                    int n;
                    int n2;
                    TeamFormPart[] teamFormPartArray;
                    TeamFormPart[] parts;
                    IFormPart section = formParts[i];
                    if (section instanceof WorkItemTeamFormSectionPart) {
                        parts = ((WorkItemTeamFormSectionPart)section).getParts();
                        if (parts != null) {
                            teamFormPartArray = parts;
                            n2 = parts.length;
                            n = 0;
                            while (n < n2) {
                                part = teamFormPartArray[n];
                                if (part.getClass().getName().equals(progressPresentationPart)) {
                                    part.setInput((Object)input);
                                }
                                ++n;
                            }
                        }
                    } else if (section instanceof WorkItemTeamFormPartContainer && (parts = ((WorkItemTeamFormPartContainer)section).getParts()) != null) {
                        teamFormPartArray = parts;
                        n2 = parts.length;
                        n = 0;
                        while (n < n2) {
                            part = teamFormPartArray[n];
                            if (part.getClass().equals(progressPresentationPart)) {
                                part.setInput((Object)input);
                            }
                            ++n;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void performRefresh(List<IWorkItemHandle> handles, IProgressMonitor monitor) {
        IDetailedStatus oldStatus = this.getStatus();
        boolean unmergableChanges = this.internalRefresh(handles, false, monitor);
        if (unmergableChanges) {
            boolean confirmed = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.WorkItemEditor_DISCARD_LOCAL_CHANGES, (String)Messages.WorkItemEditor_NOT_ALL_CHANGES_PRESERVED);
            if (confirmed) {
                this.internalRefresh(handles, true, monitor);
                this.clearOldStatus(oldStatus);
            }
        } else {
            this.clearOldStatus(oldStatus);
        }
    }

    private boolean internalRefresh(final List<IWorkItemHandle> handles, final boolean dropUnmergableChanges, IProgressMonitor monitor) {
        final boolean[] unmergableChanges = new boolean[1];
        this.runLongOperationWithExceptionHandling(Messages.WorkItemEditor_REFRESHING_WORKITEM, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(Messages.WorkItemEditor_REFRESHING_WORKITEM, 1);
                        IWorkItemWorkingCopyManager workingCopyManager = ((WorkItemEditorInput)WorkItemEditor.this.getEditorInput()).getWorkingCopyManager();
                        for (IWorkItemHandle handle : handles) {
                            if (!WorkItemEditor.this.fCachedWorkingCopy.getWorkItem().sameItemId((IItemHandle)handle) && !workingCopyManager.connectLocal(handle, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[0]))) continue;
                            try {
                                try {
                                    ((WorkItemWorkingCopyManager)workingCopyManager).mergeWithCurrent(handle, dropUnmergableChanges, monitor);
                                }
                                catch (UnmergableChangesException unmergableChangesException) {
                                    unmergableChanges[0] = true;
                                }
                            }
                            finally {
                                if (!WorkItemEditor.this.fCachedWorkingCopy.getWorkItem().sameItemId((IItemHandle)handle)) {
                                    workingCopyManager.disconnect(handle);
                                }
                            }
                        }
                    }
                    catch (TeamRepositoryException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemEditor_ERROR_REFRESHING_WORKING_COPY, x);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        return unmergableChanges[0];
    }

    private boolean performConnectionValidation() {
        final IStatus[] result = new IStatus[1];
        this.runLongOperationWithExceptionHandling(Messages.WorkItemEditor_VALIDATING_CONNECTION, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.WorkItemEditor_VALIDATING_CONNECTION, 1);
                result[0] = FoundationUIUtils.validateRepository((ITeamRepository)WorkItemEditor.this.fCachedWorkingCopy.getTeamRepository(), (boolean)true, (IProgressMonitor)monitor);
            }
        });
        return result[0] != null && result[0].getSeverity() != 4 && result[0].getSeverity() != 8;
    }

    protected FormToolkit createToolkit(Display display) {
        return WorkItemIDEUIPlugin.getDefault().getWorkItemEditorToolkit();
    }

    private void createHeader(IManagedForm headerForm) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)input;
            String layoutId = workItemEditorInput.getEditorPresentation().getEditorLayout();
            Map presentations = workItemEditorInput.getEditorPresentation().getPresentationsMap();
            if (presentations.get(layoutId) == null) {
                String message = NLS.bind((String)Messages.WorkItemEditor_NOE_EDITORLAYOUT_DEFINED, (Object)"com.ibm.team.workitem.editor.default", (Object[])new Object[0]);
                if (!layoutId.equals("com.ibm.team.workitem.editor.default")) {
                    message = NLS.bind((String)Messages.WorkItemEditor_BOUND_EDITORLAYOUT_NOT_DEFINED, (Object)workItemEditorInput.getWorkItem().getWorkItemType(), (Object[])new Object[]{layoutId});
                }
                DetailedStatus status = new DetailedStatus(4, "com.ibm.team.workitem.ide.ui", 4, message, null);
                this.setInput(new WorkItemEditorInputError(workItemEditorInput.getWorkItemHandle(), (IDetailedStatus)status, true));
                return;
            }
            for (AbstractPresentationDescriptor descriptor : (List)presentations.get(layoutId)) {
                String tabLayout;
                if (!(descriptor instanceof TabDescriptor) || !"internalHeader".equals(tabLayout = (String)workItemEditorInput.getEditorPresentation().getTabLayouts().get(descriptor.getElementId()))) continue;
                List headerSections = (List)presentations.get(descriptor.getElementId());
                String headerId = null;
                if (headerSections == null || headerSections.size() != 1) continue;
                headerId = ((AbstractPresentationDescriptor)headerSections.get(0)).getElementId();
                this.fHeaderSection = WorkItemEditorSections.createHeaderSection((WorkItemEditorInput)input, presentations, headerId, headerForm);
                headerForm.setInput((Object)this.getEditorInput());
                return;
            }
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.fTitlePart = new TitlePart();
        this.fTitlePart.init((SharedHeaderFormEditor)this);
        if (this.getEditorInput() != null) {
            this.fTitlePart.setInput(this.getEditorInput());
        }
    }

    private static class InternalChangeDecorator
    implements ILabelDecorator {
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        private ListenerList fListeners = new ListenerList();
        private ChangeDecorator fDecorator = new ChangeDecorator(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (InternalChangeDecorator.this.fDecorator == null) {
                    monitor.setCanceled(true);
                } else {
                    InternalChangeDecorator.this.fireLabelChangedEvent();
                }
            }
        });

        private InternalChangeDecorator() {
        }

        public void setShowChangeDecoration(boolean showChangeDecoration) {
            this.fDecorator.setShowChangeDecoration(showChangeDecoration);
        }

        public Image decorateImage(Image image, Object element) {
            InternalImageDescriptor baseDescriptor = new InternalImageDescriptor(image);
            ImageDescriptor decoratedDescriptor = this.fDecorator.decorate(baseDescriptor);
            Image decorated = (Image)this.fResourceManager.find((DeviceResourceDescriptor)decoratedDescriptor);
            if (decorated != null) {
                return decorated;
            }
            this.fResourceManager.createImage((ImageDescriptor)baseDescriptor);
            return this.fResourceManager.createImage(decoratedDescriptor);
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fListeners.remove((Object)listener);
        }

        private void fireLabelChangedEvent() {
            Object[] objectArray = this.fListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ILabelProviderListener)listener).labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
                ++n2;
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            if (this.fDecorator != null) {
                this.fDecorator = null;
            }
            this.fListeners = null;
        }

        private static class InternalImageDescriptor
        extends ImageDescriptor {
            private Image fImage;
            private int fHashCode;

            public InternalImageDescriptor(Image image) {
                this.fImage = image;
                this.fHashCode = this.fImage.hashCode();
            }

            public ImageData getImageData() {
                return this.fImage.getImageData();
            }

            public int hashCode() {
                return this.fHashCode;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof InternalImageDescriptor)) {
                    return false;
                }
                return this.fImage == ((InternalImageDescriptor)((Object)obj)).fImage;
            }
        }
    }

    public class InternalRefreshJob
    extends FoundationJob
    implements IPartListener2 {
        private static final long DEFAULT_DELAY = 300000L;
        private static final long ACTIVE_DELAY = 30000L;
        private long fDelay;

        public InternalRefreshJob() {
            super(Messages.WorkItemEditor_REFRESHING_WORKITEM);
            this.fDelay = 300000L;
            this.setSystem(true);
            this.setPriority(30);
            this.setRule(WorkItemRCPUIPlugin.REFRESH_RULE);
            WorkItemEditor.this.getSite().getPage().addPartListener((IPartListener2)this);
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            WorkItemWorkingCopy workingCopy = WorkItemEditor.this.fCachedWorkingCopy;
            if (workingCopy != null) {
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IWorkItem workItem = workingCopy.getWorkItem();
                if (teamRepository != null && workItem != null) {
                    if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0 && !workItem.isNewItem()) {
                        try {
                            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                            IWorkItemHandle handle = (IWorkItemHandle)workItem.getItemHandle();
                            auditableClient.fetchCurrentAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE, monitor);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                    }
                    if (!monitor.isCanceled()) {
                        this.scheduleDelayed();
                    }
                }
            }
            return Status.OK_STATUS;
        }

        public void scheduleDelayed() {
            this.schedule(this.fDelay);
        }

        public void setActive(boolean active) {
            long delay;
            long l = delay = active ? 30000L : 300000L;
            if (delay != this.fDelay) {
                this.cancel();
                this.fDelay = delay;
                if (active) {
                    this.schedule();
                } else {
                    this.scheduleDelayed();
                }
            }
        }

        public void dispose() {
            WorkItemEditor.this.getSite().getPage().removePartListener((IPartListener2)this);
            this.cancel();
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == WorkItemEditor.this) {
                this.schedule();
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == WorkItemEditor.this) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }
    }

    private static class InternalSafeRunner {
        private InternalSafeRunner() {
        }

        public static void run(ISafeRunnable code) {
            try {
                code.run();
            }
            catch (Exception x) {
                FoundationLog log = FoundationLog.getLog((String)"com.ibm.team.workitem.ide.ui");
                log.error(x.getMessage(), (Throwable)x);
                code.handleException((Throwable)x);
            }
        }
    }

    private class InternalWorkItemListener
    implements IWorkItemListener {
        private InternalWorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)WorkItemEditor.this.fCachedWorkingCopy.getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.PROJECT_AREA_PROPERTY)) {
                try {
                    WorkItemEditor.this.getSite().getWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                if (WorkItemEditor.this.getEditorInput() instanceof WorkItemEditorInput) {
                                    ((WorkItemEditorInput)WorkItemEditor.this.getEditorInput()).updateEditorPresentation(monitor);
                                }
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                WorkItemEditor.this.updateEditorLayout();
            }
            if (event.affects(IWorkItem.TYPE_PROPERTY)) {
                WorkItemEditor.this.updateEditorTab();
                if (WorkItemEditor.this.fCurrentDisplayedType.equals(event.getWorkItem().getWorkItemType())) {
                    WorkItemEditor.this.clearStatus();
                } else {
                    WorkItemEditor.this.setStatus("", (IDetailedStatus)new DetailedStatus(1, "com.ibm.team.workitem.ide.ui", 70005, Messages.WorkItemEditor_TYPE_OUT_OF_SYNC, null));
                }
            }
            WorkItemEditor.this.handleRemoteChange(event);
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ItemConfirmationDialog
    extends MessageDialog {
        private List<IAuditableHandle> fItems = new ArrayList<IAuditableHandle>();

        public ItemConfirmationDialog(Shell parentShell, String title, String message, int imageType, String[] labels, List<IAuditableHandle> itemHandles) {
            super(parentShell, title, null, message, imageType, labels, 0);
            for (IAuditableHandle handle : itemHandles) {
                ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                IAuditable auditable = handle instanceof IAuditable ? (IAuditable)handle : auditableClient.findCachedAuditable(handle, ItemProfile.createProfile((IItemType)handle.getItemType(), (String[])new String[0]));
                if (auditable != null) {
                    this.fItems.add((IAuditableHandle)auditable);
                    continue;
                }
                this.fItems.add(handle);
            }
        }

        protected Control createDialogArea(Composite parent) {
            String tmp = this.message;
            this.message = null;
            this.createMessageArea(parent);
            this.message = tmp;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createMessageArea(composite);
            TableViewer tableViewer = new TableViewer(composite, 2816);
            tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            tableViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return ((List)inputElement).toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            tableViewer.setInput(this.fItems);
            this.createTooltipSupport((Control)tableViewer.getTable());
            return parent;
        }

        protected void createTooltipSupport(Control control) {
        }

        public Image getImage() {
            if (this.message != null) {
                return null;
            }
            return super.getImage();
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }
    }

    public static class WorkItemEditorInputError
    extends AbstractWorkItemEditorInput {
        private IDetailedStatus fStatus;
        private final boolean fIsSuppressDialog;

        public WorkItemEditorInputError(IWorkItemHandle workItemHandle, IDetailedStatus status, boolean suppressDialog) {
            super(workItemHandle);
            this.fIsSuppressDialog = suppressDialog;
            this.fStatus = status;
        }

        public void release() {
        }

        public IDetailedStatus getStatus() {
            return this.fStatus;
        }

        public boolean isSuppressDialog() {
            return this.fIsSuppressDialog;
        }
    }

    private class WorkItemListener
    extends UIWorkItemListener {
        public WorkItemListener(IWorkItemListener listener) {
            super(listener);
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)WorkItemEditor.this.fCachedWorkingCopy.getWorkItem())) {
                return;
            }
            super.workItemAttributeChanged(event);
            WorkItemEditor.this.fPresentationHandlerManager.presentationEvent((WorkItemEvent)event);
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)WorkItemEditor.this.fCachedWorkingCopy.getWorkItem())) {
                return;
            }
            super.workItemAttributeDependencyChanged(event);
        }
    }

    private class WorkingCopyListener
    implements IWorkingCopyListener {
        private WorkingCopyListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (WorkItemEditor.this.fCachedWorkingCopy == null) {
                return;
            }
            if (event.hasType("dirtyState")) {
                WorkItemEditor.this.handleDirtyStateChanged(event.getSource().isDirty());
            }
            if (event.hasType("staleState")) {
                WorkItemEditor.this.handleStaleStateChanged(((WorkItemWorkingCopyImpl)event.getSource()).isStale());
            }
            if (event.hasType("aboutToBeDisposed")) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemEditor_WORKING_COPY_DISPOSAL, new IllegalStateException());
            }
            if (event.hasType("saved") || event.hasType("saveCanceled") || event.hasType("reverted") || event.hasType("workflowAction")) {
                WorkItemEditor.this.fPresentationHandlerManager.presentationEvent((WorkItemEvent)event);
            }
        }
    }
}

