/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.internal.editor.TeamFormLayout;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormHeadlessSection;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final int[] COLORS = new int[]{10, 4, 6};
    public static final int WIDTH_IN_CHARS = 33;
    private static final int NARROW_WIDTH_IN_CHARS = 11;
    private static final int BORDER_MARGIN_WIDTH = 1;
    private static final int BORDER_MARGIN_HEIGHT = 2;
    private static final int MARGIN_LEFT = 3;
    private static final int MARGIN_HEIGHT = 2;

    public static void color(Composite composite) {
        Util.color(composite, 0);
    }

    public static URIReference[] createURIReferences(Object[] elements, ITeamRepository repository) {
        ArrayList<URIReference> result = new ArrayList<URIReference>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IReference && ((IReference)element).isURIReference()) {
                IURIReference reference = (IURIReference)element;
                String label = reference.getComment().trim();
                URI uri = reference.getURI();
                if (label.length() == 0) {
                    label = uri.toString();
                }
                result.add(new URIReference(label, "", uri));
            } else {
                URIReference link = Hyperlinks.createHyperlink((Object)element);
                if (link != null) {
                    result.add(link);
                } else {
                    IAuditableHandle handle;
                    if (element instanceof IAuditableHandle) {
                        handle = (IAuditableHandle)element;
                    } else {
                        IItemHandle itemHandle;
                        handle = (IAuditableHandle)Platform.getAdapterManager().getAdapter(element, IAuditableHandle.class);
                        if (handle == null) {
                            handle = (IAuditableHandle)Platform.getAdapterManager().getAdapter(element, IWorkItemHandle.class);
                        }
                        if (handle == null && element instanceof IReference && ((IReference)element).isItemReference() && (itemHandle = ((IItemReference)element).getReferencedItem()) instanceof IAuditableHandle) {
                            handle = (IAuditableHandle)itemHandle;
                        }
                    }
                    String label = null;
                    URI uri = null;
                    if (handle != null) {
                        IDomainAdapter domainAdapter = DomainAdapterUtils.getDomainAdapter((Object)handle);
                        if (domainAdapter == null && element instanceof IReference) {
                            label = ((IReference)element).getComment();
                        }
                        uri = element instanceof IReference ? ClientUtils.createURI((String)(repository != null ? repository.getRepositoryURI() : null), (IReference)((IReference)element)) : URIService.createAuditableURI((ITeamRepository)((ITeamRepository)handle.getOrigin()), (IItemHandle)handle);
                        if (domainAdapter != null) {
                            label = Util.createLabel(domainAdapter, handle);
                        }
                    } else if (element instanceof IReference && ((IReference)element).isURIReference()) {
                        IURIReference uriReference = (IURIReference)element;
                        label = uriReference.getComment();
                        uri = uriReference.getURI();
                        if (uri != null && !uri.isAbsolute() && repository != null) {
                            URI base = Location.itemLocation((IItemHandle)uriReference.getLink(), (String)repository.getRepositoryURI()).toAbsoluteUri();
                            uri = Hyperlinks.resolveURI((URI)uri, (URI)base);
                        }
                    } else if (element instanceof IAdaptable) {
                        try {
                            IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                            if (resource != null) {
                                label = resource.getName();
                                uri = new URI("file://" + resource.getFullPath());
                            }
                        }
                        catch (URISyntaxException x) {
                            WorkItemIDEUIPlugin.getDefault().log(Messages.Util_INVALID_URI, x);
                        }
                    }
                    if (label != null && !"".equals(label) && uri != null) {
                        result.add(new URIReference(label, label, uri));
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new URIReference[result.size()]);
    }

    public static ContextProvider getWorkItemContextProvider(final IWorkItem workItem) {
        Assert.isTrue((boolean)workItem.isPropertySet(IWorkItem.ID_PROPERTY));
        return new ContextProvider(null){

            public URIReference getContext() {
                String id = workItem.getId() > 0 ? String.valueOf(workItem.getId()) : "";
                URIReference ref = new URIReference(Messages.Util_WORK_ITEM, NLS.bind((String)Messages.Util_WORK_ITEM_ID, (Object)id, (Object[])new Object[0]), Location.itemLocation((IItemHandle)workItem, (String)((ITeamRepository)workItem.getOrigin()).getRepositoryURI()).toAbsoluteUri());
                return ref;
            }
        };
    }

    private static String createLabel(IDomainAdapter domainAdapter, IAuditableHandle handle) {
        if (handle instanceof IWorkItemHandle) {
            try {
                ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItem workItem = (IWorkItem)auditableClient.resolveAuditable(handle, IWorkItem.SMALL_PROFILE, null);
                IWorkItemType type = workItemClient.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), null);
                String typeName = type != null ? type.getDisplayName().toLowerCase() : workItem.getWorkItemType();
                return String.valueOf(typeName) + " " + WorkItemTextUtilities.getWorkItemId((IWorkItem)workItem);
            }
            catch (TeamRepositoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.Util_EXCEPTION_RESOLVING_WORK_ITEM, x);
            }
        }
        return domainAdapter.generateTitle((Object)handle);
    }

    private static void color(Composite composite, int index) {
        composite.setBackground(Display.getCurrent().getSystemColor(COLORS[index]));
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                Util.color((Composite)children[i], (index + 1) % COLORS.length);
            }
            ++i;
        }
    }

    public static IWorkbenchPage getWorkbenchPage(Shell shell) {
        IWorkbenchPage page;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = null;
        if (shell != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                if (workbenchWindow.getShell().equals(shell)) {
                    window = workbenchWindow;
                    break;
                }
                ++n2;
            }
        }
        if (window == null && (window = workbench.getActiveWorkbenchWindow()) == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        if ((page = window.getActivePage()) == null) {
            if (window.getPages().length > 0) {
                page = window.getPages()[0];
            } else {
                return null;
            }
        }
        return page;
    }

    public static boolean isFixedHeight(TeamFormSectionContainer container) {
        Composite parent = null;
        if (container.getLayoutControl() instanceof Section && ((Section)container.getLayoutControl()).getClient() instanceof Composite) {
            parent = (Composite)((Section)container.getLayoutControl()).getClient();
        } else if (container.getFormPart() instanceof TeamFormHeadlessSection && container.getLayoutControl() instanceof Composite) {
            parent = (Composite)container.getLayoutControl();
        }
        if (parent == null) {
            return true;
        }
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            ITeamFormData data = TeamFormLayouts.getLayoutData((Control)c);
            if (data != null && !data.isFixedHeight()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int guessWeight(TeamFormSectionContainer container) {
        Composite parent = null;
        if (container.getLayoutControl() instanceof Section && ((Section)container.getLayoutControl()).getClient() instanceof Composite) {
            parent = (Composite)((Section)container.getLayoutControl()).getClient();
        } else if (container.getFormPart() instanceof TeamFormHeadlessSection && container.getLayoutControl() instanceof Composite) {
            parent = (Composite)container.getLayoutControl();
        }
        if (parent == null || parent.getChildren().length == 0) {
            return 1;
        }
        ITeamFormLayout formLayout = TeamFormLayouts.getLayout((Composite)parent);
        if (formLayout == null) {
            return 1;
        }
        int guides = ((TeamFormLayout)formLayout).getNumberOfVerticalGuides();
        return guides + 5;
    }

    public static FormLayout createPageFormLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.spacing = 10;
        return layout;
    }

    public static void shorten(IType type, String property, IStyledDocument document, boolean wholeLine) {
        try {
            if (!com.ibm.team.workitem.common.internal.util.Utils.isTooLong((IType)type, (String)property, (String)document.getHTML().getXMLText())) {
                return;
            }
            String indicator = wholeLine ? "[...]" : "";
            String xmlIndicator = XMLString.createFromPlainText((String)indicator).getXMLText();
            int i = -1;
            int j = document.getLength();
            while (j - i > 1) {
                int k = i + j >> 1;
                IStatus status = IItemValidator.INSTANCE.validateAttribute(type, property, (Object)(String.valueOf(document.getHTML(0, k).getXMLText()) + xmlIndicator));
                if (status instanceof IStringSizeConstraintErrorStatus) {
                    j = k;
                    continue;
                }
                i = k;
            }
            if (wholeLine) {
                i = document.getLineInformationOfOffset(i).getOffset();
            }
            document.replace(i, document.getLength() - i, indicator);
        }
        catch (BadLocationException x) {
            WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.Util_EXCEPTION_SHORTENING_STRING, (Object)property, (Object[])new Object[0]), x);
        }
    }

    public static void showAndDisposeOnHide(Menu menu) {
        menu.setVisible(true);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(final MenuEvent e) {
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        e.widget.dispose();
                    }
                });
            }
        });
    }

    public static boolean isInWorkItemEditor(TeamFormPart part) {
        ITeamFormPartSite site = part.getSite();
        IEditorPart editorPart = (IEditorPart)site.getAdapter(IEditorPart.class);
        return editorPart instanceof WorkItemEditor;
    }

    public static boolean saveNewWorkItem(IEditorPart editorPart, WorkItemWorkingCopy workingCopy) {
        return Utils.saveNewWorkItem((IRunnableContext)editorPart.getSite().getWorkbenchWindow(), (IEditorPart)editorPart, (WorkItemWorkingCopy)workingCopy);
    }

    public static void addWidthHint(Control control) {
        Util.addWidthHint(control, 33);
    }

    public static void addNarrowWidthHint(Control control) {
        Util.addWidthHint(control, 11);
    }

    private static void addWidthHint(Control control, int widthInChars) {
        ITeamFormData layoutData = TeamFormLayouts.getLayoutData((Control)control);
        if (layoutData == null) {
            return;
        }
        GC gc = new GC((Drawable)control);
        FontMetrics metrics = gc.getFontMetrics();
        int widthHint = widthInChars * metrics.getAverageCharWidth();
        gc.dispose();
        TeamFormLayouts.setLayoutData((Control)control, (ITeamFormData)layoutData.setWidthHint(widthHint));
    }

    public static void updateFormLayout(Control[] changedControls) {
        SharedScrolledComposite form;
        if (changedControls.length > 0 && (form = Util.findScrolledComposite(changedControls[0])) != null) {
            form.reflow(true);
            form.layout(changedControls);
        }
    }

    private static SharedScrolledComposite findScrolledComposite(Control baseControl) {
        Composite parent = baseControl.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                return (SharedScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static PresentationDescriptor cloneDescriptor(PresentationDescriptor source) {
        PresentationDescriptor desc = new PresentationDescriptor(source.getParentSectionId(), source.getId(), source.getKind(), source.getLabel(), source.getAttributeId(), new HashMap());
        for (Map.Entry e : source.getProperties().entrySet()) {
            desc.getProperties().put((String)e.getKey(), (String)e.getValue());
        }
        return desc;
    }

    public static PresentationDescriptor addDependencies(PresentationDescriptor desc, String ... dependencies) {
        int n;
        int n2;
        String[] stringArray;
        HashSet<String> deps = new HashSet<String>();
        String existing = (String)desc.getProperties().get("attributeDependency");
        if (existing != null) {
            String[] ex;
            stringArray = ex = existing.split(",");
            n2 = ex.length;
            n = 0;
            while (n < n2) {
                String e = stringArray[n];
                deps.add(e.trim());
                ++n;
            }
        }
        PresentationDescriptor source = desc;
        desc = Util.cloneDescriptor(source);
        stringArray = dependencies;
        n2 = dependencies.length;
        n = 0;
        while (n < n2) {
            String dependency = stringArray[n];
            deps.add(dependency);
            ++n;
        }
        String dep = "";
        for (String d : deps) {
            dep = String.valueOf(dep) + ", " + d;
        }
        if (dep.startsWith(", ")) {
            dep = dep.substring(2);
            desc.getProperties().put("attributeDependency", dep);
        }
        return desc;
    }

    public static List<AbstractPresentationDescriptor> getPresentationChildren(String sectionId, Map<String, List<AbstractPresentationDescriptor>> presentations) {
        ArrayList<AbstractPresentationDescriptor> children = new ArrayList<AbstractPresentationDescriptor>();
        if (sectionId == null || presentations == null) {
            return children;
        }
        List<AbstractPresentationDescriptor> list = presentations.get(sectionId);
        if (list == null) {
            return children;
        }
        for (AbstractPresentationDescriptor desc : list) {
            if (!(desc instanceof PresentationDescriptor)) continue;
            children.add(desc);
        }
        return children;
    }

    public static Composite[] singleLineStyledTextBorder(Composite parent, WorkItemEditorToolkit toolkit, int backgroundStyle) {
        ITeamFormData layoutData = ITeamFormData.SINGLE_LINE_STYLED_TEXT;
        GridData gridData = new GridData(4, 128, true, false);
        return Util.styledTextBorder(parent, toolkit, layoutData, gridData, 0, backgroundStyle);
    }

    public static Composite[] multiLineStyledTextBorder(Composite parent, WorkItemEditorToolkit toolkit, int backgroundStyle) {
        ITeamFormData layoutData = ITeamFormData.MULTI_LINE_STYLED_TEXT;
        GridData gridData = new GridData(4, 4, true, true);
        return Util.styledTextBorder(parent, toolkit, layoutData, gridData, 2, backgroundStyle);
    }

    private static Composite[] styledTextBorder(Composite parent, WorkItemEditorToolkit toolkit, ITeamFormData layoutData, GridData gridData, int marginHeight, int backgroundStyle) {
        Composite container = toolkit.createComposite(parent, 0, backgroundStyle);
        TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)layoutData.addOffset(4, 2 + marginHeight));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        toolkit.paintBordersFor(container);
        Composite border = toolkit.createComposite(container);
        border.setLayoutData((Object)gridData);
        border.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 3;
        layout.marginHeight = marginHeight;
        border.setLayout((Layout)layout);
        return new Composite[]{container, border};
    }
}

