/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationInput;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContextProviderContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.IContentAssistProposalsComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.rcp.ui.internal.UserResolvableProposal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPickerProposalComputer
implements IContentAssistProposalsComputer {
    private final boolean fInsertAsLink;
    private final ReferenceInsertionStrategy fInsertionStrategy;

    public UserPickerProposalComputer(ReferenceInsertionStrategy insertionStrategy) {
        this.fInsertionStrategy = insertionStrategy;
        this.fInsertAsLink = true;
    }

    public UserPickerProposalComputer(ReferenceInsertionStrategy insertionStrategy, boolean insertAsLink) {
        this.fInsertionStrategy = insertionStrategy;
        this.fInsertAsLink = insertAsLink;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ITeamRepository repository;
        ContentAssistContextProvider contextProvider;
        if (context instanceof ContextProviderContentAssistContext && (contextProvider = ((ContextProviderContentAssistContext)context).getContextProvider()) instanceof TeamContextProvider && (repository = ((TeamContextProvider)contextProvider).getTeamRepository()) != null) {
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            result.add((ICompletionProposal)new UserPickerProposal(context.getOffset(), this.fInsertionStrategy, repository, this.fInsertAsLink));
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    private static final class UserPickerProposal
    extends UserResolvableProposal {
        private final boolean fInsertAsLink;

        public UserPickerProposal(int startOffset, ReferenceInsertionStrategy insertionStrategy, ITeamRepository repository, boolean insertAsLink) {
            super(Messages.UserPickerProposalComputer_ADD_MORE_USERS_LABEL, null, null, insertionStrategy, repository);
            this.fInsertAsLink = insertAsLink;
        }

        public void apply(IDocument document, char trigger, int offset) {
            TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.getShell(), this.fTeamRepository);
            if (dialog.open() != 0) {
                return;
            }
            IContributorHandle[] contributorHandles = dialog.getContributorResult();
            this.resolveAndInsert(document, offset, contributorHandles, Messages.UserPickerProposalComputer_RESOLVE_PROGRESS_LABEL, this.fInsertAsLink);
        }

        protected AdditionalInformationInput getAdditionaInformationInput(IProgressMonitor monitor) {
            String text = Messages.UserPickerProposalComputer_ADD_MORE_USERS_DESCRIPTION;
            return new AdditionalInformationInput(text, text);
        }

        public boolean isValidFor(IDocument document, int offset) {
            return true;
        }
    }
}

