/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.rcp.core.internal.text.SyntheticDelimiterPosition;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.jface.internal.util.TextViewerDecorator;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.LineBasedSubstitutionScannerRegistry;
import java.text.BreakIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TextLineWrapper
extends TextViewerDecorator {
    private static final String SYNTHETIC_DELIMITER_CATEGORY = SyntheticDelimiterPosition.SYNTHETIC_DELIMITER_CATEGORY;
    private static final String TEMPORARY_CATEGORY = String.valueOf(TextLineWrapper.class.getName()) + "_temporary";
    private static final String SYNTHETIC_DELIMITER = "\n";
    private static final int DELAY = 500;
    private ITextViewer fTextViewer;
    private InternalListener fInternalListener = new InternalListener();
    private UIUpdaterJob fUpdater = new UIUpdaterJob(Messages.TextLineWrapper_LINE_WRAPPING_UPDATE){

        public IStatus runInUI(IProgressMonitor monitor) {
            try {
                if (TextLineWrapper.this.fTextViewer == null || TextLineWrapper.this.fTextViewer.getDocument() == null) {
                    return Status.CANCEL_STATUS;
                }
                TextLineWrapper.this.wrap(TextLineWrapper.this.fTextViewer, (IRegion)new Region(0, TextLineWrapper.this.fTextViewer.getDocument().getLength()));
                return Status.OK_STATUS;
            }
            catch (BadLocationException x) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.TextLineWrapper_EXCEPTION_WRAPPING_LINES, (Throwable)x);
            }
            catch (BadPositionCategoryException x) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.TextLineWrapper_EXCEPTION_WRAPPING_LINES, (Throwable)x);
            }
        }
    };
    private BreakIterator fWordBreakIterator = BreakIterator.getWordInstance();
    private int fUpdating = 0;
    private int fClientWidth = 0;

    public void install(TextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fTextViewer.addTextInputListener((ITextInputListener)this.fInternalListener);
        this.fTextViewer.getTextWidget().addControlListener((ControlListener)this.fInternalListener);
        if (this.fTextViewer.getDocument() != null) {
            this.fInternalListener.inputDocumentAboutToBeChanged(null, this.fTextViewer.getDocument());
            this.fInternalListener.inputDocumentChanged(null, this.fTextViewer.getDocument());
        }
    }

    public void uninstall() {
        if (this.fTextViewer != null) {
            if (this.fTextViewer.getDocument() != null) {
                this.fInternalListener.inputDocumentAboutToBeChanged(this.fTextViewer.getDocument(), null);
                this.fInternalListener.inputDocumentChanged(this.fTextViewer.getDocument(), null);
            }
            this.fTextViewer.removeTextInputListener((ITextInputListener)this.fInternalListener);
            this.fTextViewer = null;
        }
    }

    private void wrap(ITextViewer textViewer, IRegion region) throws BadLocationException, BadPositionCategoryException {
        Position focusPosition;
        block13: {
            IDocument document = textViewer.getDocument();
            StyledText textWidget = textViewer.getTextWidget();
            int clientWidth = textWidget.getClientArea().width;
            if (clientWidth == 0) {
                return;
            }
            this.fClientWidth = clientWidth;
            int maxIndent = 0;
            int i = 0;
            int n = textWidget.getLineCount();
            while (i < n) {
                maxIndent = Math.max(textWidget.getLineIndent(i), maxIndent);
                ++i;
            }
            focusPosition = this.storeFocusPosition(textViewer);
            DocumentRewriteSession session = null;
            if (region.getOffset() == 0 && region.getLength() == document.getLength()) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            GC graphics = new GC((Drawable)textWidget);
            graphics.setFont(textWidget.getFont());
            try {
                int delta = this.removeSyntheticDelimiters(document, region);
                MultiTextEdit edit = new MultiTextEdit();
                int line = document.getLineOfOffset(region.getOffset());
                int endLine = document.getLineOfOffset(region.getOffset() + region.getLength() - delta);
                while (line <= endLine) {
                    IRegion lineInformation = document.getLineInformation(line);
                    String text = document.get(lineInformation.getOffset(), lineInformation.getLength());
                    ReferencePosition[] positions = LineBasedSubstitutionScannerRegistry.getDefault().scan(text);
                    if (positions == null || positions.length == 0) {
                        int lineWidth = clientWidth;
                        lineWidth -= maxIndent;
                        int maxWidth = Math.max(--lineWidth, 40 * graphics.stringExtent((String)" ").x);
                        this.wrapLine(document, lineInformation, graphics, maxWidth, edit);
                    }
                    ++line;
                }
                if (edit.getChildrenSize() <= 0) break block13;
                try {
                    try {
                        ++this.fUpdating;
                        edit.apply(document, 2);
                    }
                    catch (BadLocationException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_DOCUMENT, x);
                        --this.fUpdating;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    --this.fUpdating;
                    throw throwable;
                }
                --this.fUpdating;
            }
            finally {
                graphics.dispose();
                if (session != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
            }
        }
        this.restoreFocusPosition(textViewer, focusPosition);
    }

    private void wrapLine(IDocument document, IRegion region, GC graphics, int maxWidth, MultiTextEdit edit) throws BadLocationException, BadPositionCategoryException {
        int docOffset = region.getOffset();
        int docLength = region.getLength();
        String text = document.get(docOffset, docLength);
        this.fWordBreakIterator.setText(text);
        int offset = this.fWordBreakIterator.first();
        int lastOffset = 0;
        int baseOffset = 0;
        int width = 0;
        while (offset != -1) {
            int widthIncrement = this.getHorizontalExtent(graphics, text.substring(lastOffset, offset));
            if (width + widthIncrement > maxWidth) {
                offset = lastOffset;
                if (offset == -1 || offset == baseOffset) {
                    offset = baseOffset + 1;
                    lastOffset = baseOffset;
                    while (offset <= text.length()) {
                        widthIncrement = this.getHorizontalExtent(graphics, text.substring(lastOffset, offset));
                        if (!Character.isWhitespace(text.charAt(lastOffset)) && width + widthIncrement > maxWidth) {
                            offset = lastOffset;
                            if (offset != baseOffset) break;
                            ++offset;
                            break;
                        }
                        width += widthIncrement;
                        lastOffset = offset++;
                    }
                }
                if (offset >= text.length()) break;
                int startOffset = offset;
                while (startOffset > 0 && Character.isWhitespace(text.charAt(startOffset - 1))) {
                    --startOffset;
                }
                edit.addChild((TextEdit)new ReplaceEdit(docOffset + startOffset, offset - startOffset, SYNTHETIC_DELIMITER));
                baseOffset = offset;
                width = 0;
            } else {
                width += widthIncrement;
            }
            lastOffset = offset;
            offset = this.next(this.fWordBreakIterator, text);
        }
    }

    private int next(BreakIterator iter, String text) {
        int next = iter.next();
        while (next != -1 && next < text.length() && Character.isWhitespace(text.charAt(next))) {
            ++next;
        }
        return next;
    }

    private int getHorizontalExtent(GC graphics, String substring) {
        return graphics.stringExtent((String)substring).x;
    }

    private int removeSyntheticDelimiters(IDocument document, IRegion region) {
        int delta;
        block12: {
            delta = 0;
            if (!document.containsPositionCategory(SYNTHETIC_DELIMITER_CATEGORY)) {
                return delta;
            }
            try {
                MultiTextEdit edit = new MultiTextEdit();
                Position[] positions = document.getPositions(SYNTHETIC_DELIMITER_CATEGORY);
                int i = 0;
                while (i < positions.length) {
                    Position position = positions[i];
                    if (position.getLength() > 0 && position.overlapsWith(region.getOffset(), region.getLength())) {
                        String original = SyntheticDelimiterPosition.getOriginal((Position)position);
                        edit.addChild((TextEdit)new ReplaceEdit(position.getOffset(), position.getLength(), original));
                        position.delete();
                        delta += position.getLength() - original.length();
                        document.removePosition(SYNTHETIC_DELIMITER_CATEGORY, position);
                    }
                    ++i;
                }
                if (edit.getChildrenSize() <= 0) break block12;
                try {
                    try {
                        ++this.fUpdating;
                        edit.apply(document, 0);
                    }
                    catch (MalformedTreeException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_DOCUMENT, x);
                        --this.fUpdating;
                    }
                    catch (BadLocationException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_DOCUMENT, x);
                        --this.fUpdating;
                    }
                }
                finally {
                    --this.fUpdating;
                }
            }
            catch (BadPositionCategoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_DOCUMENT, x);
            }
        }
        return delta;
    }

    private Position storeFocusPosition(ITextViewer textViewer) throws BadLocationException, BadPositionCategoryException {
        IDocument document = textViewer.getDocument();
        int topIndex = textViewer.getTopIndex();
        int bottomIndex = textViewer.getBottomIndex();
        int focusLine = 0;
        if (topIndex >= 0 && bottomIndex >= 0) {
            focusLine = topIndex + (bottomIndex - topIndex) / 2;
        }
        int focusOffset = document.getLineOffset(focusLine);
        Position focusPosition = new Position(focusOffset, 0);
        document.addPosition(TEMPORARY_CATEGORY, focusPosition);
        return focusPosition;
    }

    private void restoreFocusPosition(ITextViewer textViewer, Position focusPosition) throws BadPositionCategoryException {
        if (!focusPosition.isDeleted()) {
            textViewer.revealRange(focusPosition.getOffset(), 0);
        }
        IDocument document = textViewer.getDocument();
        document.removePosition(TEMPORARY_CATEGORY, focusPosition);
    }

    private class InternalListener
    implements IDocumentListener,
    ITextInputListener,
    ControlListener {
        private IPositionUpdater fSyntheticDelimiterUpdater = new DefaultPositionUpdater(TextLineWrapper.access$2());
        private IPositionUpdater fTemporaryUpdater = new DefaultPositionUpdater(TextLineWrapper.access$3());
        private IDocumentListener fPositionSetter = new IDocumentListener(){
            private String fOriginal = "";

            public void documentAboutToBeChanged(DocumentEvent event) {
                if (TextLineWrapper.this.fUpdating > 0 && TextLineWrapper.SYNTHETIC_DELIMITER.equals(event.getText())) {
                    try {
                        this.fOriginal = event.getDocument().get(event.getOffset(), event.getLength());
                    }
                    catch (BadLocationException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_UNEXPECTED_EXCEPTION, x);
                    }
                }
            }

            public void documentChanged(DocumentEvent event) {
                if (TextLineWrapper.this.fUpdating > 0 && TextLineWrapper.SYNTHETIC_DELIMITER.equals(event.getText())) {
                    try {
                        event.getDocument().addPosition(SYNTHETIC_DELIMITER_CATEGORY, (Position)new SyntheticDelimiterPosition(event.getOffset(), event.getText().length(), this.fOriginal));
                    }
                    catch (BadLocationException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_UNEXPECTED_EXCEPTION, x);
                    }
                    catch (BadPositionCategoryException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_UNEXPECTED_EXCEPTION, x);
                    }
                }
            }
        };

        private InternalListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput instanceof IDocumentExtension && oldInput instanceof IDocumentExtension4) {
                try {
                    oldInput.removePrenotifiedDocumentListener(this.fPositionSetter);
                    oldInput.removeDocumentListener((IDocumentListener)this);
                    TextLineWrapper.this.removeSyntheticDelimiters(oldInput, (IRegion)new Region(0, oldInput.getLength()));
                    StyledText text = TextLineWrapper.this.fTextViewer.getTextWidget();
                    if (text != null && !text.isDisposed() && text.getTopPixel() > 0) {
                        text.setTopPixel(text.getTopPixel() - 1);
                    }
                    if (oldInput.containsPositionCategory(SYNTHETIC_DELIMITER_CATEGORY)) {
                        oldInput.removePositionCategory(SYNTHETIC_DELIMITER_CATEGORY);
                        oldInput.removePositionUpdater(this.fSyntheticDelimiterUpdater);
                    }
                    if (oldInput.containsPositionCategory(TEMPORARY_CATEGORY)) {
                        oldInput.removePositionCategory(TEMPORARY_CATEGORY);
                        oldInput.removePositionUpdater(this.fTemporaryUpdater);
                    }
                }
                catch (BadPositionCategoryException x) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_REMOVING_POSITION_CATEGORY, x);
                }
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput instanceof IDocumentExtension && newInput instanceof IDocumentExtension4) {
                try {
                    newInput.addPositionUpdater(this.fSyntheticDelimiterUpdater);
                    newInput.addPositionCategory(SYNTHETIC_DELIMITER_CATEGORY);
                    newInput.addPositionUpdater(this.fTemporaryUpdater);
                    newInput.addPositionCategory(TEMPORARY_CATEGORY);
                    newInput.addPrenotifiedDocumentListener(this.fPositionSetter);
                    TextLineWrapper.this.wrap(TextLineWrapper.this.fTextViewer, (IRegion)new Region(0, TextLineWrapper.this.fTextViewer.getDocument().getLength()));
                    newInput.addDocumentListener((IDocumentListener)this);
                }
                catch (BadLocationException x) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_LINES, x);
                }
                catch (BadPositionCategoryException x) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_LINES, x);
                }
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (TextLineWrapper.this.fUpdating > 0) {
                return;
            }
            try {
                final Position position = new Position(event.getOffset(), event.getText().length());
                event.getDocument().addPosition(TEMPORARY_CATEGORY, position);
                ((IDocumentExtension)event.getDocument()).registerPostNotificationReplace((IDocumentListener)this, new IDocumentExtension.IReplace(){

                    public void perform(IDocument document, IDocumentListener owner) {
                        try {
                            document.removePosition(TEMPORARY_CATEGORY, position);
                            if (position.isDeleted()) {
                                return;
                            }
                            int line = document.getLineOfOffset(position.getOffset() + position.getLength());
                            int endOffset = this.getLineEndOffset(document, line);
                            Position[] positions = document.getPositions(SYNTHETIC_DELIMITER_CATEGORY);
                            int i = 0;
                            while (i < positions.length) {
                                if (!positions[i].isDeleted()) {
                                    if (endOffset == positions[i].getOffset()) {
                                        endOffset = this.getLineEndOffset(document, ++line);
                                    }
                                    if (endOffset < positions[i].getOffset()) break;
                                }
                                ++i;
                            }
                            TextLineWrapper.this.wrap(TextLineWrapper.this.fTextViewer, (IRegion)new Region(position.getOffset(), endOffset - position.getOffset()));
                        }
                        catch (BadLocationException x) {
                            WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_LINES, x);
                        }
                        catch (BadPositionCategoryException x) {
                            WorkItemIDEUIPlugin.getDefault().log(Messages.TextLineWrapper_EXCEPTION_WRAPPING_LINES, x);
                        }
                    }

                    private int getLineEndOffset(IDocument document, int line) throws BadLocationException {
                        IRegion lineInformation = document.getLineInformation(line);
                        int endOffset = lineInformation.getOffset() + lineInformation.getLength();
                        return endOffset;
                    }
                });
            }
            catch (BadLocationException x1) {
                throw new RuntimeException(x1);
            }
            catch (BadPositionCategoryException x1) {
                throw new RuntimeException(x1);
            }
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (((TextLineWrapper)TextLineWrapper.this).fTextViewer.getTextWidget().getClientArea().width == TextLineWrapper.this.fClientWidth) {
                return;
            }
            TextLineWrapper.this.fUpdater.schedule(500L);
        }
    }
}

