/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashForm;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashFormData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

class TeamSashFormLayout
extends Layout {
    TeamSashFormLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        TeamSashForm sashForm = (TeamSashForm)composite;
        Control[] cArray = sashForm.getControls(true);
        int width = 0;
        int height = 0;
        if (cArray.length == 0) {
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        boolean vertical = sashForm.getOrientation() == 512;
        int i = 0;
        while (i < cArray.length) {
            Point size;
            if (vertical) {
                size = cArray[i].computeSize(wHint, -1, flushCache);
                height += size.y;
                width = Math.max(width, size.x);
            } else {
                size = cArray[i].computeSize(-1, hHint, flushCache);
                width += size.x;
                height = Math.max(height, size.y);
            }
            if (cArray[i].getLayoutData() == null || !(cArray[i].getLayoutData() instanceof TeamSashFormData)) {
                cArray[i].setLayoutData((Object)new TeamSashFormData());
            }
            ++i;
        }
        int sashwidth = sashForm.SASH_WIDTH;
        if (vertical) {
            height += (cArray.length - 1) * (sashwidth + 2 * sashForm.SPACING);
        } else {
            width += (cArray.length - 1) * (sashwidth + 2 * sashForm.SPACING);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected boolean flushCache(Control control) {
        Object data = control.getLayoutData();
        if (data instanceof TeamSashFormData) {
            ((TeamSashFormData)data).setMinHeight(-1);
        }
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        block79: {
            int i;
            int[] sBounds;
            int[][] cBounds;
            int sashwidth;
            Sash[] sashes;
            Control[] controls;
            Rectangle area;
            block73: {
                int diff;
                int missing;
                long[] ratios;
                block80: {
                    int spacing;
                    int fixedHeight;
                    long total;
                    block74: {
                        int i2;
                        int[] sBounds2;
                        int[][] cBounds2;
                        block75: {
                            int i3;
                            Sash[] newSashes;
                            TeamSashForm sashForm = (TeamSashForm)composite;
                            if (flushCache) {
                                Control[] controlArray = sashForm.getControls(false);
                                int n = controlArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Control control = controlArray[n2];
                                    this.flushCache(control);
                                    ++n2;
                                }
                            }
                            area = sashForm.getClientArea();
                            if (area.width <= 1 || area.height <= 1) {
                                return;
                            }
                            Control[] newControls = sashForm.getControls(true);
                            if (sashForm.controls.length == 0 && newControls.length == 0) {
                                return;
                            }
                            sashForm.controls = newControls;
                            controls = sashForm.controls;
                            if (sashForm.sashes.length < controls.length - 1) {
                                newSashes = new Sash[controls.length - 1];
                                System.arraycopy(sashForm.sashes, 0, newSashes, 0, sashForm.sashes.length);
                                i3 = sashForm.sashes.length;
                                while (i3 < newSashes.length) {
                                    newSashes[i3] = new Sash((Composite)sashForm, sashForm.sashStyle);
                                    newSashes[i3].setEnabled(sashForm.isSashEnabled());
                                    newSashes[i3].setVisible(sashForm.isSashEnabled());
                                    newSashes[i3].setBackground(sashForm.background);
                                    newSashes[i3].setForeground(sashForm.foreground);
                                    newSashes[i3].addListener(13, sashForm.sashListener);
                                    ++i3;
                                }
                                sashForm.sashes = newSashes;
                            }
                            if (sashForm.sashes.length > controls.length - 1) {
                                if (controls.length == 0) {
                                    int i4 = 0;
                                    while (i4 < sashForm.sashes.length) {
                                        sashForm.sashes[i4].dispose();
                                        ++i4;
                                    }
                                    sashForm.sashes = new Sash[0];
                                } else {
                                    newSashes = new Sash[controls.length - 1];
                                    System.arraycopy(sashForm.sashes, 0, newSashes, 0, newSashes.length);
                                    i3 = controls.length - 1;
                                    while (i3 < sashForm.sashes.length) {
                                        sashForm.sashes[i3].dispose();
                                        ++i3;
                                    }
                                    sashForm.sashes = newSashes;
                                }
                            }
                            if (controls.length == 0) {
                                return;
                            }
                            sashForm.normalizeWeights(flushCache);
                            sashes = sashForm.sashes;
                            ratios = new long[controls.length];
                            total = 0L;
                            int fixedWidth = 0;
                            fixedHeight = 0;
                            int i5 = 0;
                            while (i5 < controls.length) {
                                if (sashForm.getOrientation() == 512) {
                                    if (((TeamSashFormData)controls[i5].getLayoutData()).getWeight() == -1L) {
                                        fixedHeight += controls[i5].computeSize((int)area.width, (int)-1, (boolean)flushCache).y;
                                    }
                                    if (controls[i5] instanceof ExpandableComposite && ((ExpandableComposite)controls[i5]).isExpanded() && ((TeamSashFormData)controls[i5].getLayoutData()).getMinHeight() == -1) {
                                        ((TeamSashFormData)controls[i5].getLayoutData()).setMinHeight(controls[i5].computeSize((int)area.width, (int)-1, (boolean)flushCache).y);
                                    }
                                } else if (sashForm.getOrientation() == 256 && ((TeamSashFormData)controls[i5].getLayoutData()).getWeight() == -1L) {
                                    fixedWidth += controls[i5].computeSize((int)-1, (int)area.height, (boolean)flushCache).x;
                                }
                                Object data = controls[i5].getLayoutData();
                                ratios[i5] = ((TeamSashFormData)data).getWeight();
                                total += ratios[i5] != -1L ? ratios[i5] : 0L;
                                ++i5;
                            }
                            if (total == 0L) {
                                i5 = 0;
                                while (i5 < ratios.length) {
                                    if (ratios[i5] == 0L || ratios[i5] < -1L) {
                                        ratios[i5] = 1L;
                                    }
                                    total += ratios[i5] != -1L ? ratios[i5] : 0L;
                                    ++i5;
                                }
                            }
                            sashwidth = sashForm.SASH_WIDTH;
                            spacing = sashForm.SPACING;
                            if (sashForm.getOrientation() != 256) break block74;
                            cBounds2 = new int[controls.length][2];
                            sBounds2 = new int[sashes.length];
                            int x = area.x;
                            int missing2 = 0;
                            i2 = 0;
                            while (i2 < controls.length) {
                                int width;
                                if (i2 > 0) {
                                    sBounds2[i2 - 1] = x - spacing - sashwidth;
                                }
                                if (ratios[i2] == -1L) {
                                    width = controls[i2].computeSize((int)-1, (int)area.height, (boolean)flushCache).x;
                                } else {
                                    int requiredWidth = controls[i2].computeSize((int)-1, (int)area.height, (boolean)flushCache).x;
                                    width = (int)(ratios[i2] * (long)(area.width - sashes.length * (sashwidth + 2 * spacing) - fixedWidth) / total);
                                    if (requiredWidth <= width - missing2) {
                                        width -= missing2;
                                        missing2 = 0;
                                    } else if (requiredWidth > width) {
                                        missing2 += requiredWidth - width;
                                        width = requiredWidth;
                                    } else if (requiredWidth > width - missing2) {
                                        missing2 = requiredWidth - (width - missing2);
                                        width = requiredWidth;
                                    }
                                }
                                cBounds2[i2][0] = x;
                                cBounds2[i2][1] = width;
                                x += width + sashwidth + 2 * spacing;
                                ++i2;
                            }
                            if (missing2 <= 0) break block75;
                            i2 = controls.length - 1;
                            while (i2 >= 0) {
                                block76: {
                                    int moved;
                                    block78: {
                                        int diff2;
                                        block77: {
                                            if (ratios[i2] == -1L) break block76;
                                            diff2 = cBounds2[i2][1] - controls[i2].computeSize((int)-1, (int)area.height, (boolean)flushCache).x;
                                            moved = 0;
                                            if (diff2 <= missing2) break block77;
                                            cBounds2[i2][1] = cBounds2[i2][1] - missing2;
                                            moved = missing2;
                                            missing2 = 0;
                                            break block78;
                                        }
                                        if (diff2 <= 0) break block76;
                                        cBounds2[i2][1] = cBounds2[i2][1] - diff2;
                                        moved = diff2;
                                        missing2 -= diff2;
                                    }
                                    int j = i2 + 1;
                                    while (j < controls.length) {
                                        sBounds2[j - 1] = sBounds2[j - 1] - moved;
                                        cBounds2[j][0] = cBounds2[j][0] - moved;
                                        ++j;
                                    }
                                    if (missing2 == 0) break;
                                }
                                --i2;
                            }
                        }
                        i2 = 0;
                        while (i2 < controls.length) {
                            if (i2 > 0) {
                                sashes[i2 - 1].setBounds(sBounds2[i2 - 1], area.y, sashwidth, area.height);
                            }
                            controls[i2].setBounds(cBounds2[i2][0], area.y, cBounds2[i2][1], area.height);
                            ++i2;
                        }
                        break block79;
                    }
                    int remain = 0;
                    missing = 0;
                    cBounds = new int[controls.length][2];
                    sBounds = new int[sashes.length];
                    int y = area.y;
                    i = 0;
                    while (i < controls.length) {
                        int requiredHeight;
                        int height;
                        if (i > 0) {
                            sBounds[i - 1] = y - spacing - sashwidth;
                        }
                        if (ratios[i] == -1L) {
                            height = controls[i].computeSize((int)area.width, (int)-1, (boolean)flushCache).y;
                        } else if (controls[i] instanceof ExpandableComposite && !((ExpandableComposite)controls[i]).isExpanded()) {
                            int diff3;
                            int couldBeHeight = (int)(ratios[i] * (long)(area.height - sashes.length * (sashwidth + 2 * spacing) - fixedHeight) / total);
                            height = controls[i].computeSize((int)area.width, (int)-1, (boolean)flushCache).y;
                            requiredHeight = height;
                            if (couldBeHeight < requiredHeight) {
                                diff3 = requiredHeight - couldBeHeight;
                                if (remain >= diff3) {
                                    remain -= diff3;
                                } else {
                                    missing += diff3 - remain;
                                    remain = 0;
                                }
                            } else {
                                diff3 = couldBeHeight - requiredHeight;
                                if (diff3 >= missing) {
                                    remain += diff3 - missing;
                                    missing = 0;
                                } else {
                                    missing -= diff3;
                                }
                            }
                        } else {
                            Assert.isTrue((remain <= 0 || missing <= 0 ? 1 : 0) != 0);
                            height = (int)(ratios[i] * (long)(area.height - sashes.length * (sashwidth + 2 * spacing) - fixedHeight) / total);
                            requiredHeight = controls[i].computeSize((int)area.width, (int)-1, (boolean)flushCache).y;
                            if (requiredHeight < height) {
                                if (remain > 0) {
                                    height += remain;
                                    remain = 0;
                                } else if (missing > 0) {
                                    diff = height - requiredHeight;
                                    if (missing <= diff) {
                                        height -= missing;
                                        missing = 0;
                                    } else {
                                        height -= diff;
                                        missing -= diff;
                                    }
                                }
                            } else {
                                diff = requiredHeight - height;
                                if (remain > 0) {
                                    if (remain >= diff) {
                                        height += remain;
                                        remain = 0;
                                    } else {
                                        height += diff;
                                        missing += diff - remain;
                                        remain = 0;
                                    }
                                } else {
                                    height += diff;
                                    missing += diff;
                                }
                            }
                        }
                        cBounds[i][0] = y;
                        cBounds[i][1] = height;
                        y += height + sashwidth + 2 * spacing;
                        ++i;
                    }
                    Assert.isTrue((remain <= 0 || missing <= 0 ? 1 : 0) != 0);
                    if (remain <= 0) break block80;
                    i = controls.length - 1;
                    while (i >= 0) {
                        if (ratios[i] != -1L && (!(controls[i] instanceof ExpandableComposite) || ((ExpandableComposite)controls[i]).isExpanded())) {
                            cBounds[i][1] = cBounds[i][1] + remain;
                            int j = i + 1;
                            while (j < controls.length) {
                                sBounds[j - 1] = sBounds[j - 1] + remain;
                                cBounds[j][0] = cBounds[j][0] + remain;
                                ++j;
                            }
                            break block73;
                        }
                        --i;
                    }
                    break block73;
                }
                if (missing <= 0) break block73;
                i = controls.length - 1;
                while (i >= 0) {
                    block81: {
                        int moved;
                        block83: {
                            block82: {
                                if (ratios[i] == -1L || controls[i] instanceof ExpandableComposite && !((ExpandableComposite)controls[i]).isExpanded()) break block81;
                                diff = cBounds[i][1] - controls[i].computeSize((int)area.width, (int)-1, (boolean)flushCache).y;
                                moved = 0;
                                if (diff <= missing) break block82;
                                cBounds[i][1] = cBounds[i][1] - missing;
                                moved = missing;
                                missing = 0;
                                break block83;
                            }
                            if (diff <= 0) break block81;
                            cBounds[i][1] = cBounds[i][1] - diff;
                            moved = diff;
                            missing -= diff;
                        }
                        int j = i + 1;
                        while (j < controls.length) {
                            sBounds[j - 1] = sBounds[j - 1] - moved;
                            cBounds[j][0] = cBounds[j][0] - moved;
                            ++j;
                        }
                        if (missing == 0) break block73;
                    }
                    --i;
                }
            }
            i = 0;
            while (i < controls.length) {
                if (i > 0) {
                    sashes[i - 1].setBounds(area.x, sBounds[i - 1], area.width, sashwidth);
                }
                controls[i].setBounds(area.x, cBounds[i][0], area.width, cBounds[i][1]);
                ++i;
            }
        }
    }
}

