/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashFormData;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashFormLayout;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class TeamSashForm
extends Composite {
    private static final int HYSTERESIS = 10;
    public int SASH_WIDTH = 3;
    public int SPACING = 3;
    private ListenerList fListeners = new ListenerList();
    private IExpansionListener fExpansionListener = new ExpansionAdapter(){

        public void expansionStateChanging(ExpansionEvent e) {
            TeamSashForm.this.notifyExpanding(e);
            if (!e.getState()) {
                TeamSashForm.this.ensureExpanded((Control)e.getSource());
            }
        }

        public void expansionStateChanged(ExpansionEvent e) {
            TeamSashForm.this.notifyExpanded(e);
        }
    };
    int sashStyle;
    Sash[] sashes = new Sash[0];
    Color background = null;
    Color foreground = null;
    Control[] controls = new Control[0];
    Listener sashListener;
    private boolean fSashEnabled = true;

    public TeamSashForm(Composite parent, int style) {
        super(parent, TeamSashForm.checkStyle(style));
        this.setLayout(new TeamSashFormLayout());
        this.sashStyle = (style & 0x200) != 0 ? 256 : 512;
        this.sashListener = new Listener(){

            public void handleEvent(Event e) {
                TeamSashForm.this.onDragSash(e);
            }
        };
    }

    static int checkStyle(int style) {
        int mask = 0x6000000;
        return style & mask;
    }

    public int getOrientation() {
        return (this.sashStyle & 0x200) != 0 ? 256 : 512;
    }

    public int getStyle() {
        int style = super.getStyle();
        return style |= this.getOrientation() == 512 ? 512 : 256;
    }

    Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] result = new Control[]{};
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash || onlyVisible && !children[i].getVisible())) {
                Control[] newResult = new Control[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = children[i];
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onDragSash(Event event) {
        this.normalizeWeights(false);
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Control c2 = this.controls[sashIndex + 1];
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        Rectangle sashBounds = sash.getBounds();
        Rectangle area = this.getClientArea();
        if (this.getOrientation() == 256) {
            int minWidth1 = c1.computeSize((int)-1, (int)area.height, (boolean)false).x;
            int minWidth2 = c2.computeSize((int)-1, (int)area.height, (boolean)false).x;
            int shift = event.x - sashBounds.x;
            if (b1.width + shift < minWidth1) {
                shift = minWidth1 - b1.width;
                event.x = shift + sashBounds.x;
            }
            if (b2.width - shift < minWidth2) {
                shift = b2.width - minWidth2;
                event.x = shift + sashBounds.x;
            }
            if (shift == 0) {
                return;
            }
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
            this.setWeight(c1, b1.width);
            this.setWeight(c2, b2.width);
        } else {
            block25: {
                int minHeight;
                int totalHeight;
                block24: {
                    totalHeight = b2.y + b2.height - b1.y;
                    int shift = event.y - sashBounds.y;
                    b1.height += shift;
                    b2.y += shift;
                    b2.height -= shift;
                    if (c1 instanceof ExpandableComposite) {
                        if (((ExpandableComposite)c1).isExpanded()) {
                            minHeight = c1.computeSize((int)area.width, (int)-1, (boolean)false).y;
                            ((TeamSashFormData)c1.getLayoutData()).setMinHeight(minHeight);
                            if (b1.height < minHeight) {
                                if (b1.height < minHeight - 10) {
                                    this.setExpanded((ExpandableComposite)c1, false);
                                    event.doit = false;
                                    return;
                                }
                                return;
                            }
                            break block24;
                        } else {
                            int minHeight2 = ((TeamSashFormData)c1.getLayoutData()).getMinHeight();
                            if (minHeight2 == -1) {
                                Control client = ((ExpandableComposite)c1).getClient();
                                minHeight2 = client != null ? client.computeSize((int)area.width, (int)-1, (boolean)false).y : 0;
                                minHeight2 += 5;
                                ((TeamSashFormData)c1.getLayoutData()).setMinHeight(minHeight2 += c1.computeSize((int)area.width, (int)-1, (boolean)false).y);
                            }
                            if (b1.height >= minHeight2) {
                                this.setWeight(c1, b1.height);
                                this.setWeight(c2, b2.height);
                                this.setExpanded((ExpandableComposite)c1, true);
                                event.doit = false;
                                return;
                            }
                            event.y = sashBounds.y;
                            return;
                        }
                    }
                    minHeight = c1.computeSize((int)area.width, (int)-1, (boolean)false).y;
                    if (b1.height < minHeight) {
                        b1.height = minHeight;
                        event.y = b1.y + b1.height + this.SPACING;
                        b2.y = event.y + sashBounds.height + this.SPACING;
                        b2.height = b1.y + totalHeight - b2.y;
                    }
                }
                if (c2 instanceof ExpandableComposite) {
                    if (((ExpandableComposite)c2).isExpanded()) {
                        minHeight = c2.computeSize((int)area.width, (int)-1, (boolean)false).y;
                        ((TeamSashFormData)c2.getLayoutData()).setMinHeight(minHeight);
                        if (b2.height < minHeight) {
                            if (b2.height < minHeight - 10) {
                                this.setExpanded((ExpandableComposite)c2, false);
                                b2.height = c2.computeSize((int)area.width, (int)-1, (boolean)false).y;
                                b2.y = b1.y + totalHeight - b2.height;
                                b1.height = totalHeight - b2.height - sashBounds.height - 2 * this.SPACING;
                                event.y = b1.y + b1.height + this.SPACING;
                                this.setWeight(c1, b1.height);
                                this.setWeight(c2, b2.height);
                                this.layout();
                                event.doit = false;
                                return;
                            }
                            return;
                        }
                        break block25;
                    } else {
                        minHeight = ((TeamSashFormData)c2.getLayoutData()).getMinHeight();
                        if (minHeight == -1) {
                            Control client = ((ExpandableComposite)c2).getClient();
                            minHeight = client != null ? client.computeSize((int)area.width, (int)-1, (boolean)false).y : 0;
                            minHeight += 5;
                            ((TeamSashFormData)c2.getLayoutData()).setMinHeight(minHeight += c2.computeSize((int)area.width, (int)-1, (boolean)false).y);
                        }
                        if (b2.height >= minHeight) {
                            this.setWeight(c1, b1.height);
                            this.setWeight(c2, b2.height);
                            this.setExpanded((ExpandableComposite)c2, true);
                            event.doit = false;
                            return;
                        }
                        event.y = sashBounds.y;
                        return;
                    }
                }
                minHeight = c2.computeSize((int)area.width, (int)-1, (boolean)false).y;
                if (b2.height < minHeight) {
                    b2.height = minHeight;
                    b1.height = totalHeight - b2.height - sashBounds.height - 2 * this.SPACING;
                    event.y = b1.y + b1.height + this.SPACING;
                    b2.y = event.y + sashBounds.height + this.SPACING;
                }
            }
            this.setWeight(c1, b1.height);
            this.setWeight(c2, b2.height);
        }
        c1.setBounds(b1);
        sash.setBounds(event.x, event.y, event.width, event.height);
        c2.setBounds(b2);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setBackground(this.background);
            ++i;
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setForeground(this.foreground);
            ++i;
        }
    }

    public boolean isSashEnabled() {
        return this.fSashEnabled;
    }

    public void setSashEnabled(boolean sashEnabled) {
        if (this.fSashEnabled != sashEnabled) {
            this.fSashEnabled = sashEnabled;
            Sash[] sashArray = this.sashes;
            int n = this.sashes.length;
            int n2 = 0;
            while (n2 < n) {
                Sash sash = sashArray[n2];
                sash.setEnabled(sashEnabled);
                sash.setVisible(sashEnabled);
                ++n2;
            }
        }
    }

    public void setWeights(int[] weights) {
        this.updateWeights(weights);
        this.layout(false);
    }

    public void updateWeights(int[] weights) {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        if (weights == null || weights.length != cArray.length) {
            SWT.error((int)5);
        }
        int i = 0;
        while (i < weights.length) {
            if (weights[i] < -1) {
                SWT.error((int)5);
            }
            ++i;
        }
        i = 0;
        while (i < cArray.length) {
            Object data = cArray[i].getLayoutData();
            if (data == null || !(data instanceof TeamSashFormData)) {
                data = new TeamSashFormData();
                cArray[i].setLayoutData(data);
            }
            ((TeamSashFormData)data).setWeight(weights[i]);
            if (cArray[i] instanceof ExpandableComposite) {
                ((ExpandableComposite)cArray[i]).addExpansionListener(this.fExpansionListener);
            }
            ++i;
        }
    }

    void normalizeWeights(boolean flushCache) {
        int size = this.getOrientation() == 256 ? this.getClientArea().width : this.getClientArea().height;
        long totalWeight = 0L;
        int fixedSize = 0;
        Control[] controlArray = this.controls;
        int n = this.controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            long weight = ((TeamSashFormData)control.getLayoutData()).getWeight();
            if (weight != -1L) {
                totalWeight += weight;
            } else {
                fixedSize = this.getOrientation() == 256 ? (fixedSize += control.computeSize((int)-1, (int)size, (boolean)flushCache).x) : (fixedSize += control.computeSize((int)size, (int)-1, (boolean)flushCache).y);
            }
            ++n2;
        }
        if (totalWeight == 0L) {
            return;
        }
        long clientSize = size - this.sashes.length * (this.SASH_WIDTH + 2 * this.SPACING) - fixedSize;
        if (clientSize <= 0L) {
            return;
        }
        long weightSum = 0L;
        Control[] controlArray2 = this.controls;
        int n3 = this.controls.length;
        int n4 = 0;
        while (n4 < n3) {
            Control control = controlArray2[n4];
            TeamSashFormData data = (TeamSashFormData)control.getLayoutData();
            long weight = data.getWeight();
            if (weight != -1L) {
                this.setWeight(control, this.normalize(weightSum + weight, clientSize, totalWeight) - this.normalize(weightSum, clientSize, totalWeight));
                weightSum += weight;
            }
            ++n4;
        }
    }

    private int normalize(long oldValue, long newTotal, long oldTotal) {
        return (int)(oldValue * newTotal / oldTotal);
    }

    private void setWeight(Control control, int size) {
        TeamSashFormData data = (TeamSashFormData)control.getLayoutData();
        data.setWeight(size);
    }

    private void ensureExpanded(Control source) {
        ExpandableComposite candidate = null;
        Control[] controlArray = this.controls;
        int n = this.controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c != source && ((TeamSashFormData)c.getLayoutData()).getWeight() != -1L) {
                if (c instanceof ExpandableComposite) {
                    if (((ExpandableComposite)c).isExpanded()) {
                        return;
                    }
                    if (candidate == null) {
                        candidate = (ExpandableComposite)c;
                    }
                } else {
                    return;
                }
            }
            ++n2;
        }
        if (candidate != null) {
            this.setExpanded(candidate, true);
        }
    }

    private void setExpanded(ExpandableComposite composite, boolean expanded) {
        ExpansionEvent e = new ExpansionEvent((Object)composite, expanded);
        this.notifyExpanding(e);
        composite.setExpanded(expanded);
        this.notifyExpanded(e);
    }

    private void notifyExpanded(ExpansionEvent e) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IExpansionListener)l).expansionStateChanged(e);
            ++n2;
        }
    }

    private void notifyExpanding(ExpansionEvent e) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IExpansionListener)l).expansionStateChanging(e);
            ++n2;
        }
    }

    public void addExpansionListener(IExpansionListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeExpansionListener(IExpansionListener listener) {
        this.fListeners.remove((Object)listener);
    }
}

