/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class StatusLine {
    private Composite fContainer;
    private HyperlinkGroup fLinkGroup;
    private ImageHyperlink fTextLink;
    private HyperlinkAdapter fListener;
    private IDetailedStatus fDetailedStatus;

    public StatusLine(FormToolkit toolkit, Composite parent) {
        this.fContainer = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 15;
        this.fContainer.setLayout((Layout)layout);
        this.fContainer.setBackground(null);
        this.fLinkGroup = new HyperlinkGroup(toolkit.getColors().getDisplay());
        this.fTextLink = ((WorkItemEditorToolkit)toolkit).createCustomImageHyperlink(this.fContainer, 0);
        this.fTextLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.clear();
        this.fLinkGroup.add((Hyperlink)this.fTextLink);
        this.fLinkGroup.setBackground(null);
        this.fLinkGroup.setActiveBackground(null);
    }

    public Control getControl() {
        return this.fContainer;
    }

    public void setInfo(String info, IDetailedStatus status) {
        this.fLinkGroup.initializeDefaultForegrounds(Display.getCurrent());
        this.show(info, ImagePool.SERVER_SAVE_STATUS_INFO);
        this.fDetailedStatus = status;
    }

    public void setError(String error, IDetailedStatus status) {
        this.fLinkGroup.setActiveForeground(Display.getCurrent().getSystemColor(3));
        this.fLinkGroup.setForeground(Display.getCurrent().getSystemColor(4));
        this.show(error, ImagePool.SERVER_SAVE_STATUS_ERROR);
        this.fDetailedStatus = status;
    }

    public void clear() {
        if (!this.fTextLink.isDisposed()) {
            this.fTextLink.setVisible(false);
            this.fTextLink.setText("X");
            this.fTextLink.setImage(WorkItemIDEUIPlugin.getImage(ImagePool.STATE_UNKNOWN));
        }
        this.fDetailedStatus = null;
    }

    public IDetailedStatus getDetailedStatus() {
        return this.fDetailedStatus;
    }

    public String getText() {
        return this.fTextLink.getText();
    }

    public void setSelectionListener(final Runnable runnable) {
        if (this.fListener != null) {
            this.fTextLink.removeHyperlinkListener((IHyperlinkListener)this.fListener);
        }
        if (runnable != null) {
            this.fListener = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    runnable.run();
                }
            };
            this.fTextLink.addHyperlinkListener((IHyperlinkListener)this.fListener);
        }
    }

    private void show(String message, ImageDescriptor imageDesc) {
        this.fTextLink.setText(message);
        this.fTextLink.setImage(WorkItemIDEUIPlugin.getImage(imageDesc));
        this.fTextLink.setToolTipText(Messages.StatusLine_SHOW_MORE_DETAILS);
        this.fTextLink.getParent().layout();
        this.fTextLink.setVisible(true);
    }
}

