/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashForm;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class LinksTab
extends PresentationTab {
    public static final String TAB_ID = "com.ibm.team.workitem.ide.ui.editor.page.links";
    public static final String ATTACHMENTS_SLOT = "attachments";
    public static final String SUBSCRIBERS_SLOT = "subscribers";
    public static final String LINKS_SLOT = "links";
    public static Map<String, String> SLOTS = new HashMap<String, String>();
    public static List<String> SMALL_SLOTS = Collections.emptyList();

    static {
        SLOTS.put(ATTACHMENTS_SLOT, Messages.LinksTab_ATTACHMENTS);
        SLOTS.put(SUBSCRIBERS_SLOT, Messages.LinksTab_SUBSCRIBERS);
        SLOTS.put(LINKS_SLOT, Messages.LinksTab_LINKS);
    }

    public LinksTab() {
        super(TAB_ID, Messages.LinksTab_LINKS_TAB_TITLE);
    }

    public LinksTab(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        int i;
        int[] weights;
        TeamFormSectionContainer container;
        int style;
        Assert.isNotNull(this.getPresentations());
        Assert.isNotNull((Object)this.getWorkingCopy());
        Assert.isTrue((boolean)(this.getEditorInput() instanceof WorkItemEditorInput));
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        TeamSashForm tab = new TeamSashForm(body, 512);
        tab.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        managedForm.getToolkit().adapt((Composite)tab);
        TeamSashForm top = new TeamSashForm(tab, 256);
        managedForm.getToolkit().adapt((Composite)top);
        TeamSashForm att = new TeamSashForm(top, 512);
        managedForm.getToolkit().adapt((Composite)att);
        TeamSashForm subs = new TeamSashForm(top, 512);
        managedForm.getToolkit().adapt((Composite)subs);
        ArrayList<SectionDescriptor> attachmentsDesc = new ArrayList<SectionDescriptor>();
        ArrayList<SectionDescriptor> subscribersDesc = new ArrayList<SectionDescriptor>();
        ArrayList<SectionDescriptor> linksDesc = new ArrayList<SectionDescriptor>();
        if (this.getPresentations().get(this.getId()) == null) {
            return;
        }
        List<AbstractPresentationDescriptor> sections = this.getPresentations().get(this.getId());
        for (AbstractPresentationDescriptor desc : sections) {
            if (!(desc instanceof SectionDescriptor)) continue;
            SectionDescriptor sd = (SectionDescriptor)desc;
            if (ATTACHMENTS_SLOT.equals(sd.getSlot())) {
                attachmentsDesc.add(sd);
                continue;
            }
            if (SUBSCRIBERS_SLOT.equals(sd.getSlot())) {
                subscribersDesc.add(sd);
                continue;
            }
            if (!LINKS_SLOT.equals(sd.getSlot())) continue;
            linksDesc.add(sd);
        }
        ArrayList<TeamFormSectionContainer> attachmentSections = new ArrayList<TeamFormSectionContainer>();
        ArrayList<TeamFormSectionContainer> subscribersSections = new ArrayList<TeamFormSectionContainer>();
        ArrayList<TeamFormSectionContainer> linksSections = new ArrayList<TeamFormSectionContainer>();
        for (SectionDescriptor desc : attachmentsDesc) {
            style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (attachmentsDesc.size() > 1) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, att, style)) == null) continue;
            attachmentSections.add(container);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        for (SectionDescriptor desc : subscribersDesc) {
            style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (subscribersDesc.size() > 1) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, subs, style)) == null) continue;
            subscribersSections.add(container);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        for (SectionDescriptor desc : linksDesc) {
            style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (!attachmentSections.isEmpty() || !subscribersSections.isEmpty()) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, tab, style)) == null) continue;
            linksSections.add(container);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        if (attachmentSections.isEmpty()) {
            att.dispose();
        }
        if (subscribersSections.isEmpty()) {
            subs.dispose();
        }
        if (subs.isDisposed() && att.isDisposed()) {
            top.dispose();
        }
        if (!top.isDisposed() && !linksSections.isEmpty()) {
            int l = linksSections.size();
            weights = new int[l + 1];
            int sum = 0;
            int i2 = 0;
            while (i2 < l) {
                if (Util.isFixedHeight((TeamFormSectionContainer)linksSections.get(i2))) {
                    weights[i2 + 1] = -1;
                } else {
                    weights[i2 + 1] = Util.guessWeight((TeamFormSectionContainer)linksSections.get(i2)) * 10;
                    sum += weights[i2 + 1];
                }
                ++i2;
            }
            int topWeight = 40;
            if (sum > 0) {
                topWeight = sum * 2 / 3;
            }
            weights[0] = topWeight;
            tab.setWeights(weights);
        } else if (!top.isDisposed()) {
            tab.setWeights(new int[]{1});
        } else if (!linksSections.isEmpty()) {
            int l = linksSections.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)linksSections.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)linksSections.get(i));
                ++i;
            }
            tab.setWeights(weights);
        }
        if (!att.isDisposed() && !subs.isDisposed()) {
            top.setWeights(new int[]{60, 40});
        } else if (!att.isDisposed() || !subs.isDisposed()) {
            top.setWeights(new int[]{1});
        }
        if (!attachmentSections.isEmpty()) {
            int l = attachmentSections.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)attachmentSections.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)attachmentSections.get(i));
                ++i;
            }
            att.setWeights(weights);
        }
        if (!subscribersSections.isEmpty()) {
            int l = subscribersSections.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)subscribersSections.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)subscribersSections.get(i));
                ++i;
            }
            subs.setWeights(weights);
        }
        HelpContextIds.hookHelpListener((Control)form, "com.ibm.team.workitem.ide.ui.work_item_editor_links_page");
    }
}

