/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormPartContainer;
import com.ibm.team.ui.internal.editor.TeamFormConfiguration;
import com.ibm.team.ui.internal.editor.TeamFormLayout;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorParts;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderSection
extends TeamFormPartContainer {
    private String fHeaderId;
    private WorkItemWorkingCopy fWorkingCopy;
    private Map<String, List<AbstractPresentationDescriptor>> fPresentations;
    private TeamFormPart fSummaryPart;
    private Composite fParent;

    public HeaderSection(WorkItemWorkingCopy workingCopy, Map<String, List<AbstractPresentationDescriptor>> presentations, String headerId) {
        this.fHeaderId = headerId;
        this.fWorkingCopy = workingCopy;
        this.fPresentations = presentations;
    }

    public void createContent(Composite parent) {
        ITeamFormLayout formLayout = TeamFormLayouts.createLayout((Composite)parent, (ITeamFormConfiguration)TeamFormConfiguration.HORIZONTAL_LABEL_CONTENT_CONFIGURATION);
        this.fParent = parent;
        parent.setBackground(null);
        TeamFormPart[] teamFormPartArray = this.getParts();
        int n = teamFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c;
            TeamFormPart part = teamFormPartArray[n2];
            part.init(this.getSite());
            if (part instanceof PresentationPart) {
                ((PresentationPart)part).setIsHeader(true);
            }
            if ((c = this.createPartContent(parent, part)) != null && c.getLayoutData() == null) {
                ((TeamFormLayout)formLayout).fill(c, part.stretchHorizontally(), part.stretchVertically());
            }
            ++n2;
        }
    }

    protected TeamFormPart[] createParts() {
        ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>();
        List<AbstractPresentationDescriptor> descriptors = null;
        if (this.fHeaderId != null) {
            descriptors = this.fPresentations.get(this.fHeaderId);
        }
        if (descriptors != null && !descriptors.isEmpty()) {
            for (AbstractPresentationDescriptor desc : descriptors) {
                TeamFormPart part = WorkItemEditorParts.createPart(this.fWorkingCopy, desc);
                if (part == null) continue;
                parts.add(part);
                if (this.fSummaryPart != null || !(desc instanceof PresentationDescriptor) || !WorkItemAttributes.SUMMARY.equals((Object)((PresentationDescriptor)desc).getAttributeId())) continue;
                this.fSummaryPart = part;
            }
        }
        return parts.toArray(new TeamFormPart[parts.size()]);
    }

    public void passFocus(TeamFormPart part) {
        if (this.getManagedForm().getContainer() instanceof WorkItemEditor && part == this.fSummaryPart) {
            ((WorkItemEditor)((Object)this.getManagedForm().getContainer())).passFocus(null);
        } else {
            super.passFocus(part);
        }
    }

    public void setFocus() {
        Control lastFocusControl = this.getLastFocusControl();
        if (lastFocusControl != null) {
            lastFocusControl.setFocus();
        } else if (this.fSummaryPart != null) {
            this.fSummaryPart.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.fParent.dispose();
    }
}

