/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashForm;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class HTab
extends PresentationTab {
    public static final String TAB_ID = "com.ibm.team.workitem.ide.ui.editor.tab.h";
    public static final String TOP_SLOT = "top";
    public static final String LEFT_SLOT = "left";
    public static final String RIGHT_SLOT = "right";
    public static final String BOTTOM_SLOT = "bottom";
    public static Map<String, String> SLOTS = new HashMap<String, String>();
    public static List<String> SMALL_SLOTS = Collections.singletonList("left");

    static {
        SLOTS.put(TOP_SLOT, Messages.HTab_TOP_SLOT_NAME);
        SLOTS.put(LEFT_SLOT, Messages.HTab_LEFT_SLOT_NAME);
        SLOTS.put(RIGHT_SLOT, Messages.HTab_RIGHT_SLOT_NAME);
        SLOTS.put(BOTTOM_SLOT, Messages.HTab_BOTTOM_SLOT_NAME);
    }

    public HTab() {
        super(TAB_ID, Messages.HTab_H_TAB_TAB_NAME);
    }

    public HTab(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        int i;
        int[] weights;
        TeamFormSectionContainer container;
        int style;
        Assert.isNotNull(this.getPresentations());
        Assert.isNotNull((Object)this.getWorkingCopy());
        Assert.isTrue((boolean)(this.getEditorInput() instanceof WorkItemEditorInput));
        ArrayList<SectionDescriptor> topDesc = new ArrayList<SectionDescriptor>();
        ArrayList<SectionDescriptor> leftDesc = new ArrayList<SectionDescriptor>();
        ArrayList<SectionDescriptor> rightDesc = new ArrayList<SectionDescriptor>();
        ArrayList<SectionDescriptor> bottomDesc = new ArrayList<SectionDescriptor>();
        if (this.getPresentations().get(this.getId()) == null) {
            return;
        }
        List<AbstractPresentationDescriptor> sections = this.getPresentations().get(this.getId());
        for (AbstractPresentationDescriptor desc : sections) {
            if (!(desc instanceof SectionDescriptor)) continue;
            SectionDescriptor sd = (SectionDescriptor)desc;
            if (TOP_SLOT.equals(sd.getSlot())) {
                topDesc.add(sd);
                continue;
            }
            if (LEFT_SLOT.equals(sd.getSlot())) {
                leftDesc.add(sd);
                continue;
            }
            if (RIGHT_SLOT.equals(sd.getSlot())) {
                rightDesc.add(sd);
                continue;
            }
            if (!BOTTOM_SLOT.equals(sd.getSlot())) continue;
            bottomDesc.add(sd);
        }
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        TeamSashForm tab = new TeamSashForm(body, 512);
        tab.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        managedForm.getToolkit().adapt((Composite)tab);
        ArrayList<TeamFormSectionContainer> topSections = new ArrayList<TeamFormSectionContainer>();
        ArrayList<TeamFormSectionContainer> leftSections = new ArrayList<TeamFormSectionContainer>();
        ArrayList<TeamFormSectionContainer> rightSections = new ArrayList<TeamFormSectionContainer>();
        ArrayList<TeamFormSectionContainer> bottomSections = new ArrayList<TeamFormSectionContainer>();
        for (SectionDescriptor desc : topDesc) {
            TeamFormSectionContainer container2;
            int style2 = 256;
            if (desc.isExpanded()) {
                style2 |= 0x40;
            }
            if (!(leftDesc.isEmpty() && rightDesc.isEmpty() && bottomDesc.isEmpty())) {
                style2 |= 2;
            }
            if ((container2 = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, tab, style2)) == null) continue;
            topSections.add(container2);
            this.addPart((IFormPart)container2.getFormPart(), container2.getLayoutControl());
            container2.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        TeamSashForm top = new TeamSashForm(tab, 256);
        managedForm.getToolkit().adapt((Composite)top);
        TeamSashForm left = new TeamSashForm(top, 512);
        managedForm.getToolkit().adapt((Composite)left);
        TeamSashForm right = new TeamSashForm(top, 512);
        managedForm.getToolkit().adapt((Composite)right);
        for (SectionDescriptor desc : leftDesc) {
            style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (leftDesc.size() > 1) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, left, style)) == null) continue;
            leftSections.add(container);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        for (SectionDescriptor desc : rightDesc) {
            style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (rightDesc.size() > 1) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, right, style)) == null) continue;
            rightSections.add(container);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        for (SectionDescriptor desc : bottomDesc) {
            style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (!(leftSections.isEmpty() && rightSections.isEmpty() && topSections.isEmpty())) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, tab, style)) == null) continue;
            bottomSections.add(container);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        if (leftSections.isEmpty()) {
            left.dispose();
        }
        if (rightSections.isEmpty()) {
            right.dispose();
        }
        if (right.isDisposed() && left.isDisposed()) {
            top.dispose();
        }
        if (!(top.isDisposed() || bottomSections.isEmpty() && topSections.isEmpty())) {
            int l = bottomSections.size() + topSections.size();
            int tops = topSections.size();
            int[] weights2 = new int[l + 1];
            int i2 = 0;
            while (i2 < topSections.size()) {
                weights2[i2] = Util.isFixedHeight((TeamFormSectionContainer)topSections.get(i2)) ? -1 : Util.guessWeight((TeamFormSectionContainer)topSections.get(i2)) * 10;
                ++i2;
            }
            while (i2 < l) {
                weights2[i2 + 1] = Util.isFixedHeight((TeamFormSectionContainer)bottomSections.get(i2 - tops)) ? -1 : Util.guessWeight((TeamFormSectionContainer)bottomSections.get(i2 - tops)) * 10;
                ++i2;
            }
            int leftSum = 0;
            for (TeamFormSectionContainer leftS : leftSections) {
                if (Util.isFixedHeight(leftS)) continue;
                leftSum += Util.guessWeight(leftS) * 10;
            }
            int rightSum = 0;
            for (TeamFormSectionContainer rightS : rightSections) {
                if (Util.isFixedHeight(rightS)) continue;
                rightSum += Util.guessWeight(rightS) * 10;
            }
            int leftRightWeight = -1;
            if (rightSum + leftSum != 0) {
                leftRightWeight = Math.max(rightSum, leftSum);
            }
            weights2[tops] = leftRightWeight;
            tab.setWeights(weights2);
        } else if (!top.isDisposed()) {
            tab.setWeights(new int[]{1});
        } else if (!bottomSections.isEmpty()) {
            int l = bottomSections.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)bottomSections.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)bottomSections.get(i));
                ++i;
            }
            tab.setWeights(weights);
        } else if (!topSections.isEmpty()) {
            int l = topSections.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)topSections.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)topSections.get(i));
                ++i;
            }
            tab.setWeights(weights);
        }
        if (!left.isDisposed() && !right.isDisposed()) {
            top.setWeights(new int[]{-1, 1});
        } else if (!left.isDisposed() || !right.isDisposed()) {
            top.setWeights(new int[]{1});
        }
        if (!leftSections.isEmpty()) {
            int l = leftSections.size();
            int[] weights3 = new int[l];
            int i3 = 0;
            while (i3 < l) {
                weights3[i3] = Util.isFixedHeight((TeamFormSectionContainer)leftSections.get(i3)) ? -1 : Util.guessWeight((TeamFormSectionContainer)leftSections.get(i3));
                ++i3;
            }
            left.setWeights(weights3);
        }
        if (!rightSections.isEmpty()) {
            int l = rightSections.size();
            int[] weights4 = new int[l];
            int i4 = 0;
            while (i4 < l) {
                weights4[i4] = Util.isFixedHeight((TeamFormSectionContainer)rightSections.get(i4)) ? -1 : Util.guessWeight((TeamFormSectionContainer)rightSections.get(i4));
                ++i4;
            }
            right.setWeights(weights4);
        }
        HelpContextIds.hookHelpListener((Control)form, "com.ibm.team.workitem.ide.ui.work_item_editor_links_page");
    }
}

