/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public class FormPageSelectionProvider
implements ISelectionProvider {
    private Control fFocusControl;
    private Map fSelectionProviders = new HashMap();
    private ListenerList fListeners = new ListenerList();
    private DisposeListener fDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            FormPageSelectionProvider.this.removeControl((Control)e.widget);
        }
    };
    private FocusListener fFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            FormPageSelectionProvider.this.setFocusControl(null);
        }

        public void focusGained(FocusEvent e) {
            FormPageSelectionProvider.this.setFocusControl((Control)e.widget);
        }
    };
    private ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == FormPageSelectionProvider.this.getActiveProvider()) {
                Object[] listeners = FormPageSelectionProvider.this.fListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                    listener.selectionChanged(event);
                    ++i;
                }
            }
        }
    };

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        ISelectionProvider provider = this.getActiveProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
    }

    private ISelectionProvider getActiveProvider() {
        if (this.fFocusControl == null) {
            return null;
        }
        return this.findSelectionProvider(this.fFocusControl);
    }

    public void addSelectionProvider(ISelectionProvider provider, Control control) {
        this.fSelectionProviders.put(control, provider);
        provider.addSelectionChangedListener(this.fSelectionChangedListener);
        control.addDisposeListener(this.fDisposeListener);
        control.addFocusListener(this.fFocusListener);
    }

    public void removeSelectionProvider(ISelectionProvider provider) {
        Control control = this.findControl(provider);
        if (control != null) {
            this.removeControl(control);
        }
    }

    private Control findControl(ISelectionProvider provider) {
        for (Map.Entry entry : this.fSelectionProviders.entrySet()) {
            if (entry.getValue() != provider) continue;
            return (Control)entry.getKey();
        }
        return null;
    }

    protected void removeControl(Control control) {
        ISelectionProvider provider;
        if (control != null && !control.isDisposed()) {
            control.removeDisposeListener(this.fDisposeListener);
            control.removeFocusListener(this.fFocusListener);
        }
        if ((provider = (ISelectionProvider)this.fSelectionProviders.remove(control)) != null) {
            provider.removeSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    protected ISelectionProvider findSelectionProvider(Control control) {
        return (ISelectionProvider)this.fSelectionProviders.get(control);
    }

    protected void setFocusControl(Control control) {
        this.fFocusControl = control;
    }
}

