/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.editor.FormEditorPage;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEditorPagesRegistry {
    private static FormEditorPagesRegistry fgSingleton;
    private Map<String, FormEditorPageDescription> fPages;

    protected FormEditorPagesRegistry() {
        fgSingleton = this;
        FormEditorPagesRegistry.fgSingleton.fPages = new HashMap<String, FormEditorPageDescription>();
        new FormEditorPagesRegistryReader().start();
    }

    public static FormEditorPagesRegistry getInstance() {
        if (fgSingleton == null) {
            new FormEditorPagesRegistry();
        }
        return fgSingleton;
    }

    public FormEditorPageDescription getEditorPage(String id) {
        return this.fPages.get(id);
    }

    public Set<FormEditorPageDescription> getEditorPages() {
        return new HashSet<FormEditorPageDescription>(this.fPages.values());
    }

    private void addEditorPage(FormEditorPageDescription page) {
        this.fPages.put(page.fId, page);
    }

    public static class FormEditorPageDescription {
        private final String fId;
        private final String fTitle;
        private final IConfigurationElement fElement;

        FormEditorPageDescription(String id, String title, IConfigurationElement pageElement) throws IllegalArgumentException {
            if (this.isInvalid(id) || this.isInvalid(title) || pageElement == null) {
                throw new IllegalArgumentException();
            }
            this.fId = id;
            this.fTitle = title;
            this.fElement = pageElement;
        }

        public String getId() {
            return this.fId;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public FormEditorPage createPage(FormEditor editor) throws IllegalArgumentException, PartInitException {
            if (editor == null) {
                throw new IllegalArgumentException();
            }
            String className = this.fElement.getAttribute("class");
            try {
                FormEditorPage page = (FormEditorPage)this.fElement.createExecutableExtension("class");
                page.init(editor, this.fId, this.fTitle);
                return page;
            }
            catch (PartInitException ex) {
                throw ex;
            }
            catch (CoreException ex) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.FormEditorPagesRegistry_ERROR_INVALID_EDITOR_PAGE_CONTRIBUTION, (Object)className, (Object[])new Object[0]), ex);
            }
            catch (RuntimeException ex) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.FormEditorPagesRegistry_ERROR_INVALID_EDITOR_PAGE_CONTRIBUTION, (Object)className, (Object[])new Object[0]), ex);
            }
            return null;
        }

        private boolean isInvalid(String str) {
            return str == null || str.length() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FormEditorPagesRegistryReader
    extends ExtensionRegistryReader<WorkItemEditorPageDescriptor> {
        FormEditorPagesRegistryReader() {
            super("com.ibm.team.workitem.ide.ui", "editorPages");
        }

        protected WorkItemEditorPageDescriptor handleExtensionAdded(IConfigurationElement element) throws TeamServiceRegistryException {
            return new WorkItemEditorPageDescriptor(element);
        }

        protected void handleExtensionRemoved(IConfigurationElement element, WorkItemEditorPageDescriptor descriptor) throws TeamServiceRegistryException {
            descriptor.remove();
        }
    }

    private class WorkItemEditorPageDescriptor
    extends AbstractElementDescriptor {
        private static final String ATTRIBUTE_ID = "id";
        private static final String ATTRIBUTE_TITLE = "title";
        private static final String ATTRIBUTE_CLASS = "class";

        public WorkItemEditorPageDescriptor(IConfigurationElement element) {
            super(element, "editorPage");
        }

        protected void initialize() {
            String className = this.getAttribute(ATTRIBUTE_CLASS);
            try {
                FormEditorPagesRegistry.this.addEditorPage(new FormEditorPageDescription(this.getAttribute(ATTRIBUTE_ID), this.getAttribute(ATTRIBUTE_TITLE), this.getElement()));
            }
            catch (IllegalArgumentException ex) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.FormEditorPagesRegistry_ERROR_INVALID_EDITOR_PAGE_CONTRIBUTION, (Object)className, (Object[])new Object[0]), ex);
            }
            catch (ClassCastException ex) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.FormEditorPagesRegistry_ERROR_INVALID_EDITOR_PAGE_CONTRIBUTION, (Object)className, (Object[])new Object[0]), ex);
            }
        }

        void remove() throws TeamServiceRegistryException {
        }
    }
}

