/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.JavaFileEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.rcp.core.internal.ContentTypeUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class FileHelper {
    private static Map<UUID, File> fgTempFileCache = new HashMap<UUID, File>();
    public static String SHOW_ATTACHMENT_WARNING_DIALOG = "com.ibm.team.workitem.ide.ui.internal.editor.FileHelper.ATTACHMENT_WARNING_DIALOG";

    public static void open(File file) throws CoreException {
        FileHelper.open(null, file);
    }

    public static void open(IWorkbenchPage page, File file) throws CoreException {
        String editorId = FileHelper.getEditorId(file);
        IEditorInput input = FileHelper.createEditorInput(file);
        if (page == null) {
            page = Util.getWorkbenchPage(null);
        }
        if (page != null) {
            page.openEditor(input, editorId);
        }
    }

    private static String getEditorId(File file) throws CoreException {
        String name = file.getName();
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(name, ContentTypeUtils.getContentType((File)file));
        if (descriptor != null) {
            return descriptor.getId();
        }
        return FileHelper.getNonDefaultEditorId(name);
    }

    private static IEditorInput createEditorInput(File file) {
        IFile workspaceFile = FileHelper.getWorkspaceFile(file);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new JavaFileEditorInput(EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath())));
    }

    private static IFile getWorkspaceFile(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile[] files = workspace.getRoot().findFilesForLocation(location);
        if ((files = FileHelper.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        return FileHelper.selectWorkspaceFile(files);
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private static IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        dialog.setTitle(Messages.FileHelper_SELECT_WORKSPACE_FILE);
        dialog.setMessage(Messages.FileHelper_SELECTED_FILE_REFERENCED_BY_MULTIPLE_RESOURCES);
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    private static boolean askUser(final IAttachment attachment) {
        final boolean[] state = new boolean[1];
        if (!WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean(SHOW_ATTACHMENT_WARNING_DIALOG)) {
            return true;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String message = NLS.bind((String)Messages.FileHelper_ATTACHMENT_OPENED_WARNING, (Object)attachment.getName(), (Object[])new Object[]{((ITeamRepository)attachment.getOrigin()).getRepositoryURI()});
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.FileHelper_DOWNLOADING_AND_OPENING, (String)message, (String)Messages.FileHelper_DO_NOT_SHOW_WARNING, (boolean)false, null, null);
                int result = dialog.getReturnCode();
                boolean toggle = dialog.getToggleState();
                if (toggle && (result == 2 || result == 3)) {
                    WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(SHOW_ATTACHMENT_WARNING_DIALOG, !toggle);
                }
                state[0] = result == 2;
            }
        });
        return state[0];
    }

    public static void open(IAttachment attachment, IProgressMonitor monitor) throws TeamRepositoryException, CoreException {
        try {
            if (!FileHelper.askUser(attachment)) {
                return;
            }
            final File file = FileHelper.createTemporaryFile(attachment, monitor);
            FoundationUIJob job = new FoundationUIJob(Messages.FileHelper_OPENING_ATTACHMENT){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    try {
                        FileHelper.open(file);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException x) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.FileHelper_EXCEPTION_OPENING_ATTACHMENT, (Throwable)x);
                    }
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        catch (IOException x) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.FileHelper_EXCEPTION_OPENING_FILE, (Throwable)x));
        }
    }

    public static File createTemporaryFile(IAttachment attachment, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        String ext;
        String name;
        FileHelper.ensureResolved(attachment, monitor);
        File file = fgTempFileCache.get(attachment.getContent().getContentId());
        if (file != null) {
            if (file.canRead()) {
                return file;
            }
            fgTempFileCache.remove(attachment.getContent());
        }
        if ((name = attachment.getName()).indexOf(46) == -1 && (ext = ContentTypeUtils.guessFileExtension((String)attachment.getContent().getContentType())) != null) {
            name = String.valueOf(name) + "." + ext;
        }
        name = name.replace(':', '_').replace('/', '_').replace('\\', '_');
        file = File.createTempFile("tmp", String.valueOf('_') + name);
        file.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            IContentManager contentManager = ((ITeamRepository)attachment.getOrigin()).contentManager();
            contentManager.retrieveContent(attachment.getContent(), (OutputStream)outputStream, monitor);
            fgTempFileCache.put(attachment.getContent().getContentId(), file);
        }
        finally {
            outputStream.close();
        }
        file.setReadOnly();
        return file;
    }

    private static void ensureResolved(IAttachment attachment, IProgressMonitor monitor) throws TeamRepositoryException {
        if (attachment.isPropertySet(IAttachment.CONTENT_PROPERTY) && attachment.isPropertySet(IAttachment.NAME_PROPERTY)) {
            return;
        }
        IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)attachment.getOrigin()).getClientLibrary(IAuditableClient.class);
        attachment = (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)attachment, IAttachment.DEFAULT_PROFILE, monitor);
    }

    private static String getNonDefaultEditorId(String name) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = null;
        if (editorDescriptor == null && editorRegistry.isSystemExternalEditorAvailable(name)) {
            editorDescriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }
}

