/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.rcp.ui.WorkItemUIOperation;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractWorkItemOperation
extends WorkItemUIOperation {
    private IWorkItemHandle fSource;
    private String fActionName;
    private XMLString fSummary;
    private XMLString fDescription;
    private List<IContributorHandle> fSubscriptions;
    private IEndPointDescriptor fSourceReferenceType;
    private String[] fCopyAttributes;

    public ExtractWorkItemOperation(IWorkItemHandle source, String actionName, XMLString summary, XMLString description, List<IContributorHandle> subscriptions, IEndPointDescriptor sourceReferenceType, String[] copyAttributes) {
        super(Messages.ExtractWorkItemOperation_EXTRACTING_WORKITEM, IWorkItem.FULL_PROFILE);
        this.fSource = source;
        this.fActionName = actionName;
        this.fSummary = summary;
        this.fDescription = description;
        this.fSubscriptions = subscriptions;
        this.fSourceReferenceType = sourceReferenceType;
        this.fCopyAttributes = copyAttributes;
    }

    protected void execute(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        int i = 0;
        while (i < workingCopies.length) {
            WorkItemWorkingCopy workingCopy = workingCopies[i];
            IWorkItem workItem = workingCopy.getWorkItem();
            ITeamRepository teamRepository = workingCopy.getTeamRepository();
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IWorkItem sourceItem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)this.fSource, IWorkItem.FULL_PROFILE, monitor);
            if (sourceItem.getProjectArea().sameItemId((IItemHandle)workingCopy.getWorkItem().getProjectArea())) {
                String[] stringArray = this.fCopyAttributes;
                int n = this.fCopyAttributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String identifier = stringArray[n2];
                    IAttribute attribute = workItemClient.findAttribute(sourceItem.getProjectArea(), identifier, monitor);
                    Object value = sourceItem.getValue(attribute);
                    workItem.setValue(attribute, value);
                    ++n2;
                }
            }
            if (this.fSummary != null) {
                workItem.setHTMLSummary(this.fSummary);
            }
            if (this.fDescription != null) {
                workItem.setHTMLDescription(this.fDescription);
            }
            IComments comments = workItem.getComments();
            LocalizationContext context = LocalizationContext.createProjectAreaContext((IAuditableCommon)auditableClient, (IProjectAreaHandle)workItem.getProjectArea(), (IProgressMonitor)monitor);
            String text = NLS.bind((String)Messages.getString(context, "ExtractWorkItemOperation_ACTION_FROM_WORKITEM"), (Object)this.fActionName, (Object[])new Object[]{sourceItem.getId()});
            IComment comment = comments.createComment(workItem.getCreator(), Utils.createSynthetic((XMLString)XMLString.createFromPlainText((String)text)));
            comments.append(comment);
            for (IContributorHandle contributor : this.fSubscriptions) {
                workItem.getSubscriptions().add(contributor);
            }
            IWorkItemReferences references = workingCopy.getReferences();
            references.add(this.fSourceReferenceType, LinkHelper.createReference((IAuditableHandle)sourceItem));
            ++i;
        }
    }

    public void setEndPoint(IEndPointDescriptor endPoint) {
        this.fSourceReferenceType = endPoint;
    }
}

