/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPaneAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteLinkAction
extends ViewerPaneAction {
    public DeleteLinkAction(String text, String tooltip, String cmdId, ImageDescriptor image) {
        super(text, tooltip, cmdId, image);
    }

    public void update() {
        this.setEnabled(this.isSubscriptionsPartActive() || this.isLinksPartActive());
    }

    public void run() {
        if (this.isSubscriptionsPartActive()) {
            this.handleSubscriptionsPart();
        } else if (this.isLinksPartActive()) {
            this.handleLinksPart();
        }
    }

    private boolean isLinksPartActive() {
        if (this.getViewerPart() == null || !(this.getViewerPart().getInput() instanceof WorkItemWorkingCopy)) {
            return false;
        }
        WorkItemWorkingCopy input = (WorkItemWorkingCopy)this.getViewerPart().getInput();
        String inputSelector = this.getViewerPart().getInputSelector();
        if (inputSelector == null || !inputSelector.startsWith("references")) {
            return false;
        }
        if (this.getViewerPart().getSelection().isEmpty()) {
            return false;
        }
        if (!(this.getViewerPart().getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getViewerPart().getSelection();
        for (Object object : selection.toList()) {
            if (!(object instanceof IReference)) {
                return false;
            }
            IReference reference = (IReference)object;
            if (reference.getLink() == null) {
                return false;
            }
            IEndPointDescriptor descriptor = reference.getLink().getThisEndpointDescriptor(reference);
            if (descriptor == null) {
                return false;
            }
            if (!WorkItemLinkTypes.isUserDeletable((IEndPointDescriptor)descriptor)) {
                return false;
            }
            if (!WorkItemLinkTypes.isCalmLink((IEndPointDescriptor)descriptor) || LinkHelper.canModifyCalmLinks(input)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubscriptionsPartActive() {
        if (this.getViewerPart() == null || !(this.getViewerPart().getInput() instanceof WorkItemWorkingCopy)) {
            return false;
        }
        String inputSelector = this.getViewerPart().getInputSelector();
        if (inputSelector == null || !inputSelector.startsWith(IWorkItem.SUBSCRIPTIONS_PROPERTY)) {
            return false;
        }
        return !this.getViewerPart().getSelection().isEmpty();
    }

    private void handleSubscriptionsPart() {
        ViewerPart viewerPart = this.getViewerPart();
        ISelection selection = viewerPart.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        WorkItemWorkingCopy workingCopy = (WorkItemWorkingCopy)viewerPart.getInput();
        Object[] elements = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IContributorHandle) {
                workingCopy.getWorkItem().getSubscriptions().remove((IContributorHandle)elements[i]);
            }
            ++i;
        }
    }

    private void handleLinksPart() {
        ViewerPart viewerPart = this.getViewerPart();
        ISelection selection = viewerPart.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        WorkItemWorkingCopy workingCopy = (WorkItemWorkingCopy)viewerPart.getInput();
        Object[] elements = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IReference) {
                workingCopy.getReferences().remove((IReference)element);
            } else if (element instanceof ArtifactLink) {
                workingCopy.getReferences().remove(((ArtifactLink)element).getReference());
            }
            ++i;
        }
    }
}

