/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;

public class ChangeDecorator {
    private static final int DELAY = 500;
    private boolean fShowChangeDecoration = false;
    private boolean fShowSparkle = false;
    private Job fJob = new InternalJob();
    private IRunnableWithProgress fUpdate;
    private Decoration fDecoration;

    public ChangeDecorator(IRunnableWithProgress update) {
        this(update, Decoration.CHANGE);
    }

    public ChangeDecorator(IRunnableWithProgress update, Decoration decoration) {
        this.fUpdate = update;
        this.fDecoration = decoration;
    }

    public ImageDescriptor decorate(ImageDescriptor baseDescriptor) {
        if (!this.fShowSparkle) {
            return baseDescriptor;
        }
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = this.fDecoration.getOverlay();
        return new OverlayIcon(baseDescriptor, null, imageDescriptorArray, new Point(16, 16), this.fDecoration.getAlignment());
    }

    public void setShowChangeDecoration(boolean showChangeDecoration) {
        this.fShowChangeDecoration = showChangeDecoration;
        if (this.fShowChangeDecoration) {
            this.fJob.schedule(500L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Decoration {
        CHANGE(ImagePool.NEWINFO_OVRL, 131200),
        STALE(ImagePool.NEWINFO_OVRL, 16512);

        private ImageDescriptor fOverlay;
        private int fAlignment;

        private Decoration(ImageDescriptor overlay, int alignment) {
            this.fOverlay = overlay;
            this.fAlignment = alignment;
        }

        private ImageDescriptor getOverlay() {
            return this.fOverlay;
        }

        private int getAlignment() {
            return this.fAlignment;
        }
    }

    private class InternalJob
    extends FoundationUIJob {
        public InternalJob() {
            super(Messages.ChangeDecorator_DECORATION_UPDATER);
            this.setSystem(true);
        }

        public IStatus runProtectedInUI(IProgressMonitor monitor) {
            try {
                if (ChangeDecorator.this.fShowChangeDecoration) {
                    ChangeDecorator.this.fShowSparkle = !ChangeDecorator.this.fShowSparkle;
                    ChangeDecorator.this.fUpdate.run(monitor);
                    if (!monitor.isCanceled()) {
                        this.schedule(500L);
                    }
                } else if (ChangeDecorator.this.fShowSparkle) {
                    ChangeDecorator.this.fShowSparkle = false;
                    ChangeDecorator.this.fUpdate.run(monitor);
                }
            }
            catch (InvocationTargetException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.ChangeDecorator_EXCEPTION_UPDATING_DECORATION, x);
            }
            catch (InterruptedException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.ChangeDecorator_EXCEPTION_UPDATING_DECORATION, x);
            }
            return Status.OK_STATUS;
        }
    }
}

