/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public abstract class AbstractWorkItemEditorInput
extends PlatformObject
implements IEditorInput {
    protected IWorkItemHandle fWorkItemHandle;

    protected AbstractWorkItemEditorInput(IWorkItemHandle workItemHandle) {
        this.fWorkItemHandle = workItemHandle;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractWorkItemEditorInput) {
            AbstractWorkItemEditorInput input = (AbstractWorkItemEditorInput)((Object)obj);
            return this.fWorkItemHandle.sameItemId((IItemHandle)input.fWorkItemHandle);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fWorkItemHandle.getItemId().hashCode();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.ID_PROPERTY, IWorkItem.SUMMARY_PROPERTY});
        IWorkItem workItem = this.findWorkItem(profile);
        if (workItem != null) {
            return WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem);
        }
        return Messages.AbstractWorkItemEditorInput_UNRESOLVED;
    }

    public String getToolTipText() {
        ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.ID_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.CREATION_DATE_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY});
        IWorkItem workItem = this.findWorkItem(profile);
        if (workItem != null) {
            String projectName = ProjectAreaPicker.getUnambiguousProjectName((List)ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true), (IProjectAreaHandle)workItem.getProjectArea());
            return projectName;
        }
        return Messages.AbstractWorkItemEditorInput_UNRESOLVED;
    }

    private IWorkItem findWorkItem(ItemProfile profile) {
        ITeamRepository teamRepository = (ITeamRepository)this.fWorkItemHandle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        if (this.fWorkItemHandle instanceof IWorkItem && profile.isMatched((IAuditable)((IWorkItem)this.fWorkItemHandle))) {
            return (IWorkItem)this.fWorkItemHandle;
        }
        IWorkItem workItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)this.fWorkItemHandle, profile);
        if (workItem != null) {
            return workItem;
        }
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        boolean connected = workingCopyManager.connectLocal(this.fWorkItemHandle, profile);
        if (!connected) {
            return null;
        }
        try {
            WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(this.fWorkItemHandle);
            IWorkItem iWorkItem = workingCopy.getWorkItem();
            return iWorkItem;
        }
        finally {
            workingCopyManager.disconnect(this.fWorkItemHandle);
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IWorkItemHandle getWorkItemHandle() {
        return this.fWorkItemHandle;
    }
}

