/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.capture;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ScreenCaptureWindow {
    private static final String PREF_SIZE_HEIGHT = "SIZE_HEIGHT";
    private static final String PREF_SIZE_WIDTH = "SIZE_WIDTH";
    private static final String PREF_LOCATION_Y = "LOCATION_Y";
    private static final String PREF_LOCATION_X = "LOCATION_X";
    private static final String PREF_DRAW_COLOR = "DRAW_COLOR";
    private static final String PREF_DRAW_STYLE = "DRAW_STYLE";
    static final int DRAW_PEN = 0;
    static final int DRAW_OVAL = 1;
    static final int DRAW_RECTANGLE = 2;
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private static final int BORDER_MIN_SIZE = 10;
    private static final int N = 0;
    private static final int E = 1;
    private static final int S = 2;
    private static final int W = 3;
    private static final int NW = 4;
    private static final int NE = 5;
    private static final int SE = 6;
    private static final int SW = 7;
    private static final int LINE_WIDTH = 3;
    private static boolean fgIsMac = "carbon".equals(SWT.getPlatform());
    private static boolean fgIsLinux = "gtk".equals(SWT.getPlatform());
    private Shell fShell;
    private LocalResourceManager fResources;
    private Canvas fCanvas;
    private Display fDisplay;
    private Image fCapturedImage;
    private Composite fCanvasContainer;
    private int fDrawingColor = 3;
    private Rectangle fInitialBounds = new Rectangle(-1, -1, 640, 480);
    private int fDrawingStyle = 0;
    private Cursor fPenCursor;
    private Shell fParentShell;
    private int fLastDirection;

    public ScreenCaptureWindow(Shell parentShell) {
        this.fParentShell = parentShell;
    }

    void initialize(IMemento settings) {
        this.setDrawingColor(this.getInteger(settings, PREF_DRAW_COLOR, 3));
        this.setDrawingStyle(this.getInteger(settings, PREF_DRAW_STYLE, 0));
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        bounds.x = this.getInteger(settings, PREF_LOCATION_X, -1);
        bounds.y = this.getInteger(settings, PREF_LOCATION_Y, -1);
        bounds.width = this.getInteger(settings, PREF_SIZE_WIDTH, 640);
        bounds.height = this.getInteger(settings, PREF_SIZE_HEIGHT, 480);
        this.fInitialBounds = bounds;
    }

    void saveSettings(IMemento memento) {
        memento.putInteger(PREF_DRAW_STYLE, this.fDrawingStyle);
        memento.putInteger(PREF_DRAW_COLOR, this.fDrawingColor);
        if (!this.getShell().isDisposed()) {
            Rectangle capBounds = this.getShell().getBounds();
            memento.putInteger(PREF_LOCATION_X, capBounds.x);
            memento.putInteger(PREF_LOCATION_Y, capBounds.y);
            memento.putInteger(PREF_SIZE_WIDTH, capBounds.width);
            memento.putInteger(PREF_SIZE_HEIGHT, capBounds.height);
        }
    }

    public void setDrawingColor(int color) {
        this.fDrawingColor = color;
    }

    public int getDrawingColor() {
        return this.fDrawingColor;
    }

    public int getDrawingStyle() {
        return this.fDrawingStyle;
    }

    public void setDrawingStyle(int drawingStyle) {
        this.fDrawingStyle = drawingStyle;
        if (this.fCanvas == null || this.fCanvas.isDisposed()) {
            return;
        }
        if (this.fDrawingStyle == 0) {
            this.fCanvas.setCursor(this.fPenCursor);
        } else if (this.fDrawingStyle == 1 || this.fDrawingStyle == 2) {
            this.fCanvas.setCursor(this.fDisplay.getSystemCursor(2));
        }
    }

    public void open() {
        this.create();
        this.fShell.open();
    }

    public void dispose() {
        if (!this.fShell.isDisposed()) {
            this.setRegion(null);
        }
        this.clearCapture(null);
        this.fPenCursor.dispose();
    }

    public Shell getShell() {
        return this.fShell;
    }

    public void reset() {
        this.clearCapture(null);
        this.clearCapturedImage();
    }

    public Image getCapturedImageCropped() {
        if (this.fCapturedImage == null) {
            this.capture();
        }
        Rectangle cBounds = this.fCanvas.getClientArea();
        Image croppedImage = new Image((Device)this.fDisplay, cBounds.width, cBounds.height);
        GC gc = new GC((Drawable)croppedImage);
        gc.drawImage(this.fCapturedImage, cBounds.x, cBounds.y, cBounds.width, cBounds.height, 0, 0, cBounds.width, cBounds.height);
        gc.dispose();
        return croppedImage;
    }

    public Point getCapturedSize() {
        Rectangle cBounds = this.fCanvas.getClientArea();
        return new Point(cBounds.width, cBounds.height);
    }

    public void capture() {
        this.clearCapturedImage();
        if (fgIsMac) {
            this.fShell.setVisible(false);
        }
        this.internalCapture();
        if (fgIsMac) {
            this.fShell.setVisible(true);
        }
        this.setRegion(null);
        this.fCanvasContainer.setBackground(this.fDisplay.getSystemColor(6));
        this.fShell.update();
        Shell[] shells = this.fShell.getDisplay().getShells();
        Rectangle capBounds = this.fShell.getBounds();
        int i = 0;
        while (i < shells.length) {
            Rectangle modalShellBounds;
            Shell shell = shells[i];
            if ((shell.getStyle() & 0x10000) != 0 && capBounds.intersects(modalShellBounds = shell.getBounds())) {
                Rectangle safeBounds = new Rectangle(0, 0, capBounds.width, capBounds.height);
                if (capBounds.width > modalShellBounds.x) {
                    safeBounds.width = modalShellBounds.x;
                }
                this.fShell.setBounds(safeBounds);
                break;
            }
            ++i;
        }
    }

    protected void recreateHook() {
    }

    private void create() {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fParentShell, 16392);
        this.fShell.setMinimumSize(48, 48);
        this.fShell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fShell);
        Shell sizeContainer = null;
        if (fgIsMac) {
            sizeContainer = this.fShell;
        } else {
            this.fShell.setLayout((Layout)new FillLayout());
            sizeContainer = new Composite((Composite)this.fShell, 2048);
        }
        sizeContainer.setCursor(this.fDisplay.getSystemCursor(fgIsMac ? 21 : 5));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        sizeContainer.setLayout((Layout)layout);
        WindowMover windowMover = new WindowMover();
        sizeContainer.addListener(3, (Listener)windowMover);
        sizeContainer.addListener(4, (Listener)windowMover);
        new ResizeHandle((Composite)sizeContainer, 4, new GridData(1, 1, false, false), 17);
        new ResizeHandle((Composite)sizeContainer, 0, new GridData(0x1000000, 1, false, false), 10);
        new ResizeHandle((Composite)sizeContainer, 5, new GridData(0x1000008, 1, false, false), 14);
        new ResizeHandle((Composite)sizeContainer, 3, new GridData(1, 0x1000000, false, true), 13);
        layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        this.fCanvasContainer = new Composite((Composite)sizeContainer, 0);
        this.fCanvasContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fCanvasContainer.setLayout((Layout)layout);
        this.fCanvasContainer.setCursor(this.fDisplay.getSystemCursor(5));
        this.fCanvas = new Canvas(this.fCanvasContainer, 0);
        this.fCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        ImageData source = new ImageData(this.getClass().getResourceAsStream("/icons/pointer/cursr_pen.gif"));
        this.fPenCursor = new Cursor((Device)this.fDisplay, source, 8, 20);
        if (this.fDrawingStyle == 0) {
            this.fCanvas.setCursor(this.fPenCursor);
        } else if (this.fDrawingStyle == 1 || this.fDrawingStyle == 2) {
            this.fCanvas.setCursor(this.fDisplay.getSystemCursor(2));
        }
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent ev) {
                if (ScreenCaptureWindow.this.fCapturedImage != null) {
                    ev.gc.drawImage(ScreenCaptureWindow.this.fCapturedImage, 0, 0);
                }
            }
        });
        this.fCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ScreenCaptureWindow.this.fCapturedImage == null) {
                    ScreenCaptureWindow.this.updateRegion();
                } else {
                    ScreenCaptureWindow.this.resizeImage();
                }
            }
        });
        new ResizeHandle((Composite)sizeContainer, 1, new GridData(0x1000008, 0x1000000, false, true), 12);
        new ResizeHandle((Composite)sizeContainer, 7, new GridData(1, 0x1000008, false, false), 16);
        new ResizeHandle((Composite)sizeContainer, 2, new GridData(0x1000000, 0x1000008, false, false), 11);
        new ResizeHandle((Composite)sizeContainer, 6, new GridData(0x1000008, 0x1000008, false, false), 15);
        Scribbler scribbleListener = new Scribbler();
        this.fCanvas.addListener(3, (Listener)scribbleListener);
        this.fCanvas.addListener(4, (Listener)scribbleListener);
        this.fInitialBounds = this.fixBounds(this.fInitialBounds);
        this.fShell.setBounds(this.fInitialBounds);
        this.clearCapturedImage();
    }

    private void clearCapture(Image newImage) {
        if (this.fCapturedImage != null && !this.fCapturedImage.isDisposed()) {
            this.fCapturedImage.dispose();
        }
        this.fCapturedImage = newImage;
    }

    private void setRegion(Region region) {
        Region oldRegion = this.fShell.getRegion();
        if (oldRegion != region) {
            this.fShell.setRegion(region);
            if (region != null) {
                Rectangle size = region.getBounds();
                this.fShell.setSize(size.width, size.height);
            }
            if (oldRegion != null) {
                oldRegion.dispose();
            }
        }
    }

    private void internalCapture() {
        Rectangle bounds = this.fCanvas.getBounds();
        Image capture = new Image((Device)this.fDisplay, bounds.width, bounds.height);
        Point p = this.fCanvas.toDisplay(0, 0);
        GC gc = new GC((Drawable)this.fDisplay);
        gc.copyArea(capture, p.x, p.y);
        gc.dispose();
        if (this.fCapturedImage == null) {
            this.fCapturedImage = capture;
        } else {
            gc = new GC((Drawable)this.fCapturedImage);
            gc.drawImage(capture, 0, 0);
            gc.dispose();
            capture.dispose();
        }
    }

    private void resizeImage() {
        if (this.fCapturedImage == null || this.fCapturedImage.isDisposed()) {
            return;
        }
        Rectangle newBounds = this.fCanvas.getBounds();
        Image biggerImage = new Image((Device)this.fDisplay, newBounds.width, newBounds.height);
        Rectangle imgBounds = this.fCapturedImage.getBounds();
        int x = 0;
        int y = 0;
        switch (this.fLastDirection) {
            case 0: 
            case 4: 
            case 5: {
                y = newBounds.height - imgBounds.height;
            }
        }
        switch (this.fLastDirection) {
            case 3: 
            case 4: 
            case 7: {
                x = newBounds.width - imgBounds.width;
            }
        }
        GC gc = new GC((Drawable)biggerImage);
        gc.drawImage(this.fCapturedImage, x, y);
        gc.dispose();
        this.clearCapture(biggerImage);
    }

    private final void resize(Rectangle bounds) {
        if (!fgIsLinux) {
            this.fShell.setBounds(bounds);
            return;
        }
        ImageData captureData = null;
        if (this.fCapturedImage != null) {
            captureData = this.fCapturedImage.getImageData();
        }
        this.fInitialBounds = bounds;
        this.dispose();
        this.fShell.close();
        this.open();
        this.recreateHook();
        if (captureData != null) {
            this.clearCapture(new Image((Device)this.fDisplay, captureData));
            this.resizeImage();
            this.setRegion(null);
            this.fCanvas.redraw();
            this.fShell.update();
        }
    }

    private void clearCapturedImage() {
        this.updateRegion();
        this.fCanvasContainer.setBackground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
        this.fShell.update();
    }

    private void updateRegion() {
        Rectangle canvasBounds = this.fCanvas.getClientArea();
        canvasBounds = this.fDisplay.map((Control)this.fCanvas, (Control)this.fShell, canvasBounds);
        Region r = new Region();
        Point size = this.fShell.getSize();
        r.add(0, 0, size.x, size.y);
        r.subtract(canvasBounds);
        this.setRegion(r);
    }

    private Rectangle fixBounds(Rectangle bounds) {
        if (bounds.x != -1 || bounds.y != -1) {
            int totalArea = bounds.width * bounds.height;
            Monitor[] monitors = this.fDisplay.getMonitors();
            int i = 0;
            while (i < monitors.length) {
                Rectangle clientArea = monitors[i].getClientArea();
                Rectangle r = clientArea.intersection(bounds);
                int area = r.width * r.height;
                if (area >= totalArea / 4) {
                    return bounds;
                }
                ++i;
            }
        }
        return this.getInitialBounds(bounds);
    }

    private Rectangle getInitialBounds(Rectangle initialBounds) {
        Composite parent = this.fShell.getParent();
        Monitor monitor = this.getActiveWorkbenchMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? this.centerPoint(parent.getBounds()) : this.centerPoint(monitorBounds);
        int x = centerPoint.x - initialBounds.width / 2;
        int y = Math.max(monitorBounds.y, Math.min(centerPoint.y - initialBounds.height * 2 / 3, monitorBounds.y + monitorBounds.height - initialBounds.height));
        int w = initialBounds.width;
        int h = initialBounds.height;
        return new Rectangle(x, y, w, h);
    }

    private Monitor getActiveWorkbenchMonitor() {
        IWorkbenchWindow activeWorkbenchWindow;
        Monitor[] monitors = this.fDisplay.getMonitors();
        if (monitors.length > 1 && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            Rectangle activeWorkbenchBounds = activeWorkbenchWindow.getShell().getBounds();
            Monitor eclipseMonitor = null;
            int maxArea = 0;
            int i = 0;
            while (i < monitors.length) {
                Monitor monitor = monitors[i];
                Rectangle monitorBounds = monitor.getBounds();
                Rectangle intersection = monitorBounds.intersection(activeWorkbenchBounds);
                int area = intersection.width * intersection.height;
                if (area >= maxArea) {
                    eclipseMonitor = monitor;
                    maxArea = area;
                }
                ++i;
            }
            return eclipseMonitor;
        }
        return this.fDisplay.getPrimaryMonitor();
    }

    private Point centerPoint(Rectangle rect) {
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    private Image getImage(int direction) {
        switch (direction) {
            case 0: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_top-mid.gif"));
            }
            case 1: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_rt-mid.gif"));
            }
            case 2: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_bot-mid.gif"));
            }
            case 3: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_lft-mid.gif"));
            }
            case 4: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_top-lft.gif"));
            }
            case 5: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_top-rt.gif"));
            }
            case 6: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_bot-rt.gif"));
            }
            case 7: {
                return JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/obj16/hndl_bot-lft.gif"));
            }
        }
        return null;
    }

    private int getInteger(IMemento memento, String key, int defaultValue) {
        if (memento == null) {
            return defaultValue;
        }
        Integer value = memento.getInteger(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static Rectangle track(Control control, int flags) {
        Rectangle bounds = control.getBounds();
        Tracker tracker = new Tracker(control.getDisplay(), flags);
        tracker.setRectangles(new Rectangle[]{bounds});
        if (tracker.open()) {
            return tracker.getRectangles()[0];
        }
        return null;
    }

    class ResizeHandle
    extends Canvas {
        private Image fImage;
        private int fDirection;

        ResizeHandle(Composite parent, int direction, GridData gridData, int cursor) {
            super(parent, 0);
            this.fDirection = direction;
            this.fImage = ScreenCaptureWindow.this.getImage(direction);
            this.setLayoutData(gridData);
            this.setCursor(ScreenCaptureWindow.this.fDisplay.getSystemCursor(cursor));
            this.setSize(this.fImage.getBounds().width, this.fImage.getBounds().height);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    ResizeHandle.this.onPaint(event.gc);
                }
            });
            WindowSizer sizer = new WindowSizer();
            this.addListener(3, sizer);
            this.addListener(4, sizer);
        }

        int getDirection() {
            return this.fDirection;
        }

        protected void onPaint(GC gc) {
            Point e = this.getSize();
            if (e.x > 0 && e.y > 0) {
                gc.drawImage(this.fImage, 0, 0);
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (wHint == -1) {
                wHint = Math.max(this.fImage.getBounds().width, 10);
            }
            if (hHint == -1) {
                hHint = Math.max(this.fImage.getBounds().height, 10);
            }
            return new Point(wHint, hHint);
        }
    }

    class Scribbler
    implements Listener {
        int fAnchorX;
        int fAnchorY;
        int fLastX;
        int fLastY;
        GC fImageGC;
        GC fCanvasGC;

        Scribbler() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 3: {
                    Color color = ScreenCaptureWindow.this.fDisplay.getSystemColor(ScreenCaptureWindow.this.fDrawingColor);
                    this.fImageGC = new GC((Drawable)ScreenCaptureWindow.this.fCapturedImage);
                    this.fImageGC.setForeground(color);
                    this.fImageGC.setAntialias(1);
                    this.fImageGC.setLineWidth(3);
                    this.fCanvasGC = new GC((Drawable)ScreenCaptureWindow.this.fCanvas);
                    this.fCanvasGC.setForeground(color);
                    this.fCanvasGC.setAntialias(1);
                    this.fCanvasGC.setLineWidth(3);
                    ScreenCaptureWindow.this.fCanvas.addListener(5, (Listener)this);
                    this.fAnchorX = this.fLastX = e.x;
                    this.fAnchorY = this.fLastY = e.y;
                    break;
                }
                case 5: {
                    if ((e.stateMask & 0x80000) == 0) break;
                    switch (ScreenCaptureWindow.this.fDrawingStyle) {
                        case 1: {
                            this.redrawBoundingBox(this.fAnchorX, this.fAnchorY, this.fLastX, this.fLastY, 3);
                            this.drawOval(this.fCanvasGC, this.fAnchorX, this.fAnchorY, e.x, e.y);
                            break;
                        }
                        case 2: {
                            this.redrawBoundingBox(this.fAnchorX, this.fAnchorY, this.fLastX, this.fLastY, 3);
                            this.drawRoundRectangle(this.fCanvasGC, this.fAnchorX, this.fAnchorY, e.x, e.y, 12, 12);
                            break;
                        }
                        case 0: {
                            this.fImageGC.drawLine(this.fLastX, this.fLastY, e.x, e.y);
                            this.redrawBoundingBox(this.fLastX, this.fLastY, e.x, e.y, 3);
                        }
                    }
                    this.fLastX = e.x;
                    this.fLastY = e.y;
                    break;
                }
                case 4: {
                    ScreenCaptureWindow.this.fCanvas.removeListener(5, (Listener)this);
                    if (this.fImageGC != null && !this.fImageGC.isDisposed()) {
                        switch (ScreenCaptureWindow.this.fDrawingStyle) {
                            case 1: {
                                this.drawOval(this.fImageGC, this.fAnchorX, this.fAnchorY, e.x, e.y);
                                this.redrawBoundingBox(this.fAnchorX, this.fAnchorY, e.x, e.y, 3);
                                break;
                            }
                            case 2: {
                                this.drawRoundRectangle(this.fImageGC, this.fAnchorX, this.fAnchorY, e.x, e.y, 12, 12);
                                this.redrawBoundingBox(this.fAnchorX, this.fAnchorY, e.x, e.y, 3);
                                break;
                            }
                            case 0: {
                                this.fImageGC.drawLine(this.fLastX, this.fLastY, e.x, e.y);
                                this.redrawBoundingBox(this.fLastX, this.fLastY, e.x, e.y, 3);
                            }
                        }
                        this.fImageGC.dispose();
                    }
                    if (this.fCanvasGC != null) {
                        this.fCanvasGC.dispose();
                    }
                    ScreenCaptureWindow.this.fParentShell.setFocus();
                }
            }
        }

        private void drawRoundRectangle(GC canvasGC, int x1, int y1, int x2, int y2, int arcWidth, int arcHeight) {
            Rectangle box = this.toBoundingBox(x1, y1, x2, y2);
            canvasGC.drawRoundRectangle(box.x, box.y, box.width, box.height, arcWidth, arcHeight);
        }

        private void drawOval(GC canvasGC, int x1, int y1, int x2, int y2) {
            Rectangle box = this.toBoundingBox(x1, y1, x2, y2);
            canvasGC.drawOval(box.x, box.y, box.width, box.height);
        }

        private void redrawBoundingBox(int x1, int y1, int x2, int y2, int lw) {
            Rectangle boundingBox = this.toBoundingBox(x1, y1, x2, y2);
            Rectangle redrawBox = new Rectangle(boundingBox.x - lw, boundingBox.y - lw, boundingBox.width + 2 * lw, boundingBox.height + 2 * lw);
            ScreenCaptureWindow.this.fCanvas.redraw(redrawBox.x, redrawBox.y, redrawBox.width, redrawBox.height, false);
            ScreenCaptureWindow.this.fCanvas.update();
        }

        private Rectangle toBoundingBox(int x1, int y1, int x2, int y2) {
            int minX = Math.min(x1, x2);
            int minY = Math.min(y1, y2);
            int width = Math.max(x1, x2) - minX;
            int height = Math.max(y1, y2) - minY;
            return new Rectangle(minX, minY, Math.max(width, 3), Math.max(height, 3));
        }
    }

    class WindowMover
    implements Listener {
        Point fOrigin;

        WindowMover() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 3: {
                    if (fgIsMac || fgIsLinux) {
                        Rectangle bounds = ScreenCaptureWindow.track((Control)ScreenCaptureWindow.this.fShell, 0);
                        if (bounds == null) break;
                        ScreenCaptureWindow.this.fShell.setLocation(bounds.x, bounds.y);
                        break;
                    }
                    this.fOrigin = new Point(e.x, e.y);
                    ((Control)e.widget).addListener(5, (Listener)this);
                    ((Control)e.widget).addListener(7, (Listener)this);
                    break;
                }
                case 4: 
                case 7: {
                    this.fOrigin = null;
                    ((Control)e.widget).removeListener(5, (Listener)this);
                    ((Control)e.widget).removeListener(7, (Listener)this);
                    ScreenCaptureWindow.this.fParentShell.setFocus();
                    break;
                }
                case 5: {
                    if (this.fOrigin == null) break;
                    Point p = ScreenCaptureWindow.this.fShell.getDisplay().map((Control)ScreenCaptureWindow.this.fShell, null, e.x, e.y);
                    ScreenCaptureWindow.this.fShell.setLocation(p.x - this.fOrigin.x, p.y - this.fOrigin.y);
                }
            }
        }
    }

    class WindowSizer
    implements Listener {
        int fAnchorX;
        int fAnchorY;
        Rectangle fShellBounds;
        Point fMinSize;

        WindowSizer() {
        }

        private int getTrackerStyle(int direction) {
            switch (direction) {
                case 0: {
                    return 144;
                }
                case 1: {
                    return 131088;
                }
                case 2: {
                    return 1040;
                }
                case 3: {
                    return 16400;
                }
                case 4: {
                    return 16528;
                }
                case 5: {
                    return 131216;
                }
                case 6: {
                    return 132112;
                }
                case 7: {
                    return 17424;
                }
            }
            return 16;
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 3: {
                    ScreenCaptureWindow.this.fLastDirection = ((ResizeHandle)e.widget).getDirection();
                    if (fgIsMac || fgIsLinux) {
                        Rectangle bounds;
                        if (!(e.widget instanceof Control) || (bounds = ScreenCaptureWindow.track((Control)ScreenCaptureWindow.this.fShell, this.getTrackerStyle(ScreenCaptureWindow.this.fLastDirection))) == null) break;
                        ScreenCaptureWindow.this.resize(bounds);
                        break;
                    }
                    Point p = ((Control)e.widget).toDisplay(e.x, e.y);
                    this.fAnchorX = p.x;
                    this.fAnchorY = p.y;
                    this.fShellBounds = ScreenCaptureWindow.this.fShell.getBounds();
                    this.fMinSize = ScreenCaptureWindow.this.fShell.getMinimumSize();
                    if (!(e.widget instanceof Control)) break;
                    ((Control)e.widget).addListener(5, (Listener)this);
                    break;
                }
                case 4: {
                    if (e.widget instanceof Control) {
                        ((Control)e.widget).removeListener(5, (Listener)this);
                    }
                    ScreenCaptureWindow.this.fParentShell.setFocus();
                    break;
                }
                case 5: {
                    if (!(e.widget instanceof Control)) break;
                    Point p = ((Control)e.widget).toDisplay(e.x, e.y);
                    int wDif = p.x - this.fAnchorX;
                    int hDif = p.y - this.fAnchorY;
                    Rectangle newBounds = new Rectangle(this.fShellBounds.x, this.fShellBounds.y, this.fShellBounds.width, this.fShellBounds.height);
                    switch (ScreenCaptureWindow.this.fLastDirection) {
                        case 0: {
                            newBounds.y += hDif;
                            newBounds.height -= hDif;
                            break;
                        }
                        case 1: {
                            newBounds.width += wDif;
                            break;
                        }
                        case 2: {
                            newBounds.height += hDif;
                            break;
                        }
                        case 3: {
                            newBounds.x += wDif;
                            newBounds.width -= wDif;
                            break;
                        }
                        case 4: {
                            newBounds.x += wDif;
                            newBounds.y += hDif;
                            newBounds.width -= wDif;
                            newBounds.height -= hDif;
                            break;
                        }
                        case 5: {
                            newBounds.y += hDif;
                            newBounds.width += wDif;
                            newBounds.height -= hDif;
                            break;
                        }
                        case 6: {
                            newBounds.width += wDif;
                            newBounds.height += hDif;
                            break;
                        }
                        case 7: {
                            newBounds.x += wDif;
                            newBounds.width -= wDif;
                            newBounds.height += hDif;
                        }
                    }
                    if (newBounds.width < this.fMinSize.x) {
                        newBounds.width = this.fMinSize.x;
                    }
                    if (newBounds.height < this.fMinSize.y) {
                        newBounds.height = this.fMinSize.y;
                    }
                    ScreenCaptureWindow.this.fShell.setBounds(newBounds);
                }
            }
        }
    }
}

