/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.capture;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.capture.Messages;
import com.ibm.team.workitem.ide.ui.internal.capture.ScreenCaptureWindow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ScreenCapture {
    private static final String MEMENTO_ROOT = "screencapture";
    private static final String PREF_ID = "com.ibm.team.workitem.ide.ui.internal.capture.ScreenCapture";
    private static final String PREF_FORMAT = "FORMAT";
    private static final int GAP_TO_CAPTURE_WINDOW = 15;
    private static final String JPG = "JPG";
    private static final String BMP = "BMP";
    private static final String PNG = "PNG";
    private static boolean fgIsMac = "carbon".equals(SWT.getPlatform());
    private static boolean fgIsLinux = "gtk".equals(SWT.getPlatform());
    private static boolean fgHasPNGSupport = SWT.getVersion() > 3303;
    private ScreenCaptureWindow fCaptureWindow;
    private Shell fShell;
    private LocalResourceManager fResources;
    private Button fSave;
    private Button fReset;
    private Button fCapture;
    private ToolBarManager fToolBarManager;
    private ToolItem fDrawCircle;
    private ToolItem fDrawRectangle;
    private ToolItem fDrawPen;
    private ToolItem fColorButton;
    private Rectangle fMonitorBounds;
    private Rectangle fShellBounds;
    protected boolean fShellDetached;
    protected boolean fBlockMoveEvent;
    private int fTimerAmount = 0;
    private Spinner fTimerSpinner;
    private String fFormat = fgHasPNGSupport ? "PNG" : "JPG";
    private Menu fColorMenu;

    protected final Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createDrawBar(container);
        Label sep = new Label(container, 258);
        sep.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createButtons(container);
        sep = new Label(container, 258);
        sep.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createToolBar(container);
        this.updateButtons(false);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected void updateButtons(boolean imageCaptured) {
        this.fSave.setEnabled(imageCaptured);
        this.fReset.setEnabled(imageCaptured);
        this.fCapture.setEnabled(!imageCaptured);
        this.fTimerSpinner.setEnabled(!imageCaptured);
        if (this.fToolBarManager != null) {
            IContributionItem[] items = this.fToolBarManager.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (item instanceof ActionContributionItem) {
                    ActionContributionItem ai = (ActionContributionItem)item;
                    IAction action = ai.getAction();
                    action.setEnabled(imageCaptured);
                }
                ++i;
            }
        }
        this.fShell.setDefaultButton(imageCaptured ? this.fSave : this.fCapture);
        if (imageCaptured) {
            this.fSave.setFocus();
        } else {
            this.fCapture.setFocus();
        }
    }

    protected ToolBar createDrawBar(Composite parent) {
        ToolBar bar = new ToolBar(parent, 0x800000);
        bar.setLayoutData((Object)new GridData(0x1000000, 1, true, false));
        this.fDrawPen = new ToolItem(bar, 0x800010);
        this.fDrawPen.setToolTipText(Messages.ScreenCapture_PENCIL);
        this.fDrawPen.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/elcl16/pen.gif")));
        this.fDrawPen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.fCaptureWindow.setDrawingStyle(0);
            }
        });
        this.fDrawCircle = new ToolItem(bar, 0x800010);
        this.fDrawCircle.setToolTipText(Messages.ScreenCapture_ELLIPSE);
        this.fDrawCircle.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/elcl16/oval.gif")));
        this.fDrawCircle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.fCaptureWindow.setDrawingStyle(1);
            }
        });
        this.fDrawRectangle = new ToolItem(bar, 0x800010);
        this.fDrawRectangle.setToolTipText(Messages.ScreenCapture_RECTANGLE);
        this.fDrawRectangle.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/elcl16/rnd-rectngl.gif")));
        this.fDrawRectangle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.fCaptureWindow.setDrawingStyle(2);
            }
        });
        switch (this.fCaptureWindow.getDrawingStyle()) {
            case 0: {
                this.fDrawPen.setSelection(true);
                break;
            }
            case 1: {
                this.fDrawCircle.setSelection(true);
                break;
            }
            case 2: {
                this.fDrawRectangle.setSelection(true);
            }
        }
        new ToolItem(bar, 2);
        this.fColorButton = new ToolItem(bar, 4);
        this.fColorButton.setToolTipText(Messages.ScreenCapture_COLOR);
        this.fColorButton.setImage(this.createColorImage(this.fCaptureWindow.getDrawingColor()));
        this.fColorButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ScreenCapture.this.fColorButton.getImage() != null) {
                    ScreenCapture.this.fColorButton.getImage().dispose();
                }
                ScreenCapture.this.fColorMenu.dispose();
            }
        });
        this.fColorMenu = new Menu((Control)bar);
        int[] colors = new int[]{9, 10, 3, 11, 12, 5, 6, 7, 8, 15, 16, 2};
        String[] names = new String[]{Messages.ScreenCapture_BLUE, Messages.ScreenCapture_DARK_BLUE, Messages.ScreenCapture_RED, Messages.ScreenCapture_MAGENTA, Messages.ScreenCapture_DARK_MAGENTA, Messages.ScreenCapture_GREEN, Messages.ScreenCapture_DARK_GREEN, Messages.ScreenCapture_YELLOW, Messages.ScreenCapture_DARK_YELLOW, Messages.ScreenCapture_GRAY, Messages.ScreenCapture_DARK_GRAY, Messages.ScreenCapture_BLACK};
        int i = 0;
        while (i < colors.length) {
            final int j = colors[i];
            final MenuItem menuItem = new MenuItem(this.fColorMenu, 8);
            menuItem.setImage(this.createColorImage(j));
            menuItem.setText(names[i]);
            menuItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (menuItem.getImage() != null) {
                        menuItem.getImage().dispose();
                    }
                }
            });
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Image oldImage = ScreenCapture.this.fColorButton.getImage();
                    ScreenCapture.this.fColorButton.setImage(ScreenCapture.this.createColorImage(j));
                    if (oldImage != null) {
                        oldImage.dispose();
                    }
                    ScreenCapture.this.fCaptureWindow.setDrawingColor(j);
                }
            });
            ++i;
        }
        this.fColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = ScreenCapture.this.fColorButton.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = ScreenCapture.this.fShell.toDisplay(pt);
                ScreenCapture.this.fColorMenu.setLocation(pt.x, pt.y);
                ScreenCapture.this.fColorMenu.setVisible(true);
            }
        });
        return bar;
    }

    private Image createColorImage(int colorValue) {
        Color borderColor = this.getShell().getDisplay().getSystemColor(16);
        Color color = this.getShell().getDisplay().getSystemColor(colorValue);
        RGB unused = new RGB(1, 1, 1);
        ImageData data = new ImageData(16, 16, 2, new PaletteData(new RGB[]{color.getRGB(), borderColor.getRGB(), unused, unused}));
        data.transparentPixel = 3;
        Arrays.fill(data.data, (byte)-1);
        Image image = new Image((Device)this.getShell().getDisplay(), data);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.setForeground(borderColor);
        gc.fillRectangle(3, 3, 10, 10);
        gc.drawRectangle(3, 3, 10, 10);
        gc.dispose();
        return image;
    }

    protected void createButtons(Composite parent) {
        Composite captureContainer = new Composite(parent, 0);
        captureContainer.setLayout((Layout)new GridLayout(4, false));
        captureContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fCapture = new Button(captureContainer, 8);
        this.fCapture.setToolTipText(Messages.ScreenCapture_CAPTURE);
        this.fCapture.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fCapture.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)WorkItemIDEUIPlugin.getImageDescriptor("icons/elcl16/capture_small.gif")));
        this.fCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScreenCapture.this.fTimerAmount > 0) {
                    ScreenCapture.this.timedCapture();
                } else {
                    ScreenCapture.this.capture();
                }
            }
        });
        Label inLabel = new Label(captureContainer, 0);
        inLabel.setText(Messages.ScreenCapture_IN_TEMPORAL);
        this.fTimerSpinner = new Spinner(captureContainer, 2048);
        this.fTimerSpinner.setMinimum(0);
        this.fTimerSpinner.setSelection(this.fTimerAmount);
        this.fTimerSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.fTimerAmount = ScreenCapture.this.fTimerSpinner.getSelection();
            }
        });
        Label spinnerLabel = new Label(captureContainer, 0);
        spinnerLabel.setText(Messages.ScreenCapture_SECONDS_ABBREVIATED);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite buttonsContainer = new Composite(parent, 0);
        buttonsContainer.setLayout((Layout)new GridLayout(2, true));
        buttonsContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fReset = new Button(buttonsContainer, 8);
        this.fReset.setText(Messages.ScreenCapture_RESET);
        this.fReset.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.doReset();
            }
        });
        this.fSave = new Button(buttonsContainer, 8);
        this.fSave.setText(Messages.ScreenCapture_SAVE);
        this.fSave.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.doSave();
            }
        });
        GridLayout formatLayout = new GridLayout(2, false);
        formatLayout.marginHeight = 0;
        formatLayout.marginWidth = 2;
        Composite formatContainer = new Composite(buttonsContainer, 0);
        formatContainer.setLayout((Layout)formatLayout);
        formatContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)formatContainer.getLayoutData()).horizontalSpan = 2;
        Label formatLabel = new Label(formatContainer, 0);
        formatLabel.setText(Messages.ScreenCapture_FORMAT);
        formatLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        final Combo formatCombo = new Combo(formatContainer, 8);
        formatCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        formatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCapture.this.fFormat = formatCombo.getItem(formatCombo.getSelectionIndex());
            }
        });
        formatCombo.add(JPG);
        formatCombo.add(BMP);
        if (fgHasPNGSupport) {
            formatCombo.add(PNG);
        }
        if (JPG.equals(this.fFormat)) {
            formatCombo.select(0);
        } else if (BMP.equals(this.fFormat)) {
            formatCombo.select(1);
        } else if (PNG.equals(this.fFormat) && fgHasPNGSupport) {
            formatCombo.select(2);
        }
    }

    protected void createToolBar(Composite container) {
        ToolBarManager manager = new ToolBarManager(0x820200);
        String label = this.createActions(manager, (ResourceManager)this.fResources);
        if (manager.getItems().length > 0) {
            Composite contribContainer = new Composite(container, 0);
            contribContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            contribContainer.setLayout((Layout)new GridLayout(1, false));
            Label toolBarLabel = new Label(contribContainer, 0);
            toolBarLabel.setText(label);
            manager.createControl(contribContainer);
            manager.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.fToolBarManager = manager;
        }
    }

    public String createActions(ToolBarManager toolBarManager, ResourceManager resourceManager) {
        return "";
    }

    private void doReset() {
        this.fCaptureWindow.reset();
        this.updateButtons(false);
    }

    private void capture() {
        this.fShell.setVisible(false);
        this.fCaptureWindow.capture();
        this.fShell.setVisible(true);
        this.updateButtons(true);
    }

    private void timedCapture() {
        this.fCapture.setEnabled(false);
        this.fTimerSpinner.setEnabled(false);
        int i = this.fTimerAmount;
        while (i > 0) {
            final int counter = i--;
            FoundationUIJob job = new FoundationUIJob(""){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    if (ScreenCapture.this.fCapture.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    if (counter == ScreenCapture.this.fTimerAmount) {
                        ScreenCapture.this.fTimerSpinner.setSelection(ScreenCapture.this.fTimerAmount);
                        ScreenCapture.this.capture();
                    } else {
                        ScreenCapture.this.fTimerSpinner.setSelection(ScreenCapture.this.fTimerAmount - counter);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule((long)(counter * 1000));
        }
    }

    private void doSave() {
        block11: {
            if (fgIsLinux && !this.fCaptureWindow.getShell().isDisposed()) {
                this.fCaptureWindow.getShell().setVisible(false);
            }
            try {
                boolean doSave;
                File f;
                block12: {
                    FileDialog dialog = new FileDialog(this.fShell, 8192);
                    dialog.setFileName("capture." + this.fFormat.toLowerCase());
                    dialog.setFilterExtensions(new String[]{"*." + this.fFormat.toLowerCase()});
                    String file = dialog.open();
                    if (file == null) break block11;
                    try {
                        f = new File(file);
                        doSave = true;
                        if (!f.exists() || fgIsMac) break block12;
                        MessageBox box = new MessageBox(this.fShell, 452);
                        box.setText(Messages.ScreenCapture_CONFIRM_REPLACE);
                        box.setMessage(Messages.ScreenCapture_OVERWRITE_FILE);
                        int status = box.open();
                        if (status != 64) {
                            doSave = false;
                        }
                        if (status != 128) break block12;
                        this.doSave();
                        return;
                    }
                    catch (IOException iOException) {}
                }
                if (doSave) {
                    this.saveCaptureToFile(f);
                    this.doReset();
                }
            }
            finally {
                if (fgIsLinux && !this.fCaptureWindow.getShell().isDisposed()) {
                    this.fCaptureWindow.getShell().setVisible(true);
                }
            }
        }
    }

    private void saveCaptureToFile(File file) throws IOException {
        String name = file.getName().toLowerCase();
        int type = 4;
        if (name.endsWith(".bmp")) {
            type = 0;
        } else if (name.endsWith(".jpg")) {
            type = 4;
        } else if (name.endsWith(".png")) {
            type = 5;
        }
        if (!fgHasPNGSupport && type == 5) {
            type = 4;
        }
        Image capturedImage = this.fCaptureWindow.getCapturedImageCropped();
        try {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{capturedImage.getImageData()};
            FileOutputStream os = new FileOutputStream(file);
            try {
                loader.save((OutputStream)os, type);
            }
            finally {
                os.close();
            }
        }
        finally {
            capturedImage.dispose();
        }
    }

    public File saveToTemp() throws IOException {
        File file = File.createTempFile("capture", "." + this.fFormat.toLowerCase());
        file.deleteOnExit();
        this.saveCaptureToFile(file);
        return file;
    }

    protected void open() {
        this.create();
        this.fShell.open();
        this.updateShellLocation();
    }

    protected final void create() {
        this.fShell = this.createShell();
        this.fMonitorBounds = this.fShell.getMonitor().getClientArea();
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fShell);
        this.fCaptureWindow = new ScreenCaptureWindow(this.fShell){

            protected void recreateHook() {
                ScreenCapture.this.hookCaptureWindowListener();
                ScreenCapture.this.updateShellLocation();
                ScreenCapture.this.updateDimensionLabel();
            }
        };
        IMemento settings = this.loadSettings();
        if (settings != null) {
            this.fFormat = settings.getString(PREF_FORMAT);
        }
        if (this.fFormat == null) {
            String string = this.fFormat = fgHasPNGSupport ? PNG : JPG;
        }
        if (!fgHasPNGSupport && PNG.equals(this.fFormat)) {
            this.fFormat = JPG;
        }
        this.fCaptureWindow.initialize(settings);
        this.createContents((Composite)this.fShell);
        this.fCaptureWindow.open();
        this.initializeBounds();
        this.fShellBounds = this.fShell.getBounds();
        this.updateDimensionLabel();
        this.hookCaptureWindowListener();
        this.fShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (!ScreenCapture.this.fBlockMoveEvent) {
                    ScreenCapture.this.fShellDetached = true;
                }
            }
        });
    }

    private void hookCaptureWindowListener() {
        this.fCaptureWindow.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                ScreenCapture.this.updateShellLocation();
            }

            public void controlResized(ControlEvent e) {
                ScreenCapture.this.updateShellLocation();
                ScreenCapture.this.updateDimensionLabel();
            }
        });
    }

    private void updateShellLocation() {
        if (!this.fShellDetached) {
            this.fBlockMoveEvent = true;
            Rectangle capBounds = this.fCaptureWindow.getShell().getBounds();
            this.moveShell(capBounds);
            this.fBlockMoveEvent = false;
        }
    }

    public Shell getShell() {
        return this.fShell;
    }

    Shell getCaptureWindowShell() {
        return this.fCaptureWindow.getShell();
    }

    private void moveShell(Rectangle capBounds) {
        boolean placeLeft = false;
        if (capBounds.x + capBounds.width + this.fShellBounds.width >= this.fMonitorBounds.width) {
            placeLeft = true;
        } else {
            boolean bl = placeLeft = this.fShell.getLocation().x < capBounds.x && this.fShell.getLocation().x > this.fMonitorBounds.x;
        }
        if (placeLeft) {
            this.fShell.setLocation(capBounds.x - this.fShellBounds.width - 15, capBounds.y);
        } else {
            this.fShell.setLocation(capBounds.x + capBounds.width + 15, capBounds.y);
        }
    }

    void updateDimensionLabel() {
        Point captureSize = this.fCaptureWindow.getCapturedSize();
        this.fShell.setText(NLS.bind((String)Messages.ScreenCapture_PX_X_PX, (Object)captureSize.x, (Object[])new Object[]{captureSize.y}));
    }

    protected void initializeBounds() {
        Point size = this.getInitialSize();
        this.fShell.setSize(size);
        Rectangle capBounds = this.fCaptureWindow.getShell().getBounds();
        this.fShell.setLocation(capBounds.x + capBounds.width + 15, capBounds.y);
    }

    protected Point getInitialSize() {
        return this.fShell.computeSize(-1, -1, true);
    }

    protected Shell createShell() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Shell shell = new Shell(Display.getDefault(), this.getShellStyle());
        shell.setLayout((Layout)layout);
        shell.setText(Messages.ScreenCapture_CAPTURE);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScreenCapture.this.dispose();
            }
        });
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    ScreenCapture.this.close();
                }
            }
        });
        return shell;
    }

    protected void close() {
        this.dispose();
        this.fShell.close();
    }

    protected void dispose() {
        this.saveSettings();
        this.fCaptureWindow.dispose();
    }

    protected int getShellStyle() {
        if (fgIsLinux) {
            return 100;
        }
        return 16484;
    }

    private IMemento loadSettings() {
        Preferences preference = WorkItemIDEUIPlugin.getDefault().getPluginPreferences();
        String mementoAsString = preference.getString(PREF_ID);
        if (mementoAsString != null && mementoAsString.length() > 0) {
            try {
                return XMLMemento.createReadRoot((Reader)new StringReader(mementoAsString));
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private void saveSettings() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_ROOT);
        this.saveSettings((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            String prefIdentifier = PREF_ID;
            Preferences preference = WorkItemIDEUIPlugin.getDefault().getPluginPreferences();
            preference.setValue(prefIdentifier, writer.getBuffer().toString());
            WorkItemIDEUIPlugin.getDefault().savePluginPreferences();
        }
        catch (IOException iOException) {}
    }

    private void saveSettings(IMemento memento) {
        memento.putString(PREF_FORMAT, this.fFormat);
        this.fCaptureWindow.saveSettings(memento);
    }
}

