/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowManager {
    private static final String WORKFLOW = "workflow";
    private static final String WORKFLOWDEFINITION = "workflowDefinition";
    private static final String NAME = "name";
    public static final String ID = "id";
    private static final String ICON = "icon";
    private static final String DESCRIPTION = "description";
    private static final String GROUP = "group";
    private static final String SHOWRESOLUTION = "showResolution";
    private static final String RESOLUTION = "resolution";
    private static final String STATE = "state";
    private static final String ACTION = "action";
    private static final String START_ACTION = "startActionId";
    private static final String RESOLVE_ACTION = "resolveActionId";
    private static final String REOPEN_ACTION = "reopenActionId";

    public static List<WFWorkflow> readWorkflows(ModelElement element) {
        ArrayList<WFWorkflow> workflows = new ArrayList<WFWorkflow>();
        if (element != null) {
            for (ModelElement definition : element.getChildElements()) {
                workflows.add(WorkflowManager.readWorkflow(definition));
            }
        }
        return workflows;
    }

    private static WFWorkflow readWorkflow(ModelElement element) {
        String id = element.getAttribute(ID);
        ModelElement flow = (ModelElement)element.getChildElements().get(0);
        WFWorkflow workflow = new WFWorkflow(flow.getAttribute(NAME), id, flow.getAttribute(DESCRIPTION));
        WorkflowManager.readWorkflow(flow, workflow);
        return workflow;
    }

    private static void readWorkflow(ModelElement element, WFWorkflow flow) {
        Map<String, WFWorkflow.WFResolution> resolutions = WorkflowManager.readResolutions(flow, element);
        Map<String, TempWFAction> actions = WorkflowManager.readActions(flow, element);
        Map<String, TempWFState> states = WorkflowManager.readStates(flow, element);
        for (TempWFState state : states.values()) {
            for (String actionId : state.getTempActions()) {
                WFWorkflow.WFAction action = actions.get(actionId);
                if (action == null) continue;
                state.addAction(action);
            }
        }
        for (TempWFAction action : actions.values()) {
            for (String resId : action.getTempResolutions()) {
                WFWorkflow.WFResolution res = resolutions.get(resId);
                if (res == null) continue;
                action.addResolution(res);
            }
            action.setTargetState(states.get(action.getTempTargetState()));
        }
        flow.setActions(actions.values());
        flow.setStates(states.values());
        flow.setResolutions(resolutions.values());
        String startId = element.getAttribute(START_ACTION);
        String resolveId = element.getAttribute(RESOLVE_ACTION);
        String reopenId = element.getAttribute(REOPEN_ACTION);
        if (resolveId != null) {
            flow.setResolveAction(actions.get(resolveId));
        }
        if (startId != null) {
            flow.setStartAction(actions.get(startId));
        }
        if (reopenId != null) {
            flow.setReopenAction(actions.get(reopenId));
        }
    }

    private static Map<String, WFWorkflow.WFResolution> readResolutions(WFWorkflow flow, ModelElement element) {
        HashMap<String, WFWorkflow.WFResolution> wfResolutions = new HashMap<String, WFWorkflow.WFResolution>();
        for (ModelElement res : element.getChildElements()) {
            if (!res.getName().equals(RESOLUTION)) continue;
            String id = res.getAttribute(ID);
            String name = res.getAttribute(NAME);
            String description = res.getAttribute(DESCRIPTION);
            String icon = res.getAttribute(ICON);
            wfResolutions.put(id, new WFWorkflow.WFResolution(flow, id, name, description, icon));
        }
        return wfResolutions;
    }

    private static Map<String, TempWFAction> readActions(WFWorkflow flow, ModelElement element) {
        HashMap<String, TempWFAction> wfActions = new HashMap<String, TempWFAction>();
        for (ModelElement act : element.getChildElements()) {
            if (!act.getName().equals(ACTION)) continue;
            String id = act.getAttribute(ID);
            String name = act.getAttribute(NAME);
            String description = act.getAttribute(DESCRIPTION);
            String icon = act.getAttribute(ICON);
            String endState = act.getAttribute(STATE);
            TempWFAction action = new TempWFAction(flow, id, name, description, icon, endState);
            for (ModelElement res : act.getChildElements()) {
                if (!res.getName().equals(RESOLUTION)) continue;
                action.addTempResolution(res.getAttribute(ID));
            }
            wfActions.put(id, action);
        }
        return wfActions;
    }

    private static Map<String, TempWFState> readStates(WFWorkflow flow, ModelElement element) {
        HashMap<String, TempWFState> wfStates = new HashMap<String, TempWFState>();
        for (ModelElement sta : element.getChildElements()) {
            if (!sta.getName().equals(STATE)) continue;
            String id = sta.getAttribute(ID);
            String name = sta.getAttribute(NAME);
            String description = sta.getAttribute(DESCRIPTION);
            String icon = sta.getAttribute(ICON);
            String group = sta.getAttribute(GROUP);
            String showResolution = sta.getAttribute(SHOWRESOLUTION);
            boolean showRes = false;
            if (showResolution != null) {
                showRes = Boolean.parseBoolean(showResolution);
            }
            TempWFState state = new TempWFState(flow, id, name, description, icon, group, showRes);
            for (ModelElement act : sta.getChildElements()) {
                if (!act.getName().equals(ACTION)) continue;
                state.addTempAction(act.getAttribute(ID));
            }
            wfStates.put(id, state);
        }
        return wfStates;
    }

    public static void writeWorkflows(IMemento memento, List<WFWorkflow> workflows) {
        for (WFWorkflow w : workflows) {
            WorkflowManager.writeWorkflow(memento.createChild(WORKFLOWDEFINITION), w);
        }
    }

    private static void writeWorkflow(IMemento definition, WFWorkflow workflow) {
        definition.putString(ID, workflow.getId());
        IMemento flow = definition.createChild(WORKFLOW);
        flow.putString(NAME, workflow.getName());
        if (workflow.getDescription() != null && !workflow.getDescription().trim().equals("")) {
            flow.putString(DESCRIPTION, workflow.getDescription());
        }
        if (workflow.getStartAction() != null) {
            flow.putString(START_ACTION, workflow.getStartAction().getId());
        }
        if (workflow.getResolveAction() != null) {
            flow.putString(RESOLVE_ACTION, workflow.getResolveAction().getId());
        }
        if (workflow.getReopenAction() != null) {
            flow.putString(REOPEN_ACTION, workflow.getReopenAction().getId());
        }
        for (WFWorkflow.WFResolution resolution : workflow.getResolutions()) {
            IMemento res = flow.createChild(RESOLUTION);
            res.putString(NAME, resolution.getName());
            res.putString(ID, resolution.getId());
            res.putString(DESCRIPTION, resolution.getDescription());
            res.putString(ICON, resolution.getIcon());
        }
        for (WFWorkflow.WFAction action : workflow.getActions()) {
            IMemento act = flow.createChild(ACTION);
            act.putString(NAME, action.getName());
            act.putString(ID, action.getId());
            act.putString(DESCRIPTION, action.getDescription());
            act.putString(ICON, action.getIcon());
            if (action.getTargetState() != null) {
                act.putString(STATE, action.getTargetState().getId());
            }
            for (WFWorkflow.WFResolution res : action.getResolutions()) {
                IMemento r = act.createChild(RESOLUTION);
                r.putString(ID, res.getId());
            }
        }
        for (WFWorkflow.WFState state : workflow.getStates()) {
            IMemento sta = flow.createChild(STATE);
            sta.putString(NAME, state.getName());
            sta.putString(ID, state.getId());
            sta.putString(DESCRIPTION, state.getDescription());
            sta.putString(ICON, state.getIcon());
            sta.putString(GROUP, state.getGroup());
            sta.putBoolean(SHOWRESOLUTION, state.getShowResolution());
            for (WFWorkflow.WFAction act : state.getActions()) {
                IMemento a = sta.createChild(ACTION);
                a.putString(ID, act.getId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TempWFAction
    extends WFWorkflow.WFAction {
        private List<String> fTempResolutions = new ArrayList<String>();
        private String fTempTargetState;

        public TempWFAction(WFWorkflow workflow, String id, String name, String description, String icon, String targetState) {
            super(workflow, id, name, description, icon);
            this.fTempTargetState = targetState;
        }

        public void addTempResolution(String res) {
            this.fTempResolutions.add(res);
        }

        public List<String> getTempResolutions() {
            return this.fTempResolutions;
        }

        public String getTempTargetState() {
            return this.fTempTargetState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TempWFState
    extends WFWorkflow.WFState {
        private List<String> fTempActions = new ArrayList<String>();

        public TempWFState(WFWorkflow workflow, String id, String name, String description, String icon, String group, boolean showResolution) {
            super(workflow, id, name, description, icon, group, showResolution);
        }

        public void addTempAction(String act) {
            this.fTempActions.add(act);
        }

        public List<String> getTempActions() {
            return this.fTempActions;
        }
    }
}

