/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.ActionsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.TransitionsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WorkflowEditorPart
extends TeamFormPart {
    private WFWorkflow fWorkflow;
    private Text fName;
    private Text fDescription;
    private DecoratedCombo fStartCombo;
    private DecoratedCombo fReopenCombo;
    private DecoratedCombo fResolveCombo;
    private IDirtyStateTracker fTracker;
    private IPrefixProvider fPrefixProvider;
    private static final String ACTION_NONE = Messages.WorkflowEditorPart_NONE;
    private WFWorkflow.WFChangeListener fWFChangedListener = new WFWorkflow.WFChangeListener(){

        public void wfChanged(final WFWorkflow.WFChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (WorkflowEditorPart.this.fStartCombo == null || WorkflowEditorPart.this.fStartCombo.getCombo().isDisposed()) {
                        return;
                    }
                    if (event.affects("actions") && event.getData() instanceof WFWorkflow.WFAction) {
                        WorkflowEditorPart.this.updateDetails();
                    } else if (event.affects("workflow") && (event.getData() instanceof WFWorkflow.WFState || event.getData() instanceof WFWorkflow.WFAction)) {
                        WorkflowEditorPart.this.updateDetails();
                    } else if (event.affects("defaultactions")) {
                        WorkflowEditorPart.this.updateDetails();
                    }
                }
            });
        }
    };
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private WorkflowAspectEditor fNameUpdateable;
    private boolean fNameModified;

    WorkflowEditorPart(IPrefixProvider prefixProvider, IDirtyStateTracker tracker, WorkflowAspectEditor nameUpdateable) {
        this.fTracker = tracker;
        this.fPrefixProvider = prefixProvider;
        this.fNameUpdateable = nameUpdateable;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite info = toolkit.createComposite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        info.setLayout((Layout)gl);
        info.setLayoutData((Object)new GridData(4, 4, true, false));
        Label namelabel = toolkit.createLabel(info, Messages.WorkflowEditorPart_NAME, 0);
        namelabel.setLayoutData((Object)new GridData());
        this.fName = toolkit.createText(info, null, 2052);
        this.fName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WorkflowEditorPart.this.fWorkflow == null || WorkflowEditorPart.this.fWorkflow.getName() == null && WorkflowEditorPart.this.fName.getText().equals("")) {
                    return;
                }
                if (!WorkflowEditorPart.this.fName.getText().equals(WorkflowEditorPart.this.fWorkflow.getName())) {
                    WorkflowEditorPart.this.fWorkflow.setName(WorkflowEditorPart.this.fName.getText());
                    WorkflowEditorPart.this.fNameModified = true;
                    WorkflowEditorPart.this.setDirty();
                }
            }
        });
        this.fName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (WorkflowEditorPart.this.fNameModified) {
                    WorkflowEditorPart.this.fNameUpdateable.updateLabels();
                    WorkflowEditorPart.this.fNameModified = false;
                }
            }
        });
        Label l = toolkit.createLabel(info, Messages.WorkflowEditorPart_DESCRIPTION, 0);
        l.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fDescription = toolkit.createText(info, null, 2626);
        GridData data = new GridData(4, 4, true, false);
        GC gc = new GC((Drawable)this.fDescription);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)3);
        gc.dispose();
        this.fDescription.setLayoutData((Object)data);
        this.fDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WorkflowEditorPart.this.fWorkflow == null || WorkflowEditorPart.this.fWorkflow.getDescription() == null && WorkflowEditorPart.this.fDescription.getText().equals("")) {
                    return;
                }
                if (!WorkflowEditorPart.this.fDescription.getText().equals(WorkflowEditorPart.this.fWorkflow.getDescription())) {
                    WorkflowEditorPart.this.fWorkflow.setDescription(WorkflowEditorPart.this.fDescription.getText());
                    WorkflowEditorPart.this.setDirty();
                }
            }
        });
        this.fDescription.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (WorkflowEditorPart.this.fWorkflow != null) {
                    WorkflowEditorPart.this.fWorkflow.setDescription(WorkflowEditorPart.this.fDescription.getText());
                }
            }
        });
        Composite defaultActions = toolkit.createComposite(parent, 0);
        defaultActions.setLayoutData((Object)new GridData(4, 4, true, false));
        gl = new GridLayout(8, false);
        gl.marginWidth = 0;
        defaultActions.setLayout((Layout)gl);
        Label lab = toolkit.createLabel(defaultActions, Messages.WorkflowEditorPart_START_ACTION, 0);
        lab.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fStartCombo = new DecoratedCombo(defaultActions, 8, 1);
        toolkit.adapt(this.fStartCombo.getImageControl(), false, false);
        toolkit.adapt((Control)this.fStartCombo.getCombo(), true, true);
        this.fStartCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof WFWorkflow.WFAction) {
                    return WorkflowEditorPart.this.getUnambiguousName((WFWorkflow.WFAction)element);
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof WFWorkflow.WFAction && ((WFWorkflow.WFAction)element).getIcon() != null) {
                    return AspectEditorUtil.getImage(WorkflowEditorPart.this.fPrefixProvider.getProcessContainer(), ((WFWorkflow.WFAction)element).getIcon(), WorkflowEditorPart.this.fResourceManager, new Runnable(){

                        public void run() {
                            if (WorkflowEditorPart.this.fStartCombo != null && !WorkflowEditorPart.this.fStartCombo.getLayoutControl().isDisposed()) {
                                WorkflowEditorPart.this.fStartCombo.setValue(WorkflowEditorPart.this.fStartCombo.getValue());
                            }
                        }
                    });
                }
                return null;
            }
        });
        this.fStartCombo.getLayoutControl().setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fStartCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (WorkflowEditorPart.this.fWorkflow == null) {
                    return;
                }
                Object value = WorkflowEditorPart.this.fStartCombo.getValue();
                if (ACTION_NONE.equals(value)) {
                    if (WorkflowEditorPart.this.fWorkflow.getStartAction() == null) {
                        return;
                    }
                    WorkflowEditorPart.this.fWorkflow.setStartAction(null);
                    WorkflowEditorPart.this.setDirty();
                } else if (TransitionsPart.NEW_ACTION.equals(value)) {
                    ActionsPart.AddEditActionDialog d = new ActionsPart.AddEditActionDialog(Display.getCurrent().getActiveShell(), Messages.WorkflowEditorPart_ADD_ACTION, WorkflowEditorPart.this.fWorkflow.getStates(), WorkflowEditorPart.this.fPrefixProvider, WorkflowEditorPart.this.fResourceManager);
                    if (d.open() == 0) {
                        String name = d.getName();
                        String description = d.getDescription();
                        String iconUrl = d.getIconUrl();
                        WFWorkflow.WFAction act = new WFWorkflow.WFAction(WorkflowEditorPart.this.fWorkflow, WorkflowEditorPart.this.fWorkflow.generateActionId(), name, description, iconUrl);
                        WFWorkflow.WFState target = d.getTargetState();
                        act.setTargetState(target);
                        WorkflowEditorPart.this.fWorkflow.addAction(act);
                        WorkflowEditorPart.this.fWorkflow.setStartAction(act);
                        WorkflowEditorPart.this.setDirty();
                    } else {
                        WorkflowEditorPart.this.updateDetails();
                    }
                } else if (!value.equals(WorkflowEditorPart.this.fWorkflow.getStartAction())) {
                    if (value instanceof WFWorkflow.WFAction) {
                        WorkflowEditorPart.this.fWorkflow.setStartAction((WFWorkflow.WFAction)value);
                        WorkflowEditorPart.this.setDirty();
                    } else {
                        WorkflowEditorPart.this.updateDetails();
                    }
                }
            }
        });
        Label fill = toolkit.createLabel(defaultActions, null, 0);
        GridData fillData = new GridData(20, 0);
        fill.setLayoutData((Object)fillData);
        lab = toolkit.createLabel(defaultActions, Messages.WorkflowEditorPart_RESOLVE_ACTION, 0);
        lab.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fResolveCombo = new DecoratedCombo(defaultActions, 8, 1);
        toolkit.adapt(this.fResolveCombo.getImageControl(), false, false);
        toolkit.adapt((Control)this.fResolveCombo.getCombo(), true, true);
        this.fResolveCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof WFWorkflow.WFAction) {
                    return WorkflowEditorPart.this.getUnambiguousName((WFWorkflow.WFAction)element);
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof WFWorkflow.WFAction && ((WFWorkflow.WFAction)element).getIcon() != null) {
                    return AspectEditorUtil.getImage(WorkflowEditorPart.this.fPrefixProvider.getProcessContainer(), ((WFWorkflow.WFAction)element).getIcon(), WorkflowEditorPart.this.fResourceManager, new Runnable(){

                        public void run() {
                            if (WorkflowEditorPart.this.fResolveCombo != null && !WorkflowEditorPart.this.fResolveCombo.getLayoutControl().isDisposed()) {
                                WorkflowEditorPart.this.fResolveCombo.setValue(WorkflowEditorPart.this.fResolveCombo.getValue());
                            }
                        }
                    });
                }
                return null;
            }
        });
        this.fResolveCombo.getLayoutControl().setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fResolveCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (WorkflowEditorPart.this.fWorkflow == null) {
                    return;
                }
                Object value = WorkflowEditorPart.this.fResolveCombo.getValue();
                if (ACTION_NONE.equals(value)) {
                    if (WorkflowEditorPart.this.fWorkflow.getResolveAction() == null) {
                        return;
                    }
                    WorkflowEditorPart.this.fWorkflow.setResolveAction(null);
                    WorkflowEditorPart.this.setDirty();
                } else if (TransitionsPart.NEW_ACTION.equals(value)) {
                    ActionsPart.AddEditActionDialog d = new ActionsPart.AddEditActionDialog(Display.getCurrent().getActiveShell(), Messages.WorkflowEditorPart_ADD_ACTION, WorkflowEditorPart.this.fWorkflow.getStates(), WorkflowEditorPart.this.fPrefixProvider, WorkflowEditorPart.this.fResourceManager);
                    if (d.open() == 0) {
                        String name = d.getName();
                        String description = d.getDescription();
                        String iconUrl = d.getIconUrl();
                        WFWorkflow.WFAction act = new WFWorkflow.WFAction(WorkflowEditorPart.this.fWorkflow, WorkflowEditorPart.this.fWorkflow.generateActionId(), name, description, iconUrl);
                        WFWorkflow.WFState target = d.getTargetState();
                        act.setTargetState(target);
                        WorkflowEditorPart.this.fWorkflow.addAction(act);
                        WorkflowEditorPart.this.fWorkflow.setResolveAction(act);
                        WorkflowEditorPart.this.setDirty();
                    } else {
                        WorkflowEditorPart.this.updateDetails();
                    }
                } else if (!value.equals(WorkflowEditorPart.this.fWorkflow.getResolveAction())) {
                    if (value instanceof WFWorkflow.WFAction) {
                        WorkflowEditorPart.this.fWorkflow.setResolveAction((WFWorkflow.WFAction)value);
                        WorkflowEditorPart.this.setDirty();
                    } else {
                        WorkflowEditorPart.this.updateDetails();
                    }
                }
            }
        });
        fill = toolkit.createLabel(defaultActions, null, 0);
        fillData = new GridData(20, 0);
        fill.setLayoutData((Object)fillData);
        lab = toolkit.createLabel(defaultActions, Messages.WorkflowEditorPart_REOPEN_ACTION, 0);
        lab.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fReopenCombo = new DecoratedCombo(defaultActions, 8, 1);
        toolkit.adapt(this.fReopenCombo.getImageControl(), false, false);
        toolkit.adapt((Control)this.fReopenCombo.getCombo(), true, true);
        this.fReopenCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof WFWorkflow.WFAction) {
                    return WorkflowEditorPart.this.getUnambiguousName((WFWorkflow.WFAction)element);
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof WFWorkflow.WFAction && ((WFWorkflow.WFAction)element).getIcon() != null) {
                    return AspectEditorUtil.getImage(WorkflowEditorPart.this.fPrefixProvider.getProcessContainer(), ((WFWorkflow.WFAction)element).getIcon(), WorkflowEditorPart.this.fResourceManager, new Runnable(){

                        public void run() {
                            if (WorkflowEditorPart.this.fReopenCombo != null && !WorkflowEditorPart.this.fReopenCombo.getLayoutControl().isDisposed()) {
                                WorkflowEditorPart.this.fReopenCombo.setValue(WorkflowEditorPart.this.fReopenCombo.getValue());
                            }
                        }
                    });
                }
                return null;
            }
        });
        this.fReopenCombo.getLayoutControl().setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fReopenCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (WorkflowEditorPart.this.fWorkflow == null) {
                    return;
                }
                Object value = WorkflowEditorPart.this.fReopenCombo.getValue();
                if (ACTION_NONE.equals(value)) {
                    if (WorkflowEditorPart.this.fWorkflow.getReopenAction() == null) {
                        return;
                    }
                    WorkflowEditorPart.this.fWorkflow.setReopenAction(null);
                    WorkflowEditorPart.this.setDirty();
                } else if (TransitionsPart.NEW_ACTION.equals(value)) {
                    ActionsPart.AddEditActionDialog d = new ActionsPart.AddEditActionDialog(Display.getCurrent().getActiveShell(), Messages.WorkflowEditorPart_ADD_ACTION, WorkflowEditorPart.this.fWorkflow.getStates(), WorkflowEditorPart.this.fPrefixProvider, WorkflowEditorPart.this.fResourceManager);
                    if (d.open() == 0) {
                        String name = d.getName();
                        String description = d.getDescription();
                        String iconUrl = d.getIconUrl();
                        WFWorkflow.WFAction act = new WFWorkflow.WFAction(WorkflowEditorPart.this.fWorkflow, WorkflowEditorPart.this.fWorkflow.generateActionId(), name, description, iconUrl);
                        WFWorkflow.WFState target = d.getTargetState();
                        act.setTargetState(target);
                        WorkflowEditorPart.this.fWorkflow.addAction(act);
                        WorkflowEditorPart.this.fWorkflow.setReopenAction(act);
                        WorkflowEditorPart.this.setDirty();
                    } else {
                        WorkflowEditorPart.this.updateDetails();
                    }
                } else if (!value.equals(WorkflowEditorPart.this.fWorkflow.getReopenAction())) {
                    if (value instanceof WFWorkflow.WFAction) {
                        WorkflowEditorPart.this.fWorkflow.setReopenAction((WFWorkflow.WFAction)value);
                        WorkflowEditorPart.this.setDirty();
                    } else {
                        WorkflowEditorPart.this.updateDetails();
                    }
                }
            }
        });
        this.updateEnablement();
    }

    private void updateDetails() {
        if (this.fWorkflow.getDescription() != null) {
            if (!this.fDescription.getText().equals(this.fWorkflow.getDescription())) {
                this.fDescription.setText(this.fWorkflow.getDescription());
            }
        } else {
            this.fDescription.setText("");
        }
        if (this.fWorkflow.getName() != null) {
            if (!this.fName.getText().equals(this.fWorkflow.getName())) {
                this.fName.setText(this.fWorkflow.getName());
            }
        } else {
            this.fName.setText("");
        }
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(ACTION_NONE);
        values.addAll(this.fWorkflow.getActions());
        if (!this.fWorkflow.getStates().isEmpty()) {
            values.add(TransitionsPart.NEW_ACTION);
        }
        this.fStartCombo.setValueSet(values.toArray());
        if (this.fWorkflow.getStartAction() == null) {
            this.fStartCombo.setValue((Object)ACTION_NONE);
        } else {
            this.fStartCombo.setValue((Object)this.fWorkflow.getStartAction());
        }
        values = new ArrayList();
        values.add(ACTION_NONE);
        values.addAll(this.fWorkflow.getActions());
        if (!this.fWorkflow.getStates().isEmpty()) {
            values.add(TransitionsPart.NEW_ACTION);
        }
        this.fResolveCombo.setValueSet(values.toArray());
        if (this.fWorkflow.getResolveAction() == null) {
            this.fResolveCombo.setValue((Object)ACTION_NONE);
        } else {
            this.fResolveCombo.setValue((Object)this.fWorkflow.getResolveAction());
        }
        values = new ArrayList();
        values.add(ACTION_NONE);
        values.addAll(this.fWorkflow.getActions());
        if (!this.fWorkflow.getStates().isEmpty()) {
            values.add(TransitionsPart.NEW_ACTION);
        }
        this.fReopenCombo.setValueSet(values.toArray());
        if (this.fWorkflow.getReopenAction() == null) {
            this.fReopenCombo.setValue((Object)ACTION_NONE);
        } else {
            this.fReopenCombo.setValue((Object)this.fWorkflow.getReopenAction());
        }
        this.fReopenCombo.getLayoutControl().getParent().layout();
    }

    private void updateEnablement() {
        if (this.fDescription != null && !this.fDescription.isDisposed()) {
            this.fDescription.setEnabled(this.fWorkflow != null);
            this.fName.setEnabled(this.fWorkflow != null);
            this.fStartCombo.getCombo().setEnabled(this.fWorkflow != null);
            this.fStartCombo.getImageControl().setEnabled(this.fWorkflow != null);
            this.fResolveCombo.getCombo().setEnabled(this.fWorkflow != null);
            this.fResolveCombo.getImageControl().setEnabled(this.fWorkflow != null);
            this.fReopenCombo.getCombo().setEnabled(this.fWorkflow != null);
            this.fReopenCombo.getImageControl().setEnabled(this.fWorkflow != null);
        }
    }

    private void flushDetails() {
        this.fDescription.setText("");
        this.fName.setText("");
        this.fStartCombo.setValueSet(new Object[0]);
        this.fStartCombo.setValue((Object)"");
        this.fResolveCombo.setValueSet(new Object[0]);
        this.fResolveCombo.setValue((Object)"");
        this.fReopenCombo.setValueSet(new Object[0]);
        this.fReopenCombo.setValue((Object)"");
    }

    public void setInput(Object input) {
        if (this.fWorkflow != null) {
            this.fWorkflow.removeWFChangeListener(this.fWFChangedListener);
        }
        if (input instanceof WFWorkflow) {
            this.fWorkflow = (WFWorkflow)input;
            this.updateDetails();
            this.fWorkflow.addWFChangeListener(this.fWFChangedListener);
        } else {
            this.fWorkflow = null;
            this.flushDetails();
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private String getUnambiguousName(WFWorkflow.WFAction action) {
        if (this.fWorkflow != null) {
            for (WFWorkflow.WFAction a : this.fWorkflow.getActions()) {
                if (a.equals(action) || !a.getName().equals(action.getName())) continue;
                return NLS.bind((String)Messages.WorkflowEditorPart_ACTION_TARGETSTATE, (Object)action.getName(), (Object[])new Object[]{action.getTargetState().getName()});
            }
        }
        return action.getName();
    }

    static abstract class SimpleContentProvider
    implements IStructuredContentProvider {
        SimpleContentProvider() {
        }

        public abstract Object[] getElements(Object var1);

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

