/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowBindingAspectEditor
extends AbstractWorkItemAspectEditor {
    private static final String NONE = Messages.WorkflowBindingAspectEditor_NONE;
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.WorkflowBindingAspectEditor_CHOOSE_TYPE_CATEGORY;
        }

        public String getSameIdMessage() {
            return Messages.WorkflowBindingAspectEditor_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.WorkflowBindingAspectEditor_ENTER_TC_ID;
        }
    };
    private DecoratedCombo fWorkflowCombo;
    private List<WFWorkflow> fExistingWorkflows = new ArrayList<WFWorkflow>();
    private WorkflowBinding fBinding;

    public WorkflowBindingAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.workflow_binding_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        WorkflowBindingManager.writeWorkflowBindings(memento, elements);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Label l = toolkit.createLabel(parent, Messages.WorkflowBindingAspectEditor_WORKFLOW, 0);
        l.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fWorkflowCombo = new DecoratedCombo(parent, 8, 4);
        toolkit.adapt((Composite)this.fWorkflowCombo.getCombo());
        this.fWorkflowCombo.getLayoutControl().setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fWorkflowCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof WFWorkflow) {
                    String name = ((WFWorkflow)element).getName();
                    if (name == null || "".equals(name.trim())) {
                        name = ((WFWorkflow)element).getIdentifier();
                    }
                    return name;
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        });
        this.fWorkflowCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String element;
                Object value = WorkflowBindingAspectEditor.this.fWorkflowCombo.getValue();
                String string = element = value instanceof WFWorkflow ? ((WFWorkflow)value).getIdentifier() : null;
                if (WorkflowBindingAspectEditor.this.fBinding != null && !AspectEditorUtil.equals(element, WorkflowBindingAspectEditor.this.fBinding.getWorkflowId())) {
                    WorkflowBindingAspectEditor.this.fBinding.setWorkflowId(element);
                    WorkflowBindingAspectEditor.this.setDirty();
                }
            }
        });
        this.updateValueSet();
    }

    @Override
    protected boolean canAdd() {
        return false;
    }

    @Override
    protected ModeledElement createNewElement() {
        return null;
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fBinding = (WorkflowBinding)newElement;
        this.updateValueSet();
        if (this.fBinding != null) {
            for (WFWorkflow w : this.fExistingWorkflows) {
                if (!w.getIdentifier().equals(this.fBinding.getWorkflowId())) continue;
                this.fWorkflowCombo.setValue((Object)w);
                return;
            }
        }
        this.fWorkflowCombo.setValue((Object)NONE);
    }

    private void updateValueSet() {
        ArrayList<WFWorkflow> valueSet = new ArrayList<WFWorkflow>(this.fExistingWorkflows);
        valueSet.add(0, (WFWorkflow)((Object)NONE));
        this.fWorkflowCombo.setValueSet(valueSet.toArray());
    }

    private Set<WFWorkflow> readExistingWorkflows() {
        ModelElement workflowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        if (workflowElement != null) {
            return new HashSet<WFWorkflow>(WorkflowManager.readWorkflows(workflowElement));
        }
        return Collections.emptySet();
    }

    @Override
    protected void doDispose() {
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        boolean found;
        Set<WFWorkflow> workflows = this.readExistingWorkflows();
        List<TypeCategory> categories = TypeManager.readTypeCategories(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes"));
        ArrayList<WorkflowBinding> bindings = new ArrayList<WorkflowBinding>(WorkflowBindingManager.readWorkflowBindings(configurationElement));
        for (TypeCategory cat : categories) {
            found = false;
            for (WorkflowBinding b : bindings) {
                if (!b.getCategoryId().equals(cat.getIdentifier())) continue;
                found = true;
                b.setDisplayName(AspectEditorUtil.getTypeCategoryDisplayName(cat));
                break;
            }
            if (found) continue;
            bindings.add(new WorkflowBinding(cat.getIdentifier(), null, AspectEditorUtil.getTypeCategoryDisplayName(cat)));
        }
        for (WorkflowBinding b : bindings) {
            if (b.getWorkflowId() == null) continue;
            found = false;
            for (WFWorkflow w : workflows) {
                if (!b.getWorkflowId().equals(w.getIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            workflows.add(new WFWorkflow(b.getWorkflowId(), b.getWorkflowId(), null));
        }
        Collections.sort(bindings, new Comparator<WorkflowBinding>(){

            @Override
            public int compare(WorkflowBinding o1, WorkflowBinding o2) {
                return Collator.getInstance().compare(o1.getCategoryId(), o2.getCategoryId());
            }
        });
        this.fExistingWorkflows = new ArrayList<WFWorkflow>(workflows);
        Collections.sort(this.fExistingWorkflows, new AspectEditorUtil.WorkflowComparator());
        return bindings;
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }
}

