/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IconsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.ActionsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.ResolutionsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.StatesPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.TransitionsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowEditorPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowAspectEditor
extends AbstractWorkItemAspectEditor
implements IPrefixProvider {
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.WorkflowAspectEditor_CHOOSE_WORKFLOW;
        }

        public String getSameIdMessage() {
            return Messages.WorkflowAspectEditor_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.WorkflowAspectEditor_ENTER_WF_ID;
        }
    };
    private WorkflowEditorPart fWFEditor;
    private TransitionsPart fTransitionsPart;
    private StatesPart fStatesPart;
    private ActionsPart fActionsPart;
    private ResolutionsPart fResolutionsPart;
    private IconsPart fIconsPart;
    private List<WorkflowBinding> fBindings;
    public static final String WORKFLOW_PREFIX = "workflow";
    private ManagedForm fManagedForm;

    public WorkflowAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.workflow_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        WorkflowManager.writeWorkflows(memento, elements);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 3;
        body.setLayout((Layout)layout);
        this.fWFEditor = new WorkflowEditorPart(this, this, this);
        TeamFormSectionPart workflowSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.WorkflowAspectEditor_WORKFLOW, new TeamFormPart[]{this.fWFEditor});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        workflowSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)workflowSection);
        this.fTransitionsPart = new TransitionsPart(this.getProcessContainerWorkingCopy(), this, this);
        TeamFormSectionPart transitionsSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 322, Messages.WorkflowAspectEditor_TRANSITIONS, new TeamFormPart[]{this.fTransitionsPart});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)workflowSection.getSection());
        transitionsSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)transitionsSection);
        this.fStatesPart = new StatesPart(this, this, this);
        TeamFormSectionPart statesSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 322, Messages.WorkflowAspectEditor_STATES, new TeamFormPart[]{this.fStatesPart});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)transitionsSection.getSection());
        statesSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)statesSection);
        this.fActionsPart = new ActionsPart(this, this, this);
        TeamFormSectionPart actionsSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 322, Messages.WorkflowAspectEditor_ACTIONS, new TeamFormPart[]{this.fActionsPart});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)statesSection.getSection());
        actionsSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)actionsSection);
        this.fResolutionsPart = new ResolutionsPart(this, this, this);
        TeamFormSectionPart resolutionsSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 322, Messages.WorkflowAspectEditor_RESOLUTIONS, new TeamFormPart[]{this.fResolutionsPart});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)actionsSection.getSection());
        resolutionsSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)resolutionsSection);
        this.fIconsPart = new IconsPart(this);
        TeamFormSectionPart iconsSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 258, Messages.WorkflowAspectEditor_ICONS, new TeamFormPart[]{this.fIconsPart});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)resolutionsSection.getSection());
        formData.bottom = new FormAttachment(100);
        iconsSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)iconsSection);
    }

    @Override
    public String getIconPrefix() {
        return "/workflow";
    }

    @Override
    public ITeamRepository getRepository() {
        return (ITeamRepository)this.getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin();
    }

    @Override
    public IProcessContainerWorkingCopy getProcessContainer() {
        return this.getProcessContainerWorkingCopy();
    }

    public void needReflow() {
        if (this.fManagedForm != null) {
            this.fManagedForm.reflow(true);
        }
    }

    public void updateLabels() {
        this.updateComboLabels();
    }

    @Override
    protected ModeledElement createNewElement() {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.WorkflowAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager()){

            protected boolean checkIdLength() {
                return true;
            }

            protected int getMaxPrefixLength() {
                return Math.max(".resolution.r".length(), ".state.s".length());
            }
        };
        if (d.open() != 0) {
            return null;
        }
        return new WFWorkflow(null, d.getId(), null);
    }

    @Override
    protected boolean canDuplicate() {
        return true;
    }

    @Override
    protected ModeledElement duplicateElement(ModeledElement original) {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.WorkflowAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager()){

            protected boolean checkIdLength() {
                return true;
            }

            protected int getMaxPrefixLength() {
                return Math.max(".resolution.r".length(), ".state.s".length());
            }
        };
        if (d.open() != 0) {
            return null;
        }
        return ((WFWorkflow)original).duplicate(d.getId());
    }

    @Override
    protected boolean canRemove() {
        return true;
    }

    @Override
    protected boolean removeElement(ModeledElement element) {
        String categories = "";
        for (WorkflowBinding binding : this.fBindings) {
            if (!binding.getWorkflowId().equals(element.getIdentifier())) continue;
            categories = NLS.bind((String)Messages.WorkflowAspectEditor_APPEND_CATEGORY_TO_LIST, (Object)categories, (Object[])new Object[]{binding.getCategoryId()});
        }
        String message = categories.length() == 0 ? NLS.bind((String)Messages.WorkflowAspectEditor_REMOVING_WARNING, (Object)element.getName(), (Object[])new Object[0]) : NLS.bind((String)Messages.WorkflowAspectEditor_REMOVING_REFERENCES_WARNING, (Object)element.getName(), (Object[])new Object[]{categories});
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.WorkflowAspectEditor_REMOVE, (String)message);
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fManagedForm.setInput((Object)newElement);
        this.fManagedForm.reflow(true);
    }

    private List<WorkflowBinding> readBindings() {
        return WorkflowBindingManager.readWorkflowBindings(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding"));
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        this.fBindings = this.readBindings();
        return WorkflowManager.readWorkflows(configurationElement);
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }
}

