/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionsPart
extends TeamFormPart {
    private WFWorkflow fWorkflow;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Composite fTransitionsContainer;
    private static final String ACTION_NONE = Messages.TransitionsPart_NONE_ENTRY;
    static final String NEW_ACTION = Messages.TransitionsPart_NEW_ACTION_ENTRY;
    private WFWorkflow.WFChangeListener fWFChangedListener = new WFWorkflow.WFChangeListener(){

        public void wfChanged(final WFWorkflow.WFChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (event.affects("states") && TransitionsPart.this.fTransitionsContainer != null && !TransitionsPart.this.fTransitionsContainer.isDisposed()) {
                        if (event.getData() instanceof WFWorkflow.WFState) {
                            TransitionsPart.this.updateTransitionStates((WFWorkflow.WFState)event.getData());
                        }
                    } else if (event.affects("actions") && TransitionsPart.this.fTransitionsContainer != null && !TransitionsPart.this.fTransitionsContainer.isDisposed()) {
                        if (event.getData() instanceof WFWorkflow.WFAction) {
                            TransitionsPart.this.updateTransitionActions((WFWorkflow.WFAction)event.getData());
                        } else if (event.getData() instanceof WFWorkflow.WFState) {
                            TransitionsPart.this.createTransitions();
                        }
                    } else if (event.affects("workflow") && TransitionsPart.this.fTransitionsContainer != null && !TransitionsPart.this.fTransitionsContainer.isDisposed()) {
                        if (event.getData() instanceof WFWorkflow.WFState || event.getData() instanceof Collection) {
                            TransitionsPart.this.createTransitions();
                            TransitionsPart.this.fReflowableContainer.needReflow();
                        } else if (event.getData() instanceof WFWorkflow.WFAction) {
                            TransitionsPart.this.updateTransitionActions((WFWorkflow.WFAction)event.getData());
                        }
                    }
                }
            });
        }
    };
    private IProcessContainerWorkingCopy fContainer;
    private IDirtyStateTracker fTracker;
    private WorkflowAspectEditor fReflowableContainer;
    private Map<WFWorkflow.WFState, StateEntry> fStateEntries = new HashMap<WFWorkflow.WFState, StateEntry>();
    private Map<WFWorkflow.WFState, ColumnTitleEntry> fColumnTitleEntries = new HashMap<WFWorkflow.WFState, ColumnTitleEntry>();

    TransitionsPart(IProcessContainerWorkingCopy processContainer, IDirtyStateTracker tracker, WorkflowAspectEditor reflowable) {
        this.fContainer = processContainer;
        this.fTracker = tracker;
        this.fReflowableContainer = reflowable;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 5;
        parent.setLayout((Layout)layout);
        ScrolledComposite c = new ScrolledComposite(parent, 256);
        toolkit.adapt((Composite)c);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 600;
        c.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        this.fTransitionsContainer = toolkit.createComposite((Composite)c, 0);
        data = new GridData(4, 4, true, true);
        this.fTransitionsContainer.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        this.fTransitionsContainer.setLayout((Layout)layout);
        this.fTransitionsContainer.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                TransitionsPart.this.updateScrolledComposite();
            }
        });
        c.setContent((Control)this.fTransitionsContainer);
    }

    private void updateScrolledComposite() {
        this.fTransitionsContainer.setSize(this.fTransitionsContainer.computeSize(-1, -1));
        this.fTransitionsContainer.layout();
    }

    private List<WFWorkflow.WFAction> getActionsForEndstat(WFWorkflow.WFState state) {
        ArrayList<WFWorkflow.WFAction> actions = new ArrayList<WFWorkflow.WFAction>();
        for (WFWorkflow.WFAction action : this.fWorkflow.getActions()) {
            if (action.getTargetState() != state) continue;
            actions.add(action);
        }
        return actions;
    }

    private WFWorkflow.WFAction getActionFromStateToState(WFWorkflow.WFState fromState, WFWorkflow.WFState toState) {
        for (WFWorkflow.WFAction action : fromState.getActions()) {
            if (action.getTargetState() != toState) continue;
            return action;
        }
        return null;
    }

    private void createTransitions() {
        Object entry;
        Control[] controlArray = this.fTransitionsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control cont = controlArray[n2];
            cont.dispose();
            ++n2;
        }
        this.fStateEntries = new HashMap<WFWorkflow.WFState, StateEntry>();
        this.fColumnTitleEntries = new HashMap<WFWorkflow.WFState, ColumnTitleEntry>();
        if (this.fWorkflow == null) {
            return;
        }
        FormToolkit toolkit = this.getSite().getToolkit();
        List<WFWorkflow.WFState> states = this.fWorkflow.getStates();
        final Collator coll = Collator.getInstance();
        coll.setStrength(1);
        Collections.sort(states, new Comparator<WFWorkflow.WFState>(){

            @Override
            public int compare(WFWorkflow.WFState o1, WFWorkflow.WFState o2) {
                return coll.compare(o1.getName(), o2.getName());
            }
        });
        Composite body = toolkit.createComposite(this.fTransitionsContainer, 0);
        GridLayout gridLayout = new GridLayout(states.size() + 1, true);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        body.setLayout((Layout)gridLayout);
        body.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite t = toolkit.createComposite(body, 0);
        t.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        layout.marginWidth = 3;
        layout.marginHeight = 2;
        layout.verticalSpacing = 0;
        t.setLayout((Layout)layout);
        Label l = toolkit.createLabel(t, Messages.TransitionsPart_FROM);
        l.setLayoutData((Object)new GridData(16384, 1024, true, true));
        l = toolkit.createLabel(t, Messages.TransitionsPart_TO);
        l.setLayoutData((Object)new GridData(131072, 128, true, true));
        for (WFWorkflow.WFState s : states) {
            entry = new ColumnTitleEntry(s);
            this.fColumnTitleEntries.put(s, (ColumnTitleEntry)entry);
            ((ColumnTitleEntry)entry).createContent(body);
        }
        for (WFWorkflow.WFState s : states) {
            entry = new StateEntry(s);
            this.fStateEntries.put(s, (StateEntry)entry);
            ((StateEntry)entry).createContent(body);
        }
        this.updateScrolledComposite();
    }

    private void updateTransitionStates(WFWorkflow.WFState affectedState) {
        StateEntry entry;
        ColumnTitleEntry title = this.fColumnTitleEntries.get(affectedState);
        if (title != null) {
            title.refresh();
        }
        if ((entry = this.fStateEntries.get(affectedState)) != null) {
            entry.refresh();
        }
    }

    private void updateTransitionActions(WFWorkflow.WFAction affectedAction) {
        for (StateEntry entry : this.fStateEntries.values()) {
            entry.refreshAction(affectedAction);
        }
    }

    private void updateEnablement() {
        if (this.fTransitionsContainer != null && !this.fTransitionsContainer.isDisposed()) {
            this.fTransitionsContainer.setEnabled(this.fWorkflow != null);
        }
    }

    public void setInput(Object input) {
        if (this.fWorkflow != null) {
            this.fWorkflow.removeWFChangeListener(this.fWFChangedListener);
        }
        if (input instanceof WFWorkflow) {
            this.fWorkflow = (WFWorkflow)input;
            this.fWorkflow.addWFChangeListener(this.fWFChangedListener);
            this.createTransitions();
        } else {
            this.fWorkflow = null;
            this.createTransitions();
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private class ColumnTitleEntry {
        private WFWorkflow.WFState fState;
        private Label fImage;
        private Label fName;

        public ColumnTitleEntry(WFWorkflow.WFState state) {
            this.fState = state;
        }

        public void createContent(Composite body) {
            FormToolkit toolkit = TransitionsPart.this.getSite().getToolkit();
            Composite c = toolkit.createComposite(body, 2048);
            c.setLayoutData((Object)new GridData(4, 4, false, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 3;
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            this.fImage = toolkit.createLabel(c, null);
            this.fImage.setLayoutData((Object)new GridData(4, 4, false, false));
            this.updateStateImage();
            this.fName = toolkit.createLabel(c, this.fState.getName());
            this.fName.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        public void refresh() {
            this.updateStateImage();
            this.fName.setText(this.fState.getName());
            TransitionsPart.this.updateScrolledComposite();
        }

        private void updateStateImage() {
            if (this.fState.getIcon() != null) {
                this.fImage.setImage(AspectEditorUtil.getImage(TransitionsPart.this.fContainer, this.fState.getIcon(), TransitionsPart.this.fResourceManager, new Runnable(){

                    public void run() {
                        if (ColumnTitleEntry.this.fImage != null && !ColumnTitleEntry.this.fImage.isDisposed()) {
                            ColumnTitleEntry.this.fImage.setImage(AspectEditorUtil.getImage(TransitionsPart.this.fContainer, ColumnTitleEntry.this.fState.getIcon(), TransitionsPart.this.fResourceManager, null));
                        }
                    }
                }));
            } else {
                this.fImage.setImage(JazzResources.getImage((ResourceManager)TransitionsPart.this.fResourceManager, (ImageDescriptor)ImagePool.EMPTY_ICON, null));
            }
        }
    }

    private class StateEntry {
        private WFWorkflow.WFState fState;
        private Map<WFWorkflow.WFState, DecoratedCombo> fComboCache = new HashMap<WFWorkflow.WFState, DecoratedCombo>();
        private Label fImage;
        private Label fName;

        public StateEntry(WFWorkflow.WFState state) {
            this.fState = state;
        }

        public void refresh() {
            try {
                if (this.fState.getIcon() != null) {
                    this.fImage.setImage(AspectEditorUtil.getImage(TransitionsPart.this.fContainer, this.fState.getIcon(), TransitionsPart.this.fResourceManager, new Runnable(){

                        public void run() {
                            if (StateEntry.this.fImage != null && !StateEntry.this.fImage.isDisposed()) {
                                StateEntry.this.fImage.setImage(AspectEditorUtil.getImage(TransitionsPart.this.fContainer, StateEntry.this.fState.getIcon(), TransitionsPart.this.fResourceManager, null));
                            }
                        }
                    }));
                }
            }
            catch (Exception exception) {}
            this.fName.setText(this.fState.getName());
            TransitionsPart.this.updateScrolledComposite();
        }

        public void refreshAction(WFWorkflow.WFAction affectedAction) {
            for (WFWorkflow.WFState s : TransitionsPart.this.fWorkflow.getStates()) {
                List candidates = TransitionsPart.this.getActionsForEndstat(s);
                DecoratedCombo combo = this.fComboCache.get(s);
                if (combo == null || !candidates.contains(affectedAction) && !Arrays.asList(combo.getValueSet()).contains(affectedAction)) continue;
                Object[] valueSet = new Object[candidates.size() + 2];
                valueSet[0] = ACTION_NONE;
                int i = 0;
                while (i < candidates.size()) {
                    valueSet[i + 1] = candidates.get(i);
                    ++i;
                }
                valueSet[valueSet.length - 1] = NEW_ACTION;
                combo.setValueSet(valueSet);
                if (combo.getValue() == affectedAction && !candidates.contains(affectedAction)) {
                    combo.setValue((Object)ACTION_NONE);
                }
                TransitionsPart.this.updateScrolledComposite();
            }
        }

        public void createContent(Composite parent) {
            this.fComboCache = new HashMap<WFWorkflow.WFState, DecoratedCombo>();
            FormToolkit toolkit = TransitionsPart.this.getSite().getToolkit();
            Composite c = toolkit.createComposite(parent, 2048);
            c.setLayoutData((Object)new GridData(4, 4, false, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            this.fImage = toolkit.createLabel(c, null);
            this.fImage.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            try {
                if (this.fState.getIcon() != null) {
                    this.fImage.setImage(AspectEditorUtil.getImage(TransitionsPart.this.fContainer, this.fState.getIcon(), TransitionsPart.this.fResourceManager, new Runnable(){

                        public void run() {
                            if (StateEntry.this.fImage != null && !StateEntry.this.fImage.isDisposed()) {
                                StateEntry.this.fImage.setImage(AspectEditorUtil.getImage(TransitionsPart.this.fContainer, StateEntry.this.fState.getIcon(), TransitionsPart.this.fResourceManager, null));
                            }
                        }
                    }));
                }
            }
            catch (Exception exception) {}
            this.fName = toolkit.createLabel(c, this.fState.getName());
            this.fName.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            for (final WFWorkflow.WFState s : TransitionsPart.this.fWorkflow.getStates()) {
                List candidates = TransitionsPart.this.getActionsForEndstat(s);
                Object[] valueSet = new Object[candidates.size() + 2];
                valueSet[0] = ACTION_NONE;
                int i = 0;
                while (i < candidates.size()) {
                    valueSet[i + 1] = candidates.get(i);
                    ++i;
                }
                valueSet[valueSet.length - 1] = NEW_ACTION;
                Composite e = toolkit.createComposite(parent, 2048);
                e.setLayoutData((Object)new GridData(4, 4, false, false));
                layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                e.setLayout((Layout)layout);
                if (s == this.fState) {
                    Label l = toolkit.createLabel(e, NLS.bind((String)Messages.TransitionsPart_ACTION_NONE_ENTRY, (Object)ACTION_NONE, (Object[])new Object[0]));
                    l.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
                    continue;
                }
                WFWorkflow.WFAction act = TransitionsPart.this.getActionFromStateToState(this.fState, s);
                final DecoratedCombo combo = new DecoratedCombo(e, 8, 5);
                toolkit.adapt((Composite)combo.getLayoutControl());
                toolkit.adapt((Control)combo.getCombo(), true, false);
                toolkit.adapt(combo.getImageControl(), false, false);
                this.fComboCache.put(s, combo);
                combo.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof String) {
                            return (String)element;
                        }
                        if (element instanceof WFWorkflow.WFAction) {
                            return ((WFWorkflow.WFAction)element).getName();
                        }
                        return null;
                    }

                    public Image getImage(Object element) {
                        Image img = null;
                        if (element instanceof WFWorkflow.WFAction && ((WFWorkflow.WFAction)element).getIcon() != null) {
                            img = this.getImage(element, ((WFWorkflow.WFAction)element).getIcon());
                        }
                        if (img == null) {
                            img = JazzResources.getImage((ResourceManager)TransitionsPart.this.fResourceManager, (ImageDescriptor)ImagePool.EMPTY_ICON, null);
                        }
                        return img;
                    }

                    private Image getImage(final Object element, String iconPath) {
                        return AspectEditorUtil.getImage(TransitionsPart.this.fContainer, iconPath, TransitionsPart.this.fResourceManager, new Runnable(){

                            public void run() {
                                this.fireChanged(element);
                            }
                        });
                    }

                    private void fireChanged(Object element) {
                        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
                    }
                });
                combo.setValueSet(valueSet);
                if (act != null) {
                    combo.setValue((Object)act);
                } else {
                    combo.setValue((Object)ACTION_NONE);
                }
                combo.addSelectionChangedListener(new ISelectionChangedListener(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void selectionChanged(SelectionChangedEvent event) {
                        WFWorkflow.WFAction act;
                        block8: {
                            Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                            if (sel instanceof WFWorkflow.WFAction) {
                                act = (WFWorkflow.WFAction)sel;
                                String desc = act.getDescription();
                                if ("".equals(desc)) {
                                    desc = null;
                                }
                                combo.getCombo().setToolTipText(desc);
                            } else {
                                combo.getCombo().setToolTipText(null);
                                if (sel.equals(NEW_ACTION)) {
                                    InputDialog inputDialog = new InputDialog(TransitionsPart.this.fTransitionsContainer.getShell(), Messages.TransitionsPart_ACTION_NAME, Messages.TransitionsPart_SPECIFY_NAME, Messages.TransitionsPart_SPECIFY_NAME_FOR_NEW_ACTION, new IInputValidator(){

                                        public String isValid(String newText) {
                                            if (newText == null || newText.trim().length() == 0) {
                                                return Messages.TransitionsPart_SPECIFY_NAME_FOR_ACTION;
                                            }
                                            return null;
                                        }
                                    });
                                    if (inputDialog.open() == 0) {
                                        String name = inputDialog.getValue();
                                        act = new WFWorkflow.WFAction(TransitionsPart.this.fWorkflow, TransitionsPart.this.fWorkflow.generateActionId(), name, null, null);
                                        act.setTargetState(s);
                                        TransitionsPart.this.fWorkflow.addAction(act);
                                        combo.setValue((Object)act);
                                        break block8;
                                    } else {
                                        Object prev = TransitionsPart.this.getActionFromStateToState(StateEntry.this.fState, s);
                                        if (prev == null) {
                                            prev = ACTION_NONE;
                                        }
                                        combo.setValue(prev);
                                        return;
                                    }
                                }
                                act = null;
                            }
                        }
                        ArrayList<WFWorkflow.WFAction> toRemove = new ArrayList<WFWorkflow.WFAction>();
                        for (WFWorkflow.WFAction action : StateEntry.this.fState.getActions()) {
                            if (!action.getTargetState().equals(s)) continue;
                            toRemove.add(action);
                        }
                        StateEntry.this.fState.getActions().removeAll(toRemove);
                        StateEntry.this.fState.addAction(act);
                        TransitionsPart.this.setDirty();
                    }
                });
                combo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            }
        }
    }
}

