/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.SimpleTableLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowEditorPart;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StatesPart
extends TeamFormPart {
    private WFWorkflow fWorkflow;
    private TableViewer fStateViewer;
    private static final int STA_COL_NAME = 0;
    private static final int STA_COL_GROUP = 1;
    private static final int STA_COL_SHOWRES = 2;
    private static final int STA_COL_DESC = 3;
    private static final String GROUP_NONE = Messages.StatesPart_NONE;
    private static final List<String> GROUPS = new ArrayList<String>(Arrays.asList(GROUP_NONE, "closed", "open", "inprogress"));
    private static final List<String> GROUPNAMES = new ArrayList<String>(Arrays.asList(GROUP_NONE, Messages.StatesPart_CLOSED_STATEGROUP, Messages.StatesPart_OPEN_STATEGROUP, Messages.StatesPart_IN_PROGRESS_STATEGROUP));
    private static final String NAME_LABEL = Messages.StatesPart_NAME_LABEL;
    private static final String DESC_LABEL = Messages.StatesPart_DESCRIPTION_LABEL;
    private static final String GROUP_LABEL = Messages.StatesPart_GROUP_LABEL;
    private static final String SHOWRES_LABEL = Messages.StatesPart_SHOWRES_LABEL;
    private WFWorkflow.WFChangeListener fWFChangedListener = new WFWorkflow.WFChangeListener(){

        public void wfChanged(final WFWorkflow.WFChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (event.affects("states") && StatesPart.this.fStateViewer != null && !StatesPart.this.fStateViewer.getControl().isDisposed()) {
                        StatesPart.this.fStateViewer.refresh();
                        if (event.getData() instanceof WFWorkflow.WFState) {
                            StatesPart.this.fStateViewer.setSelection((ISelection)new StructuredSelection(event.getData()), true);
                            StatesPart.this.fStateViewer.getTable().setFocus();
                        }
                    } else if (event.affects("workflow") && StatesPart.this.fStateViewer != null && !StatesPart.this.fStateViewer.getControl().isDisposed() && event.getData() instanceof WFWorkflow.WFState) {
                        StatesPart.this.fStateViewer.refresh();
                        StatesPart.this.fStateViewer.setSelection((ISelection)new StructuredSelection(event.getData()), true);
                        StatesPart.this.fStateViewer.getTable().setFocus();
                        StatesPart.this.fReflowableContainer.needReflow();
                    }
                }
            });
        }
    };
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private IDirtyStateTracker fTracker;
    private IPrefixProvider fPrefixProvider;
    private WorkflowAspectEditor fReflowableContainer;
    private Button fAddState;

    StatesPart(IPrefixProvider prefixProvider, IDirtyStateTracker tracker, WorkflowAspectEditor reflowable) {
        this.fPrefixProvider = prefixProvider;
        this.fTracker = tracker;
        this.fReflowableContainer = reflowable;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createStateViewer(parent);
    }

    private void createStateViewer(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite comp = toolkit.createComposite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g = new GridLayout(2, false);
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(100);
        c.setResizable(true);
        c.setText(GROUP_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(110);
        c.setResizable(true);
        c.setText(SHOWRES_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(DESC_LABEL);
        this.fStateViewer = new TableViewer(t);
        this.fStateViewer.setColumnProperties(new String[]{NAME_LABEL, GROUP_LABEL, SHOWRES_LABEL, DESC_LABEL});
        this.fStateViewer.setLabelProvider((IBaseLabelProvider)new SimpleTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFState) {
                    WFWorkflow.WFState sta = (WFWorkflow.WFState)element;
                    switch (columnIndex) {
                        case 0: {
                            return sta.getName();
                        }
                        case 3: {
                            return sta.getDescription();
                        }
                        case 1: {
                            int index = 0;
                            if (sta.getGroup() != null) {
                                index = GROUPS.indexOf(sta.getGroup());
                            }
                            if (index > -1 && index < GROUPNAMES.size()) {
                                return (String)GROUPNAMES.get(index);
                            }
                            return GROUP_NONE;
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFState) {
                    WFWorkflow.WFState sta = (WFWorkflow.WFState)element;
                    if (columnIndex == 0) {
                        if (sta.getIcon() != null) {
                            return this.getImage(element, sta.getIcon());
                        }
                    } else if (columnIndex == 2) {
                        if (sta.getShowResolution()) {
                            ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.rcp.ui", (String)"/icons/obj16/checkbox_checked.gif");
                            return JazzResources.getImage((ResourceManager)StatesPart.this.fResourceManager, (ImageDescriptor)image, null);
                        }
                        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.rcp.ui", (String)"/icons/obj16/checkbox_unchecked.gif");
                        return JazzResources.getImage((ResourceManager)StatesPart.this.fResourceManager, (ImageDescriptor)image, null);
                    }
                }
                return null;
            }

            protected IProcessContainerWorkingCopy getProcessContainer() {
                return StatesPart.this.fPrefixProvider.getProcessContainer();
            }

            protected ResourceManager getResourceManager() {
                return StatesPart.this.fResourceManager;
            }
        });
        this.fStateViewer.setContentProvider((IContentProvider)new WorkflowEditorPart.SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof WFWorkflow) {
                    return ((WFWorkflow)inputElement).getStates().toArray();
                }
                return null;
            }
        });
        Composite buttonBar = new Composite(comp, 0);
        data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginTop = this.fStateViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeState = toolkit.createButton(buttonBar, Messages.StatesPart_REMOVE, 0x800000);
        removeState.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeState.setEnabled(false);
        removeState.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StatesPart.this.fStateViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)StatesPart.this.fStateViewer.getSelection();
                    for (Object o : sel.toList()) {
                        if (!(o instanceof WFWorkflow.WFState)) continue;
                        WFWorkflow.WFState state = (WFWorkflow.WFState)o;
                        ArrayList<WFWorkflow.WFAction> criticalActions = new ArrayList<WFWorkflow.WFAction>();
                        for (WFWorkflow.WFAction action : StatesPart.this.fWorkflow.getActions()) {
                            if (action.getTargetState() != state) continue;
                            criticalActions.add(action);
                        }
                        if (criticalActions.size() > 0) {
                            String text = NLS.bind((String)Messages.StatesPart_REMOVING_WARNING, (Object)state.getName(), (Object[])new Object[0]);
                            String states = "";
                            for (WFWorkflow.WFAction action : criticalActions) {
                                states = String.valueOf(states) + NLS.bind((String)"- {0}\n", (Object)action.getName(), (Object[])new Object[0]);
                            }
                            String message = NLS.bind((String)Messages.StatesPart_REMOVING_ACTIONS, (Object)text, (Object[])new Object[]{states});
                            if (!MessageDialog.openQuestion((Shell)removeState.getShell(), (String)NLS.bind((String)Messages.StatesPart_REMOVE_STATE, (Object)state.getName(), (Object[])new Object[0]), (String)message)) {
                                return;
                            }
                        }
                        StatesPart.this.fWorkflow.removeState(state);
                        StatesPart.this.setDirty();
                    }
                }
            }
        });
        final Collator coll = Collator.getInstance();
        coll.setStrength(1);
        this.fStateViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof WFWorkflow.WFState && e2 instanceof WFWorkflow.WFState) {
                    return coll.compare(((WFWorkflow.WFState)e1).getName(), ((WFWorkflow.WFState)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fAddState = toolkit.createButton(buttonBar, Messages.StatesPart_ADD, 0x800000);
        this.fAddState.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddState.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditStateDialog d = new AddEditStateDialog(Display.getCurrent().getActiveShell(), Messages.StatesPart_ADD_STATE, null, null, null, null, false, StatesPart.this.fPrefixProvider, StatesPart.this.fResourceManager);
                if (d.open() == 0) {
                    StatesPart.this.fWorkflow.addState(new WFWorkflow.WFState(StatesPart.this.fWorkflow, StatesPart.this.fWorkflow.generateStateId(), d.getName(), d.getDescription(), d.getIconUrl(), d.getGroup(), d.getShowRes()));
                    StatesPart.this.setDirty();
                }
            }
        });
        final Button editState = toolkit.createButton(buttonBar, Messages.StatesPart_EDIT, 0x800000);
        editState.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editState.setEnabled(false);
        editState.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatesPart.this.editState();
            }
        });
        this.fStateViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeState.setEnabled(!StatesPart.this.fStateViewer.getSelection().isEmpty());
                editState.setEnabled(((IStructuredSelection)StatesPart.this.fStateViewer.getSelection()).size() == 1);
            }
        });
        this.fStateViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)StatesPart.this.fStateViewer.getSelection()).size() == 1) {
                    StatesPart.this.editState();
                }
            }
        });
        this.updateEnablement();
        Utils.updateColumnWidths((Table)this.fStateViewer.getTable(), (int[])new int[]{-1, -1, -1, 1});
    }

    private void editState() {
        WFWorkflow.WFState sta = (WFWorkflow.WFState)((IStructuredSelection)this.fStateViewer.getSelection()).getFirstElement();
        AddEditStateDialog d = new AddEditStateDialog(Display.getCurrent().getActiveShell(), Messages.StatesPart_EDIT_STATE, sta.getName(), sta.getDescription(), sta.getIcon(), sta.getGroup(), sta.getShowResolution(), this.fPrefixProvider, this.fResourceManager);
        if (d.open() == 0) {
            String name = d.getName();
            String description = d.getDescription();
            String iconUrl = d.getIconUrl();
            String group = d.getGroup();
            boolean showRes = d.getShowRes();
            if (!name.equals(sta.getName())) {
                sta.setName(name);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(description, sta.getDescription())) {
                sta.setDescription(description);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(iconUrl, sta.getIcon())) {
                sta.setIcon(iconUrl);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(group, sta.getGroup())) {
                sta.setGroup(group);
                this.setDirty();
            }
            if (showRes != sta.getShowResolution()) {
                sta.setShowResolution(showRes);
                this.setDirty();
            }
        }
    }

    private void updateEnablement() {
        if (this.fAddState != null && !this.fAddState.isDisposed()) {
            this.fAddState.setEnabled(this.fWorkflow != null);
            this.fStateViewer.getControl().setEnabled(this.fWorkflow != null);
        }
    }

    public void setInput(Object input) {
        if (this.fWorkflow != null) {
            this.fWorkflow.removeWFChangeListener(this.fWFChangedListener);
        }
        if (input instanceof WFWorkflow) {
            this.fWorkflow = (WFWorkflow)input;
            this.fWorkflow.addWFChangeListener(this.fWFChangedListener);
            this.fStateViewer.setInput((Object)this.fWorkflow);
        } else {
            this.fWorkflow = null;
            this.fStateViewer.setInput(null);
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private static class AddEditStateDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fNameField;
        private Text fDescriptionField;
        private String fDescription;
        private String fName;
        private String fGroup;
        private Combo fGroupCombo;
        private boolean fShowRes;

        protected AddEditStateDialog(Shell parentShell, String title, String name, String description, String iconUrl, String group, boolean showRes, IPrefixProvider prefixProvider, ResourceManager resourceManager) {
            super(parentShell, title, iconUrl, prefixProvider, resourceManager);
            this.fName = name;
            this.fDescription = description;
            this.fGroup = group;
            this.fShowRes = showRes;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    String n;
                    if ((AddEditStateDialog.this.fName == null || "".equals(AddEditStateDialog.this.fName.trim())) && AddEditStateDialog.this.fNameField != null && !AddEditStateDialog.this.fNameField.isDisposed() && (n = AddEditStateDialog.this.fNameField.getText()).trim().equals("")) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.StatesPart_EMPTY_NAME);
                    }
                    if (AddEditStateDialog.this.fGroup == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.StatesPart_NO_GROUP);
                    }
                    if (AddEditStateDialog.this.getIconUrl() == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.StatesPart_NO_ICON);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected void okPressed() {
            this.fName = this.fNameField.getText();
            super.okPressed();
        }

        protected void iconChanged() {
            this.validate();
        }

        public String getName() {
            return this.fName.trim();
        }

        public String getGroup() {
            return this.fGroup;
        }

        public String getDescription() {
            if (this.fDescription != null) {
                return this.fDescription.trim();
            }
            return this.fDescription;
        }

        public boolean getShowRes() {
            return this.fShowRes;
        }

        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.StatesPart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(parent, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditStateDialog.this.fName = AddEditStateDialog.this.fNameField.getText();
                    AddEditStateDialog.this.validate();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.StatesPart_DESCRIPTION);
            l.setLayoutData((Object)new GridData(4, 128, false, false));
            this.fDescriptionField = new Text(parent, 2112);
            if (this.fDescription != null) {
                this.fDescriptionField.setText(this.fDescription);
            }
            GridData data = new GridData(4, 4, true, false);
            GC gc = new GC((Drawable)l);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)2);
            gc.dispose();
            this.fDescriptionField.setLayoutData((Object)data);
            this.fDescriptionField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditStateDialog.this.fDescription = AddEditStateDialog.this.fDescriptionField.getText();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.StatesPart_RESOLUTION);
            l.setLayoutData((Object)new GridData());
            final Button b = new Button(parent, 32);
            b.setLayoutData((Object)new GridData());
            b.setSelection(this.fShowRes);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddEditStateDialog.this.fShowRes = b.getSelection();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.StatesPart_GROUP);
            l.setLayoutData((Object)new GridData());
            this.fGroupCombo = new Combo(parent, 8);
            AspectEditorUtil.adaptCombo(this.fGroupCombo);
            this.fGroupCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fGroupCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = AddEditStateDialog.this.fGroupCombo.getSelectionIndex();
                    if (index == 0) {
                        AddEditStateDialog.this.fGroup = null;
                    } else {
                        AddEditStateDialog.this.fGroup = (String)GROUPS.get(index);
                    }
                    AddEditStateDialog.this.validate();
                }
            });
            for (String g : GROUPNAMES) {
                this.fGroupCombo.add(g);
            }
            int index = -1;
            if (this.fGroup != null) {
                index = GROUPS.indexOf(this.fGroup);
            }
            if (index == -1) {
                index = 0;
            }
            this.fGroupCombo.select(index);
        }
    }
}

