/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.type;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IconsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorIdBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.WorkitemTypeEditorIdBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.CustomAttributesPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypePart;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAspectEditor
extends AbstractWorkItemAspectEditor
implements IPrefixProvider {
    private static final String ENUMERATIONS = "com.ibm.team.workitem.configuration.enumerations";
    private static final String EDITOR_ID_BINDINGS = "com.ibm.team.workitem.editor.configuration.workitemTypeEditorIdBinding";
    private static final String ERROR_RETRIEVING_ATTRIBUTES = Messages.TypeAspectEditor_ERROR_RETRIEVING_ATTRIBUTES;
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.TypeAspectEditor_CHOOSE_TYPE_CATEGORY;
        }

        public String getSameIdMessage() {
            return Messages.TypeAspectEditor_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.TypeAspectEditor_ENTER_TC_ID;
        }
    };
    private ManagedForm fManagedForm;
    private List<String> fEnumerationTypes;
    private HashSet<TypeCategory.CustomAttribute> fRepositoryAttributes;
    public static String TYPE_PREFIX = "workitemtype";
    private CustomAttributesPart fCustomPart;
    private List<EditorIdBinding> fBindings;
    private TypePart fTypePart;

    public TypeAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.work_item_type_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        TypeManager.writeTypeCategories(memento, elements);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fTypePart = new TypePart(this, this, this);
        TeamFormSectionPart typeSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 322, Messages.TypeAspectEditor_WORK_ITEM_TYPES, new TeamFormPart[]{this.fTypePart});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        typeSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)typeSection);
        this.fCustomPart = new CustomAttributesPart(this, this);
        TeamFormSectionPart customSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 322, Messages.TypeAspectEditor_CUSTOM_ATTRIBUTES, new TeamFormPart[]{this.fCustomPart});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)typeSection.getSection());
        customSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)customSection);
        this.fCustomPart.setTemplate(this.getProcessContainerWorkingCopy().getUnderlyingProcessItem() instanceof IProcessDefinition);
        IconsPart icons = new IconsPart(this);
        TeamFormSectionPart iconsSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 258, Messages.TypeAspectEditor_ICONS, new TeamFormPart[]{icons});
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)customSection.getSection());
        formData.bottom = new FormAttachment(100);
        iconsSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)iconsSection);
        this.fTypePart.setBindings(this.fBindings);
    }

    @Override
    protected ModeledElement createNewElement() {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.TypeAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager());
        if (d.open() != 0) {
            return null;
        }
        TypeCategory category = new TypeCategory(d.getId());
        category.setSortedTypes(TypeManager.findSortedTypesList(this.getAllCategories()));
        category.setAttributeDefinitions(TypeManager.findAttributeDefinitions(this.getAllCategories()));
        return category;
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fManagedForm.setInput((Object)newElement);
        this.fCustomPart.setEnumerationTypes(this.fEnumerationTypes);
        this.fCustomPart.setRepositoryAttributes(this.fRepositoryAttributes);
        this.fManagedForm.reflow(true);
    }

    void needReflow() {
        if (this.fManagedForm != null) {
            this.fManagedForm.reflow(true);
        }
    }

    List<TypeCategory> getAllCategories() {
        return this.getAllElements();
    }

    public void updateLabels() {
        this.updateComboLabels();
    }

    private List<String> readEnumerationTypes() {
        ArrayList<String> enums = new ArrayList<String>();
        ModelElement enumElement = this.getSite().getConfigurationData(ENUMERATIONS);
        if (enumElement != null) {
            for (ModelElement enu : enumElement.getChildElements()) {
                String enumeration = enu.getAttribute("attributeTypeId");
                if (enumeration == null) continue;
                enums.add(enumeration);
            }
        }
        return enums;
    }

    private List<EditorIdBinding> readBindings(List<TypeCategory> categories) {
        ArrayList<EditorIdBinding.Type> types = new ArrayList<EditorIdBinding.Type>();
        for (TypeCategory cat : categories) {
            for (TypeCategory.Type t : cat.getTypes()) {
                types.add(new EditorIdBinding.Type(t.getId(), t.getName()));
            }
        }
        return WorkitemTypeEditorIdBindingManager.readEditorIdBindings(this.getSite().getConfigurationData(EDITOR_ID_BINDINGS), types);
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        this.fEnumerationTypes = this.readEnumerationTypes();
        List<TypeCategory> categories = TypeManager.readTypeCategories(configurationElement);
        this.fBindings = this.readBindings(categories);
        if (this.fTypePart != null) {
            this.fTypePart.setBindings(this.fBindings);
        }
        if (this.fCustomPart != null) {
            this.fCustomPart.setTemplate(this.getProcessContainerWorkingCopy().getUnderlyingProcessItem() instanceof IProcessDefinition);
        }
        this.computeRepositoryAttributes();
        return categories;
    }

    void updateRepositoryAttributes() {
        this.computeRepositoryAttributes();
        this.fCustomPart.setRepositoryAttributes(this.fRepositoryAttributes);
    }

    private void computeRepositoryAttributes() {
        final IProcessItem processItem = this.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final ArrayList attributes = new ArrayList();
        if (processItem instanceof IProcessArea) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IProcessArea processArea = (IProcessArea)processItem;
                        ITeamRepository teamRepository = (ITeamRepository)processItem.getOrigin();
                        IWorkItemClient workitemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                        try {
                            attributes.addAll(workitemClient.findAttributes(processArea.getProjectArea(), monitor));
                        }
                        catch (TeamRepositoryException e) {
                            WorkItemIDEUIPlugin.getDefault().log(ERROR_RETRIEVING_ATTRIBUTES, e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                WorkItemIDEUIPlugin.getDefault().log(ERROR_RETRIEVING_ATTRIBUTES, e);
            }
            catch (InterruptedException e) {
                WorkItemIDEUIPlugin.getDefault().log(ERROR_RETRIEVING_ATTRIBUTES, e);
            }
        }
        this.fRepositoryAttributes = new HashSet();
        for (IAttribute attr : attributes) {
            this.fRepositoryAttributes.add(new TypeCategory.CustomAttribute(attr.getIdentifier(), attr.getDisplayName(), attr.getAttributeType(), false, !attr.isBuiltIn(), attr.isReadOnly(), null));
        }
    }

    @Override
    public String getIconPrefix() {
        return "/" + TYPE_PREFIX;
    }

    @Override
    public ITeamRepository getRepository() {
        return (ITeamRepository)this.getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin();
    }

    @Override
    public IProcessContainerWorkingCopy getProcessContainer() {
        return this.getProcessContainerWorkingCopy();
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }
}

