/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

public class SharedTemplateLabelProvider
extends CellLabelProvider {
    private final OverlayIcon fTemplateWithError;
    private ResourceManager fResourceManager;

    public SharedTemplateLabelProvider() {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.ERROR_OVR;
        this.fTemplateWithError = new OverlayIcon(ImagePool.WORKITEM_TEMPLATE_ICON, imageDescriptorArray, 16512);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public boolean isLabelProperty(Object element, String property) {
        return !"name".equals(property);
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof SharedTemplate) {
            SharedTemplate template = (SharedTemplate)cell.getElement();
            cell.setText(template.getName());
            if (template.getIdentifier().length() == 0 || template.getPath().length() == 0 || template.getName().length() == 0) {
                cell.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)this.fTemplateWithError));
            } else {
                cell.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.WORKITEM_TEMPLATE_ICON));
            }
        }
    }

    public void dispose() {
        this.fResourceManager.dispose();
        super.dispose();
    }
}

