/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates;

import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.AbstractQueryAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplate;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplateContentProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplateDetailsSection;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplateLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplateManager;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedTemplateAspectEditor
extends AbstractQueryAspectEditor {
    private final String fProcessAspectId;
    private final Set<String> fChangedTemplates;
    private TableViewer fTableViewer;
    private SharedTemplateManager fTemplateManager;
    private SharedTemplateManager.IChangeListener fChangeListener;
    private Button fRemoveButton;

    public SharedTemplateAspectEditor(String processAspectId) {
        this.fProcessAspectId = processAspectId;
        this.fChangedTemplates = new HashSet<String>();
    }

    @Override
    protected void initialize(ProcessAspect aspect) {
        this.fTemplateManager = new SharedTemplateManager(aspect, this.fProcessAspectId);
        this.fChangeListener = new SharedTemplateManager.IChangeListener(){

            public void dirtyStateChanged(boolean dirty) {
                SharedTemplateAspectEditor.this.updateInput();
                SharedTemplateAspectEditor.this.setDirty(dirty);
            }

            public void templateChanged(SharedTemplate template, String[] properties) {
                if (SharedTemplateAspectEditor.this.fTableViewer != null) {
                    SharedTemplateAspectEditor.this.fTableViewer.update((Object)template, properties);
                }
                if (template.getIdentifier().length() > 0) {
                    SharedTemplateAspectEditor.this.fChangedTemplates.add(template.getIdentifier());
                    SharedTemplateAspectEditor.this.setDirty(true);
                }
            }

            public void templateStructureChanged() {
                if (SharedTemplateAspectEditor.this.fTableViewer != null) {
                    SharedTemplateAspectEditor.this.fTableViewer.refresh();
                }
                SharedTemplateAspectEditor.this.fRemoveButton.setEnabled(!SharedTemplateAspectEditor.this.fTemplateManager.getTemplates().isEmpty());
            }
        };
        this.fTemplateManager.addListener(this.fChangeListener);
        this.updateInput();
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Section section = toolkit.createSection(parent, 256);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        section.setText(Messages.SharedTemplateAspectEditor_SECTION_NAME);
        this.createSharedTemplateSection(container, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        Section detailsSection = toolkit.createSection(parent, 256);
        Composite detailsContainer = toolkit.createComposite((Composite)detailsSection);
        detailsSection.setClient((Control)detailsContainer);
        detailsSection.setText(Messages.SharedTemplateAspectEditor_DETAILS_SECTION_NAME);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)detailsSection);
        SharedTemplateDetailsSection details = new SharedTemplateDetailsSection(this.fChangeListener);
        details.createContent(detailsContainer, toolkit);
        this.fTableViewer.addSelectionChangedListener((ISelectionChangedListener)details);
        this.updateInput();
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.ide.ui.predefined_query_aspect_editor");
    }

    @Override
    protected void applyChanges() {
        if (this.fTemplateManager != null) {
            this.fTemplateManager.applyChanges(this.fChangedTemplates);
            this.fChangedTemplates.clear();
        }
    }

    @Override
    protected void revertChanges() {
        if (this.fTemplateManager != null) {
            this.fTemplateManager.revertChanges();
        }
    }

    private void updateInput() {
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput((Object)this.fTemplateManager);
        }
    }

    private void createSharedTemplateSection(Composite composite, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Table table = toolkit.createTable(composite, 2050);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new SharedTemplateContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new SharedTemplateLabelProvider());
        Composite buttonComposite = toolkit.createComposite(composite);
        Button addButton = toolkit.createButton(buttonComposite, Messages.SharedTemplateAspectEditor_ADD, 8);
        addButton.setEnabled(false);
        addButton.setToolTipText(Messages.SharedTemplateAspectEditor_ADD_TOOLTIP);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                throw new UnsupportedOperationException();
            }
        });
        this.fRemoveButton = toolkit.createButton(buttonComposite, Messages.SharedTemplateAspectEditor_REMOVE, 8);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection selection = (IStructuredSelection)SharedTemplateAspectEditor.this.fTableViewer.getSelection();
                SharedTemplateAspectEditor.this.fTemplateManager.removeTemplates(selection.toList());
            }
        });
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.fill = true;
        buttonComposite.setLayout((Layout)buttonLayout);
        int minWidth = Utils.convertWidthInCharsToPixels((Control)table, (int)25);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, buttonLayout.marginTop).hint(minWidth, -1).applyTo((Control)table);
        GridDataFactory.swtDefaults().align(4, 1).applyTo((Control)buttonComposite);
    }

    private List<IProjectAreaHandle> getProjectAreas(IProcessItemHandle processItem) {
        if (processItem instanceof IProjectAreaHandle) {
            return Collections.singletonList((IProjectAreaHandle)processItem);
        }
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas((ITeamRepository)processItem.getOrigin());
    }
}

