/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import com.ibm.team.workitem.rcp.ui.internal.util.DefaultCheckStateBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateBasedModificationEditor
extends OperationDetailsAspectEditor {
    private TreeElement fRoot;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private CheckboxTreeViewer fTreeViewer;
    private Button fAllowActionsCheckBox;
    private List<WFWorkflow> fWorkflows;
    private List<WorkflowBinding> fBindings;
    private List<TypeCategory> fTypeCategories;
    private Map<String, Map<String, List<WFWorkflow.WFAction>>> fStateActionMaps = new HashMap<String, Map<String, List<WFWorkflow.WFAction>>>();
    private IMemento fStateToRestore;

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Label label = toolkit.createLabel(parent, Messages.StateBasedModificationEditor_PREVENT_CHANGES);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        Tree tree = toolkit.createTree(parent, 67616);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        CheckboxTreeViewer treeViewer = this.fTreeViewer = new CheckboxTreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new TreeElementContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new TreeElementLabelProvider((ILabelProvider)new AspectEditorLabelProvider(this.getAspect(), this.fResourceManager)));
        Composite buttonComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(buttonComposite);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        this.createButtons(buttonComposite, toolkit);
        this.installTreeListeners(treeViewer);
        this.fAllowActionsCheckBox = toolkit.createButton(parent, Messages.StateBasedModificationEditor_ALLOW_ACTIONS, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fAllowActionsCheckBox);
        this.fAllowActionsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateBasedModificationEditor.this.setDirty();
            }
        });
        this.init();
    }

    private void init() {
        this.fRoot = this.buildTree();
        this.fTreeViewer.setInput((Object)this.fRoot);
        if (this.fStateToRestore != null) {
            this.restore(this.fStateToRestore);
        }
    }

    private void installTreeListeners(CheckboxTreeViewer treeViewer) {
        DefaultCheckStateBehavior.install((Tree)treeViewer.getTree());
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                StateBasedModificationEditor.this.setDirty();
            }
        });
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        Button selectAll = toolkit.createButton(parent, Messages.StateBasedModificationEditor_SELECT_ALL, 8);
        GridDataFactory.fillDefaults().applyTo((Control)selectAll);
        Button deselectAll = toolkit.createButton(parent, Messages.StateBasedModificationEditor_DESELECT_ALL, 8);
        GridDataFactory.fillDefaults().applyTo((Control)deselectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateBasedModificationEditor.this.selectAll();
            }
        });
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateBasedModificationEditor.this.deselectAll();
            }
        });
    }

    private void selectAll() {
        this.fTreeViewer.setCheckedElements(this.fRoot.getAllChildren().toArray());
        this.setDirty();
    }

    private void deselectAll() {
        this.fTreeViewer.setCheckedElements(new Object[0]);
        this.setDirty();
    }

    public boolean saveState(IMemento memento) {
        IMemento checks = memento.createChild("checks");
        this.saveState(checks, this.fTreeViewer.getTree().getItems());
        IMemento options = memento.createChild("options");
        options.putBoolean("allowActions", this.fAllowActionsCheckBox.getSelection());
        return true;
    }

    private void saveState(IMemento checks, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeElement element = (TreeElement)item.getData();
            if (item.getChecked() && !item.getGrayed()) {
                IMemento rule = checks.createChild("check");
                TreeElement parent = element;
                while (parent != null) {
                    this.addToMemento(rule, parent);
                    parent = parent.getParent();
                }
            } else {
                this.saveState(checks, item.getItems());
            }
            ++n2;
        }
    }

    private void addToMemento(IMemento memento, TreeElement element) {
        Object realElement = element.getElement();
        if (realElement instanceof TypeCategory.Type) {
            memento.putString("type", ((TypeCategory.Type)realElement).getIdentifier());
        } else if (realElement instanceof WFWorkflow.WFState) {
            memento.putString("state", ((WFWorkflow.WFState)realElement).getIdentifier());
        } else if (realElement instanceof WFWorkflow.WFResolution) {
            memento.putString("resolution", ((WFWorkflow.WFResolution)realElement).getIdentifier());
        }
    }

    public void restoreState(IMemento memento) {
        this.fStateToRestore = memento;
    }

    private void restore(IMemento memento) {
        IMemento options;
        IMemento checks = memento.getChild("checks");
        if (checks != null) {
            this.restoreTree(checks);
        }
        boolean checked = (options = memento.getChild("options")) != null && Boolean.TRUE.equals(options.getBoolean("allowActions"));
        this.fAllowActionsCheckBox.setSelection(checked);
    }

    private void restoreTree(IMemento memento) {
        IMemento[] checks;
        ArrayList<TreeElement> checkedElements = new ArrayList<TreeElement>();
        IMemento[] iMementoArray = checks = memento.getChildren("check");
        int n = checks.length;
        int n2 = 0;
        while (n2 < n) {
            String resolution;
            String state;
            IMemento check = iMementoArray[n2];
            String type = check.getString("type");
            TreeElement element = this.findElement(type, state = check.getString("state"), resolution = check.getString("resolution"));
            if (element != null) {
                checkedElements.add(element);
            }
            ++n2;
        }
        this.fTreeViewer.setCheckedElements(checkedElements.toArray());
        if (checkedElements.size() > 0) {
            this.fTreeViewer.reveal(checkedElements.get(0));
            DefaultCheckStateBehavior.checkTree((Tree)this.fTreeViewer.getTree());
        }
    }

    private TreeElement findElement(String type, String state, String resolution) {
        TreeElement typeElement = this.find(this.fRoot, type);
        if (state == null) {
            return typeElement;
        }
        TreeElement stateElement = this.find(typeElement, state);
        if (resolution == null) {
            return stateElement;
        }
        return this.find(stateElement, resolution);
    }

    private TreeElement find(TreeElement root, String id) {
        if (root != null) {
            for (TreeElement element : root.getChildren()) {
                ModeledElement modeledElement = (ModeledElement)element.getElement();
                if (!modeledElement.getIdentifier().equals(id)) continue;
                return element;
            }
        }
        return null;
    }

    private TreeElement buildTree() {
        TreeElement root = new TreeElement(null, null);
        for (TypeCategory typeCategory : this.getTypeCategories()) {
            List<WFWorkflow.WFState> states = this.getStates(typeCategory);
            for (TypeCategory.Type type : typeCategory.getTypes()) {
                TreeElement typeElement = root.addChild(type);
                for (WFWorkflow.WFState state : states) {
                    TreeElement stateElement = typeElement.addChild(state);
                    for (WFWorkflow.WFResolution resolution : this.getResolutions(typeCategory, state)) {
                        if (stateElement.contains(resolution)) continue;
                        stateElement.addChild(resolution);
                    }
                }
            }
        }
        return root;
    }

    private List<WFWorkflow.WFState> getStates(TypeCategory typeCategory) {
        String workflowId = this.getWorkflowId(typeCategory);
        WFWorkflow workflow = this.getWorkflow(workflowId);
        return workflow != null ? workflow.getStates() : Collections.emptyList();
    }

    private List<WFWorkflow.WFResolution> getResolutions(TypeCategory typeCategory, WFWorkflow.WFState state) {
        ArrayList<WFWorkflow.WFResolution> resolutions = new ArrayList<WFWorkflow.WFResolution>();
        List<WFWorkflow.WFAction> actions = this.getStateActionMap(typeCategory).get(state.getIdentifier());
        if (actions != null) {
            for (WFWorkflow.WFAction action : actions) {
                resolutions.addAll(action.getResolutions());
            }
        }
        return resolutions;
    }

    private Map<String, List<WFWorkflow.WFAction>> getStateActionMap(TypeCategory typeCategory) {
        Map<String, List<WFWorkflow.WFAction>> map = this.fStateActionMaps.get(typeCategory.getIdentifier());
        if (map == null) {
            map = new HashMap<String, List<WFWorkflow.WFAction>>();
            String workflowId = this.getWorkflowId(typeCategory);
            WFWorkflow workflow = this.getWorkflow(workflowId);
            for (WFWorkflow.WFAction action : workflow.getActions()) {
                WFWorkflow.WFState state = action.getTargetState();
                List<WFWorkflow.WFAction> actions = map.get(state.getIdentifier());
                if (actions == null) {
                    actions = new ArrayList<WFWorkflow.WFAction>(2);
                    map.put(state.getIdentifier(), actions);
                }
                actions.add(action);
            }
        }
        return map;
    }

    private WFWorkflow getWorkflow(String workflowId) {
        for (WFWorkflow workflow : this.getWorkflows()) {
            if (!workflow.getId().equals(workflowId)) continue;
            return workflow;
        }
        return null;
    }

    private String getWorkflowId(TypeCategory typeCategory) {
        for (WorkflowBinding binding : this.getWorkflowBindings()) {
            if (!binding.getCategoryId().equals(typeCategory.getIdentifier())) continue;
            return binding.getWorkflowId();
        }
        return null;
    }

    private List<WFWorkflow> getWorkflows() {
        if (this.fWorkflows == null) {
            ModelElement workflowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
            this.fWorkflows = workflowElement != null ? WorkflowManager.readWorkflows(workflowElement) : Collections.emptyList();
        }
        return this.fWorkflows;
    }

    private List<WorkflowBinding> getWorkflowBindings() {
        if (this.fBindings == null) {
            ModelElement bindingElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding");
            this.fBindings = bindingElement != null ? WorkflowBindingManager.readWorkflowBindings(bindingElement) : Collections.emptyList();
        }
        return this.fBindings;
    }

    private List<TypeCategory> getTypeCategories() {
        if (this.fTypeCategories == null) {
            ModelElement workItemTypes = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
            this.fTypeCategories = workItemTypes != null ? TypeManager.readTypeCategories(workItemTypes) : Collections.emptyList();
        }
        return this.fTypeCategories;
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeElement {
        private final TreeElement fParent;
        private final Object fElement;
        private final List<TreeElement> fChildren;

        public TreeElement(TreeElement parent, Object element) {
            this.fParent = parent;
            this.fElement = element;
            this.fChildren = new ArrayList<TreeElement>();
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public TreeElement addChild(Object child) {
            TreeElement element = new TreeElement(this, child);
            this.fChildren.add(element);
            return element;
        }

        public List<TreeElement> getChildren() {
            return this.fChildren;
        }

        public Object getElement() {
            return this.fElement;
        }

        public TreeElement getParent() {
            return this.fParent;
        }

        public List<TreeElement> getAllChildren() {
            ArrayList<TreeElement> allElements = new ArrayList<TreeElement>();
            for (TreeElement child : this.fChildren) {
                allElements.add(child);
                allElements.addAll(child.getAllChildren());
            }
            return allElements;
        }

        public boolean contains(Object object) {
            for (TreeElement child : this.fChildren) {
                if (!child.getElement().equals(object)) continue;
                return true;
            }
            return false;
        }
    }

    private static class TreeElementContentProvider
    implements ITreeContentProvider {
        private TreeElementContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TreeElement) {
                return ((TreeElement)inputElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeElement) {
                return ((TreeElement)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TreeElement) {
                return ((TreeElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeElement) {
                return ((TreeElement)element).hasChildren();
            }
            return false;
        }

        public void dispose() {
        }
    }

    private static class TreeElementLabelProvider
    extends CellLabelProvider {
        private ILabelProvider fLabelProvider;

        public TreeElementLabelProvider(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof TreeElement) {
                TreeElement treeElement = (TreeElement)element;
                Object realElement = treeElement.getElement();
                cell.setText(this.fLabelProvider.getText(realElement));
                cell.setImage(this.fLabelProvider.getImage(realElement));
            }
        }
    }
}

