/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredApprovalsEditor
extends OperationDetailsAspectEditor {
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private TreeViewer fApprovalsViewer;
    private List<TypeCategory.Type> fTypes = new ArrayList<TypeCategory.Type>();
    private Map<TypeState, List<RequiredApproval>> fRequiredApprovals;
    private List<WFWorkflow> fWorkflows;
    private List<WorkflowBinding> fBindings;
    private Map<TypeCategory.Type, List<TypeState>> fTypeWorkflowMap = new HashMap<TypeCategory.Type, List<TypeState>>();
    private TypeCategory fUnspecified;
    private List<TypeCategory> fTypeCategories;

    public void restoreState(IMemento memento) {
        this.fRequiredApprovals = new HashMap<TypeState, List<RequiredApproval>>();
        IMemento[] iMementoArray = memento.getChildren("approval");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            WFWorkflow.WFState s;
            IMemento approvals = iMementoArray[n2];
            String workItemType = approvals.getString("workItemType");
            String stateId = approvals.getString("stateId");
            TypeCategory.Type type = this.findType(workItemType);
            if (type == null) {
                type = this.createTypeInUnspecifiedCategory(workItemType);
            }
            if ((s = this.getState(type, stateId)) != null) {
                TypeState typeState = this.findOrCreateTypeState(type, s);
                String approvalType = approvals.getString("approvalType");
                String approvalState = approvals.getString("approvalState");
                RequiredApproval approval = new RequiredApproval(approvalType, approvalState);
                if (this.fRequiredApprovals.get(typeState) == null) {
                    this.fRequiredApprovals.put(typeState, new ArrayList());
                }
                this.fRequiredApprovals.get(typeState).add(approval);
            }
            ++n2;
        }
    }

    private TypeCategory.Type createTypeInUnspecifiedCategory(String typeId) {
        if (this.fUnspecified == null) {
            this.fUnspecified = new TypeCategory("unspecified");
        }
        TypeCategory typeCategory = this.fUnspecified;
        typeCategory.getClass();
        TypeCategory.Type type = new TypeCategory.Type(typeCategory, typeId, typeId, null, null, new ArrayList<String>());
        this.fUnspecified.addType(type);
        this.fTypes.add(type);
        return type;
    }

    private TypeCategory.Type findType(String typeId) {
        if (this.fTypes == null || typeId == null) {
            return null;
        }
        for (TypeCategory.Type t : this.fTypes) {
            if (!t.getId().equals(typeId)) continue;
            return t;
        }
        return null;
    }

    private TypeState findOrCreateTypeState(TypeCategory.Type type, WFWorkflow.WFState state) {
        TypeState ts2;
        List<TypeState> list = this.fTypeWorkflowMap.get(type);
        if (list != null) {
            for (TypeState ts2 : list) {
                if (ts2.getState() != state) continue;
                return ts2;
            }
        }
        ts2 = new TypeState(type, state);
        if (this.fTypeWorkflowMap.get(type) == null) {
            this.fTypeWorkflowMap.put(type, new ArrayList());
        }
        this.fTypeWorkflowMap.get(type).add(ts2);
        return ts2;
    }

    private void initializeWorkflows() {
        ModelElement workflowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        this.fWorkflows = workflowElement != null ? WorkflowManager.readWorkflows(workflowElement) : Collections.emptyList();
        ModelElement bindingElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding");
        this.fBindings = bindingElement != null ? WorkflowBindingManager.readWorkflowBindings(bindingElement) : Collections.emptyList();
    }

    private String findCategory(String type) {
        for (TypeCategory tc : this.fTypeCategories) {
            for (TypeCategory.Type t : tc.getTypes()) {
                if (!t.getIdentifier().equals(type)) continue;
                return tc.getIdentifier();
            }
        }
        return null;
    }

    private WFWorkflow.WFState getState(TypeCategory.Type type, String stateId) {
        if (this.fWorkflows == null) {
            this.initializeWorkflows();
        }
        String categoryId = this.findCategory(type.getIdentifier());
        String workflowId = null;
        for (WorkflowBinding b : this.fBindings) {
            if (!b.getCategoryId().equals(categoryId)) continue;
            workflowId = b.getWorkflowId();
            break;
        }
        for (WFWorkflow w : this.fWorkflows) {
            if (!w.getIdentifier().equals(workflowId)) continue;
            for (WFWorkflow.WFState s : w.getStates()) {
                if (!s.getId().equals(stateId)) continue;
                return s;
            }
        }
        return null;
    }

    public boolean saveState(IMemento memento) {
        if (this.fRequiredApprovals.isEmpty()) {
            return false;
        }
        for (Map.Entry<TypeState, List<RequiredApproval>> e : this.fRequiredApprovals.entrySet()) {
            TypeState typeState = e.getKey();
            List<RequiredApproval> requiredApprovals = e.getValue();
            for (RequiredApproval app : requiredApprovals) {
                IMemento approval = memento.createChild("approval");
                approval.putString("workItemType", typeState.getType().getIdentifier());
                approval.putString("stateId", typeState.getState().getId());
                approval.putString("approvalType", app.getApprovalType());
                approval.putString("approvalState", app.getApprovalState());
            }
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Tree t = new Tree(parent, 67586);
        t.setLayoutData((Object)new GridData(4, 4, true, true));
        t.setHeaderVisible(true);
        TreeColumn c = new TreeColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(Messages.RequiredApprovalsEditor_WORKITEM_TYPE);
        c = new TreeColumn(t, 0);
        c.setWidth(200);
        c.setResizable(true);
        c.setText(Messages.RequiredApprovalsEditor_REQUIRED_APPROVALS);
        this.fApprovalsViewer = new TreeViewer(t);
        this.fApprovalsViewer.setColumnProperties(new String[]{"type", "approval"});
        this.fApprovalsViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (cell.getColumnIndex() == 0 && element instanceof TypeCategory.Type) {
                    if (((TypeCategory.Type)element).getIcon() != null) {
                        cell.setImage(this.getImage(element, ((TypeCategory.Type)element).getIcon()));
                    } else {
                        cell.setImage(null);
                    }
                    cell.setText(((TypeCategory.Type)element).getName());
                } else if (cell.getColumnIndex() == 0 && element instanceof TypeState) {
                    TypeState state = (TypeState)element;
                    cell.setText(state.getState().getName());
                    if (state.getState().getIcon() != null) {
                        cell.setImage(this.getImage(element, state.getState().getIcon()));
                    } else {
                        cell.setImage(null);
                    }
                } else if (cell.getColumnIndex() == 1) {
                    if (element instanceof TypeState) {
                        List approvals = (List)RequiredApprovalsEditor.this.fRequiredApprovals.get(element);
                        String text = this.getText(approvals);
                        cell.setText(text);
                    } else if (element instanceof TypeCategory.Type) {
                        List states = RequiredApprovalsEditor.this.findTypeStates((TypeCategory.Type)element);
                        String text = "";
                        int i = 0;
                        while (i < states.size()) {
                            TypeState typeState = (TypeState)states.get(i);
                            if (RequiredApprovalsEditor.this.fRequiredApprovals.get(typeState) != null && !((List)RequiredApprovalsEditor.this.fRequiredApprovals.get(typeState)).isEmpty()) {
                                text = NLS.bind((String)Messages.RequiredApprovalsEditor_LIST_OF_STATES, (Object)text, (Object[])new Object[]{typeState.getState().getName()});
                            }
                            ++i;
                        }
                        if (text.length() > 0) {
                            text = text.substring(2);
                            text = NLS.bind((String)Messages.RequiredApprovalsEditor_CONFIGURED_STATES, (Object)text, (Object[])new Object[0]);
                        }
                        cell.setText(text);
                    } else {
                        cell.setText("");
                    }
                }
            }

            private String getText(List<RequiredApproval> approvals) {
                String result = "";
                if (approvals == null) {
                    return result;
                }
                int i = 0;
                while (i < approvals.size()) {
                    RequiredApproval approval = approvals.get(i);
                    if (i > 0) {
                        result = NLS.bind((String)Messages.RequiredApprovalsEditor_SEMICOLON_SEPARATOR, (Object)result, (Object[])new Object[0]);
                    }
                    result = NLS.bind((String)Messages.RequiredApprovalsEditor_LIST_OF_APPROVALS, (Object)result, (Object[])new Object[]{this.getApprovalText(approval)});
                    ++i;
                }
                return result;
            }

            private String getApprovalText(RequiredApproval approval) {
                IApprovalType type = WorkItemApprovals.getType((String)approval.getApprovalType());
                String typeName = null;
                if (type != null) {
                    typeName = type.getDisplayName();
                }
                if (typeName == null) {
                    typeName = approval.getApprovalType();
                }
                IApprovalState state = WorkItemApprovals.getState((String)approval.getApprovalState());
                String stateName = null;
                if (state != null) {
                    stateName = state.getDisplayName();
                }
                if (stateName == null) {
                    stateName = approval.getApprovalState();
                }
                return NLS.bind((String)Messages.RequiredApprovalsEditor_APPROVAL_SEPARATOR, (Object)typeName, (Object[])new Object[]{stateName});
            }

            private Image getImage(final Object element, String iconPath) {
                return AspectEditorUtil.getImage(RequiredApprovalsEditor.this.getAspect().getProcessContainerWorkingCopy(), iconPath, RequiredApprovalsEditor.this.fResourceManager, new Runnable(){

                    public void run() {
                        this.fireChanged(element);
                    }
                });
            }

            private void fireChanged(Object element) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
            }
        });
        this.fApprovalsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                List list;
                if (parentElement instanceof TypeCategory.Type && (list = RequiredApprovalsEditor.this.findTypeStates((TypeCategory.Type)parentElement)) != null) {
                    return list.toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                if (RequiredApprovalsEditor.this.fTypes != null) {
                    return RequiredApprovalsEditor.this.fTypes.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fApprovalsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RequiredApprovalsEditor.this.editTypeState((IStructuredSelection)event.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action edit = new Action(Messages.RequiredApprovalsEditor_EDIT){

            public void run() {
                RequiredApprovalsEditor.this.editTypeState((IStructuredSelection)RequiredApprovalsEditor.this.fApprovalsViewer.getSelection());
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)edit){
            private final /* synthetic */ IAction val$edit;
            {
                this.val$edit = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (RequiredApprovalsEditor.this.fApprovalsViewer != null && ((IStructuredSelection)RequiredApprovalsEditor.this.fApprovalsViewer.getSelection()).size() == 1) {
                    manager.add(this.val$edit);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fApprovalsViewer.getControl());
        this.fApprovalsViewer.getControl().setMenu(menu);
        final Button editButton = toolkit.createButton(parent, Messages.RequiredApprovalsEditor_EDIT, 0x800000);
        GridData data = new GridData(0x1000000, 128, false, false);
        data.verticalIndent = this.fApprovalsViewer.getTree().getHeaderHeight();
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredApprovalsEditor.this.editTypeState((IStructuredSelection)RequiredApprovalsEditor.this.fApprovalsViewer.getSelection());
            }
        });
        editButton.setEnabled(false);
        this.fApprovalsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!editButton.isDisposed()) {
                    editButton.setEnabled(((IStructuredSelection)RequiredApprovalsEditor.this.fApprovalsViewer.getSelection()).size() == 1);
                }
            }
        });
        this.fApprovalsViewer.setInput(this.fTypes);
    }

    private List<TypeState> findTypeStates(TypeCategory.Type type) {
        if (this.fWorkflows == null) {
            this.initializeWorkflows();
        }
        String categoryId = this.findCategory(type.getIdentifier());
        String workflowId = null;
        for (WorkflowBinding b : this.fBindings) {
            if (!b.getCategoryId().equals(categoryId)) continue;
            workflowId = b.getWorkflowId();
            break;
        }
        for (WFWorkflow w : this.fWorkflows) {
            if (!w.getIdentifier().equals(workflowId)) continue;
            ArrayList<TypeState> result = new ArrayList<TypeState>();
            for (WFWorkflow.WFState s : w.getStates()) {
                TypeState ts = this.findOrCreateTypeState(type, s);
                result.add(ts);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void editTypeState(IStructuredSelection selection) {
        ModeledElement element = (ModeledElement)selection.getFirstElement();
        if (!(element instanceof TypeState)) {
            return;
        }
        TypeState typeState = (TypeState)element;
        EditApprovalsDialog d = new EditApprovalsDialog(Display.getCurrent().getActiveShell(), NLS.bind((String)Messages.RequiredApprovalsEditor_EDIT_APPROVALS_TITLE, (Object)typeState.getState().getName(), (Object[])new Object[]{typeState.getType().getName()}), typeState, this.fRequiredApprovals.get(typeState), this.fResourceManager);
        if (d.open() == 0) {
            List<RequiredApproval> approvals = d.getRequiredApprovals();
            this.fRequiredApprovals.put(typeState, approvals);
            this.setDirty();
            this.fApprovalsViewer.refresh();
        }
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    private void readCategories() {
        ModelElement workItemTypes = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        if (workItemTypes != null) {
            this.fTypeCategories = TypeManager.readTypeCategories(workItemTypes);
            for (TypeCategory category : this.fTypeCategories) {
                this.fTypes.addAll(category.getTypes());
            }
        }
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readCategories();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditApprovalsDialog
    extends ProcessAttachmentIconSelectionDialog {
        private List<RequiredApproval> fRequiredApprovals;
        private TypeState fTypeState;

        public EditApprovalsDialog(Shell parentShell, String title, TypeState typeState, List<RequiredApproval> approvals, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fRequiredApprovals = approvals == null ? new ArrayList<RequiredApproval>() : new ArrayList<RequiredApproval>(approvals);
            this.fTypeState = typeState;
        }

        @Override
        protected void iconChanged() {
            this.validate();
        }

        public List<RequiredApproval> getRequiredApprovals() {
            return this.fRequiredApprovals;
        }

        private RequiredApproval findRequiredApproval(String type, String state) {
            for (RequiredApproval r : this.fRequiredApprovals) {
                if (!r.getApprovalType().equals(type) || !r.getApprovalState().equals(state)) continue;
                return r;
            }
            return null;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Composite approvals = new Composite(parent, 0);
            approvals.setLayout((Layout)new GridLayout(1, false));
            approvals.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            Label l = new Label(approvals, 0);
            l.setText(NLS.bind((String)Messages.RequiredApprovalsEditor_EDIT_APPROVALS_MESSAGE, (Object)this.fTypeState.getState().getName(), (Object[])new Object[0]));
            for (final IApprovalType t : WorkItemApprovals.getTypes()) {
                Group group = new Group(approvals, 0);
                group.setLayout((Layout)new GridLayout());
                group.setLayoutData((Object)new GridData(4, 4, true, false));
                l = new Label((Composite)group, 0);
                l.setText(t.getDisplayName());
                for (final IApprovalState s : WorkItemApprovals.getStates()) {
                    final Button checkBox = new Button((Composite)group, 32);
                    checkBox.setText(s.getDisplayName());
                    if (this.findRequiredApproval(t.getIdentifier(), s.getIdentifier()) != null) {
                        checkBox.setSelection(true);
                    }
                    checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (checkBox.getSelection()) {
                                EditApprovalsDialog.this.fRequiredApprovals.add(new RequiredApproval(t.getIdentifier(), s.getIdentifier()));
                            } else {
                                RequiredApproval r = EditApprovalsDialog.this.findRequiredApproval(t.getIdentifier(), s.getIdentifier());
                                if (r != null) {
                                    EditApprovalsDialog.this.fRequiredApprovals.remove(r);
                                }
                            }
                        }
                    });
                }
            }
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }

    private static class RequiredApproval {
        private String fApprovalType;
        private String fApprovalState;

        public RequiredApproval(String approvalType, String approvalState) {
            this.fApprovalType = approvalType;
            this.fApprovalState = approvalState;
        }

        public String getApprovalType() {
            return this.fApprovalType;
        }

        public String getApprovalState() {
            return this.fApprovalState;
        }

        public void setApprovalType(String approvalType) {
            this.fApprovalType = approvalType;
        }

        public void setApprovalState(String approvalState) {
            this.fApprovalState = approvalState;
        }
    }

    private static class TypeState
    extends ModeledElement {
        private WFWorkflow.WFState fState;
        private ModeledElement fType;

        public TypeState(ModeledElement typeOrCategory, WFWorkflow.WFState state) {
            this.fType = typeOrCategory;
            this.fState = state;
        }

        public String getIdentifier() {
            return String.valueOf(this.fType.getIdentifier()) + "#" + this.fState.getId();
        }

        public String getName() {
            return NLS.bind((String)Messages.RequiredApprovalsEditor_TYPESTATE_NAME, (Object)this.fType.getName(), (Object[])new Object[]{this.fState.getName()});
        }

        public WFWorkflow.WFState getState() {
            return this.fState;
        }

        public ModeledElement getType() {
            return this.fType;
        }
    }
}

