/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.Quickinformation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickinformationAspectManager {
    private static final String ID = "id";
    private static final String PRESENTATION = "presentation";
    private static final String KIND = "kind";
    private static final String TITLE = "title";
    private static final String PROPERTY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String QUICKINFO = "quickinformationConfiguration";

    public static List<Quickinformation> readQuickinformations(ModelElement configurationElement) {
        ArrayList<Quickinformation> infos = new ArrayList<Quickinformation>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                infos.add(QuickinformationAspectManager.readInfo(element));
            }
        }
        return infos;
    }

    private static Quickinformation readInfo(ModelElement element) {
        String id = element.getAttribute(ID);
        Quickinformation information = new Quickinformation(id);
        for (ModelElement pres : element.getChildElements()) {
            String kind = pres.getAttribute(KIND);
            if (kind == null || kind.trim().equals("")) continue;
            Quickinformation quickinformation = information;
            quickinformation.getClass();
            Quickinformation.QuickEntry entry = quickinformation.new Quickinformation.QuickEntry(kind, pres.getAttribute(TITLE));
            for (ModelElement prop : pres.getChildElements()) {
                String key = prop.getAttribute(KEY);
                if (key == null) continue;
                String value = prop.getAttribute(VALUE);
                entry.setProperty(key, value);
            }
            information.addPresentation(entry);
        }
        return information;
    }

    public static void writeInformations(IMemento memento, List<Quickinformation> informations) {
        for (Quickinformation i : informations) {
            QuickinformationAspectManager.writeInformation(memento.createChild(QUICKINFO), i);
        }
    }

    private static void writeInformation(IMemento definition, Quickinformation information) {
        definition.putString(ID, information.getId());
        for (Quickinformation.QuickEntry e : information.getPresentations()) {
            IMemento entry = definition.createChild(PRESENTATION);
            entry.putString(TITLE, e.getTitle());
            entry.putString(KIND, e.getKind());
            for (String key : e.getPropertyKeys()) {
                IMemento prop = entry.createChild(PROPERTY);
                prop.putString(KEY, key);
                prop.putString(VALUE, e.getProperty(key));
            }
        }
    }
}

