/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.Quickinformation;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.QuickinformationAspectManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.QuickinformationAspectPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickinformationAspectEditor
extends AbstractWorkItemAspectEditor {
    private List<String> fPartIds;
    private static final String PRESENTATIONS = "com.ibm.team.workitem.editor.configuration.presentations";
    private static final String PRESENTATION = "presentation";
    private static final String SECTION = "section";
    private static final String ID = "id";
    private static final String ATTRIBUTE_ID = "attributeId";
    private static final String KIND = "kind";
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.QuickinformationAspectEditor_CHOOSE_QUICK_INFORMATION;
        }

        public String getSameIdMessage() {
            return Messages.QuickinformationAspectEditor_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.QuickinformationAspectEditor_ENTER_QI_ID;
        }
    };
    private QuickinformationAspectPart fQuick;
    private ManagedForm fManagedForm;

    QuickinformationAspectEditor(String configurationDataId) {
        super(configurationDataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.quick_information_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        QuickinformationAspectManager.writeInformations(memento, elements);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fQuick = new QuickinformationAspectPart(this);
        TeamFormSectionPart quickinformationSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.QuickinformationAspectEditor_QUICK_INFORMATION, new TeamFormPart[]{this.fQuick});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        quickinformationSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)quickinformationSection);
    }

    @Override
    protected ModeledElement createNewElement() {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.QuickinformationAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager());
        if (d.open() != 0) {
            return null;
        }
        return new Quickinformation(d.getId());
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fManagedForm.setInput((Object)newElement);
        this.fQuick.setPartIds(this.fPartIds);
    }

    @Override
    protected boolean canDuplicate() {
        return true;
    }

    @Override
    protected ModeledElement duplicateElement(ModeledElement original) {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.QuickinformationAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager());
        if (d.open() != 0) {
            return null;
        }
        return ((Quickinformation)original).duplicate(d.getId());
    }

    @Override
    protected boolean canRemove() {
        return true;
    }

    @Override
    protected boolean removeElement(ModeledElement element) {
        String message = NLS.bind((String)Messages.QuickinformationAspectEditor_REMOVING_WARNING, (Object)element.getIdentifier(), (Object[])new Object[0]);
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.QuickinformationAspectEditor_REMOVE, (String)message);
    }

    private Set<String> readPartIds() {
        HashSet<String> partIds = new HashSet<String>();
        ModelElement presentationsElement = this.getSite().getConfigurationData(PRESENTATIONS);
        if (presentationsElement != null) {
            for (ModelElement wf : presentationsElement.getChildElements()) {
                if (!wf.getName().equals(SECTION)) continue;
                for (ModelElement s : wf.getChildElements()) {
                    if (!s.getName().equals(PRESENTATION)) continue;
                    String id = s.getAttribute(ID);
                    if (id == null) {
                        id = s.getAttribute(ATTRIBUTE_ID);
                    }
                    if (id == null) {
                        id = s.getAttribute(KIND);
                    }
                    if (id == null) continue;
                    partIds.add(id);
                }
            }
        }
        return partIds;
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        this.fPartIds = new ArrayList<String>(this.readPartIds());
        Collections.sort(this.fPartIds);
        return QuickinformationAspectManager.readQuickinformations(configurationElement);
    }
}

