/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation;

import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quickinformation
extends ModeledElement {
    private String fId;
    private List<QuickEntry> fEntries = Collections.synchronizedList(new ArrayList());
    private List<QuickinformationChangeListener> fListeners = new ArrayList<QuickinformationChangeListener>();

    public Quickinformation(String id) {
        this.fId = id;
    }

    @Override
    public String getIdentifier() {
        return this.fId;
    }

    public String getId() {
        return this.fId;
    }

    public void addPresentation(QuickEntry newEntry, QuickEntry beforeIt) {
        if (beforeIt != null && this.fEntries.indexOf(beforeIt) > -1) {
            this.fEntries.add(this.fEntries.indexOf(beforeIt) + 1, newEntry);
        } else {
            this.fEntries.add(newEntry);
        }
        this.notifyListeners(newEntry);
    }

    public void addPresentation(QuickEntry entry) {
        this.fEntries.add(entry);
        this.notifyListeners(entry);
    }

    public void removePresentation(QuickEntry entry) {
        this.fEntries.remove(entry);
        this.notifyListeners(entry);
    }

    public void moveUp(QuickEntry entry) {
        int current = this.fEntries.indexOf(entry);
        if (current < 1) {
            return;
        }
        this.fEntries.set(current, this.fEntries.get(current - 1));
        this.fEntries.set(current - 1, entry);
        this.notifyListeners(entry);
    }

    public void moveDown(QuickEntry entry) {
        int current = this.fEntries.indexOf(entry);
        if (current > this.fEntries.size() - 1) {
            return;
        }
        this.fEntries.set(current, this.fEntries.get(current + 1));
        this.fEntries.set(current + 1, entry);
        this.notifyListeners(entry);
    }

    public List<QuickEntry> getPresentations() {
        return this.fEntries;
    }

    public void notifyListeners(Object changed) {
        QuickinformationChangeEvent event = new QuickinformationChangeEvent(changed);
        for (QuickinformationChangeListener listener : this.fListeners) {
            listener.quickinformationChanged(event);
        }
    }

    public void addListener(QuickinformationChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(QuickinformationChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public Quickinformation duplicate(String id) {
        Quickinformation copy = new Quickinformation(id);
        for (QuickEntry entry : this.fEntries) {
            Quickinformation quickinformation = copy;
            quickinformation.getClass();
            QuickEntry e = quickinformation.new QuickEntry(entry.getKind(), entry.getTitle());
            if (entry.getProperties() != null) {
                e.setProperties(new HashMap<String, String>(entry.getProperties()));
            } else {
                e.setProperties(new HashMap());
            }
            copy.addPresentation(e);
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QuickEntry {
        private String fKind;
        private String fTitle;
        private Map<String, String> fProperties = new HashMap<String, String>();

        public QuickEntry(String kind, String title) {
            this.fKind = kind;
            this.fTitle = title;
        }

        public String getKind() {
            return this.fKind;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public void setKind(String kind) {
            this.fKind = kind;
            Quickinformation.this.notifyListeners(this);
        }

        public void setTitle(String title) {
            this.fTitle = title;
            Quickinformation.this.notifyListeners(this);
        }

        public String getProperty(String key) {
            return this.fProperties.get(key);
        }

        public void setProperty(String key, String value) {
            this.fProperties.put(key, value);
            Quickinformation.this.notifyListeners(this);
        }

        public Map<String, String> getProperties() {
            return this.fProperties;
        }

        public Set<String> getPropertyKeys() {
            return this.fProperties.keySet();
        }

        private void setProperties(Map<String, String> properties) {
            this.fProperties = properties == null ? new HashMap<String, String>() : properties;
            Quickinformation.this.notifyListeners(null);
        }
    }

    public static class QuickinformationChangeEvent {
        private Object fChanged;

        public QuickinformationChangeEvent(Object changed) {
            this.fChanged = changed;
        }

        public Object getChanged() {
            return this.fChanged;
        }
    }

    public static interface QuickinformationChangeListener {
        public void quickinformationChanged(QuickinformationChangeEvent var1);
    }
}

