/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries;

import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.AbstractQueryAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQuery;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQueryContentProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQueryDetailsSection;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQueryLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQueryManager;
import com.ibm.team.workitem.rcp.ui.internal.queries.QuerySelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedQueryAspectEditor
extends AbstractQueryAspectEditor {
    private final String fProcessAspectId;
    private TableViewer fTableViewer;
    private PredefinedQueryManager fPredefinedQueryManager;

    public PredefinedQueryAspectEditor(String processAspectId) {
        this.fProcessAspectId = processAspectId;
    }

    @Override
    protected void initialize(ProcessAspect aspect) {
        this.fPredefinedQueryManager = new PredefinedQueryManager(aspect, this.fProcessAspectId);
        this.fPredefinedQueryManager.addListener(new PredefinedQueryManager.IChangeListener(){

            public void dirtyStateChanged(boolean dirty) {
                PredefinedQueryAspectEditor.this.setDirty(dirty);
            }

            public void queryChanged(PredefinedQuery query, String[] properties) {
            }

            public void queryStructureChanged() {
            }
        });
        this.updateInput();
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Section sharedQuerySection = toolkit.createSection(parent, 256);
        Composite sharedQuerySectionClient = toolkit.createComposite((Composite)sharedQuerySection);
        sharedQuerySection.setClient((Control)sharedQuerySectionClient);
        sharedQuerySection.setText(Messages.PredefinedQueryAspectEditor_PREDEFINED_QUERIES_SECTION_NAME);
        this.createSharedQuerySection(sharedQuerySectionClient, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sharedQuerySection);
        Section detailsSection = toolkit.createSection(parent, 256);
        Composite detailsSectionClient = toolkit.createComposite((Composite)detailsSection);
        detailsSection.setClient((Control)detailsSectionClient);
        detailsSection.setText(Messages.PredefinedQueryAspectEditor_DETAILS_SECTION_NAME);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)detailsSection);
        PredefinedQueryDetailsSection details = new PredefinedQueryDetailsSection();
        details.createContent(detailsSectionClient, toolkit);
        this.fTableViewer.addSelectionChangedListener((ISelectionChangedListener)details);
        this.updateInput();
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.ide.ui.predefined_query_aspect_editor");
    }

    @Override
    protected void applyChanges() {
        if (this.fPredefinedQueryManager != null) {
            this.fPredefinedQueryManager.applyChanges();
        }
    }

    @Override
    protected void revertChanges() {
        if (this.fPredefinedQueryManager != null) {
            this.fPredefinedQueryManager.revertChanges();
        }
    }

    private void updateInput() {
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput((Object)this.fPredefinedQueryManager);
        }
    }

    private void createSharedQuerySection(Composite composite, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Table table = toolkit.createTable(composite, 2050);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new PredefinedQueryContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new PredefinedQueryLabelProvider());
        Composite buttonComposite = toolkit.createComposite(composite);
        Button addButton = toolkit.createButton(buttonComposite, Messages.PredefinedQueryAspectEditor_ADD, 8);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PredefinedQueryAspectEditor.this.handleAddQuery();
            }
        });
        Button removeButton = toolkit.createButton(buttonComposite, Messages.PredefinedQueryAspectEditor_REMOVE, 8);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PredefinedQueryAspectEditor.this.handleRemoveQuery();
            }
        });
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.fill = true;
        buttonComposite.setLayout((Layout)buttonLayout);
        int minWidth = Utils.convertWidthInCharsToPixels((Control)table, (int)25);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, buttonLayout.marginTop).hint(minWidth, -1).applyTo((Control)table);
        GridDataFactory.swtDefaults().align(4, 1).applyTo((Control)buttonComposite);
    }

    private void handleAddQuery() {
        IProcessItemHandle processItem = this.fPredefinedQueryManager.getProcessItem();
        List<IProjectAreaHandle> projectAreas = this.getProjectAreas(processItem);
        QuerySelectionDialog dialog = new QuerySelectionDialog(this.fTableViewer.getControl().getShell());
        dialog.setTitle(Messages.PredefinedQueryAspectEditor_ADD_QUERY);
        dialog.configureProjectAreas(projectAreas);
        if (dialog.open() == 0) {
            this.fPredefinedQueryManager.addQueries(dialog.getSelectedQueries());
        }
    }

    private List<IProjectAreaHandle> getProjectAreas(IProcessItemHandle processItem) {
        if (processItem instanceof IProjectAreaHandle) {
            return Collections.singletonList((IProjectAreaHandle)processItem);
        }
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas((ITeamRepository)processItem.getOrigin());
    }

    private void handleRemoveQuery() {
        List<PredefinedQuery> predefinedQueries = this.getSelectedQueries();
        this.fPredefinedQueryManager.removePredefinedQueries(predefinedQueries);
    }

    private List<PredefinedQuery> getSelectedQueries() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        return selection.toList();
    }
}

