/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries;

import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQueryManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class PredefinedQuery {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DESCRIPTION = "desc";
    public static final String PROPERTY_STATUS = "status";
    public static final String PROPERTY_ID = "id";
    private static final IStatus OK_STATUS = new Status(0, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQuery_VALID_FOR_PROCESS_TEMPLATE);
    private static final IStatus STATUS_EMPTY_NAME = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQuery_NAME_EMPTY_ERROR);
    private static final IStatus STATUS_INVALID_ID = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQuery_INVALID_ID_ERROR);
    private final IQueryDescriptor fQueryDescriptor;
    private final PredefinedQueryManager fManager;
    private IStatus fStatus;
    private String fName;

    PredefinedQuery(PredefinedQueryManager manager, IQueryDescriptor query) {
        this(manager, query, OK_STATUS);
    }

    PredefinedQuery(PredefinedQueryManager manager, String name, IStatus status) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)status);
        this.fManager = manager;
        this.fQueryDescriptor = null;
        this.fName = name;
        this.fStatus = status;
    }

    PredefinedQuery(PredefinedQueryManager manager, IQueryDescriptor query, IStatus status) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)query);
        Assert.isNotNull((Object)status);
        Assert.isTrue((boolean)query.isWorkingCopy());
        this.fManager = manager;
        this.fQueryDescriptor = query;
        this.fStatus = status;
        if (this.fQueryDescriptor.getDescription() == null) {
            this.fQueryDescriptor.setDescription("");
        }
        if (this.fQueryDescriptor.getId() == null) {
            this.fQueryDescriptor.setId("");
        }
    }

    public IQueryDescriptor getQueryDescriptor() {
        return this.fQueryDescriptor;
    }

    public void setName(String text) {
        if (this.fQueryDescriptor != null && !this.fQueryDescriptor.getName().equals(text)) {
            this.fQueryDescriptor.setName(text);
            this.fManager.notifyChanged(this, new String[]{PROPERTY_NAME});
        }
    }

    public void setIdentifier(String id) {
        if (this.fQueryDescriptor != null && !this.fQueryDescriptor.getId().equals(id)) {
            this.fQueryDescriptor.setId(id);
            this.fManager.notifyChanged(this, new String[]{PROPERTY_ID});
        }
    }

    public void setDescription(String text) {
        if (this.fQueryDescriptor != null && !this.fQueryDescriptor.getDescription().equals(text)) {
            this.fQueryDescriptor.setDescription(text);
            this.fManager.notifyChanged(this, new String[]{PROPERTY_DESCRIPTION});
        }
    }

    public String getName() {
        if (this.fQueryDescriptor != null) {
            return this.fQueryDescriptor.getName();
        }
        return this.fName;
    }

    public String getIdentifier() {
        if (this.fQueryDescriptor != null) {
            return this.fQueryDescriptor.getId();
        }
        return "";
    }

    public String getDescription() {
        if (this.fQueryDescriptor != null) {
            return this.fQueryDescriptor.getDescription();
        }
        return "";
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
        this.fManager.notifyChanged(this, new String[]{PROPERTY_STATUS});
    }

    public IStatus getStatus() {
        if (!this.isNameSet()) {
            return STATUS_EMPTY_NAME;
        }
        if (!this.hasValidId()) {
            return STATUS_INVALID_ID;
        }
        if (this.fStatus.isOK()) {
            return OK_STATUS;
        }
        return this.fStatus;
    }

    private boolean isNameSet() {
        if (this.fQueryDescriptor != null) {
            return this.fQueryDescriptor.getName() != null && !"".equals(this.fQueryDescriptor.getName());
        }
        return true;
    }

    private boolean hasValidId() {
        String identifier = this.getIdentifier();
        if (identifier != null && identifier.length() > 0) {
            for (PredefinedQuery predefined : this.fManager.getQueries()) {
                if (predefined == this || !predefined.getIdentifier().equals(identifier)) continue;
                return false;
            }
        }
        return true;
    }
}

