/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.UIEnumeration;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIEnumerationManager {
    private static final String ENUMERATION = "enumeration";
    public static final String ATTRIBUTE_TYPE_ID = "attributeTypeId";
    private static final String LITERAL = "literal";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ICON = "icon";
    private static final String DEFAULT = "default";
    private static final String NULL = "null";

    public static List<UIEnumeration> readEnumerations(ModelElement configurationElement) {
        ArrayList<UIEnumeration> enumerations = new ArrayList<UIEnumeration>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                enumerations.add(UIEnumerationManager.readEnumeration(element));
            }
        }
        return enumerations;
    }

    private static UIEnumeration readEnumeration(ModelElement element) {
        String attributeTypeId = element.getAttribute(ATTRIBUTE_TYPE_ID);
        UIEnumeration enumeration = new UIEnumeration(attributeTypeId);
        for (ModelElement lit : element.getChildElements()) {
            String id = lit.getAttribute(ID);
            if (id == null) continue;
            String name = lit.getAttribute(NAME);
            String icon = lit.getAttribute(ICON);
            String def = lit.getAttribute(DEFAULT);
            String nullValue = lit.getAttribute(NULL);
            boolean d = false;
            if (def != null) {
                d = Boolean.valueOf(def);
            }
            boolean isNull = nullValue != null ? Boolean.valueOf(nullValue) : false;
            new UIEnumeration.UILiteral(enumeration, id, name, icon, d, isNull);
        }
        return enumeration;
    }

    public static void writeEnumerations(IMemento memento, List<UIEnumeration> enumerations) {
        for (UIEnumeration e : enumerations) {
            UIEnumerationManager.writeEnumeration(memento.createChild(ENUMERATION), e);
        }
    }

    private static void writeEnumeration(IMemento memento, UIEnumeration enumeration) {
        memento.putString(ATTRIBUTE_TYPE_ID, enumeration.getAttributeTypeId());
        for (UIEnumeration.UILiteral literal : enumeration.getLiterals()) {
            IMemento lit = memento.createChild(LITERAL);
            lit.putString(ID, literal.getId());
            lit.putString(NAME, literal.getName());
            lit.putString(ICON, literal.getIcon());
            if (literal.isDefault()) {
                lit.putString(DEFAULT, Boolean.toString(literal.isDefault()));
            }
            if (!literal.isNull()) continue;
            lit.putString(NULL, Boolean.toString(literal.isNull()));
        }
    }
}

