/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration;

import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.SimpleTableLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.UIEnumeration;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EnumerationPart
extends TeamFormPart {
    private UIEnumeration fEnumeration;
    private TableViewer fEnumerationViewer;
    private EnumerationCombo fDefaultCombo;
    private EnumerationCombo fNullCombo;
    private Button fAddEnumeration;
    private IPrefixProvider fPrefixProvider;
    private IDirtyStateTracker fTracker;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static final int RES_COL_ICON = 0;
    private static final int RES_COL_NAME = 1;
    private static final String NAME_LABEL = Messages.EnumerationPart_NAME_LABEL;
    private static final String ICON_LABEL = Messages.EnumerationPart_ICON_LABEL;
    private static final String NONE = Messages.EnumerationPart_NONE;
    private static final Map<String, Integer> RES_PROP_COL = new HashMap<String, Integer>();
    private UIEnumeration.EnumerationChangeListener fListener = new UIEnumeration.EnumerationChangeListener(){

        public void enumerationChanged(final UIEnumeration.EnumerationChangeEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    EnumerationPart.this.fEnumerationViewer.refresh();
                    if (e.getChanged() != null) {
                        EnumerationPart.this.fEnumerationViewer.setSelection((ISelection)new StructuredSelection(e.getChanged()));
                        EnumerationPart.this.fEnumerationViewer.getTable().setFocus();
                        EnumerationPart.this.fDefaultCombo.updateValueSet();
                        EnumerationPart.this.fDefaultCombo.updateErrorDecoration();
                        EnumerationPart.this.fNullCombo.updateValueSet();
                        EnumerationPart.this.fNullCombo.updateErrorDecoration();
                    }
                }
            });
        }
    };

    static {
        RES_PROP_COL.put(NAME_LABEL, 1);
        RES_PROP_COL.put(ICON_LABEL, 0);
    }

    EnumerationPart(IPrefixProvider prefixProvider, IDirtyStateTracker tracker) {
        this.fPrefixProvider = prefixProvider;
        this.fTracker = tracker;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite defaultLit = toolkit.createComposite(parent, 0);
        defaultLit.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        defaultLit.setLayout((Layout)layout);
        Label l = toolkit.createLabel(defaultLit, Messages.EnumerationPart_DEFAULT_LITERAL);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fDefaultCombo = new EnumerationCombo(defaultLit, false){

            protected boolean isDefault(UIEnumeration.UILiteral literal) {
                return literal.isDefault();
            }

            protected void setDefault(UIEnumeration.UILiteral literal, boolean value) {
                literal.setDefault(value);
            }
        };
        toolkit.adapt((Composite)this.fDefaultCombo.getDecoratedCombo().getCombo());
        Label nullLabel = toolkit.createLabel(defaultLit, Messages.EnumerationPart_NULL_LITERAL);
        nullLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fNullCombo = new EnumerationCombo(defaultLit, true){

            protected boolean isDefault(UIEnumeration.UILiteral literal) {
                return literal.isNull();
            }

            protected void setDefault(UIEnumeration.UILiteral literal, boolean value) {
                literal.setNull(value);
            }
        };
        toolkit.adapt((Composite)this.fNullCombo.getDecoratedCombo().getCombo());
        Composite viewer = toolkit.createComposite(parent, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = toolkit.createComposite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        this.createViewer(viewer, buttonBar);
    }

    private void createViewer(Composite viewer, Composite buttonBar) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        viewer.setLayout((Layout)layout);
        Table t = new Table(viewer, 67586);
        t.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.heightHint = t.getItemHeight() * 16;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(180);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        this.fEnumerationViewer = new TableViewer(t);
        this.fEnumerationViewer.setColumnProperties(new String[]{NAME_LABEL});
        this.fEnumerationViewer.setLabelProvider((IBaseLabelProvider)new SimpleTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof UIEnumeration.UILiteral) {
                    UIEnumeration.UILiteral lit = (UIEnumeration.UILiteral)element;
                    return lit.getName();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                UIEnumeration.UILiteral lit;
                if (element instanceof UIEnumeration.UILiteral && (lit = (UIEnumeration.UILiteral)element).getIcon() != null) {
                    return this.getImage(element, lit.getIcon());
                }
                return null;
            }

            protected IProcessContainerWorkingCopy getProcessContainer() {
                return EnumerationPart.this.fPrefixProvider.getProcessContainer();
            }

            protected ResourceManager getResourceManager() {
                return EnumerationPart.this.fResourceManager;
            }
        });
        this.fEnumerationViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof UIEnumeration) {
                    return ((UIEnumeration)inputElement).getLiterals().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        layout = new GridLayout();
        layout.marginTop = this.fEnumerationViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeEnumeration = toolkit.createButton(buttonBar, Messages.EnumerationPart_REMOVE, 0x800000);
        removeEnumeration.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeEnumeration.setEnabled(false);
        removeEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnumerationPart.this.fEnumerationViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)EnumerationPart.this.fEnumerationViewer.getSelection();
                    boolean removedAny = false;
                    for (Object o : sel.toList()) {
                        if (!(o instanceof UIEnumeration.UILiteral)) continue;
                        UIEnumeration.UILiteral literal = (UIEnumeration.UILiteral)o;
                        EnumerationPart.this.fDefaultCombo.handleRemoved(literal);
                        EnumerationPart.this.fNullCombo.handleRemoved(literal);
                        EnumerationPart.this.fEnumeration.removeLiteral((UIEnumeration.UILiteral)o);
                        removedAny = true;
                    }
                    if (removedAny) {
                        EnumerationPart.this.setDirty();
                    }
                }
            }
        });
        this.fAddEnumeration = toolkit.createButton(buttonBar, Messages.EnumerationPart_ADD, 0x800000);
        this.fAddEnumeration.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditLiteralDialog d = new AddEditLiteralDialog(Display.getCurrent().getActiveShell(), Messages.EnumerationPart_ADD_LITERAL, null, null, EnumerationPart.this.fPrefixProvider, EnumerationPart.this.fResourceManager);
                if (d.open() == 0) {
                    String name = d.getName();
                    if (name == null || name.trim().equals("")) {
                        return;
                    }
                    if (!EnumerationPart.this.fEnumerationViewer.getSelection().isEmpty()) {
                        new UIEnumeration.UILiteral(EnumerationPart.this.fEnumeration, EnumerationPart.this.fEnumeration.generateLiteralId(), name, d.getIconUrl(), false, false, (UIEnumeration.UILiteral)((IStructuredSelection)EnumerationPart.this.fEnumerationViewer.getSelection()).getFirstElement());
                    } else {
                        new UIEnumeration.UILiteral(EnumerationPart.this.fEnumeration, EnumerationPart.this.fEnumeration.generateLiteralId(), name, d.getIconUrl(), false, false);
                    }
                    EnumerationPart.this.fDefaultCombo.updateValueSet();
                    EnumerationPart.this.fNullCombo.updateValueSet();
                    EnumerationPart.this.setDirty();
                }
            }
        });
        final Button editEnumeration = toolkit.createButton(buttonBar, Messages.EnumerationPart_EDIT, 0x800000);
        editEnumeration.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editEnumeration.setEnabled(false);
        editEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumerationPart.this.editLiteral();
            }
        });
        AspectEditorUtil.createFiller(buttonBar, toolkit, 6);
        final Button moveUpButton = toolkit.createButton(buttonBar, Messages.EnumerationPart_MOVE_UP, 0x800000);
        moveUpButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        moveUpButton.setEnabled(false);
        final Button moveDownButton = toolkit.createButton(buttonBar, Messages.EnumerationPart_MOVE_DOWN, 0x800000);
        moveDownButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        moveDownButton.setEnabled(false);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (EnumerationPart.this.fEnumerationViewer.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)EnumerationPart.this.fEnumerationViewer.getSelection()).getFirstElement()) instanceof UIEnumeration.UILiteral) {
                    EnumerationPart.this.fEnumeration.moveUp((UIEnumeration.UILiteral)o);
                    EnumerationPart.this.setDirty();
                    EnumerationPart.this.updateMoveButtons(moveUpButton, moveDownButton);
                }
            }
        });
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (EnumerationPart.this.fEnumerationViewer.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)EnumerationPart.this.fEnumerationViewer.getSelection()).getFirstElement()) instanceof UIEnumeration.UILiteral) {
                    EnumerationPart.this.fEnumeration.moveDown((UIEnumeration.UILiteral)o);
                    EnumerationPart.this.setDirty();
                    EnumerationPart.this.updateMoveButtons(moveUpButton, moveDownButton);
                }
            }
        });
        this.fEnumerationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeEnumeration.setEnabled(!EnumerationPart.this.fEnumerationViewer.getSelection().isEmpty());
                editEnumeration.setEnabled(((IStructuredSelection)EnumerationPart.this.fEnumerationViewer.getSelection()).size() == 1);
                EnumerationPart.this.updateMoveButtons(moveUpButton, moveDownButton);
            }
        });
        this.fEnumerationViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)EnumerationPart.this.fEnumerationViewer.getSelection()).size() == 1) {
                    EnumerationPart.this.editLiteral();
                }
            }
        });
        this.updateEnablement();
        Utils.updateColumnWidths((Table)this.fEnumerationViewer.getTable(), (int[])new int[]{1});
    }

    private void editLiteral() {
        UIEnumeration.UILiteral selected = (UIEnumeration.UILiteral)((IStructuredSelection)this.fEnumerationViewer.getSelection()).getFirstElement();
        AddEditLiteralDialog d = new AddEditLiteralDialog(Display.getCurrent().getActiveShell(), Messages.EnumerationPart_EDIT_LITERAL, selected.getName(), selected.getIcon(), this.fPrefixProvider, this.fResourceManager);
        if (d.open() == 0) {
            String name = d.getName();
            if (!name.equals(selected.getName())) {
                selected.setName(name);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(d.getIconUrl(), selected.getIcon())) {
                selected.setIcon(d.getIconUrl());
                this.setDirty();
            }
        }
    }

    private void updateEnablement() {
        if (this.fAddEnumeration != null && !this.fAddEnumeration.isDisposed()) {
            this.fAddEnumeration.setEnabled(this.fEnumeration != null);
            this.fEnumerationViewer.getControl().setEnabled(this.fEnumeration != null);
            this.fDefaultCombo.getDecoratedCombo().getCombo().setEnabled(this.fEnumeration != null);
            this.fNullCombo.getDecoratedCombo().getCombo().setEnabled(this.fEnumeration != null);
        }
    }

    private void updateMoveButtons(Button moveUp, Button moveDown) {
        boolean moveUpEnabled = false;
        if (!this.fEnumerationViewer.getSelection().isEmpty() && this.fEnumerationViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.fEnumerationViewer.getSelection()).getFirstElement() instanceof UIEnumeration.UILiteral && ((IStructuredSelection)this.fEnumerationViewer.getSelection()).size() == 1 && this.fEnumeration.getLiterals().indexOf(((IStructuredSelection)this.fEnumerationViewer.getSelection()).getFirstElement()) > 0) {
            moveUpEnabled = true;
        }
        moveUp.setEnabled(moveUpEnabled);
        boolean moveDownEnabled = false;
        if (!this.fEnumerationViewer.getSelection().isEmpty() && this.fEnumerationViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.fEnumerationViewer.getSelection()).getFirstElement() instanceof UIEnumeration.UILiteral && ((IStructuredSelection)this.fEnumerationViewer.getSelection()).size() == 1 && this.fEnumeration.getLiterals().indexOf(((IStructuredSelection)this.fEnumerationViewer.getSelection()).getFirstElement()) < this.fEnumeration.getLiterals().size() - 1) {
            moveDownEnabled = true;
        }
        moveDown.setEnabled(moveDownEnabled);
    }

    public void setInput(Object input) {
        if (this.fEnumeration != null) {
            this.fEnumeration.removeListener(this.fListener);
        }
        if (input instanceof UIEnumeration) {
            this.fEnumeration = (UIEnumeration)input;
            this.fEnumerationViewer.setInput((Object)this.fEnumeration);
            this.fEnumeration.addListener(this.fListener);
        } else {
            this.fEnumeration = null;
            this.fEnumerationViewer.setInput(null);
        }
        this.fDefaultCombo.updateCombo();
        this.fNullCombo.updateCombo();
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fEnumeration != null) {
            this.fEnumeration.removeListener(this.fListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private static class AddEditLiteralDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fNameField;
        private String fName;

        protected AddEditLiteralDialog(Shell parentShell, String title, String name, String iconUrl, IPrefixProvider prefixProvider, ResourceManager resourceManager) {
            super(parentShell, title, iconUrl, prefixProvider, resourceManager);
            this.fName = name;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    String n;
                    if ((AddEditLiteralDialog.this.fName == null || "".equals(AddEditLiteralDialog.this.fName.trim())) && AddEditLiteralDialog.this.fNameField != null && !AddEditLiteralDialog.this.fNameField.isDisposed() && (n = AddEditLiteralDialog.this.fNameField.getText()).trim().equals("")) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EnumerationPart_EMPTY_NAME);
                    }
                    if (AddEditLiteralDialog.this.getIconUrl() == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.EnumerationPart_NO_ICON);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected void okPressed() {
            this.fName = this.fNameField.getText();
            super.okPressed();
        }

        protected void iconChanged() {
            this.validate();
        }

        public String getName() {
            return this.fName.trim();
        }

        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.EnumerationPart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(parent, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditLiteralDialog.this.validate();
                }
            });
        }
    }

    private abstract class EnumerationCombo {
        private final DecoratedCombo fCombo;
        private final boolean fIsNoneAllowed;

        public EnumerationCombo(Composite parent, boolean isNoneAllowed) {
            this.fIsNoneAllowed = isNoneAllowed;
            this.fCombo = new DecoratedCombo(parent, 8, 1);
            this.fCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EnumerationCombo.this.handleComboChanged();
                }
            });
            this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (NONE.equals(element)) {
                        return NONE;
                    }
                    if (element instanceof UIEnumeration.UILiteral) {
                        return ((UIEnumeration.UILiteral)element).getName();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    if (element instanceof UIEnumeration.UILiteral && ((UIEnumeration.UILiteral)element).getIcon() != null) {
                        return this.getImage(element, ((UIEnumeration.UILiteral)element).getIcon());
                    }
                    return EnumerationPart.this.fResourceManager.createImage(ImagePool.EMPTY_ICON);
                }

                private Image getImage(final Object element, String iconPath) {
                    return AspectEditorUtil.getImage(EnumerationPart.this.fPrefixProvider.getProcessContainer(), iconPath, EnumerationPart.this.fResourceManager, new Runnable(){

                        public void run() {
                            this.updateElement(element);
                        }
                    });
                }

                private void updateElement(Object element) {
                    if (EnumerationCombo.this.fCombo != null && !EnumerationCombo.this.fCombo.getCombo().isDisposed()) {
                        EnumerationCombo.this.fCombo.setValue(EnumerationCombo.this.fCombo.getValue());
                    }
                }
            });
        }

        public DecoratedCombo getDecoratedCombo() {
            return this.fCombo;
        }

        public void handleRemoved(UIEnumeration.UILiteral literal) {
            if (this.isDefault(literal)) {
                this.fCombo.setValue((Object)NONE);
            }
        }

        public void updateCombo() {
            UIEnumeration.UILiteral defaultLiteral = this.updateValueSet();
            if (defaultLiteral != null) {
                this.fCombo.setValue((Object)defaultLiteral);
            } else {
                this.fCombo.setValue((Object)NONE);
            }
            this.fCombo.getLayoutControl().getParent().layout(new Control[]{this.fCombo.getCombo()});
            this.updateErrorDecoration();
        }

        public void updateErrorDecoration() {
            if (EnumerationPart.this.fEnumeration == null) {
                return;
            }
            if (!this.fIsNoneAllowed && NONE.equals(this.fCombo.getValue()) && EnumerationPart.this.fEnumeration.getLiterals().size() > 0) {
                this.fCombo.setStatus((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EnumerationPart_NO_DEFAULT_LITERAL));
            } else {
                this.fCombo.setStatus(Status.OK_STATUS);
            }
        }

        private void handleComboChanged() {
            if (EnumerationPart.this.fEnumeration == null) {
                return;
            }
            Object selected = this.fCombo.getValue();
            boolean dirty = false;
            for (UIEnumeration.UILiteral lit : EnumerationPart.this.fEnumeration.getLiterals()) {
                if (lit.equals(selected)) {
                    if (this.isDefault(lit)) continue;
                    this.setDefault(lit, true);
                    dirty = true;
                    continue;
                }
                if (!this.isDefault(lit)) continue;
                this.setDefault(lit, false);
                dirty = true;
            }
            if (dirty) {
                EnumerationPart.this.setDirty();
                this.updateErrorDecoration();
            }
        }

        private UIEnumeration.UILiteral updateValueSet() {
            Object[] valueSet;
            UIEnumeration.UILiteral defaultLiteral = null;
            if (EnumerationPart.this.fEnumeration != null) {
                List<UIEnumeration.UILiteral> literals = EnumerationPart.this.fEnumeration.getLiterals();
                valueSet = new Object[literals.size() + 1];
                valueSet[0] = NONE;
                int i = 0;
                while (i < literals.size()) {
                    UIEnumeration.UILiteral literal = literals.get(i);
                    if (this.isDefault(literal)) {
                        defaultLiteral = literal;
                    }
                    valueSet[i + 1] = literal;
                    ++i;
                }
            } else {
                valueSet = new Object[]{NONE};
            }
            this.fCombo.setValueSet(valueSet);
            return defaultLiteral;
        }

        protected abstract void setDefault(UIEnumeration.UILiteral var1, boolean var2);

        protected abstract boolean isDefault(UIEnumeration.UILiteral var1);
    }
}

