/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorPresentation;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPresentationAspectManager {
    public static void writeEditorPresentations(IMemento memento, List<EditorPresentation> elements, Map<String, List<AbstractPresentationDescriptor>> map, Map<String, String> tabLayouts, List<String> tabIds, List<String> sectionIds) {
        for (EditorPresentation p : elements) {
            EditorPresentationAspectManager.writeEditor(memento, p, map);
        }
        for (String key : map.keySet()) {
            List<AbstractPresentationDescriptor> descriptors = map.get(key);
            if (sectionIds.contains(key)) {
                EditorPresentationAspectManager.writeSection(memento, key, descriptors);
            }
            if (!tabIds.contains(key)) continue;
            EditorPresentationAspectManager.writeTab(memento, key, descriptors, tabLayouts);
        }
    }

    private static void writeEditor(IMemento memento, EditorPresentation p, Map<String, List<AbstractPresentationDescriptor>> map) {
        IMemento editor = memento.createChild("editor");
        editor.putString("id", p.getIdentifier());
        List<AbstractPresentationDescriptor> descriptors = map.get(p.getIdentifier());
        if (descriptors != null) {
            for (AbstractPresentationDescriptor d : descriptors) {
                if (!(d instanceof TabDescriptor)) continue;
                TabDescriptor desc = (TabDescriptor)d;
                IMemento tab = editor.createChild("tab");
                tab.putString("tabId", desc.getElementId());
                tab.putString("title", desc.getTitle());
                EditorPresentationAspectManager.writeProperties((AbstractPresentationDescriptor)desc, tab);
            }
        }
    }

    private static void writeTab(IMemento memento, String tabId, List<AbstractPresentationDescriptor> descriptors, Map<String, String> tabLayouts) {
        IMemento tab = memento.createChild("tab");
        tab.putString("id", tabId);
        tab.putString("layout", tabLayouts.get(tabId));
        if (descriptors != null) {
            for (AbstractPresentationDescriptor d : descriptors) {
                if (!(d instanceof SectionDescriptor)) continue;
                SectionDescriptor desc = (SectionDescriptor)d;
                IMemento sec = tab.createChild("section");
                sec.putString("sectionId", desc.getElementId());
                sec.putString("title", desc.getTitle());
                sec.putString("slot", desc.getSlot());
                EditorPresentationAspectManager.writeProperties((AbstractPresentationDescriptor)desc, sec);
            }
        }
    }

    private static void writeSection(IMemento memento, String sectionId, List<AbstractPresentationDescriptor> descriptors) {
        IMemento section = memento.createChild("section");
        section.putString("id", sectionId);
        if (descriptors != null) {
            for (AbstractPresentationDescriptor d : descriptors) {
                if (!(d instanceof PresentationDescriptor)) continue;
                PresentationDescriptor desc = (PresentationDescriptor)d;
                IMemento pres = section.createChild("presentation");
                if (desc.getId() != null) {
                    pres.putString("id", desc.getId());
                }
                if (desc.getAttributeId() != null) {
                    pres.putString("attributeId", desc.getAttributeId().getStringIdentifier());
                }
                if (desc.getKind() != null) {
                    pres.putString("kind", desc.getKind());
                }
                if (desc.getLabel() != null) {
                    pres.putString("label", desc.getLabel());
                }
                EditorPresentationAspectManager.writeProperties((AbstractPresentationDescriptor)desc, pres);
            }
        }
    }

    private static void writeProperties(AbstractPresentationDescriptor desc, IMemento memento) {
        Map properties = desc.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String key : properties.keySet()) {
            IMemento prop = memento.createChild("property");
            prop.putString("key", key);
            prop.putString("value", (String)properties.get(key));
        }
    }
}

