/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentationManager;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.AttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorIdBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorPresentation;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorPresentationAspectManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorPresentationAspectPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.WorkitemTypeEditorIdBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPresentationAspectEditor
extends AbstractWorkItemAspectEditor {
    private static final String ERROR_RETRIEVING_ATTRIBUTES = Messages.EditorPresentationAspectEditor_ERROR_RETRIEVING_ATTRIBUTES;
    private static final String EDITOR_ID_BINDINGS = "com.ibm.team.workitem.editor.configuration.workitemTypeEditorIdBinding";
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.EditorPresentationAspectEditor_CHOOSE_EDITOR_PRESENTATION;
        }

        public String getSameIdMessage() {
            return Messages.EditorPresentationAspectEditor_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.EditorPresentationAspectEditor_ENTER_PRESENTATION_ID;
        }
    };
    private EditorPresentationAspectPart fEPart;
    private Map<String, List<AbstractPresentationDescriptor>> fPresentationsMap;
    private Map<String, String> fTabLayouts;
    private List<EditorPresentation.Attribute> fAttributes;
    private List<String> fSectionIds;
    private List<String> fTabIds;
    private List<String> fEditorIds;
    private List<EditorIdBinding> fBindings;
    private ManagedForm fManagedForm;

    public EditorPresentationAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.editor_presentation_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        EditorPresentationAspectManager.writeEditorPresentations(memento, elements, this.fPresentationsMap, this.fTabLayouts, this.fTabIds, this.fSectionIds);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fEPart = new EditorPresentationAspectPart(this);
        TeamFormSectionPart editorPresentationSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.EditorPresentationAspectEditor_EDITOR_PRESENTATION, new TeamFormPart[]{this.fEPart});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        editorPresentationSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)editorPresentationSection);
        this.fEPart.setRequiredListsAndMaps(this.fPresentationsMap, this.fEditorIds, this.fTabIds, this.fTabLayouts, this.fSectionIds, this.fAttributes);
    }

    @Override
    protected ModeledElement createNewElement() {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.EditorPresentationAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager());
        if (d.open() != 0) {
            return null;
        }
        return new EditorPresentation(d.getId());
    }

    @Override
    protected boolean canDuplicate() {
        return true;
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }

    @Override
    protected ModeledElement duplicateElement(ModeledElement original) {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.EditorPresentationAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager());
        if (d.open() != 0) {
            return null;
        }
        EditorPresentation pres = new EditorPresentation(d.getId());
        this.fEditorIds.add(pres.getIdentifier());
        if (this.fPresentationsMap.get(pres.getIdentifier()) == null) {
            this.fPresentationsMap.put(pres.getIdentifier(), new ArrayList());
        }
        List<AbstractPresentationDescriptor> toDuplicate = this.fPresentationsMap.get(original.getIdentifier());
        List<AbstractPresentationDescriptor> toFill = this.fPresentationsMap.get(pres.getIdentifier());
        if (toDuplicate != null) {
            for (AbstractPresentationDescriptor desc : toDuplicate) {
                if (!(desc instanceof TabDescriptor)) continue;
                toFill.add(desc);
            }
        }
        this.fEPart.initializeEditorDependency(pres.getIdentifier());
        return pres;
    }

    @Override
    protected boolean canRemove() {
        return true;
    }

    @Override
    protected boolean removeElement(ModeledElement element) {
        String types = "";
        for (EditorIdBinding binding : this.fBindings) {
            if (!binding.getEditorId().equals(element.getIdentifier())) continue;
            types = NLS.bind((String)Messages.EditorPresentationAspectEditor_APPEND_TYPE_TO_LIST, (Object)types, (Object[])new Object[]{binding.getType().getName()});
        }
        String message = types.length() == 0 ? ("com.ibm.team.workitem.editor.default".equals(element.getIdentifier()) ? Messages.EditorPresentationAspectEditor_REMOVE_DEFAULT_EDITOR : NLS.bind((String)Messages.EditorPresentationAspectEditor_REMOVE_EDITOR, (Object)element.getName(), (Object[])new Object[0])) : ("com.ibm.team.workitem.editor.default".equals(element.getIdentifier()) ? NLS.bind((String)Messages.EditorPresentationAspectEditor_REMOVING_REFERENCED_DEFAULT_EDITOR, (Object)element.getName(), (Object[])new Object[]{types}) : NLS.bind((String)Messages.EditorPresentationAspectEditor_REMOVING_REFERENCED_EDITOR, (Object)element.getName(), (Object[])new Object[]{types}));
        if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.EditorPresentationAspectEditor_REMOVE, (String)message)) {
            return false;
        }
        this.fEPart.cleanUpEditorDependency(element.getIdentifier());
        List<AbstractPresentationDescriptor> toCheck = this.fPresentationsMap.get(element.getIdentifier());
        if (toCheck != null) {
            Iterator<AbstractPresentationDescriptor> it = toCheck.iterator();
            while (it.hasNext()) {
                AbstractPresentationDescriptor a = it.next();
                if (!(a instanceof SectionDescriptor)) continue;
                it.remove();
            }
        }
        this.fEditorIds.remove(element.getIdentifier());
        return true;
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fManagedForm.setInput((Object)newElement);
    }

    private List<TypeCategory.CustomAttribute> readCustomAttributes() {
        List<TypeCategory> categories = TypeManager.readTypeCategories(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes"));
        ArrayList<TypeCategory.CustomAttribute> attributes = new ArrayList<TypeCategory.CustomAttribute>();
        for (TypeCategory cat : categories) {
            attributes.addAll(cat.getCustomAttributes());
        }
        return attributes;
    }

    private List<EditorIdBinding> readBindings() {
        List<EditorIdBinding.Type> types = WorkitemTypeEditorIdBindingManager.readWorkItemTypes(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes"));
        return WorkitemTypeEditorIdBindingManager.readEditorIdBindings(this.getSite().getConfigurationData(EDITOR_ID_BINDINGS), types);
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        HashMap<String, List<AbstractPresentationDescriptor>> definitions = new HashMap<String, List<AbstractPresentationDescriptor>>();
        HashMap<String, String> tabLayouts = new HashMap<String, String>();
        ArrayList<String> editorIds = new ArrayList<String>();
        ArrayList<String> tabIds = new ArrayList<String>();
        ArrayList<String> sectionIds = new ArrayList<String>();
        if (configurationElement != null) {
            EditorPresentationManager.readPresentations((List)configurationElement.getChildElements(), definitions, tabLayouts, editorIds, tabIds, sectionIds);
        }
        this.fPresentationsMap = definitions;
        this.fTabLayouts = tabLayouts;
        this.fSectionIds = sectionIds;
        this.fTabIds = tabIds;
        this.fEditorIds = editorIds;
        final IProcessItem processItem = this.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        if (processItem instanceof IProcessArea) {
            final ArrayList attributes = new ArrayList();
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IProcessArea processArea = (IProcessArea)processItem;
                        ITeamRepository teamRepository = (ITeamRepository)processItem.getOrigin();
                        IWorkItemClient workitemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                        try {
                            attributes.addAll(workitemClient.findAttributes(processArea.getProjectArea(), monitor));
                        }
                        catch (TeamRepositoryException e) {
                            WorkItemIDEUIPlugin.getDefault().log(ERROR_RETRIEVING_ATTRIBUTES, e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                WorkItemIDEUIPlugin.getDefault().log(ERROR_RETRIEVING_ATTRIBUTES, e);
                return Collections.emptyList();
            }
            catch (InterruptedException e) {
                WorkItemIDEUIPlugin.getDefault().log(ERROR_RETRIEVING_ATTRIBUTES, e);
                return Collections.emptyList();
            }
            this.fAttributes = new ArrayList<EditorPresentation.Attribute>();
            HashSet<Identifier> attributeIdentifiers = new HashSet<Identifier>();
            for (IAttribute attribute : attributes) {
                if (attribute.isInternal()) continue;
                Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)attribute.getIdentifier());
                this.fAttributes.add(new EditorPresentation.Attribute((Identifier<IAttribute>)ident, attribute.getAttributeType(), attribute.getDisplayName(), !attribute.isBuiltIn(), false));
                attributeIdentifiers.add(ident);
            }
            List<TypeCategory.CustomAttribute> customAttributes = this.readCustomAttributes();
            block4: for (TypeCategory.CustomAttribute a : customAttributes) {
                Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)a.getId());
                if (!attributeIdentifiers.contains(ident)) {
                    this.fAttributes.add(new EditorPresentation.Attribute((Identifier<IAttribute>)ident, a.getAttributeType(), a.getName(), true, true));
                    continue;
                }
                for (EditorPresentation.Attribute attr : this.fAttributes) {
                    if (!attr.getIdentifier().equals((Object)ident)) continue;
                    attr.setConfiguredInSpec(true);
                    continue block4;
                }
            }
        } else if (processItem instanceof IProcessDefinition) {
            this.fAttributes = new ArrayList<EditorPresentation.Attribute>();
            AttributeDescriptor[] attributeDescriptorArray = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS;
            int n = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS.length;
            int attributeIdentifiers = 0;
            while (attributeIdentifiers < n) {
                AttributeDescriptor desc = attributeDescriptorArray[attributeIdentifiers];
                if (!desc.isInternal()) {
                    this.fAttributes.add(new EditorPresentation.Attribute((Identifier<IAttribute>)WorkItemAttributes.getPropertyIdentifier((String)desc.getIdentifier()), desc.getAttributeType(), desc.getDisplayName(), false, false));
                }
                ++attributeIdentifiers;
            }
            List<TypeCategory.CustomAttribute> customAttributes = this.readCustomAttributes();
            for (TypeCategory.CustomAttribute a : customAttributes) {
                this.fAttributes.add(new EditorPresentation.Attribute((Identifier<IAttribute>)WorkItemAttributes.getPropertyIdentifier((String)a.getId()), a.getAttributeType(), a.getName(), true, true));
            }
        } else {
            throw new UnsupportedOperationException(Messages.EditorPresentationAspectEditor_NEITHER_AREA_NOR_DEFINITION);
        }
        ArrayList<EditorPresentation> elements = new ArrayList<EditorPresentation>();
        for (String id : editorIds) {
            elements.add(new EditorPresentation(id));
        }
        if (this.fEPart != null) {
            this.fEPart.setRequiredListsAndMaps(this.fPresentationsMap, this.fEditorIds, this.fTabIds, this.fTabLayouts, this.fSectionIds, this.fAttributes);
        }
        this.fBindings = this.readBindings();
        return elements;
    }
}

