/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.ApprovalTracking;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovalTrackingManager {
    private static final String APPROVAL_TYPE = "approvalType";
    private static final String APPROVAL_TARGET = "approvalTarget";
    private static final String WORKFLOW_ACTION = "workflowAction";
    private static final String WORKFLOW_ID = "workflowId";
    private static final String APPROVAL_TRACKING = "approvalTracking";

    public static List<ApprovalTracking> readTrackings(ModelElement configurationElement, List<WFWorkflow> workflows) {
        ArrayList<ApprovalTracking> trackings = new ArrayList<ApprovalTracking>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                String id = element.getAttribute(WORKFLOW_ID);
                ApprovalTracking tracking = null;
                for (ApprovalTracking t : trackings) {
                    if (!t.getWorkflow().getId().equals(id)) continue;
                    tracking = t;
                    break;
                }
                WFWorkflow wf = null;
                for (WFWorkflow workflow : workflows) {
                    if (!workflow.getId().equals(id)) continue;
                    wf = workflow;
                    break;
                }
                if (wf == null) {
                    wf = new WFWorkflow(id, id, null);
                    workflows.add(wf);
                }
                if (tracking == null) {
                    tracking = new ApprovalTracking(id, wf);
                    trackings.add(tracking);
                }
                String type = element.getAttribute(APPROVAL_TYPE);
                String target = element.getAttribute(APPROVAL_TARGET);
                String action = element.getAttribute(WORKFLOW_ACTION);
                WFWorkflow.WFAction act = null;
                for (WFWorkflow.WFAction a : wf.getActions()) {
                    if (!a.getId().equals(action)) continue;
                    act = a;
                    break;
                }
                if (act == null) {
                    act = new WFWorkflow.WFAction(wf, action, action, null, null);
                }
                ApprovalTracking approvalTracking = tracking;
                approvalTracking.getClass();
                ApprovalTracking.TrackingEntry entry = approvalTracking.new ApprovalTracking.TrackingEntry(WorkItemApprovals.getType((String)type), WorkItemApprovals.getState((String)target));
                entry.setWFAction(act);
                tracking.addEntry(entry);
            }
        }
        return trackings;
    }

    private static void writeTracking(IMemento parentMemento, ApprovalTracking tracking) {
        for (ApprovalTracking.TrackingEntry entry : tracking.getEntries()) {
            String type = null;
            if (entry.getApprovalType() != null) {
                type = entry.getApprovalType().getIdentifier();
            }
            String target = null;
            if (entry.getApprovalTarget() != null) {
                target = entry.getApprovalTarget().getIdentifier();
            }
            String action = null;
            if (entry.getWFAction() != null) {
                action = entry.getWFAction().getId();
            }
            if (type == null || target == null || action == null) continue;
            IMemento memento = parentMemento.createChild(APPROVAL_TRACKING);
            memento.putString(WORKFLOW_ID, tracking.getWorkflow().getId());
            memento.putString(APPROVAL_TYPE, type);
            memento.putString(APPROVAL_TARGET, target);
            memento.putString(WORKFLOW_ACTION, action);
        }
    }

    public static void writeTrackings(IMemento memento, List<ApprovalTracking> trackings) {
        for (ApprovalTracking t : trackings) {
            ApprovalTrackingManager.writeTracking(memento, t);
        }
    }
}

