/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.ApprovalTracking;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.ApprovalTrackingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.ApprovalTrackingPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovalTrackingAspectEditor
extends AbstractWorkItemAspectEditor {
    private ApprovalTrackingPart fApprovalTracking;
    private ManagedForm fManagedForm;
    List<WFWorkflow> fWorkflows;
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.ApprovalTrackingAspectEditor_CHOSSE_APPROVAL_TRACKING;
        }

        public String getSameIdMessage() {
            return Messages.ApprovalTrackingAspectEditor_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.ApprovalTrackingAspectEditor_ENTER_ID;
        }
    };

    ApprovalTrackingAspectEditor(String configurationDataId) {
        super(configurationDataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.approval_tracking_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        ApprovalTrackingManager.writeTrackings(memento, elements);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fApprovalTracking = new ApprovalTrackingPart(this.getProcessContainerWorkingCopy(), this);
        TeamFormSectionPart approvalTrackingSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.ApprovalTrackingAspectEditor_APPROVAL_TRACKING, new TeamFormPart[]{this.fApprovalTracking});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        approvalTrackingSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)approvalTrackingSection);
    }

    @Override
    protected ModeledElement createNewElement() {
        return null;
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fManagedForm.setInput((Object)newElement);
    }

    private List<WFWorkflow> readWorkflows() {
        ModelElement workflowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        if (workflowElement != null) {
            return WorkflowManager.readWorkflows(workflowElement);
        }
        return new ArrayList<WFWorkflow>();
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        this.fWorkflows = this.readWorkflows();
        List<ApprovalTracking> trackings = ApprovalTrackingManager.readTrackings(configurationElement, this.fWorkflows);
        for (WFWorkflow w : this.fWorkflows) {
            boolean found = false;
            for (ApprovalTracking t : trackings) {
                if (w != t.getWorkflow()) continue;
                found = true;
                break;
            }
            if (found) continue;
            trackings.add(new ApprovalTracking(w.getIdentifier(), w));
        }
        final AspectEditorUtil.WorkflowComparator comp = new AspectEditorUtil.WorkflowComparator();
        Collections.sort(trackings, new Comparator<ApprovalTracking>(){

            @Override
            public int compare(ApprovalTracking o1, ApprovalTracking o2) {
                return comp.compare(o1.getWorkflow(), o2.getWorkflow());
            }
        });
        return trackings;
    }

    @Override
    protected boolean canAdd() {
        return false;
    }
}

