/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IconsPart
extends TeamFormPart {
    private Set<IProcessAttachmentHandle> fIcons = new ItemHandleAwareHashSet();
    private TableViewer fIconViewer;
    private IconChangeListener fIconListener = new IconChangeListener();
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private IPrefixProvider fPrefixProvider;
    private boolean fInitialized;
    private static final int ICON_COL_NAME = 0;
    private static final String NAME_LABEL = Messages.IconsPart_NAME;

    public IconsPart(IPrefixProvider prefixProvider) {
        this.fPrefixProvider = prefixProvider;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createIconViewer(parent);
        this.createButtons(parent);
    }

    private void createButtons(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite buttonBar = new Composite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginTop = this.fIconViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button uploadIcon = toolkit.createButton(buttonBar, Messages.IconsPart_ADD_ICON, 0x800000);
        uploadIcon.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        uploadIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AspectEditorUtil.addProcessAttachement(uploadIcon.getShell(), IconsPart.this.fPrefixProvider.getProcessContainer().getProcessAttachments(), IconsPart.this.fPrefixProvider.getIconPrefix());
            }
        });
    }

    private void createIconViewer(Composite parent) {
        Composite comp = this.getSite().getToolkit().createComposite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g = new GridLayout();
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.widthHint = 120;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(120);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        this.fIconViewer = new TableViewer(t);
        this.fIconViewer.setColumnProperties(new String[]{NAME_LABEL});
        this.fIconViewer.setLabelProvider((IBaseLabelProvider)new AspectEditorUtil.IconLabelProvider(this.fPrefixProvider, 0, 0, this.fResourceManager));
        this.fIconViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fIconViewer.setSorter((ViewerSorter)new AspectEditorUtil.ProcessAttachmentSorter());
        if (!"gtk".equals(SWT.getPlatform())) {
            Utils.updateColumnWidths((Table)this.fIconViewer.getTable(), (int[])new int[]{1});
        }
    }

    private void initializeUI() {
        if (this.fResourceManager == null) {
            return;
        }
        IProcessAttachmentsWorkingCopy workingCopy = this.fPrefixProvider.getProcessContainer().getProcessAttachments();
        workingCopy.removeWorkingCopyListener((IWorkingCopyListener)this.fIconListener);
        workingCopy.addWorkingCopyListener((IWorkingCopyListener)this.fIconListener);
        IProcessAttachmentHandle[] handles = workingCopy.getAttachments();
        this.fIcons = new ItemHandleAwareHashSet();
        IProcessAttachmentHandle[] iProcessAttachmentHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessAttachmentHandle handle = iProcessAttachmentHandleArray[n2];
            String path = workingCopy.getPath(handle);
            if (path.startsWith(this.fPrefixProvider.getIconPrefix())) {
                this.fIcons.add(handle);
            }
            ++n2;
        }
        if (!this.fIconViewer.getControl().isDisposed()) {
            this.fIconViewer.setInput(this.fIcons);
        }
        this.fInitialized = true;
    }

    public void setInput(Object input) {
        if (!this.fInitialized) {
            this.initializeUI();
        }
    }

    public void dispose() {
        if (this.fPrefixProvider.getProcessContainer() != null && this.fPrefixProvider.getProcessContainer().getProcessAttachments() != null) {
            this.fPrefixProvider.getProcessContainer().getProcessAttachments().removeWorkingCopyListener((IWorkingCopyListener)this.fIconListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private final class IconChangeListener
    implements IWorkingCopyListener {
        private FoundationUIJob fUIRefreshJob = new FoundationUIJob(Messages.IconsPart_REFRESH){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                if (!IconsPart.this.fIconViewer.getControl().isDisposed()) {
                    IconsPart.this.fIconViewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };

        private IconChangeListener() {
        }

        private void scheduleJob() {
            if (!this.fUIRefreshJob.isSystem()) {
                this.fUIRefreshJob.setSystem(true);
            }
            this.fUIRefreshJob.schedule(500L);
        }

        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            if (IconsPart.this.fPrefixProvider.getProcessContainer().getProcessAttachments() != event.getSource()) {
                return;
            }
            String property = event.getProperty();
            if (property == null) {
                return;
            }
            if (property.startsWith("processAttachments")) {
                if ("processAttachments.change".equals(property) && !IconsPart.this.fIconViewer.getControl().isDisposed()) {
                    IconsPart.this.fIconViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!IconsPart.this.fIconViewer.getControl().isDisposed()) {
                                IconsPart.this.initializeUI();
                            }
                        }
                    });
                }
                if ("processAttachments.update".equals(property)) {
                    IProcessItemHandle[] newValues = (IProcessItemHandle[])event.getNewValue();
                    boolean affected = false;
                    IProcessItemHandle[] iProcessItemHandleArray = newValues;
                    int n = newValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessItemHandle newIcon = iProcessItemHandleArray[n2];
                        if (IconsPart.this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath((IProcessAttachmentHandle)newIcon).startsWith(IconsPart.this.fPrefixProvider.getIconPrefix())) {
                            affected = true;
                            break;
                        }
                        ++n2;
                    }
                    if (affected) {
                        this.scheduleJob();
                    }
                    return;
                }
                if ("processAttachments.add".equals(property)) {
                    IProcessItemHandle[] newValues = (IProcessItemHandle[])event.getNewValue();
                    boolean affected = false;
                    IProcessItemHandle[] iProcessItemHandleArray = newValues;
                    int n = newValues.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IProcessItemHandle newIcon = iProcessItemHandleArray[n3];
                        if (IconsPart.this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath((IProcessAttachmentHandle)newIcon).startsWith(IconsPart.this.fPrefixProvider.getIconPrefix()) && newIcon instanceof IProcessAttachmentHandle) {
                            IconsPart.this.fIcons.add((IProcessAttachmentHandle)newIcon);
                            affected = true;
                        }
                        ++n3;
                    }
                    if (affected) {
                        this.scheduleJob();
                    }
                    return;
                }
                if ("processAttachments.delete".equals(property)) {
                    IProcessItemHandle[] oldValues = (IProcessItemHandle[])event.getOldValue();
                    boolean affected = false;
                    IProcessItemHandle[] iProcessItemHandleArray = oldValues;
                    int n = oldValues.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IProcessItemHandle oldIcon = iProcessItemHandleArray[n4];
                        if (oldIcon instanceof IProcessAttachmentHandle && IconsPart.this.fIcons.remove(oldIcon)) {
                            affected = true;
                        }
                        ++n4;
                    }
                    if (affected) {
                        this.scheduleJob();
                    }
                }
            }
        }
    }
}

