/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.util.RemoteImages;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.Messages;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class IconResolver
extends UIUpdaterJob {
    private final ITeamRepository fRepository;
    private final URL fRemoteURL;
    private final Runnable fCallback;

    public IconResolver(ITeamRepository repository, URL remoteURL, Runnable callback) {
        super(Messages.IconResolver_RESOLVING_ICONS);
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)remoteURL);
        this.fRemoteURL = remoteURL;
        this.fRepository = repository;
        this.fCallback = callback;
    }

    public IStatus runInBackground(IProgressMonitor monitor) {
        WorkItemClient client = (WorkItemClient)this.fRepository.getClientLibrary(IWorkItemClient.class);
        try {
            client.resolveURL(this.fRemoteURL, monitor);
        }
        catch (TeamRepositoryException e) {
            WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)"Unable to resolve icon: {0}", (Object)this.fRemoteURL.toExternalForm(), (Object[])new Object[0]), e);
        }
        return super.runInBackground(monitor);
    }

    public IStatus runInUI(IProgressMonitor monitor) {
        if (this.fCallback != null && this.isLocallyAvailable()) {
            this.fCallback.run();
        }
        return super.runInUI(monitor);
    }

    private boolean isLocallyAvailable() {
        try {
            return RemoteImages.getCachedImageContentServiceURL((URI)this.fRemoteURL.toURI()) != null;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return false;
    }
}

