/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import com.ibm.team.workitem.client.internal.util.RemoteImages;
import com.ibm.team.workitem.common.internal.ResourceLocation;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.LinkLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IconResolver;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AspectEditorUtil {
    public static final String ID = "id";
    public static final String WORKFLOWS_CONFIGURATION_POINT = "com.ibm.team.workitem.configuration.workflow";
    public static final String WORKFLOW_BINDING_CONFIGURATION_POINT = "com.ibm.team.workitem.configuration.workflowBinding";
    public static final int MAX_SPECIFICATION_STRING_LENGHT = 250;
    private static Set<String> validSuffixes = new HashSet<String>();

    static {
        validSuffixes.add("jpg");
        validSuffixes.add("jpeg");
        validSuffixes.add("ico");
        validSuffixes.add("gif");
        validSuffixes.add("tif");
        validSuffixes.add("tiff");
        validSuffixes.add("bmp");
        validSuffixes.add("gif");
        validSuffixes.add("png");
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static boolean equalMaps(Map map1, Map map2) {
        for (Object key : map1.keySet()) {
            if (!map2.containsKey(key)) {
                return false;
            }
            if (AspectEditorUtil.equals(map1.get(key), map2.get(key))) continue;
            return false;
        }
        for (Object key : map2.keySet()) {
            if (!map1.containsKey(key)) {
                return false;
            }
            if (AspectEditorUtil.equals(map1.get(key), map2.get(key))) continue;
            return false;
        }
        return true;
    }

    public static int getIdNumberSuffix(String id) {
        int dot = id.lastIndexOf(".");
        if (id.length() < dot + 2) {
            return -1;
        }
        String number = id.substring(dot + 2);
        try {
            int i = Integer.valueOf(number);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static void adaptCombo(Combo combo) {
        combo.setVisibleItemCount(15);
    }

    public static String getTypeCategoryDisplayName(TypeCategory category) {
        if (category == null || category.getTypes() == null || category.getTypes().isEmpty()) {
            return null;
        }
        String list = "";
        for (TypeCategory.Type t : category.getTypes()) {
            list = NLS.bind((String)Messages.AspectEditorUtil_LIST_OF_TYPES, (Object)list, (Object[])new Object[]{t.getName()});
        }
        return NLS.bind((String)Messages.AspectEditorUtil_CATEGORYID_LIST, (Object)list.substring(2), (Object[])new Object[]{category.getIdentifier()});
    }

    public static void createFiller(Composite parent, FormToolkit toolkit, int additionalHeight) {
        Composite filler = toolkit == null ? new Composite(parent, 0) : toolkit.createComposite(parent, 0);
        GridData data = new GridData();
        data.heightHint = additionalHeight;
        filler.setLayoutData((Object)data);
    }

    private static String[] checkFileNames(Shell shell, String[] names) {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> invalides = new ArrayList<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                invalides.add(name);
            } else {
                String suffix = name.substring(dot + 1);
                if (validSuffixes.contains(suffix.toLowerCase())) {
                    files.add(name);
                } else {
                    invalides.add(name);
                }
            }
            ++n2;
        }
        if (!invalides.isEmpty()) {
            String fil = "";
            for (String f : invalides) {
                fil = NLS.bind((String)Messages.AspectEditorUtil_APPEND_FILENAME_TO_LIST, (Object)fil, (Object[])new Object[]{f});
            }
            String message = NLS.bind((String)Messages.AspectEditorUtil_INVALID_TYPES_MESSAGE, (Object)fil, (Object[])new Object[0]);
            MessageDialog.openInformation((Shell)shell, (String)Messages.AspectEditorUtil_INVALID_TYPES_TITLE, (String)message);
        }
        return files.toArray(new String[files.size()]);
    }

    public static Image getImage(IProcessContainerWorkingCopy workingCopy, String iconUrl, ResourceManager resourceManager, Runnable handler) {
        ImageDescriptor image = AspectEditorUtil.getImageDescriptor(workingCopy, iconUrl, handler);
        if (image == null) {
            return null;
        }
        return JazzResources.getImage((ResourceManager)resourceManager, (ImageDescriptor)image, null);
    }

    private static ImageDescriptor getImageDescriptor(IProcessContainerWorkingCopy workingCopy, String iconUrl, Runnable handler) {
        if (iconUrl.startsWith("processattachment")) {
            IProcessAttachmentHandle[] iProcessAttachmentHandleArray = workingCopy.getProcessAttachments().getAttachments();
            int n = iProcessAttachmentHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessAttachmentHandle handle = iProcessAttachmentHandleArray[n2];
                if (AspectEditorUtil.extractPath(iconUrl).equals(workingCopy.getProcessAttachments().getPath(handle))) {
                    File localFile = workingCopy.getProcessAttachments().getLocalFile(handle);
                    if (localFile == null) break;
                    return ImageDescriptor.createFromFile(null, (String)localFile.getAbsolutePath());
                }
                ++n2;
            }
        }
        try {
            ITeamRepository repository = (ITeamRepository)workingCopy.getUnderlyingProcessItem().getOrigin();
            URL url = ResourceLocation.getResourceURL((IProcessContainerHandle)((IProcessContainerHandle)workingCopy.getUnderlyingProcessItem()), (URI)new URI(iconUrl), (String)repository.getRepositoryURI());
            if (ResourceLocation.isImageContentServiceURL((URL)url)) {
                URL cached = RemoteImages.getCachedImageContentServiceURL((URI)url.toURI());
                if (cached == null) {
                    new IconResolver(repository, url, handler).schedule();
                    return ImagePool.EMPTY_ICON;
                }
                return WorkItemUI.getImageDescriptor((URL)cached);
            }
            return WorkItemUI.getImageDescriptor((URL)url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String extractPath(String relativeIconUrl) {
        int index = relativeIconUrl.indexOf("://") + 2;
        if (index == 1) {
            index = relativeIconUrl.indexOf(":/") + 1;
        }
        if (index > 0) {
            return relativeIconUrl.substring(index);
        }
        return relativeIconUrl;
    }

    public static void addProcessAttachement(final Shell shell, IProcessAttachmentsWorkingCopy processAttachmentWorkingCopy, String iconPrefix) {
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(Messages.AspectEditorUtil_CHOOSE_FILE);
        String filePath = dialog.open();
        if (filePath != null) {
            final String prefix = !iconPrefix.startsWith("/") ? "/" + iconPrefix : iconPrefix;
            if (dialog.getFileNames().length > 0) {
                String path = dialog.getFilterPath();
                String[] fileNames = AspectEditorUtil.checkFileNames(shell, dialog.getFileNames());
                PathChecker checker = new PathChecker(processAttachmentWorkingCopy);
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    final String f = stringArray[n2];
                    String name = String.valueOf(prefix) + "/" + f;
                    name = name.replace(' ', '_');
                    boolean canceled = false;
                    while (!canceled && !checker.check(name)) {
                        final Object[] values = new Object[]{name, new Boolean(canceled)};
                        shell.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                InputDialog inputDialog = new InputDialog(shell, Messages.AspectEditorUtil_ATTACHMENT_EXISTS_TITLE, NLS.bind((String)Messages.AspectEditorUtil_ATTACHMENT_EXISTS_MESSAGE, (Object)f, (Object[])new Object[0]), new Path(f).lastSegment(), new IInputValidator(){

                                    public String isValid(String newText) {
                                        if (newText == null || newText.trim().length() == 0) {
                                            return Messages.AspectEditorUtil_SPECIFY_PATH;
                                        }
                                        IStatus valid = IItemValidator.INSTANCE.validateAttribute((IType)IProcessAttachment.ITEM_TYPE, "path", (Object)newText);
                                        if (valid.getSeverity() != 0 && valid instanceof IStringSizeConstraintErrorStatus) {
                                            return NLS.bind((String)Messages.AspectEditorUtil_INVALID_PATH, (Object)valid.getMessage(), (Object[])new Object[0]);
                                        }
                                        return null;
                                    }
                                });
                                if (inputDialog.open() == 0) {
                                    String fName = inputDialog.getValue();
                                    values[0] = String.valueOf(prefix) + "/" + fName;
                                } else {
                                    values[1] = Boolean.TRUE;
                                }
                            }
                        });
                        name = (String)values[0];
                        canceled = (Boolean)values[1];
                    }
                    if (!canceled) {
                        File file = new File(String.valueOf(path) + "/" + f);
                        processAttachmentWorkingCopy.createAttachment(name, file);
                    }
                    ++n2;
                }
            }
        }
    }

    public static boolean isValidPathSegment(String string) {
        return string != null && string.length() > 0 && !string.contains(":") && !string.contains("/") && !string.contains("\\");
    }

    public static boolean isValidLength(String string, int length) {
        if (string == null) {
            return true;
        }
        return string.length() <= length;
    }

    public static String safeGetLinkText(IReference ref, LinkLabelProvider labelProvider) {
        String text = null;
        if (labelProvider != null) {
            text = labelProvider.getText(ref);
        }
        if (text == null || "".equals(text.trim())) {
            text = ref.getComment();
        }
        return XMLString.createFromPlainText((String)text).getXMLText();
    }

    public static class IconLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final int fLabelColumn;
        private final int fImageColumn;
        private IPrefixProvider fPrefixProvider;
        private ResourceManager fResourceManager;

        public IconLabelProvider(IPrefixProvider prefixProvider, int labelColumn, int imageColumn, ResourceManager resourceManager) {
            this.fPrefixProvider = prefixProvider;
            this.fLabelColumn = labelColumn;
            this.fImageColumn = imageColumn;
            this.fResourceManager = resourceManager;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IProcessAttachmentHandle) {
                IProcessAttachmentHandle file = (IProcessAttachmentHandle)element;
                if (columnIndex == this.fLabelColumn) {
                    String path = this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath(file);
                    if (path.lastIndexOf("/") > 0) {
                        path = String.valueOf(path.substring(path.lastIndexOf("/") + 1)) + " ";
                    }
                    return path;
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IProcessAttachmentHandle) {
                IProcessAttachmentHandle file = (IProcessAttachmentHandle)element;
                if (columnIndex == this.fImageColumn) {
                    try {
                        return this.getImage(element, ResourceLocation.createRelativeProcessAttachmentURI((String)this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath(file)).toString());
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
            return null;
        }

        private Image getImage(final Object element, String iconPath) {
            return AspectEditorUtil.getImage(this.fPrefixProvider.getProcessContainer(), iconPath, this.fResourceManager, new Runnable(){

                public void run() {
                    IconLabelProvider.this.fireChanged(element);
                }
            });
        }

        private void fireChanged(Object element) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
        }
    }

    private static class PathChecker {
        private Set<String> existingPaths = new HashSet<String>();

        PathChecker(IProcessAttachmentsWorkingCopy workingCopy) {
            IProcessAttachmentHandle[] iProcessAttachmentHandleArray = workingCopy.getAttachments();
            int n = iProcessAttachmentHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessAttachmentHandle handle = iProcessAttachmentHandleArray[n2];
                this.existingPaths.add(workingCopy.getPath(handle));
                ++n2;
            }
        }

        public boolean check(String path) {
            if (this.existingPaths.contains(path)) {
                return false;
            }
            this.existingPaths.add(path);
            return true;
        }
    }

    public static class ProcessAttachmentSorter
    extends ViewerSorter {
        private static Collator collator = Collator.getInstance();

        static {
            collator.setStrength(1);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IProcessAttachment && e2 instanceof IProcessAttachment) {
                String name2;
                String name1 = ((IProcessAttachment)e1).getPath();
                if (name1.lastIndexOf("/") > 0) {
                    name1 = String.valueOf(name1.substring(name1.lastIndexOf("/") + 1)) + " ";
                }
                if ((name2 = ((IProcessAttachment)e2).getPath()).lastIndexOf("/") > 0) {
                    name2 = String.valueOf(name2.substring(name2.lastIndexOf("/") + 1)) + " ";
                }
                return collator.compare(name1, name2);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WorkflowComparator
    implements Comparator<WFWorkflow> {
        @Override
        public int compare(WFWorkflow o1, WFWorkflow o2) {
            String name2;
            String name1 = o1.getName();
            if (name1 == null || "".equals(name1.trim())) {
                name1 = o1.getIdentifier();
            }
            if ((name2 = o2.getName()) == null || "".equals(name2.trim())) {
                name2 = o2.getIdentifier();
            }
            return Collator.getInstance().compare(name1, name2);
        }
    }
}

