/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class AspectEditorLabelProvider
extends LabelProvider {
    private ProcessAspect fAspect;
    private ResourceManager fResourceManager;

    public AspectEditorLabelProvider(ProcessAspect aspect, ResourceManager resourceManager) {
        this.fAspect = aspect;
        this.fResourceManager = resourceManager;
    }

    public String getText(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ModeledElement) {
            return this.getModeledElementLabel((ModeledElement)element);
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof TypeCategory.Type) {
            TypeCategory.Type type = (TypeCategory.Type)element;
            return this.getImage(type, type.getIcon());
        }
        if (element instanceof WFWorkflow.WFState) {
            WFWorkflow.WFState state = (WFWorkflow.WFState)element;
            return this.getImage(state, state.getIcon());
        }
        if (element instanceof WFWorkflow.WFResolution) {
            WFWorkflow.WFResolution resolution = (WFWorkflow.WFResolution)element;
            return this.getImage(resolution, resolution.getIcon());
        }
        if (element instanceof WFWorkflow.WFAction) {
            WFWorkflow.WFAction action = (WFWorkflow.WFAction)element;
            return this.getImage(action, action.getIcon());
        }
        return null;
    }

    private String getModeledElementLabel(ModeledElement element) {
        String name = element.getName();
        if (name != null) {
            return name;
        }
        return element.getIdentifier();
    }

    private Image getImage(final Object element, String iconUrl) {
        if (iconUrl != null) {
            return AspectEditorUtil.getImage(this.fAspect.getProcessContainerWorkingCopy(), iconUrl, this.fResourceManager, new Runnable(){

                public void run() {
                    AspectEditorLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)AspectEditorLabelProvider.this, element));
                }
            });
        }
        return null;
    }
}

