/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.actions;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.actions.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAttachmentAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    private Shell fShell;

    public void run(IAction action) {
        if (!this.shouldEnable() || this.fShell == null) {
            return;
        }
        final List<IAttachmentHandle> handles = this.getHandleList();
        UIUpdaterJob job = new UIUpdaterJob(Messages.SaveAttachmentAction_RESOLVING_ATTACHMENTS){
            List<IAttachment> fAttachments;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    ITeamRepository teamRepository = (ITeamRepository)((IAttachmentHandle)handles.get(0)).getOrigin();
                    ArrayList<IAttachment> resolvedStates = new ArrayList<IAttachment>();
                    for (IAttachmentHandle handle : handles) {
                        if (!(handle instanceof IAttachment) || !((IAttachment)handle).isComplete()) continue;
                        resolvedStates.add((IAttachment)handle);
                    }
                    handles.removeAll(resolvedStates);
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    this.fAttachments = handles.size() == 1 ? auditableClient.resolveAuditablesPermissionAware(handles, IAttachment.SMALL_PROFILE, monitor) : auditableClient.resolveAuditables(handles, IAttachment.SMALL_PROFILE, monitor);
                    if (this.fAttachments.isEmpty()) {
                        this.fAttachments = new ArrayList<IAttachment>();
                    }
                    this.fAttachments.addAll(resolvedStates);
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.SaveAttachmentAction_EXCEPTION_RESOLVING_ATTACHMENTS, (Throwable)x);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                SaveAttachmentAction.this.run(this.fAttachments);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void run(List<IAttachment> list) {
        ITeamRepository teamRepository = (ITeamRepository)list.get(0).getOrigin();
        if (list.size() == 1) {
            String fname;
            FileDialog dialog = new FileDialog(this.fShell, 8192);
            dialog.setText(Messages.SaveAttachmentAction_SAVE_ATTACHMENT);
            String path = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getString("com.ibm.team.workitem.ide.ui.editor.attachments.dialogfilterpath");
            if (path != null) {
                dialog.setFilterPath(path);
            }
            dialog.setFileName(list.get(0).getName());
            while ((fname = dialog.open()) != null) {
                MessageDialog md;
                File file = new File(fname);
                if (file.exists() && (md = new MessageDialog(this.fShell, Messages.SaveAttachmentAction_SAVE_ATTACHMENT, null, NLS.bind((String)Messages.SaveAttachmentAction_ALREADY_EXISTS, (Object)fname, (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) continue;
                new FileSaveJob(teamRepository, list.get(0), file).schedule();
                break;
            }
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.workitem.ide.ui.editor.attachments.dialogfilterpath", Path.fromOSString((String)dialog.getFilterPath()).makeAbsolute().toString());
        } else if (list.size() > 1) {
            DirectoryDialog dialog = new DirectoryDialog(this.fShell);
            dialog.setText(Messages.SaveAttachmentAction_SAVE_ATTACHMENTS);
            String path = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getString("com.ibm.team.workitem.ide.ui.editor.attachments.dialogfilterpath");
            if (path != null) {
                dialog.setFilterPath(path);
            }
            dialog.setMessage(Messages.SaveAttachmentAction_SELECT_DIRECTORY);
            String dir = dialog.open();
            if (dir != null) {
                boolean yestoall = false;
                ArrayList<IAttachment> attachments = new ArrayList<IAttachment>();
                ArrayList<File> files = new ArrayList<File>();
                for (IAttachment handle : list) {
                    if (handle == null) continue;
                    File file = new File(dir, handle.getName());
                    if (!yestoall && file.exists()) {
                        MessageDialog md = new MessageDialog(this.fShell, Messages.SaveAttachmentAction_SAVE_ATTACHMENT, null, NLS.bind((String)Messages.SaveAttachmentAction_ALREADY_EXISTS, (Object)file.getPath(), (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL}, 1);
                        int r = md.open();
                        if (r == 2) {
                            yestoall = true;
                        } else if (r != 0) continue;
                    }
                    attachments.add(handle);
                    files.add(file);
                }
                new FileSaveJob(teamRepository, attachments.toArray(new IAttachment[attachments.size()]), files.toArray(new File[files.size()])).schedule();
            }
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.workitem.ide.ui.editor.attachments.dialogfilterpath", Path.fromOSString((String)dialog.getFilterPath()).makeAbsolute().toString());
        }
    }

    private List<IAttachmentHandle> getHandleList() {
        ArrayList<IAttachmentHandle> result = new ArrayList<IAttachmentHandle>();
        for (Object o : ((IStructuredSelection)this.fSelection).toList()) {
            if (!(o instanceof IAttachmentHandle)) continue;
            result.add((IAttachmentHandle)o);
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        action.setEnabled(this.shouldEnable());
    }

    private boolean shouldEnable() {
        return !this.fSelection.isEmpty() && this.fSelection instanceof IStructuredSelection && ((IStructuredSelection)this.fSelection).getFirstElement() instanceof IAttachmentHandle;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShell = targetPart.getSite().getShell();
    }

    private static class FileSaveJob
    extends FoundationJob {
        private ITeamRepository fTeamRepository;
        private IAttachment[] fAttachments;
        private File[] fFiles;

        public FileSaveJob(ITeamRepository teamRepository, IAttachment[] attachments, File[] files) {
            super(Messages.SaveAttachmentAction_SAVING_ATTACHMENTS);
            this.setUser(true);
            this.fTeamRepository = teamRepository;
            this.fAttachments = attachments;
            this.fFiles = files;
        }

        public FileSaveJob(ITeamRepository teamRepository, IAttachment attachment, File file) {
            this(teamRepository, new IAttachment[]{attachment}, new File[]{file});
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus runProtected(IProgressMonitor monitor) {
            n = this.fAttachments.length;
            stati = new IStatus[n];
            taskMessage = NLS.bind((String)(n == 1 ? Messages.SaveAttachmentAction_ATTACHMENT_NOUN_SINGULAR : Messages.SaveAttachmentAction_ATTACHMENT_NOUN_PLURAL), (Object)Integer.toString(n), (Object[])new Object[0]);
            monitor.beginTask(taskMessage, n);
            i = 0;
            block10: while (i < n) {
                submon = new SubProgressMonitor(monitor, 1);
                try {
                    FileSaveJob.checkCancelled(monitor);
                    auditableClient = (IAuditableClient)this.fTeamRepository.getClientLibrary(IAuditableClient.class);
                    attachment = this.fAttachments[i];
                    if (!attachment.isComplete()) {
                        attachment = (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)attachment, IAttachment.DEFAULT_PROFILE, (IProgressMonitor)submon);
                    }
                    FileSaveJob.checkCancelled(monitor);
                    content = attachment.getContent();
                    submon.beginTask(null, (int)content.getEstimatedConvertedLength());
                    submon.subTask(NLS.bind((String)Messages.SaveAttachmentAction_DOWNLOADING, (Object)attachment.getName(), (Object[])new Object[0]));
                    try {
                        out = new FileOutputStream(this.fFiles[i]);
                        try {
                            this.fTeamRepository.contentManager().retrieveContent(content, (OutputStream)out, (IProgressMonitor)submon);
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        submon.done();
                    }
                    stati[i] = Status.OK_STATUS;
                }
                catch (OperationCanceledException v0) {
                    j = i;
                    ** while (j < n)
                }
lbl-1000:
                // 1 sources

                {
                    stati[j] = Status.CANCEL_STATUS;
                    ++j;
                    continue;
lbl38:
                    // 1 sources

                    break block10;
                }
                catch (TeamRepositoryException x) {
                    stati[i] = new Status(4, "com.ibm.team.workitem.ide.ui", 0, NLS.bind((String)Messages.SaveAttachmentAction_ERROR_RETRIEVING_FROM_REPO, (Object)this.fAttachments[i].getName(), (Object[])new Object[0]), (Throwable)x);
                }
                catch (IOException x) {
                    stati[i] = new Status(4, "com.ibm.team.workitem.ide.ui", 0, NLS.bind((String)Messages.SaveAttachmentAction_ERROR_SAVING_TODISK, (Object)this.fAttachments[i].getName(), (Object[])new Object[0]), (Throwable)x);
                }
                ++i;
            }
            monitor.done();
            return new MultiStatus("com.ibm.team.workitem.ide.ui", 0, stati, Messages.SaveAttachmentAction_ERRORS_SAVING_ATTACHMENTS, null);
        }

        private static void checkCancelled(IProgressMonitor monitor) throws OperationCanceledException {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }
}

