/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.actions;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.StyledEditingAction;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.actions.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.CommentsDocument;
import com.ibm.team.workitem.ide.ui.internal.editor.ExtractWorkItemOperation;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.wizards.ExtractWorkItemWizard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ExtractWorkItemAction
extends StyledEditingAction {
    private static final int SUMMARY_SIZE = 100;
    private static final String[] COPY_ATTRIBUTES = new String[]{IWorkItem.CATEGORY_PROPERTY, IWorkItem.FOUND_IN_PROPERTY};

    public ExtractWorkItemAction() {
        this(null, null);
    }

    public ExtractWorkItemAction(IWorkbenchPart part) {
        this(null, ImagePool.CREATE_DUPLICATE, part, null);
    }

    public ExtractWorkItemAction(IWorkbenchPart part, ISourceViewer sourceViewer) {
        this(Messages.ExtractWorkItemAction_EXTRACT_WORKITEM, null, part, sourceViewer);
    }

    private ExtractWorkItemAction(String text, ImageDescriptor image, IWorkbenchPart part, ISourceViewer sourceViewer) {
        super(text, "com.ibm.team.workitem.ide.ui.edit.extractworkitem", image, sourceViewer);
        this.setToolTipText(Messages.ExtractWorkItemAction_EXTRACT_FROM_TEXT);
        this.setDisabledImageDescriptor(ImageDescriptor.createWithFlags((ImageDescriptor)image, (int)1));
        this.setPart(part);
        this.update();
    }

    public void run() {
        SourceViewerPane sourceViewerPane;
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        IEditorPart editorPart = (IEditorPart)this.getPart();
        WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)editorPart.getEditorInput();
        WorkItemWorkingCopy sourceWorkingCopy = workItemEditorInput.getWorkingCopy();
        IWorkItem sourceItem = sourceWorkingCopy.getWorkItem();
        boolean ok = this.saveNewWorkItem(editorPart, sourceWorkingCopy);
        if (!ok) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null && (sourceViewerPane = (SourceViewerPane)editorPart.getAdapter(SourceViewerPane.class)) != null) {
            sourceViewer = sourceViewerPane.getActiveSourceViewer();
        }
        if (sourceViewer == null) {
            ExtractWorkItemOperation operation = new ExtractWorkItemOperation((IWorkItemHandle)sourceItem, Messages.ExtractWorkItemAction_CREATED, XMLString.EMPTY, XMLString.EMPTY, Collections.<IContributorHandle>emptyList(), WorkItemEndPoints.RELATED_WORK_ITEM, COPY_ATTRIBUTES);
            this.openWizard(operation, sourceItem);
            return;
        }
        ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
        XMLString description = XMLString.createFromPlainText((String)selection.getText());
        IDocument document = sourceViewer.getDocument();
        if (document instanceof IStyledDocument) {
            try {
                description = ((IStyledDocument)document).getHTML(selection.getOffset(), selection.getLength());
            }
            catch (BadLocationException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.ExtractWorkItemAction_EXCEPTION_EXTRACTING_WORKITEM, x);
            }
        }
        String summary = description.getPlainText();
        if ((summary = summary.replaceAll(System.getProperty("line.separator", "\n"), " ").trim()).length() >= 100) {
            int endPos = summary.indexOf(" ", 100);
            if (endPos < 0) {
                endPos = 100;
            }
            summary = String.valueOf(summary.substring(0, endPos)) + " ...";
        }
        ItemHandleAwareHashSet subscriptions = new ItemHandleAwareHashSet();
        if (document instanceof CommentsDocument) {
            List comments = ((CommentsDocument)document).getComments(selection.getOffset(), selection.getLength());
            for (IComment comment : comments) {
                subscriptions.add(comment.getCreator());
            }
            subscriptions.remove(sourceWorkingCopy.getTeamRepository().loggedInContributor());
        }
        ExtractWorkItemOperation operation = new ExtractWorkItemOperation((IWorkItemHandle)sourceItem, !selection.isEmpty() ? Messages.ExtractWorkItemAction_EXTRACTED : Messages.ExtractWorkItemAction_CREATED, XMLString.createFromPlainText((String)summary), description, new ArrayList<IContributorHandle>((Collection<IContributorHandle>)subscriptions), WorkItemEndPoints.RELATED_WORK_ITEM, COPY_ATTRIBUTES);
        this.openWizard(operation, sourceItem);
    }

    private void openWizard(ExtractWorkItemOperation operation, IWorkItem sourceItem) {
        IWorkbenchPart part = this.getPart();
        if (part == null) {
            return;
        }
        Shell shell = part.getSite().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        ExtractWorkItemWizard wizard = new ExtractWorkItemWizard(sourceItem.getProjectArea(), operation);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }

    public void update() {
        this.setEnabled(this.shouldEnable());
        this.setImageDescriptor(this.isEnabled() ? ImagePool.CREATE_DUPLICATE : ImagePool.CREATE_DUPLICATE_DISABLED);
    }

    private boolean shouldEnable() {
        IWorkbenchPart part = this.getPart();
        if (!(part instanceof IEditorPart)) {
            return false;
        }
        IEditorInput input = ((IEditorPart)part).getEditorInput();
        return input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved();
    }

    private boolean saveNewWorkItem(IEditorPart editorPart, WorkItemWorkingCopy workingCopy) {
        if (!workingCopy.getWorkItem().isNewItem()) {
            return true;
        }
        Shell shell = editorPart.getSite().getShell();
        if (shell == null || shell.isDisposed()) {
            return false;
        }
        boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)Messages.ExtractWorkItemAction_SAVE_WORKITEM, (String)Messages.ExtractWorkItemAction_NEED_TO_SAVE);
        if (!confirmed) {
            return false;
        }
        return Util.saveNewWorkItem(editorPart, workingCopy);
    }
}

