/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CacheHelper {
    private static final long EXPIRATION = 10000L;
    private static ItemProfile<IProjectArea> PROJECT_CHECK_PROFILE = ItemProfile.PROJECT_AREA_DEFAULT.createExtension(ProcessPackage.eINSTANCE.getProjectArea_IsInitialized().getName());
    private IAuditableCommon fAuditableCommon;
    private Map<UUID, UUID> fLastSeenStates = Collections.synchronizedMap(new HashMap());
    private Map<UUID, Long> fLastChecked = Collections.synchronizedMap(new HashMap());
    private Object fUpdateLock = new Object();

    public CacheHelper(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    private boolean hasChanged(IAuditable auditable) throws TeamRepositoryException {
        UUID lastSeen = this.fLastSeenStates.get(auditable.getItemId());
        return lastSeen == null || !lastSeen.equals((Object)auditable.getStateId());
    }

    public void checkCache(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectAreaHandle, this.getAuditableCommon(), monitor);
    }

    protected void checkCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
            Assert.isTrue((projectAreaHandle != null ? 1 : 0) != 0);
        }
        try {
            this.internalCheckCache(projectAreaHandle, auditableCommon, monitor);
        }
        catch (TeamRepositoryException x) {
            if (this.fLastSeenStates.get(projectAreaHandle.getItemId()) == null) {
                throw x;
            }
            WorkItemCommonPlugin.log("Exception while updating cache", (Exception)((Object)x));
        }
    }

    public void invalidateCache(IProjectAreaHandle projectArea) {
        this.fLastSeenStates.remove(projectArea.getItemId());
        this.fLastChecked.remove(projectArea.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache(IProjectAreaHandle projectArea) {
        Object object = this.fUpdateLock;
        synchronized (object) {
            this.invalidateCache(projectArea);
            this.doFlushCache(projectArea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCheckCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.recentlyChecked(projectAreaHandle)) {
            return;
        }
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, PROJECT_CHECK_PROFILE, monitor);
        if (projectArea.isInitialized()) {
            this.fLastChecked.put(projectAreaHandle.getItemId(), System.currentTimeMillis());
        }
        if (!this.hasChanged((IAuditable)projectArea)) {
            return;
        }
        Object object = this.fUpdateLock;
        synchronized (object) {
            if (!this.hasChanged((IAuditable)projectArea)) {
                return;
            }
            this.updateCache(projectAreaHandle, auditableCommon, monitor);
            this.fLastSeenStates.put(projectArea.getItemId(), projectArea.getStateId());
        }
    }

    private boolean recentlyChecked(IProjectAreaHandle projectAreaHandle) {
        if (this.fLastSeenStates.get(projectAreaHandle.getItemId()) == null) {
            return false;
        }
        Long timestamp = this.fLastChecked.get(projectAreaHandle.getItemId());
        return timestamp != null && timestamp + 10000L > System.currentTimeMillis();
    }

    protected IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }

    protected abstract void updateCache(IProjectAreaHandle var1, IAuditableCommon var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected void doFlushCache(IProjectAreaHandle projectArea) {
    }
}

